/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.StringColumnCodec;

class NonNullStringColumnCodec
extends StringColumnCodec {
    protected Variable mLengthVar;

    NonNullStringColumnCodec(ColumnInfo info, MethodMaker mm) {
        super(info, mm);
    }

    @Override
    ColumnCodec bind(MethodMaker mm) {
        return new NonNullStringColumnCodec(this.mInfo, mm);
    }

    @Override
    int codecFlags() {
        return 0;
    }

    @Override
    void encodePrepare() {
        this.mLengthVar = this.mMaker.var(Integer.TYPE);
    }

    @Override
    void encodeSkip() {
        this.mLengthVar.set((Object)0);
    }

    @Override
    Variable encodeSize(Variable srcVar, Variable totalVar) {
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        this.mLengthVar.set((Object)rowUtils.invoke("lengthStringUTF", new Object[]{srcVar}));
        totalVar = this.accum(totalVar, rowUtils.invoke("lengthPrefixPF", new Object[]{this.mLengthVar}));
        return this.accum(totalVar, this.mLengthVar);
    }

    @Override
    void encode(Variable srcVar, Variable dstVar, Variable offsetVar) {
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        offsetVar.set((Object)rowUtils.invoke("encodePrefixPF", new Object[]{dstVar, offsetVar, this.mLengthVar}));
        this.finishEncode(srcVar, rowUtils, dstVar, offsetVar);
    }

    @Override
    void decode(Variable dstVar, Variable srcVar, Variable offsetVar, Variable endVar) {
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        Variable lengthVar = rowUtils.invoke("decodePrefixPF", new Object[]{srcVar, offsetVar});
        offsetVar.inc((Object)rowUtils.invoke("lengthPrefixPF", new Object[]{lengthVar}));
        this.finishDecode(dstVar, rowUtils, srcVar, offsetVar, lengthVar);
    }

    @Override
    void decodeSkip(Variable srcVar, Variable offsetVar, Variable endVar) {
        offsetVar.set((Object)this.mMaker.var(RowUtils.class).invoke("skipBytesPF", new Object[]{srcVar, offsetVar}));
    }

    @Override
    protected void decodeHeader(Variable srcVar, Variable offsetVar, Variable endVar, Variable lengthVar, Variable isNullVar) {
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        lengthVar.set((Object)rowUtils.invoke("decodePrefixPF", new Object[]{srcVar, offsetVar}));
        offsetVar.inc((Object)rowUtils.invoke("lengthPrefixPF", new Object[]{lengthVar}));
    }

    protected void finishEncode(Variable srcVar, Variable rowUtils, Variable dstVar, Variable offsetVar) {
        offsetVar.set((Object)rowUtils.invoke("encodeStringUTF", new Object[]{dstVar, offsetVar, srcVar}));
    }

    protected void finishDecode(Variable dstVar, Variable rowUtils, Variable srcVar, Variable offsetVar, Variable lengthVar) {
        dstVar.set((Object)rowUtils.invoke("decodeStringUTF", new Object[]{srcVar, offsetVar, lengthVar}));
        offsetVar.inc((Object)lengthVar);
    }
}

