/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.IOException;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.rows.BaseTable;
import org.cojen.tupl.rows.BasicUpdater;
import org.cojen.tupl.rows.ScanController;

final class NonRepeatableUpdater<R>
extends BasicUpdater<R> {
    LockResult mLockResult;

    NonRepeatableUpdater(BaseTable<R> table, ScanController<R> controller) {
        super(table, controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LockResult toFirst(Cursor c) throws IOException {
        Transaction txn = c.link();
        LockMode original = txn.lockMode();
        txn.lockMode(LockMode.UPGRADABLE_READ);
        try {
            LockResult lockResult = this.mLockResult = super.toFirst(c);
            return lockResult;
        }
        finally {
            txn.lockMode(original);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LockResult toNext(Cursor c) throws IOException {
        Transaction txn = c.link();
        LockResult result = this.mLockResult;
        if (result != null && result.isAcquired()) {
            txn.unlock();
        }
        LockMode original = txn.lockMode();
        txn.lockMode(LockMode.UPGRADABLE_READ);
        try {
            LockResult lockResult = this.mLockResult = c.next();
            return lockResult;
        }
        finally {
            txn.lockMode(original);
        }
    }

    @Override
    protected void unlocked() {
        this.mLockResult = null;
    }

    @Override
    protected void finished() throws IOException {
        this.mRow = null;
        this.mLockResult = null;
    }
}

