/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.NonNullBigIntegerColumnCodec;
import org.cojen.tupl.rows.RowUtils;

final class NullableBigIntegerColumnCodec
extends NonNullBigIntegerColumnCodec {
    NullableBigIntegerColumnCodec(ColumnInfo info, MethodMaker mm) {
        super(info, mm);
    }

    @Override
    ColumnCodec bind(MethodMaker mm) {
        return new NullableBigIntegerColumnCodec(this.mInfo, mm);
    }

    @Override
    int codecFlags() {
        return 0;
    }

    @Override
    Variable encodeSize(Variable srcVar, Variable totalVar) {
        Variable arrayLengthVar = this.mMaker.var(Integer.TYPE);
        Label notNull = this.mMaker.label();
        srcVar.ifNe(null, notNull);
        this.mBytesVar.set(null);
        arrayLengthVar.set((Object)0);
        this.mLengthVar.set((Object)0);
        Label cont = this.mMaker.label();
        this.mMaker.goto_(cont);
        notNull.here();
        this.mBytesVar.set((Object)srcVar.invoke("toByteArray", new Object[0]));
        arrayLengthVar.set((Object)this.mBytesVar.alength());
        this.mLengthVar.set((Object)arrayLengthVar.add((Object)1));
        cont.here();
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        totalVar = this.accum(totalVar, rowUtils.invoke("lengthPrefixPF", new Object[]{this.mLengthVar}));
        return this.accum(totalVar, arrayLengthVar);
    }

    @Override
    void decodeSkip(Variable srcVar, Variable offsetVar, Variable endVar) {
        offsetVar.set((Object)this.mMaker.var(RowUtils.class).invoke("skipNullableBytesPF", new Object[]{srcVar, offsetVar}));
    }

    @Override
    protected void decodeHeader(Variable srcVar, Variable offsetVar, Variable endVar, Variable lengthVar, Variable isNullVar) {
        super.decodeHeader(srcVar, offsetVar, endVar, lengthVar, null);
        this.decodeNullableLength(lengthVar, isNullVar);
    }

    @Override
    protected void finishEncode(Variable dstVar, Variable offsetVar, Variable lengthVar) {
        Label isNull = this.mMaker.label();
        this.mBytesVar.ifEq(null, isNull);
        super.finishEncode(dstVar, offsetVar, this.mBytesVar.alength());
        isNull.here();
    }

    @Override
    protected void finishDecode(Variable dstVar, Variable srcVar, Variable offsetVar, Variable lengthVar) {
        Label notNull = this.mMaker.label();
        lengthVar.ifNe((Object)0, notNull);
        dstVar.set(null);
        Label cont = this.mMaker.label();
        this.mMaker.goto_(cont);
        notNull.here();
        super.finishDecode(dstVar, srcVar, offsetVar, lengthVar.sub((Object)1));
        cont.here();
    }
}

