/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.NonNullLastStringColumnCodec;
import org.cojen.tupl.rows.RowUtils;

final class NullableLastStringColumnCodec
extends NonNullLastStringColumnCodec {
    NullableLastStringColumnCodec(ColumnInfo info, MethodMaker mm) {
        super(info, mm);
    }

    @Override
    ColumnCodec bind(MethodMaker mm) {
        return new NullableLastStringColumnCodec(this.mInfo, mm);
    }

    @Override
    int codecFlags() {
        return 1;
    }

    @Override
    int minSize() {
        return 1;
    }

    @Override
    Variable encodeSize(Variable srcVar, Variable totalVar) {
        if (totalVar == null) {
            totalVar = this.mMaker.var(Integer.TYPE).set((Object)0);
        }
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        Label isNull = this.mMaker.label();
        srcVar.ifEq(null, isNull);
        totalVar.inc((Object)rowUtils.invoke("lengthStringUTF", new Object[]{srcVar}));
        isNull.here();
        return totalVar;
    }

    @Override
    void encode(Variable srcVar, Variable dstVar, Variable offsetVar) {
        Label end = this.mMaker.label();
        this.encodeNullHeader(end, srcVar, dstVar, offsetVar);
        super.encode(srcVar, dstVar, offsetVar);
        end.here();
    }

    @Override
    void decode(Variable dstVar, Variable srcVar, Variable offsetVar, Variable endVar) {
        Label end = this.mMaker.label();
        this.decodeNullHeader(end, dstVar, srcVar, offsetVar);
        super.decode(dstVar, srcVar, offsetVar, endVar);
        end.here();
    }

    @Override
    void decodeSkip(Variable srcVar, Variable offsetVar, Variable endVar) {
        Label end = this.mMaker.label();
        this.decodeNullHeader(end, null, srcVar, offsetVar);
        super.decodeSkip(srcVar, offsetVar, endVar);
        end.here();
    }

    @Override
    protected void decodeHeader(Variable srcVar, Variable offsetVar, Variable endVar, Variable lengthVar, Variable isNullVar) {
        this.decodeNullHeader(null, isNullVar, srcVar, offsetVar);
        Label notNull = this.mMaker.label();
        isNullVar.ifFalse(notNull);
        lengthVar.set((Object)0);
        Label cont = this.mMaker.label().goto_();
        notNull.here();
        super.decodeHeader(srcVar, offsetVar, endVar, lengthVar, null);
        cont.here();
    }
}

