/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.NonNullPrimitiveArrayColumnCodec;
import org.cojen.tupl.rows.RowUtils;

final class NullablePrimitiveArrayColumnCodec
extends NonNullPrimitiveArrayColumnCodec {
    private Variable mBytesLengthVar;

    NullablePrimitiveArrayColumnCodec(ColumnInfo info, MethodMaker mm) {
        super(info, mm);
    }

    @Override
    ColumnCodec bind(MethodMaker mm) {
        return new NullablePrimitiveArrayColumnCodec(this.mInfo, mm);
    }

    @Override
    void encodePrepare() {
        super.encodePrepare();
        this.mBytesLengthVar = this.mMaker.var(Integer.TYPE);
    }

    @Override
    void encodeSkip() {
        super.encodeSkip();
        this.mBytesLengthVar.set((Object)0);
    }

    @Override
    Variable encodeSize(Variable srcVar, Variable totalVar) {
        Label notNull = this.mMaker.label();
        srcVar.ifNe(null, notNull);
        this.mBytesLengthVar.set((Object)0);
        this.mLengthVar.set((Object)0);
        Label cont = this.mMaker.label().goto_();
        notNull.here();
        this.mBytesLengthVar.set((Object)this.byteArrayLength(srcVar));
        this.mLengthVar.set((Object)this.mBytesLengthVar.add((Object)1));
        cont.here();
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        totalVar = this.accum(totalVar, rowUtils.invoke("lengthPrefixPF", new Object[]{this.mLengthVar}));
        return this.accum(totalVar, this.mBytesLengthVar);
    }

    @Override
    void decodeSkip(Variable srcVar, Variable offsetVar, Variable endVar) {
        offsetVar.set((Object)this.mMaker.var(RowUtils.class).invoke("skipNullableBytesPF", new Object[]{srcVar, offsetVar}));
    }

    @Override
    protected void decodeHeader(Variable srcVar, Variable offsetVar, Variable endVar, Variable lengthVar, Variable isNullVar) {
        super.decodeHeader(srcVar, offsetVar, endVar, lengthVar, null);
        this.decodeNullableLength(lengthVar, isNullVar);
    }

    @Override
    protected void finishEncode(Variable srcVar, Variable dstVar, Variable offsetVar) {
        Label isNull = this.mMaker.label();
        srcVar.ifEq(null, isNull);
        this.encodeByteArray(srcVar, dstVar, offsetVar);
        offsetVar.inc((Object)this.mBytesLengthVar);
        isNull.here();
    }

    @Override
    protected void finishDecode(Variable dstVar, Variable srcVar, Variable offsetVar, Variable lengthVar) {
        Label notNull = this.mMaker.label();
        lengthVar.ifNe((Object)0, notNull);
        dstVar.set(null);
        Label cont = this.mMaker.label().goto_();
        notNull.here();
        super.finishDecode(dstVar, srcVar, offsetVar, lengthVar.sub((Object)1));
        cont.here();
    }
}

