/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.NonNullStringColumnCodec;
import org.cojen.tupl.rows.RowUtils;

final class NullableStringColumnCodec
extends NonNullStringColumnCodec {
    NullableStringColumnCodec(ColumnInfo info, MethodMaker mm) {
        super(info, mm);
    }

    @Override
    ColumnCodec bind(MethodMaker mm) {
        return new NullableStringColumnCodec(this.mInfo, mm);
    }

    @Override
    int codecFlags() {
        return 0;
    }

    @Override
    Variable encodeSize(Variable srcVar, Variable totalVar) {
        Variable rowUtils = this.mMaker.var(RowUtils.class);
        Variable strLengthVar = this.mMaker.var(Integer.TYPE);
        Label notNull = this.mMaker.label();
        srcVar.ifNe(null, notNull);
        strLengthVar.set((Object)0);
        this.mLengthVar.set((Object)0);
        Label cont = this.mMaker.label().goto_();
        notNull.here();
        strLengthVar.set((Object)rowUtils.invoke("lengthStringUTF", new Object[]{srcVar}));
        this.mLengthVar.set((Object)strLengthVar.add((Object)1));
        cont.here();
        totalVar = this.accum(totalVar, rowUtils.invoke("lengthPrefixPF", new Object[]{this.mLengthVar}));
        return this.accum(totalVar, strLengthVar);
    }

    @Override
    void decodeSkip(Variable srcVar, Variable offsetVar, Variable endVar) {
        offsetVar.set((Object)this.mMaker.var(RowUtils.class).invoke("skipNullableBytesPF", new Object[]{srcVar, offsetVar}));
    }

    @Override
    protected void decodeHeader(Variable srcVar, Variable offsetVar, Variable endVar, Variable lengthVar, Variable isNullVar) {
        super.decodeHeader(srcVar, offsetVar, endVar, lengthVar, null);
        this.decodeNullableLength(lengthVar, isNullVar);
    }

    @Override
    protected void finishEncode(Variable srcVar, Variable rowUtils, Variable dstVar, Variable offsetVar) {
        Label isNull = this.mMaker.label();
        srcVar.ifEq(null, isNull);
        super.finishEncode(srcVar, rowUtils, dstVar, offsetVar);
        isNull.here();
    }

    @Override
    protected void finishDecode(Variable dstVar, Variable rowUtils, Variable srcVar, Variable offsetVar, Variable lengthVar) {
        Label notNull = this.mMaker.label();
        lengthVar.ifNe((Object)0, notNull);
        dstVar.set(null);
        Label cont = this.mMaker.label().goto_();
        notNull.here();
        super.finishDecode(dstVar, rowUtils, srcVar, offsetVar, lengthVar.sub((Object)1));
        cont.here();
    }
}

