/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.RowInfo;

public final class OrderBy
extends LinkedHashMap<String, Rule> {
    static OrderBy forPrimaryKey(RowInfo rowInfo) {
        OrderBy orderBy = new OrderBy(rowInfo.keyColumns.size());
        for (ColumnInfo column : rowInfo.keyColumns.values()) {
            orderBy.put(column.name, new Rule(column, column.typeCode));
        }
        return orderBy;
    }

    static OrderBy forSpec(RowInfo rowInfo, String spec) {
        try {
            OrderBy orderBy = OrderBy.parseSpec(rowInfo.allColumns, spec);
            if (!orderBy.isEmpty()) {
                return orderBy;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Malformed ordering specification: " + spec);
    }

    public OrderBy() {
    }

    public OrderBy(OrderBy orderBy) {
        super(orderBy);
    }

    private OrderBy(int capacity) {
        super(capacity, 1.0f);
    }

    OrderBy truncate(int num) {
        if (num <= 0) {
            return null;
        }
        if (num >= this.size()) {
            return this;
        }
        OrderBy ob = new OrderBy(num);
        for (Map.Entry e : this.entrySet()) {
            ob.put((String)e.getKey(), (Rule)e.getValue());
            if (--num > 0) continue;
            break;
        }
        return ob;
    }

    String spec() {
        StringBuilder b = new StringBuilder();
        for (Rule rule : this.values()) {
            rule.appendTo(b);
        }
        return b.toString().intern();
    }

    static String[] splitSpec(String spec) {
        int end = OrderBy.nextSubSpec(spec, 0);
        if (end < 0) {
            return new String[]{spec};
        }
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        do {
            list.add(spec.substring(start, end));
            start = end;
        } while ((end = OrderBy.nextSubSpec(spec, end)) >= 0);
        list.add(spec.substring(start));
        return (String[])list.toArray(String[]::new);
    }

    private static int nextSubSpec(String spec, int pos) {
        int length = spec.length();
        while (++pos < length) {
            char c = spec.charAt(pos);
            if (c != '-' && c != '+') continue;
            return pos;
        }
        return -1;
    }

    private static OrderBy parseSpec(Map<String, ColumnInfo> columns, String spec) {
        OrderBy orderBy = new OrderBy();
        int length = spec.length();
        int pos = 0;
        while (pos < length) {
            int end;
            char order;
            int type = 0;
            if ((order = spec.charAt(pos++)) == '-') {
                type |= 0x80;
            } else if (order != '+') break;
            if (spec.charAt(pos) == '!') {
                type |= 0x100;
            }
            for (end = ++pos; end < length && (order = spec.charAt(end)) != '-' && order != '+'; ++end) {
            }
            if (end == pos) break;
            String name = spec.substring(pos, end);
            ColumnInfo column = columns.get(name);
            if (column == null) {
                throw new IllegalStateException("Unknown column \"" + name + "\" in ordering specification: " + spec);
            }
            pos = end;
            if (column.isPrimitive()) {
                type &= 0xFFFFFEFF;
            }
            if (orderBy.containsKey(name)) continue;
            orderBy.put(name, new Rule(column, type |= column.typeCode & 0xFFFFFE7F));
        }
        return orderBy;
    }

    public record Rule(ColumnInfo column, int type) {
        public ColumnInfo asColumn() {
            ColumnInfo c = this.column;
            if (c.typeCode != this.type) {
                c = c.copy();
                c.typeCode = this.type;
            }
            return c;
        }

        public boolean isDescending() {
            return ColumnInfo.isDescending(this.type);
        }

        public boolean isNullLow() {
            return ColumnInfo.isNullLow(this.type);
        }

        public void appendTo(StringBuilder b) {
            b.append(this.isDescending() ? (char)'-' : '+');
            if (this.isNullLow()) {
                b.append('!');
            }
            b.append(this.column.name);
        }
    }
}

