/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.MethodHandle;
import java.util.function.Predicate;
import org.cojen.tupl.core.Pair;
import org.cojen.tupl.filter.Parser;
import org.cojen.tupl.filter.RowFilter;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowPredicateMaker;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.WeakCache;

final class PlainPredicateMaker {
    private static final WeakCache<Pair<Class<?>, String>, MethodHandle, Object> cCache = new WeakCache<Pair<Class<?>, String>, MethodHandle, Object>(){

        @Override
        public MethodHandle newValue(Pair<Class<?>, String> key, Object unused) {
            Class<?> rowType = key.a();
            String query = key.b();
            RowInfo info = RowInfo.find(rowType);
            RowFilter filter = new Parser(info.allColumns, query).parseQuery(null).filter();
            String filterStr = filter.toString();
            if (filterStr.equals(query)) {
                RowPredicateMaker maker = new RowPredicateMaker(rowType, info.rowGen(), filter, filterStr);
                return maker.finishPlain();
            }
            return (MethodHandle)this.obtain(new Pair(rowType, filterStr), (Object)null);
        }
    };

    PlainPredicateMaker() {
    }

    public static <R> Predicate<R> predicate(Class<R> rowType, String query, Object ... args) {
        MethodHandle mh = (MethodHandle)cCache.obtain((Object)new Pair<Class<R>, String>(rowType, query), (Object)null);
        try {
            return mh.invokeExact(args);
        }
        catch (Throwable e) {
            throw RowUtils.rethrow(e);
        }
    }
}

