/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.BytesColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.PrimitiveArrayUtils;

abstract class PrimitiveArrayColumnCodec
extends BytesColumnCodec {
    protected final int mFlags;
    protected final int mBitPow;

    PrimitiveArrayColumnCodec(ColumnInfo info, MethodMaker mm, int flags) {
        super(info, mm);
        this.mFlags = flags;
        int typeCode = info.plainTypeCode();
        this.mBitPow = switch (typeCode) {
            default -> typeCode & 7;
            case 17 -> 5;
            case 18 -> 6;
        };
    }

    @Override
    protected final boolean doEquals(Object obj) {
        PrimitiveArrayColumnCodec other = (PrimitiveArrayColumnCodec)obj;
        if (this.mFlags != other.mFlags || this.mBitPow != other.mBitPow) {
            return false;
        }
        int typeCode = this.mInfo.typeCode;
        int otherTypeCode = other.mInfo.typeCode;
        if (!this.isLex()) {
            typeCode = ColumnInfo.unorderedTypeCode(typeCode);
            otherTypeCode = ColumnInfo.unorderedTypeCode(otherTypeCode);
        }
        return typeCode == otherTypeCode;
    }

    @Override
    public final int doHashCode() {
        return this.mInfo.unorderedTypeCode();
    }

    @Override
    final int codecFlags() {
        return this.mFlags;
    }

    @Override
    protected Variable filterPrepareBytes(Variable argVar) {
        Variable bytesVar = this.mMaker.var(byte[].class);
        Label cont = null;
        if (this.mInfo.isNullable()) {
            Label notNull = this.mMaker.label();
            argVar.ifNe(null, notNull);
            bytesVar.set(null);
            cont = this.mMaker.label().goto_();
            notNull.here();
        }
        bytesVar.set((Object)this.mMaker.new_(byte[].class, new Object[]{this.byteArrayLength(argVar)}));
        this.encodeByteArray(argVar, bytesVar, 0);
        if (cont != null) {
            cont.here();
        }
        return bytesVar;
    }

    @Override
    protected boolean compareBytesUnsigned() {
        return this.isLex() || this.mInfo.isUnsigned() || ColumnInfo.isFloat(this.mInfo.plainTypeCode());
    }

    protected Variable byteArrayLength(Variable srcVar) {
        Variable lengthVar = srcVar.alength();
        int shift = this.mBitPow - 3;
        if (shift > 0) {
            lengthVar = lengthVar.shl((Object)shift);
        }
        return lengthVar;
    }

    protected void encodeByteArray(Variable srcVar, Variable dstVar, Object offset) {
        Variable utilsVar = this.mMaker.var(PrimitiveArrayUtils.class);
        if (this.mBitPow == 3) {
            Variable lengthVar = srcVar.alength();
            this.mMaker.var(System.class).invoke("arraycopy", new Object[]{srcVar, 0, dstVar, offset, lengthVar});
            if (this.isLex() && !this.mInfo.isUnsigned()) {
                utilsVar.invoke("signFlip", new Object[]{dstVar, offset, lengthVar});
            }
        } else {
            utilsVar.invoke("encodeArray" + this.methodSuffix(), new Object[]{dstVar, offset, srcVar});
        }
    }

    protected void decodeByteArray(Variable dstVar, Variable srcVar, Object offset, Object length) {
        Variable valueVar;
        Variable utilsVar = this.mMaker.var(PrimitiveArrayUtils.class);
        if (this.mBitPow == 3) {
            valueVar = this.mMaker.new_(byte[].class, new Object[]{length});
            this.mMaker.var(System.class).invoke("arraycopy", new Object[]{srcVar, offset, valueVar, 0, length});
            if (this.isLex() && !this.mInfo.isUnsigned()) {
                utilsVar.invoke("signFlip", new Object[]{valueVar, 0, length});
            }
        } else {
            Object method = switch (this.mInfo.plainTypeCode()) {
                case 0 -> "Boolean";
                case 4 -> "Short";
                case 5 -> "Int";
                case 6 -> "Long";
                case 12 -> "Short";
                case 13 -> "Int";
                case 14 -> "Long";
                case 17 -> "Float";
                case 18 -> "Double";
                case 20 -> "Char";
                default -> throw new AssertionError();
            };
            method = "decode" + (String)method + "Array" + this.methodSuffix();
            valueVar = utilsVar.invoke((String)method, new Object[]{srcVar, offset, length});
        }
        dstVar.set((Object)valueVar);
    }

    protected String methodSuffix() {
        return this.mBitPow == 0 ? "" : (this.isLex() && !this.mInfo.isUnsigned() ? "Lex" : "BE");
    }
}

