/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import org.cojen.tupl.rows.RowUtils;

public class PrimitiveArrayUtils
extends RowUtils {
    private static final VarHandle cShortArrayBEHandle;
    private static final VarHandle cIntArrayBEHandle;
    private static final VarHandle cLongArrayBEHandle;
    private static final VarHandle cFloatArrayBEHandle;
    private static final VarHandle cDoubleArrayBEHandle;

    public static void encodeArray(byte[] dst, int offset, boolean[] a) {
        for (boolean v : a) {
            dst[offset++] = v ? (byte)1 : 0;
        }
    }

    public static boolean[] decodeBooleanArray(byte[] src, int offset, int length) {
        boolean[] a = new boolean[length];
        int end = offset + length;
        int i = 0;
        while (offset < end) {
            a[i++] = src[offset] != 0;
            ++offset;
        }
        return a;
    }

    public static void encodeArrayBE(byte[] dst, int offset, short[] a) {
        for (short v : a) {
            cShortArrayBEHandle.set(dst, offset, v);
            offset += 2;
        }
    }

    public static void encodeArrayLex(byte[] dst, int offset, short[] a) {
        for (short v : a) {
            cShortArrayBEHandle.set(dst, offset, (short)(v ^ 0x8000));
            offset += 2;
        }
    }

    public static void encodeArrayBE(byte[] dst, int offset, int[] a) {
        for (int v : a) {
            cIntArrayBEHandle.set(dst, offset, v);
            offset += 4;
        }
    }

    public static void encodeArrayLex(byte[] dst, int offset, int[] a) {
        for (int v : a) {
            cIntArrayBEHandle.set(dst, offset, v ^ Integer.MIN_VALUE);
            offset += 4;
        }
    }

    public static void encodeArrayBE(byte[] dst, int offset, long[] a) {
        for (long v : a) {
            cLongArrayBEHandle.set(dst, offset, v);
            offset += 8;
        }
    }

    public static void encodeArrayLex(byte[] dst, int offset, long[] a) {
        for (long v : a) {
            cLongArrayBEHandle.set(dst, offset, v ^ Long.MIN_VALUE);
            offset += 8;
        }
    }

    public static void encodeArrayBE(byte[] dst, int offset, float[] a) {
        PrimitiveArrayUtils.encodeArrayLex(dst, offset, a);
    }

    public static void encodeArrayLex(byte[] dst, int offset, float[] a) {
        for (float v : a) {
            cIntArrayBEHandle.set(dst, offset, PrimitiveArrayUtils.encodeFloatSign(Float.floatToRawIntBits(v)));
            offset += 4;
        }
    }

    public static void encodeArrayBE(byte[] dst, int offset, double[] a) {
        PrimitiveArrayUtils.encodeArrayLex(dst, offset, a);
    }

    public static void encodeArrayLex(byte[] dst, int offset, double[] a) {
        for (double v : a) {
            cLongArrayBEHandle.set(dst, offset, PrimitiveArrayUtils.encodeFloatSign(Double.doubleToRawLongBits(v)));
            offset += 8;
        }
    }

    public static void encodeArrayBE(byte[] dst, int offset, char[] a) {
        for (char v : a) {
            cShortArrayBEHandle.set(dst, offset, (short)v);
            offset += 2;
        }
    }

    public static void encodeArrayLex(byte[] dst, int offset, char[] a) {
        PrimitiveArrayUtils.encodeArrayBE(dst, offset, a);
    }

    public static short[] decodeShortArrayBE(byte[] src, int offset, int length) {
        short[] a = new short[length >> 1];
        int end = offset + length;
        int i = 0;
        while (offset < end) {
            a[i++] = cShortArrayBEHandle.get(src, offset);
            offset += 2;
        }
        return a;
    }

    public static short[] decodeShortArrayLex(byte[] src, int offset, int length) {
        short[] a = new short[length >> 1];
        int end = offset + length;
        int i = 0;
        while (offset < end) {
            a[i++] = (short)(cShortArrayBEHandle.get(src, offset) ^ 0x8000);
            offset += 2;
        }
        return a;
    }

    public static int[] decodeIntArrayBE(byte[] src, int offset, int length) {
        int[] a = new int[length >> 2];
        int end = offset + length;
        int i = 0;
        while (offset < end) {
            a[i++] = cIntArrayBEHandle.get(src, offset);
            offset += 4;
        }
        return a;
    }

    public static int[] decodeIntArrayLex(byte[] src, int offset, int length) {
        int[] a = new int[length >> 2];
        int end = offset + length;
        int i = 0;
        while (offset < end) {
            a[i++] = cIntArrayBEHandle.get(src, offset) ^ Integer.MIN_VALUE;
            offset += 4;
        }
        return a;
    }

    public static long[] decodeLongArrayBE(byte[] src, int offset, int length) {
        long[] a = new long[length >> 3];
        int end = offset + length;
        int i = 0;
        while (offset < end) {
            a[i++] = cLongArrayBEHandle.get(src, offset);
            offset += 8;
        }
        return a;
    }

    public static long[] decodeLongArrayLex(byte[] src, int offset, int length) {
        long[] a = new long[length >> 3];
        int end = offset + length;
        int i = 0;
        while (offset < end) {
            a[i++] = cLongArrayBEHandle.get(src, offset) ^ Long.MIN_VALUE;
            offset += 8;
        }
        return a;
    }

    public static float[] decodeFloatArrayBE(byte[] src, int offset, int length) {
        return PrimitiveArrayUtils.decodeFloatArrayLex(src, offset, length);
    }

    public static float[] decodeFloatArrayLex(byte[] src, int offset, int length) {
        float[] a = new float[length >> 2];
        int end = offset + length;
        int i = 0;
        while (offset < end) {
            a[i++] = Float.intBitsToFloat(PrimitiveArrayUtils.decodeFloatSign(cIntArrayBEHandle.get(src, offset)));
            offset += 4;
        }
        return a;
    }

    public static double[] decodeDoubleArrayBE(byte[] src, int offset, int length) {
        return PrimitiveArrayUtils.decodeDoubleArrayLex(src, offset, length);
    }

    public static double[] decodeDoubleArrayLex(byte[] src, int offset, int length) {
        double[] a = new double[length >> 3];
        int end = offset + length;
        int i = 0;
        while (offset < end) {
            a[i++] = Double.longBitsToDouble(PrimitiveArrayUtils.decodeFloatSign(cLongArrayBEHandle.get(src, offset)));
            offset += 8;
        }
        return a;
    }

    public static char[] decodeCharArrayBE(byte[] src, int offset, int length) {
        char[] a = new char[length >> 1];
        int end = offset + length;
        int i = 0;
        while (offset < end) {
            a[i++] = (char)cShortArrayBEHandle.get(src, offset);
            offset += 2;
        }
        return a;
    }

    public static char[] decodeCharArrayLex(byte[] src, int offset, int length) {
        return PrimitiveArrayUtils.decodeCharArrayBE(src, offset, length);
    }

    public static void signFlip(byte[] a, int off, int len) {
        int end = off + len;
        for (int i = off; i < end; ++i) {
            a[i] = (byte)(a[i] ^ 0x80);
        }
    }

    public static int lengthBytes32K(int keyLength) {
        return ((keyLength << 4) + 29) / 15 | 1;
    }

    public static int encodeBytes32K(byte[] dst, int dstOffset, byte[] key) {
        return PrimitiveArrayUtils.encodeBytes32K(dst, dstOffset, key, 0);
    }

    public static int encodeBytes32KDesc(byte[] dst, int dstOffset, byte[] key) {
        return PrimitiveArrayUtils.encodeBytes32K(dst, dstOffset, key, -1);
    }

    private static int encodeBytes32K(byte[] dst, int dstOffset, byte[] key, int xorMask) {
        int terminator;
        if (key.length == 0) {
            terminator = 1;
        } else {
            int accumBits = 0;
            int accum = 0;
            for (int i = 0; i < key.length; ++i) {
                if (accumBits <= 7) {
                    accum = accum << 8 | key[i] & 0xFF;
                    if ((accumBits += 8) != 15) continue;
                    PrimitiveArrayUtils.encodeDigit32K(dst, dstOffset, accum, xorMask);
                    dstOffset += 2;
                    accum = 0;
                    accumBits = 0;
                    continue;
                }
                int supply = 15 - accumBits;
                accum = accum << supply | (key[i] & 0xFF) >> 8 - supply;
                PrimitiveArrayUtils.encodeDigit32K(dst, dstOffset, accum, xorMask);
                dstOffset += 2;
                accumBits = 8 - supply;
                accum = key[i] & (1 << accumBits) - 1;
            }
            if (accumBits <= 0) {
                terminator = 16;
            } else {
                terminator = accumBits + 1;
                PrimitiveArrayUtils.encodeDigit32K(dst, dstOffset, accum <<= 15 - accumBits, xorMask);
                dstOffset += 2;
            }
        }
        dst[dstOffset++] = (byte)(terminator ^ xorMask);
        return dstOffset;
    }

    private static void encodeDigit32K(byte[] dst, int dstOffset, int digit, int xor) {
        int a = digit * 21846 >> 22;
        int b = digit - ((a << 7) + (a << 6));
        dst[dstOffset] = (byte)(a + 32 ^ xor);
        dst[dstOffset + 1] = (byte)(b + 32 ^ xor);
    }

    public static int lengthBytes32K(byte[] src, int srcOffset) {
        byte b;
        int start = srcOffset;
        while (-32 > (b = src[srcOffset++]) || b >= 32) {
        }
        return srcOffset - start;
    }

    public static byte[] decodeBytes32K(byte[] src, int srcOffset, int length) {
        return PrimitiveArrayUtils.decodeBytes32K(src, srcOffset, length, 0);
    }

    public static byte[] decodeBytes32KDesc(byte[] src, int srcOffset, int length) {
        return PrimitiveArrayUtils.decodeBytes32K(src, srcOffset, length, -1);
    }

    private static byte[] decodeBytes32K(byte[] src, int srcOffset, int length, int xorMask) {
        int term = (src[srcOffset + length - 1] ^ xorMask) & 0xFF;
        if (length == 1) {
            return (byte[])(term == 1 ? EMPTY_BYTES : null);
        }
        int keyLength = length * 15 - 29 >> 4;
        if (term > 9) {
            ++keyLength;
        }
        byte[] key = new byte[keyLength];
        int keyOffset = 0;
        int endOffset = srcOffset + length - 1;
        int accumBits = 0;
        int accum = 0;
        while (true) {
            int a = ((src[srcOffset++] ^ xorMask) & 0xFF) - 32;
            int b = ((src[srcOffset++] ^ xorMask) & 0xFF) - 32;
            int d = (a << 7) + (a << 6) + b;
            accum = accum << 15 | d;
            key[keyOffset++] = (byte)(accum >> (accumBits += 7));
            if (srcOffset == endOffset) {
                if (term <= 9) break;
                key[keyOffset++] = (byte)(accum >> (accumBits -= 8));
                break;
            }
            if (accumBits < 8) continue;
            key[keyOffset++] = (byte)(accum >> (accumBits -= 8));
        }
        return key;
    }

    static {
        try {
            cShortArrayBEHandle = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.BIG_ENDIAN);
            cIntArrayBEHandle = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.BIG_ENDIAN);
            cLongArrayBEHandle = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.BIG_ENDIAN);
            cFloatArrayBEHandle = MethodHandles.byteArrayViewVarHandle(float[].class, ByteOrder.BIG_ENDIAN);
            cDoubleArrayBEHandle = MethodHandles.byteArrayViewVarHandle(double[].class, ByteOrder.BIG_ENDIAN);
        }
        catch (Throwable e) {
            throw new ExceptionInInitializerError();
        }
    }
}

