/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import org.cojen.maker.Field;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.CompareUtils;
import org.cojen.tupl.rows.RowUtils;

final class PrimitiveColumnCodec
extends ColumnCodec {
    private final int mFlags;
    private final int mSize;

    PrimitiveColumnCodec(ColumnInfo info, MethodMaker mm, int flags, int size) {
        super(info, mm);
        this.mFlags = flags & 0xFFFFFFFE;
        this.mSize = size;
    }

    @Override
    ColumnCodec bind(MethodMaker mm) {
        return new PrimitiveColumnCodec(this.mInfo, mm, this.mFlags, this.mSize);
    }

    @Override
    protected final boolean doEquals(Object obj) {
        PrimitiveColumnCodec other = (PrimitiveColumnCodec)obj;
        if (this.mFlags != other.mFlags || this.mSize != other.mSize) {
            return false;
        }
        int typeCode = this.mInfo.typeCode;
        int otherTypeCode = other.mInfo.typeCode;
        if (!this.isLex()) {
            typeCode = ColumnInfo.unorderedTypeCode(typeCode);
            otherTypeCode = ColumnInfo.unorderedTypeCode(otherTypeCode);
        }
        return typeCode == otherTypeCode;
    }

    @Override
    public final int doHashCode() {
        return this.mInfo.unorderedTypeCode();
    }

    @Override
    int codecFlags() {
        return this.mFlags;
    }

    @Override
    int minSize() {
        return this.mInfo.isNullable() ? 1 : this.mSize;
    }

    @Override
    void encodePrepare() {
    }

    @Override
    void encodeSkip() {
    }

    @Override
    Variable encodeSize(Variable srcVar, Variable totalVar) {
        if (this.mInfo.isNullable() && this.mInfo.plainTypeCode() != 0) {
            if (totalVar == null) {
                totalVar = this.mMaker.var(Integer.TYPE).set((Object)0);
            }
            Label isNull = this.mMaker.label();
            srcVar.ifEq(null, isNull);
            totalVar.inc((Object)this.mSize);
            isNull.here();
        }
        return totalVar;
    }

    @Override
    void encode(Variable srcVar, Variable dstVar, Variable offsetVar) {
        Label end;
        block28: {
            String format;
            String methodType;
            end = null;
            int plain = this.mInfo.plainTypeCode();
            if (this.mInfo.isNullable() && plain != 0) {
                end = this.mMaker.label();
                this.encodeNullHeader(end, srcVar, dstVar, offsetVar);
            }
            switch (plain) {
                case 0: 
                case 3: 
                case 11: {
                    if (plain == 0) {
                        byte t;
                        byte f;
                        byte n = this.nullByte();
                        if (!this.isLex()) {
                            f = 0;
                            t = 1;
                        } else {
                            f = -128;
                            t = -127;
                            if (this.mInfo.isDescending()) {
                                f = ~f;
                                t = ~t;
                            }
                        }
                        Variable byteVar = this.mMaker.var(Byte.TYPE);
                        Label cont = this.mMaker.label();
                        if (this.mInfo.isNullable()) {
                            Label notNull = this.mMaker.label();
                            srcVar.ifNe(null, notNull);
                            byteVar.set((Object)n);
                            this.mMaker.goto_(cont);
                            notNull.here();
                        }
                        Label trueCase = this.mMaker.label();
                        srcVar.ifTrue(trueCase);
                        byteVar.set((Object)f);
                        this.mMaker.goto_(cont);
                        trueCase.here();
                        byteVar.set((Object)t);
                        srcVar = byteVar;
                        cont.here();
                    } else if (this.isLex()) {
                        if (plain == 11) {
                            byte mask = (byte)(this.mInfo.isDescending() ? 127 : 128);
                            srcVar = srcVar.unbox().xor((Object)mask);
                        } else if (this.mInfo.isDescending()) {
                            srcVar = srcVar.unbox().xor((Object)-1);
                        }
                    }
                    dstVar.aset((Object)offsetVar, (Object)srcVar);
                    offsetVar.inc((Object)1);
                    break block28;
                }
                case 4: 
                case 12: 
                case 20: {
                    methodType = "Short";
                    break;
                }
                case 17: {
                    srcVar = this.mMaker.var(Float.class).invoke("floatToRawIntBits", new Object[]{srcVar});
                }
                case 5: 
                case 13: {
                    methodType = "Int";
                    break;
                }
                case 18: {
                    srcVar = this.mMaker.var(Double.class).invoke("doubleToRawLongBits", new Object[]{srcVar});
                }
                case 6: 
                case 14: {
                    methodType = "Long";
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            Variable rowUtils = this.mMaker.var(RowUtils.class);
            if (!this.isLex()) {
                format = "LE";
            } else {
                format = "BE";
                if (ColumnInfo.isFloat(plain)) {
                    Object method = "encodeFloatSign";
                    if (this.mInfo.isDescending()) {
                        method = (String)method + "Desc";
                    }
                    srcVar = rowUtils.invoke((String)method, new Object[]{srcVar});
                } else if (!this.mInfo.isUnsigned()) {
                    srcVar = srcVar.unbox().xor(this.signMask());
                } else if (this.mInfo.isDescending()) {
                    srcVar = srcVar.unbox().xor((Object)-1);
                }
            }
            String methodName = "encode" + methodType + format;
            rowUtils.invoke(methodName, new Object[]{dstVar, offsetVar, srcVar});
            offsetVar.inc((Object)this.mSize);
        }
        if (end != null) {
            end.here();
        }
    }

    @Override
    void decode(Variable dstVar, Variable srcVar, Variable offsetVar, Variable endVar) {
        this.decode(dstVar, srcVar, offsetVar, this.mInfo.isNullable());
    }

    private void decode(Variable dstVar, Variable srcVar, Variable offsetVar, boolean isNullable) {
        Variable valueVar;
        Label end;
        block31: {
            String methodType;
            end = null;
            int plain = this.mInfo.plainTypeCode();
            if (isNullable && plain != 0) {
                end = this.mMaker.label();
                this.decodeNullHeader(end, dstVar, srcVar, offsetVar);
            }
            switch (plain) {
                case 0: 
                case 3: 
                case 11: {
                    Variable byteVar = srcVar.aget((Object)offsetVar);
                    offsetVar.inc((Object)1);
                    if (plain == 0) {
                        Label cont = null;
                        if (!isNullable) {
                            valueVar = this.mMaker.var(Boolean.TYPE);
                        } else {
                            byte n = this.nullByte();
                            valueVar = this.mMaker.var(Boolean.class);
                            Label notNull = this.mMaker.label();
                            byteVar.ifNe((Object)n, notNull);
                            valueVar.set(null);
                            cont = this.mMaker.label().goto_();
                            notNull.here();
                        }
                        if (this.mInfo.isDescending()) {
                            byteVar = byteVar.com();
                        }
                        valueVar.set((Object)byteVar.cast(Boolean.TYPE));
                        if (cont != null) {
                            cont.here();
                        }
                    } else {
                        if (this.isLex()) {
                            if (plain == 11) {
                                byte mask = (byte)(this.mInfo.isDescending() ? 127 : 128);
                                byteVar = byteVar.xor((Object)mask);
                            } else if (this.mInfo.isDescending()) {
                                byteVar = byteVar.xor((Object)-1);
                            }
                        }
                        valueVar = byteVar;
                    }
                    break block31;
                }
                case 4: 
                case 12: 
                case 20: {
                    methodType = "UnsignedShort";
                    break;
                }
                case 5: 
                case 13: 
                case 17: {
                    methodType = "Int";
                    break;
                }
                case 6: 
                case 14: 
                case 18: {
                    methodType = "Long";
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            Variable rowUtils = this.mMaker.var(RowUtils.class);
            String methodName = "decode" + methodType + (this.isLex() ? "BE" : "LE");
            valueVar = rowUtils.invoke(methodName, new Object[]{srcVar, offsetVar});
            offsetVar.inc((Object)this.mSize);
            if (this.isLex()) {
                if (ColumnInfo.isFloat(plain)) {
                    Object method = "decodeFloatSign";
                    if (this.mInfo.isDescending()) {
                        method = (String)method + "Desc";
                    }
                    valueVar = rowUtils.invoke((String)method, new Object[]{valueVar});
                } else if (!this.mInfo.isUnsigned()) {
                    valueVar = valueVar.xor(this.signMask());
                } else if (this.mInfo.isDescending()) {
                    valueVar = valueVar.xor((Object)-1);
                }
            }
            valueVar = switch (plain) {
                case 4, 12 -> valueVar.cast(Short.TYPE);
                case 20 -> valueVar.cast(Character.TYPE);
                case 17 -> this.mMaker.var(Float.class).invoke("intBitsToFloat", new Object[]{valueVar});
                case 18 -> this.mMaker.var(Double.class).invoke("longBitsToDouble", new Object[]{valueVar});
                default -> valueVar;
            };
        }
        dstVar.set((Object)valueVar);
        if (end != null) {
            end.here();
        }
    }

    @Override
    void decodeSkip(Variable srcVar, Variable offsetVar, Variable endVar) {
        Label end = null;
        if (this.mInfo.isNullable() && this.mInfo.plainTypeCode() != 0) {
            end = this.mMaker.label();
            this.decodeNullHeader(end, null, srcVar, offsetVar);
        }
        offsetVar.inc((Object)this.mSize);
        if (end != null) {
            end.here();
        }
    }

    @Override
    boolean canFilterQuick(ColumnInfo dstInfo) {
        return dstInfo.typeCode == this.mInfo.typeCode && !dstInfo.type.isPrimitive() && dstInfo.plainTypeCode() != 0;
    }

    @Override
    Object filterQuickDecode(ColumnInfo dstInfo, Variable srcVar, Variable offsetVar, Variable endVar) {
        Variable columnVar = this.mMaker.var(dstInfo.unboxedType());
        if (!dstInfo.isNullable()) {
            this.decode(columnVar, srcVar, offsetVar, false);
            return columnVar;
        }
        columnVar.set((Object)0);
        Variable isNullVar = this.mMaker.var(Boolean.TYPE);
        this.decodeNullHeader(null, isNullVar, srcVar, offsetVar);
        Label isNull = this.mMaker.label();
        isNullVar.ifTrue(isNull);
        this.decode(columnVar, srcVar, offsetVar, false);
        isNull.here();
        return new Variable[]{columnVar, isNullVar};
    }

    @Override
    void filterQuickCompare(ColumnInfo dstInfo, Variable srcVar, Variable offsetVar, int op, Object decoded, Variable argObjVar, int argNum, Label pass, Label fail) {
        Variable isNullVar;
        Variable columnVar;
        if (decoded instanceof Variable) {
            columnVar = (Variable)decoded;
            isNullVar = null;
        } else {
            Variable[] pair = (Variable[])decoded;
            columnVar = pair[0];
            isNullVar = pair[1];
        }
        Field argField = argObjVar.field(this.argFieldName(argNum));
        if (isNullVar != null) {
            this.compareNullHeader(isNullVar, null, (Variable)argField, op, pass, fail);
        } else if (this.mInfo.isNullable()) {
            CompareUtils.compare(this.mMaker, dstInfo, columnVar, dstInfo, (Variable)argField, op, pass, fail);
            return;
        }
        CompareUtils.comparePrimitives(this.mMaker, dstInfo, columnVar, dstInfo, (Variable)argField, op, pass, fail);
    }

    private Object signMask() {
        if (this.mSize == 8) {
            long lmask = Long.MIN_VALUE;
            if (this.mInfo.isDescending()) {
                lmask ^= 0xFFFFFFFFFFFFFFFFL;
            }
            return lmask;
        }
        if (this.mSize == 4) {
            int imask = Integer.MIN_VALUE;
            if (this.mInfo.isDescending()) {
                imask ^= 0xFFFFFFFF;
            }
            return imask;
        }
        int imask = 32768;
        if (this.mInfo.isDescending()) {
            imask ^= 0xFFFFFFFF;
        }
        return (int)(this.mInfo.plainTypeCode() == 20 ? (short)imask : (short)imask);
    }
}

