/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.IOException;
import java.util.Comparator;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.View;
import org.cojen.tupl.core.RowPredicate;
import org.cojen.tupl.rows.MergedScanController;
import org.cojen.tupl.rows.RowEvaluator;
import org.cojen.tupl.rows.ScanController;
import org.cojen.tupl.rows.SingleScanController;

final class RangeUnionScanController<R>
implements ScanController<R> {
    private final SingleScanController<R>[] mControllers;
    private int mPosition;
    private SingleScanController<R> mCurrent;

    RangeUnionScanController(SingleScanController<R>[] controllers) {
        this.mControllers = controllers;
        this.assignCurrent(0);
    }

    @Override
    public boolean isJoined() {
        for (SingleScanController<R> controller : this.mControllers) {
            if (!controller.isJoined()) continue;
            return true;
        }
        return false;
    }

    @Override
    public RowPredicate<R> predicate() {
        return this.mControllers[0].predicate();
    }

    @Override
    public long estimateSize() {
        try {
            long size = this.mControllers[0].estimateSize();
            for (int i = 1; size != Long.MAX_VALUE && i < this.mControllers.length; ++i) {
                long nextSize = this.mControllers[i].estimateSize();
                if (nextSize == Long.MAX_VALUE) {
                    return nextSize;
                }
                size = Math.addExact(size, nextSize);
            }
            return size;
        }
        catch (ArithmeticException e) {
            return Long.MAX_VALUE;
        }
    }

    @Override
    public int characteristics() {
        return this.mControllers[0].characteristics();
    }

    @Override
    public Cursor newCursor(View view, Transaction txn) throws IOException {
        return this.mCurrent.newCursor(view, txn);
    }

    @Override
    public RowEvaluator<R> evaluator() {
        return this.mCurrent.evaluator();
    }

    @Override
    public boolean next() {
        int pos = this.mPosition + 1;
        if (pos < this.mControllers.length) {
            this.assignCurrent(pos);
            return true;
        }
        this.mCurrent = null;
        return false;
    }

    private void assignCurrent(int pos) {
        SingleScanController<R> next;
        MergedScanController<R> merged;
        int nextPos;
        SingleScanController<R> current = this.mControllers[pos];
        Comparator<byte[]> comparator = current.comparator();
        while ((nextPos = pos + 1) < this.mControllers.length && (merged = MergedScanController.tryMerge(comparator, current, next = this.mControllers[nextPos])) != null) {
            current = merged;
            pos = nextPos;
        }
        this.mPosition = pos;
        this.mCurrent = current;
    }
}

