/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.util.Arrays;
import org.cojen.tupl.core.RowPredicate;
import org.cojen.tupl.diag.QueryPlan;
import org.cojen.tupl.rows.RangeUnionScanController;
import org.cojen.tupl.rows.ScanController;
import org.cojen.tupl.rows.ScanControllerFactory;
import org.cojen.tupl.rows.SingleScanController;

final class RangeUnionScanControllerFactory<R>
implements ScanControllerFactory<R> {
    private final ScanControllerFactory<R>[] mRanges;

    RangeUnionScanControllerFactory(ScanControllerFactory<R>[] ranges) {
        if (ranges.length <= 1) {
            throw new IllegalArgumentException();
        }
        this.mRanges = ranges;
    }

    @Override
    public QueryPlan plan(Object ... args) {
        QueryPlan[] plans = new QueryPlan[this.mRanges.length];
        for (int i = 0; i < plans.length; ++i) {
            plans[i] = this.mRanges[i].plan(args);
        }
        return new QueryPlan.RangeUnion(plans);
    }

    @Override
    public ScanControllerFactory<R> reverse() {
        ScanControllerFactory[] reversed = new ScanControllerFactory[this.mRanges.length];
        for (int i = 0; i < reversed.length; ++i) {
            reversed[reversed.length - i - 1] = this.mRanges[i].reverse();
        }
        return new RangeUnionScanControllerFactory<R>(reversed);
    }

    @Override
    public RowPredicate<R> predicate(Object ... args) {
        return this.mRanges[0].predicate(args);
    }

    @Override
    public int characteristics() {
        return this.mRanges[0].characteristics();
    }

    @Override
    public ScanController<R> scanController(Object ... args) {
        ScanControllerFactory<R>[] ranges = this.mRanges;
        SingleScanController[] controllers = new SingleScanController[ranges.length];
        SingleScanController first = (SingleScanController)ranges[0].scanController(args);
        RowPredicate predicate = first.predicate();
        controllers[0] = first;
        for (int i = 1; i < controllers.length; ++i) {
            controllers[i] = (SingleScanController)ranges[i].scanController(predicate);
        }
        Arrays.sort(controllers, SingleScanController::compareLow);
        return new RangeUnionScanController(controllers);
    }

    @Override
    public ScanController<R> scanController(RowPredicate<R> predicate) {
        ScanControllerFactory<R>[] ranges = this.mRanges;
        SingleScanController[] controllers = new SingleScanController[ranges.length];
        for (int i = 0; i < controllers.length; ++i) {
            controllers[i] = (SingleScanController)ranges[i].scanController(predicate);
        }
        Arrays.sort(controllers, SingleScanController::compareLow);
        return new RangeUnionScanController(controllers);
    }
}

