/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.util.Latch;

abstract class RefCache<K, V, H>
extends ReferenceQueue<Object> {
    private static final MethodHandle START_VIRTUAL_THREAD;

    public RefCache() {
        if (START_VIRTUAL_THREAD != null) {
            try {
                Thread thread = START_VIRTUAL_THREAD.invokeExact(() -> {
                    try {
                        while (true) {
                            Reference ref = this.remove();
                            RefCache refCache = this;
                            synchronized (refCache) {
                                this.cleanup(ref);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public abstract void clear();

    public final V get(K key) {
        Reference<V> ref = this.getRef(key);
        return ref == null ? null : (V)ref.get();
    }

    public abstract Reference<V> getRef(K var1);

    public abstract Reference<V> put(K var1, V var2);

    public abstract void removeKey(K var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public V obtain(K key, H helper) {
        while (true) {
            if ((value = this.get(key)) != null) {
                if (!(value instanceof Latch)) {
                    return value;
                }
                latch = (Latch)value;
            } else {
                var5_5 = this;
                synchronized (var5_5) {
                    value = this.get(key);
                    if (value == null) {
                        latch = new Latch(-2147483648);
                        this.put(key, latch);
                        break;
                    }
                    if (!(value instanceof Latch)) {
                        return value;
                    }
                    latch = (Latch)value;
                }
            }
            latch.acquireShared();
        }
        ex = null;
        try {
            value = this.newValue(key, helper);
        }
        catch (Throwable e) {
            value = null;
            ex = e;
        }
        try {
            if (value == null) ** GOTO lbl43
            try {
                this.put(key, value);
            }
            catch (Throwable e) {
                if (ex == null) {
                    ex = e;
                } else {
                    ex.addSuppressed(e);
                }
lbl43:
                // 3 sources

                this.removeKey(key);
            }
        }
        finally {
            latch.releaseExclusive();
        }
        if (ex != null) {
            throw RowUtils.rethrow(ex);
        }
        return value;
    }

    protected V newValue(K key, H helper) {
        throw new UnsupportedOperationException();
    }

    protected abstract void cleanup(Object var1);

    static {
        MethodHandle mh;
        try {
            MethodType mt = MethodType.methodType(Thread.class, Runnable.class);
            mh = MethodHandles.lookup().findStatic(Thread.class, "startVirtualThread", mt);
            Thread thread = mh.invokeExact(() -> {});
        }
        catch (Throwable e) {
            mh = null;
        }
        START_VIRTUAL_THREAD = mh;
    }
}

