/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import java.util.TreeMap;
import org.cojen.dirmi.Pipe;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.Field;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.remote.RemoteTableProxy;
import org.cojen.tupl.remote.RemoteTransaction;
import org.cojen.tupl.remote.RemoteUpdater;
import org.cojen.tupl.remote.ServerTransaction;
import org.cojen.tupl.remote.ServerUpdater;
import org.cojen.tupl.rows.AutomaticKeyGenerator;
import org.cojen.tupl.rows.BaseTable;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.Converter;
import org.cojen.tupl.rows.RowGen;
import org.cojen.tupl.rows.RowHeader;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowMaker;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.SoftCache;
import org.cojen.tupl.rows.TableMaker;

public final class RemoteProxyMaker {
    private static final SoftCache<CacheKey, MethodHandle, BaseTable> cCache = new SoftCache<CacheKey, MethodHandle, BaseTable>(){

        @Override
        protected MethodHandle newValue(CacheKey key, BaseTable table) {
            return new RemoteProxyMaker(table, key.descriptor).finish();
        }
    };
    private final BaseTable mTable;
    private final Class<?> mRowType;
    private final Class<?> mRowClass;
    private final RowGen mRowGen;
    private final RowHeader mRowHeader;
    private final ClassMaker mClassMaker;
    private final ColumnInfo mAutoColumn;
    private Variable mUpdaterFactoryVar;
    private ColumnCodec[] mClientCodecs;

    static RemoteTableProxy make(BaseTable<?> table, int schemaVersion, byte[] descriptor) {
        MethodHandle mh = (MethodHandle)cCache.obtain(new CacheKey(table.getClass(), descriptor), table);
        try {
            return mh.invoke(table, schemaVersion);
        }
        catch (Throwable e) {
            throw RowUtils.rethrow(e);
        }
    }

    private RemoteProxyMaker(BaseTable table, byte[] descriptor) {
        this.mTable = table;
        this.mRowType = table.rowType();
        this.mRowClass = RowMaker.find(this.mRowType);
        this.mRowGen = RowInfo.find(this.mRowType).rowGen();
        this.mRowHeader = RowHeader.decode(descriptor);
        this.mClassMaker = this.mRowGen.beginClassMaker(RemoteProxyMaker.class, this.mRowType, null);
        this.mClassMaker.implement(RemoteTableProxy.class);
        ColumnInfo auto = null;
        for (ColumnInfo column : this.mRowGen.info.keyColumns.values()) {
            if (!column.isAutomatic()) continue;
            auto = column;
            break;
        }
        this.mAutoColumn = auto;
    }

    private MethodHandle finish() {
        MethodHandles.Lookup lookup;
        this.mClassMaker.addField(Boolean.TYPE, "assert").private_().static_().final_();
        MethodMaker mm = this.mClassMaker.addClinit();
        mm.field("assert").set((Object)mm.class_().invoke("desiredAssertionStatus", new Object[0]));
        Class<?> tableClass = this.mTable.getClass();
        this.mClassMaker.addField(tableClass, "table").private_().final_();
        MethodMaker ctorMaker = this.mClassMaker.addConstructor(new Object[]{tableClass, Integer.TYPE}).private_();
        ctorMaker.invokeSuperConstructor(new Object[0]);
        ctorMaker.field("table").set((Object)ctorMaker.param(0));
        if (RowHeader.make(this.mRowGen).equals(this.mRowHeader)) {
            this.mClassMaker.addField(this.mRowClass, "EMPTY_ROW").private_().static_().final_();
            MethodMaker mm2 = this.mClassMaker.addClinit();
            mm2.field("EMPTY_ROW").set((Object)mm2.new_(this.mRowClass, new Object[0]));
            if (this.mTable.isEvolvable()) {
                this.mClassMaker.addField(Integer.TYPE, "prefixLength").private_().final_();
                this.mClassMaker.addField(Integer.TYPE, "schemaVersion").private_().final_();
                Variable schemaVersionVar = ctorMaker.param(1);
                Label small = ctorMaker.label();
                schemaVersionVar.ifLt((Object)128, small);
                ctorMaker.field("prefixLength").set((Object)4);
                schemaVersionVar.set((Object)schemaVersionVar.or((Object)Integer.MIN_VALUE));
                Label cont = ctorMaker.label().goto_();
                small.here();
                ctorMaker.field("prefixLength").set((Object)1);
                cont.here();
                ctorMaker.field("schemaVersion").set((Object)schemaVersionVar);
            }
            lookup = this.makeDirect();
        } else {
            if (!this.mTable.isEvolvable()) {
                throw new IllegalStateException();
            }
            lookup = this.makeConverter();
        }
        try {
            MethodType mt = MethodType.methodType(Void.TYPE, tableClass, Integer.TYPE);
            return lookup.findConstructor(lookup.lookupClass(), mt);
        }
        catch (Throwable e) {
            throw RowUtils.rethrow(e);
        }
    }

    private MethodHandles.Lookup makeDirect() {
        this.addRequireSet("requireAllSet", this.mRowGen.info.allColumns);
        this.addByKeyDirectMethod("load");
        this.addByKeyDirectMethod("exists");
        this.addByKeyDirectMethod("delete");
        this.addStoreDirectMethod("store");
        this.addStoreDirectMethod("exchange");
        this.addStoreDirectMethod("insert");
        this.addStoreDirectMethod("replace");
        this.addUpdateDirectMethod("update");
        this.addUpdateDirectMethod("merge");
        this.addDecodeRow();
        this.addEncodeColumns(true);
        this.addEncodeColumns(false);
        this.addUpdaterMethod("row");
        this.addUpdaterMethod("step");
        this.addUpdaterMethod("update");
        this.addUpdaterMethod("delete");
        return this.mClassMaker.finishLookup();
    }

    private void addRequireSet(String name, Map<String, ColumnInfo> columns) {
        Object[] paramTypes = new Object[1 + (columns.size() + 15) / 16];
        paramTypes[0] = Pipe.class;
        for (int i = 1; i < paramTypes.length; ++i) {
            paramTypes[i] = Integer.TYPE;
        }
        MethodMaker mm = this.mClassMaker.addMethod(null, name, paramTypes).private_().static_();
        Variable pipeVar = mm.param(0);
        mm.var(RemoteProxyMaker.class).invoke("skipKeyAndValue", new Object[]{pipeVar});
        Variable exVar = mm.var(Throwable.class);
        Label tryStart = mm.label().here();
        this.mRowGen.requireSet(mm, columns, num -> mm.param(1 + (num >> 4)));
        exVar.set((Object)mm.new_(AssertionError.class, new Object[0]));
        Label finish = mm.label().goto_();
        Label tryEnd = mm.label().here();
        exVar.set((Object)mm.catch_(tryStart, tryEnd, Throwable.class));
        finish.here();
        pipeVar.invoke("writeObject", new Object[]{exVar});
        pipeVar.invoke("flush", new Object[0]);
        pipeVar.invoke("recycle", new Object[0]);
        mm.return_();
    }

    private void checkPrimaryKeySet(MethodMaker mm, Variable pipeVar, Variable[] stateVars) {
        Label isReady = mm.label();
        this.checkSet(mm, this.mRowGen.info.keyColumns, stateVars).ifTrue(isReady);
        mm.var(RemoteProxyMaker.class).invoke("skipKeyAndValue", new Object[]{pipeVar});
        Variable iseVar = mm.new_(IllegalStateException.class, new Object[]{"Primary key isn't fully specified"});
        pipeVar.invoke("writeObject", new Object[]{iseVar});
        pipeVar.invoke("flush", new Object[0]);
        pipeVar.invoke("recycle", new Object[0]);
        mm.return_(null);
        isReady.here();
    }

    private void addByKeyDirectMethod(String variant) {
        MethodMaker mm = this.mClassMaker.addMethod(Pipe.class, variant, new Object[]{RemoteTransaction.class, Pipe.class}).public_();
        Variable txnVar = this.txn(mm.param(0));
        Variable pipeVar = mm.param(1);
        Label tryStart = mm.label().here();
        Variable[] stateVars = this.readStateFields(pipeVar);
        this.checkPrimaryKeySet(mm, pipeVar, stateVars);
        Variable makerVar = mm.var(RemoteProxyMaker.class);
        Variable keyVar = makerVar.invoke("decodeKey", new Object[]{pipeVar});
        makerVar.invoke("skipValue", new Object[]{pipeVar});
        Variable valueVar = makerVar.invoke(variant, new Object[]{mm.field("table"), txnVar, keyVar, pipeVar});
        if (variant == "load") {
            Label done = mm.label();
            valueVar.ifEq(null, done);
            this.convertAndWriteValue(pipeVar, valueVar);
            pipeVar.invoke("flush", new Object[0]);
            pipeVar.invoke("recycle", new Object[0]);
            done.here();
        }
        mm.return_(null);
        Variable exVar = mm.catch_(tryStart, mm.label().here(), Throwable.class);
        makerVar.invoke("handleException", new Object[]{exVar, pipeVar});
        mm.return_(null);
    }

    private void addStoreDirectMethod(String variant) {
        MethodMaker mm = this.mClassMaker.addMethod(Pipe.class, variant, new Object[]{RemoteTransaction.class, Pipe.class}).public_();
        Variable txnVar = this.txn(mm.param(0));
        Variable pipeVar = mm.param(1);
        Label tryStart = mm.label().here();
        Variable[] stateVars = this.readStateFields(pipeVar);
        Label isReady = mm.label();
        this.checkSet(mm, this.mRowGen.info.allColumns, stateVars).ifTrue(isReady);
        Variable makerVar = mm.var(RemoteProxyMaker.class);
        if (variant != "replace" && this.mAutoColumn != null) {
            TreeMap<String, ColumnInfo> allButAuto = new TreeMap<String, ColumnInfo>(this.mRowGen.info.allColumns);
            allButAuto.remove(this.mAutoColumn.name);
            Label notReady = mm.label();
            this.checkSet(mm, allButAuto, stateVars).ifFalse(notReady);
            int tailLen = this.mAutoColumn.type == Integer.TYPE ? 4 : 8;
            Variable keyVar = makerVar.invoke("decodeKey", new Object[]{pipeVar, tailLen});
            Variable valueVar = this.decodeValue(makerVar, pipeVar);
            Variable tableVar = mm.field("table").get();
            makerVar.invoke("storeAuto", new Object[]{tableVar, tableVar.field("autogen"), txnVar, mm.field("EMPTY_ROW"), keyVar, valueVar, pipeVar});
            mm.return_(null);
            notReady.here();
        }
        Object[] paramVars = new Object[1 + stateVars.length];
        paramVars[0] = pipeVar;
        System.arraycopy(stateVars, 0, paramVars, 1, stateVars.length);
        mm.invoke("requireAllSet", paramVars);
        mm.return_(null);
        isReady.here();
        Variable keyVar = makerVar.invoke("decodeKey", new Object[]{pipeVar});
        Variable valueVar = this.decodeValue(makerVar, pipeVar);
        Variable oldValueVar = makerVar.invoke(variant, new Object[]{mm.field("table"), txnVar, mm.field("EMPTY_ROW"), keyVar, valueVar, pipeVar});
        if (variant == "exchange") {
            Label done = mm.label();
            oldValueVar.ifEq(null, done);
            this.convertAndWriteValue(pipeVar, oldValueVar);
            pipeVar.invoke("flush", new Object[0]);
            pipeVar.invoke("recycle", new Object[0]);
            done.here();
        }
        mm.return_(null);
        Variable exVar = mm.catch_(tryStart, mm.label().here(), Throwable.class);
        makerVar.invoke("handleException", new Object[]{exVar, pipeVar});
        mm.return_(null);
    }

    private Variable decodeValue(Variable makerVar, Variable pipeVar) {
        Variable valueVar;
        MethodMaker mm = makerVar.methodMaker();
        if (this.mTable.isEvolvable()) {
            valueVar = makerVar.invoke("decodeValue", new Object[]{pipeVar, mm.field("prefixLength")});
            mm.var(RowUtils.class).invoke("encodePrefixPF", new Object[]{valueVar, 0, mm.field("schemaVersion")});
        } else {
            valueVar = makerVar.invoke("decodeValue", new Object[]{pipeVar});
        }
        return valueVar;
    }

    private void addUpdateDirectMethod(String variant) {
        Label mergeReply;
        MethodMaker mm = this.mClassMaker.addMethod(Pipe.class, variant, new Object[]{RemoteTransaction.class, Pipe.class}).public_();
        Variable txnVar = this.txn(mm.param(0));
        Variable pipeVar = mm.param(1);
        Label tryStart = mm.label().here();
        Variable[] stateVars = this.readStateFields(pipeVar);
        this.checkPrimaryKeySet(mm, pipeVar, stateVars);
        Variable makerVar = mm.var(RemoteProxyMaker.class);
        Variable keyVar = makerVar.invoke("decodeKey", new Object[]{pipeVar});
        Label partial = mm.label();
        this.checkDirty(mm, this.mRowGen.info.valueColumns, stateVars).ifFalse(partial);
        Variable newValueVar = this.decodeValue(makerVar, pipeVar);
        if (variant == "merge") {
            Variable resultVar = makerVar.invoke("mergeReplace", new Object[]{mm.field("table"), txnVar, mm.field("EMPTY_ROW"), keyVar, newValueVar, pipeVar});
            mergeReply = mm.label();
            resultVar.ifTrue(mergeReply);
        } else {
            makerVar.invoke("replace", new Object[]{mm.field("table"), txnVar, mm.field("EMPTY_ROW"), keyVar, newValueVar, pipeVar});
            mergeReply = null;
        }
        mm.return_(null);
        partial.here();
        Variable dirtyValueVar = makerVar.invoke("decodeValue", new Object[]{pipeVar});
        if (this.mUpdaterFactoryVar == null) {
            this.mUpdaterFactoryVar = makerVar.condy("condyValueUpdater", new Object[]{mm.class_(), this.mTable.getClass(), this.mRowType}).invoke(MethodHandle.class, "_");
        }
        Object[] params = new Object[2 + stateVars.length];
        params[0] = mm.this_();
        params[1] = dirtyValueVar;
        System.arraycopy(stateVars, 0, params, 2, stateVars.length);
        Variable updaterFactoryVar = mm.var(MethodHandle.class).set((Object)this.mUpdaterFactoryVar);
        Variable updaterVar = updaterFactoryVar.invoke(BaseTable.ValueUpdater.class, "invokeExact", (Object[])null, params);
        Variable resultVar = makerVar.invoke(variant, new Object[]{mm.field("table"), txnVar, mm.field("EMPTY_ROW"), keyVar, updaterVar, pipeVar});
        if (variant == "merge") {
            newValueVar.set((Object)resultVar);
            Label done = mm.label();
            newValueVar.ifEq(null, done);
            mergeReply.here();
            this.writeValue(pipeVar, newValueVar);
            pipeVar.invoke("flush", new Object[0]);
            pipeVar.invoke("recycle", new Object[0]);
            done.here();
        }
        mm.return_(null);
        Variable exVar = mm.catch_(tryStart, mm.label().here(), Throwable.class);
        makerVar.invoke("handleException", new Object[]{exVar, pipeVar});
        mm.return_(null);
    }

    public static MethodHandle condyValueUpdater(MethodHandles.Lookup lookup, String name, Class<?> type, Class<?> proxyClass, Class<?> tableClass, Class<?> rowType) {
        MethodHandle factory;
        Field schemaVersion;
        RowInfo rowInfo = RowInfo.find(rowType);
        RowGen rowGen = rowInfo.rowGen();
        ClassMaker cm = ClassMaker.begin((String)proxyClass.getName(), (MethodHandles.Lookup)lookup);
        cm.implement(BaseTable.ValueUpdater.class);
        int numStateFields = (rowInfo.allColumns.size() + 15) / 16;
        cm.addField(proxyClass, "proxy").private_().final_();
        cm.addField(byte[].class, "dirtyValue").private_().final_();
        for (int i = 0; i < numStateFields; ++i) {
            cm.addField(Integer.TYPE, "state$" + i).private_().final_();
        }
        Class[] paramTypes = new Class[2 + numStateFields];
        paramTypes[0] = proxyClass;
        paramTypes[1] = byte[].class;
        for (int i = 2; i < paramTypes.length; ++i) {
            paramTypes[i] = Integer.TYPE;
        }
        MethodType ctorType = MethodType.methodType(Void.TYPE, paramTypes);
        MethodMaker mm = cm.addConstructor(ctorType);
        mm.invokeSuperConstructor(new Object[0]);
        mm.field("proxy").set((Object)mm.param(0));
        mm.field("dirtyValue").set((Object)mm.param(1));
        for (int i = 0; i < numStateFields; ++i) {
            mm.field("state$" + i).set((Object)mm.param(2 + i));
        }
        MethodMaker mm2 = cm.addMethod(byte[].class, "updateValue", new Object[]{byte[].class}).public_();
        Variable originalValueVar = mm2.param(0);
        Variable tableVar = mm2.var(tableClass);
        Class<?> rowClass = RowMaker.find(rowType);
        if (BaseTable.isEvolvable(rowType)) {
            schemaVersion = mm2.field("proxy").field("schemaVersion");
            TableMaker.convertValueIfNecessary(tableVar, rowClass, schemaVersion, originalValueVar);
        } else {
            schemaVersion = null;
        }
        Variable dirtyValueVar = mm2.field("dirtyValue").get();
        Map<String, Integer> columnNumbers = rowGen.columnNumbers();
        ColumnCodec[] codecs = ColumnCodec.bind(rowGen.valueCodecs(), mm2);
        Variable[] offsetVars = new Variable[codecs.length];
        Variable newSizeVar = dirtyValueVar.alength();
        Variable startOffsetVar = mm2.var(Integer.TYPE);
        if (schemaVersion != null) {
            startOffsetVar.set((Object)mm2.var(RowUtils.class).invoke("lengthPrefixPF", new Object[]{schemaVersion}));
            newSizeVar.inc((Object)startOffsetVar);
        } else {
            startOffsetVar.set((Object)0);
        }
        Variable offsetVar = mm2.var(Integer.TYPE).set((Object)startOffsetVar);
        int stateFieldNum = -1;
        Variable stateField = null;
        for (int i = 0; i < codecs.length; ++i) {
            ColumnCodec codec = codecs[i];
            codec.encodePrepare();
            offsetVars[i] = offsetVar.get();
            codec.decodeSkip(originalValueVar, offsetVar, null);
            ColumnInfo info = codec.mInfo;
            int num = columnNumbers.get(info.name);
            int sfNum = RowGen.stateFieldNum(num);
            if (sfNum != stateFieldNum) {
                stateFieldNum = sfNum;
                stateField = mm2.field("state$" + sfNum).get();
            }
            int sfMask = RowGen.stateFieldMask(num);
            Label cont = mm2.label();
            stateField.and((Object)sfMask).ifEq((Object)sfMask, cont);
            codec.encodeSkip();
            newSizeVar.inc((Object)offsetVar.sub((Object)offsetVars[i]));
            cont.here();
        }
        Variable newValueVar = mm2.new_(byte[].class, new Object[]{newSizeVar});
        Variable srcOffsetVar = mm2.var(Integer.TYPE).set((Object)0);
        Variable dstOffsetVar = mm2.var(Integer.TYPE).set((Object)0);
        Variable dirtyOffsetVar = mm2.var(Integer.TYPE).set((Object)0);
        Variable spanLengthVar = mm2.var(Integer.TYPE).set((Object)startOffsetVar);
        Variable sysVar = mm2.var(System.class);
        for (int i = 0; i < codecs.length; ++i) {
            ColumnCodec codec = codecs[i];
            ColumnInfo info = codec.mInfo;
            int num = columnNumbers.get(info.name);
            Variable endVar = i + 1 < codecs.length ? offsetVars[i + 1] : originalValueVar.alength();
            Variable columnLenVar = endVar.sub((Object)offsetVars[i]);
            int sfNum = RowGen.stateFieldNum(num);
            if (sfNum != stateFieldNum) {
                stateFieldNum = sfNum;
                stateField = mm2.field("state$" + sfNum).get();
            }
            int sfMask = RowGen.stateFieldMask(num);
            Label isDirty = mm2.label();
            stateField.and((Object)sfMask).ifEq((Object)sfMask, isDirty);
            Label cont = mm2.label();
            spanLengthVar.inc((Object)columnLenVar);
            mm2.goto_(cont);
            isDirty.here();
            Label noSpan = mm2.label();
            spanLengthVar.ifEq((Object)0, noSpan);
            sysVar.invoke("arraycopy", new Object[]{originalValueVar, srcOffsetVar, newValueVar, dstOffsetVar, spanLengthVar});
            srcOffsetVar.inc((Object)spanLengthVar);
            dstOffsetVar.inc((Object)spanLengthVar);
            spanLengthVar.set((Object)0);
            noSpan.here();
            Integer dirtyStart = i == 0 ? Integer.valueOf(0) : dirtyOffsetVar.get();
            codec.decodeSkip(dirtyValueVar, dirtyOffsetVar, null);
            Variable dirtyLengthVar = dirtyOffsetVar.sub((Object)dirtyStart);
            sysVar.invoke("arraycopy", new Object[]{dirtyValueVar, dirtyStart, newValueVar, dstOffsetVar, dirtyLengthVar});
            dstOffsetVar.inc((Object)dirtyLengthVar);
            srcOffsetVar.inc((Object)columnLenVar);
            cont.here();
        }
        Label noSpan = mm2.label();
        spanLengthVar.ifEq((Object)0, noSpan);
        sysVar.invoke("arraycopy", new Object[]{originalValueVar, srcOffsetVar, newValueVar, dstOffsetVar, spanLengthVar});
        noSpan.here();
        mm2.return_((Object)newValueVar);
        lookup = cm.finishHidden();
        try {
            factory = lookup.findConstructor(lookup.lookupClass(), ctorType);
        }
        catch (Throwable e) {
            throw RowUtils.rethrow(e);
        }
        return factory.asType(ctorType.changeReturnType(BaseTable.ValueUpdater.class));
    }

    private void addUpdaterMethod(String variant) {
        MethodMaker mm = this.mClassMaker.addMethod(Pipe.class, variant, new Object[]{RemoteUpdater.class, Pipe.class}).public_();
        Variable updaterVar = this.updater(mm.param(0));
        Variable pipeVar = mm.param(1);
        Label tryStart = mm.label().here();
        Variable rowVar = mm.var(this.mRowClass);
        Variable currentRowVar = updaterVar.invoke("row", new Object[0]);
        Label finish = mm.label();
        Variable makerVar = mm.var(RemoteProxyMaker.class);
        if (variant == "row") {
            rowVar.set((Object)currentRowVar.cast(this.mRowClass));
        } else if (variant == "step") {
            makerVar.invoke("currentRowCheck", new Object[]{currentRowVar});
            rowVar.set((Object)updaterVar.invoke(variant, new Object[]{currentRowVar}).cast(this.mRowClass));
        } else {
            makerVar.invoke("currentRowCheck", new Object[]{currentRowVar});
            rowVar.set((Object)mm.invoke("decodeRow", new Object[]{currentRowVar.cast(this.mRowClass), pipeVar}));
            rowVar.ifEq(null, finish);
            rowVar.set((Object)updaterVar.invoke(variant, new Object[]{rowVar}).cast(this.mRowClass));
        }
        Label noRow = mm.label();
        rowVar.ifEq(null, noRow);
        Variable keyBytesVar = mm.invoke("encodeKeyColumns", new Object[]{rowVar});
        Variable valueBytesVar = mm.invoke("encodeValueColumns", new Object[]{rowVar, false});
        mm.catch_(tryStart, Throwable.class, exVar -> {
            pipeVar.invoke("writeObject", new Object[]{exVar});
            finish.goto_();
        });
        pipeVar.invoke("writeNull", new Object[0]);
        keyBytesVar.aset((Object)0, (Object)1);
        pipeVar.invoke("write", new Object[]{keyBytesVar});
        pipeVar.invoke("write", new Object[]{valueBytesVar});
        String[] rowStateFieldNames = this.mRowGen.stateFields();
        Map<String, Integer> rowColumnNumbers = this.mRowGen.columnNumbers();
        ColumnCodec[] clientCodecs = this.clientCodecs();
        Variable clientStateVar = mm.var(Integer.TYPE).set((Object)0);
        for (int columnNum = 0; columnNum < clientCodecs.length; ++columnNum) {
            Integer rowColumnNumObj;
            if (columnNum > 0 && (columnNum & 0xF) == 0) {
                pipeVar.invoke("writeInt", new Object[]{clientStateVar});
                clientStateVar.set((Object)0);
            }
            if ((rowColumnNumObj = rowColumnNumbers.get(this.mRowHeader.columnNames[columnNum])) == null) continue;
            int rowColumnNum = rowColumnNumObj;
            int stateFieldNum = RowGen.stateFieldNum(rowColumnNum);
            int stateFieldMask = RowGen.stateFieldMask(rowColumnNum);
            Variable rowStateVar = rowVar.field(rowStateFieldNames[stateFieldNum]).and((Object)stateFieldMask);
            int stateShiftRight = RowGen.stateFieldShift(rowColumnNum) - RowGen.stateFieldShift(columnNum);
            if (stateShiftRight > 0) {
                rowStateVar.set((Object)rowStateVar.ushr((Object)stateShiftRight));
            } else if (stateShiftRight != 0) {
                rowStateVar.set((Object)rowStateVar.shl((Object)(-stateShiftRight)));
            }
            clientStateVar.set((Object)clientStateVar.or((Object)rowStateVar));
        }
        pipeVar.invoke("writeInt", new Object[]{clientStateVar});
        finish.here();
        pipeVar.invoke("flush", new Object[0]);
        pipeVar.invoke("recycle", new Object[0]);
        mm.return_(null);
        noRow.here();
        pipeVar.invoke("writeNull", new Object[0]);
        pipeVar.invoke("writeByte", new Object[]{0});
        finish.goto_();
        Variable exVar2 = mm.catch_(tryStart, mm.label().here(), Throwable.class);
        makerVar.invoke("handleException", new Object[]{exVar2, pipeVar, updaterVar});
        mm.return_(null);
    }

    private Variable txn(Variable remoteTxnVar) {
        return remoteTxnVar.methodMaker().var(ServerTransaction.class).invoke("txn", new Object[]{remoteTxnVar});
    }

    private Variable updater(Variable remoteUpdaterVar) {
        return remoteUpdaterVar.methodMaker().var(ServerUpdater.class).invoke("updater", new Object[]{remoteUpdaterVar});
    }

    private Variable[] readStateFields(Variable pipeVar) {
        Variable[] stateVars = new Variable[(this.mRowHeader.columnNames.length + 15) / 16];
        for (int i = 0; i < stateVars.length; ++i) {
            stateVars[i] = pipeVar.invoke("readInt", new Object[0]);
        }
        return stateVars;
    }

    private Variable checkSet(MethodMaker mm, Map<String, ColumnInfo> columns, Variable[] stateVars) {
        Variable allSetVar = mm.var(Boolean.TYPE);
        this.mRowGen.checkSet(mm, columns, allSetVar, num -> stateVars[num >> 4]);
        return allSetVar;
    }

    private Variable checkDirty(MethodMaker mm, Map<String, ColumnInfo> columns, Variable[] stateVars) {
        Variable allDirtyVar = mm.var(Boolean.TYPE);
        this.mRowGen.checkDirty(mm, columns, allDirtyVar, num -> stateVars[num >> 4]);
        return allDirtyVar;
    }

    private void convertAndWriteValue(Variable pipeVar, Variable valueVar) {
        if (this.mTable.isEvolvable()) {
            MethodMaker mm = pipeVar.methodMaker();
            Variable tableVar = mm.var(this.mTable.getClass());
            Field schemaVersion = mm.field("schemaVersion");
            TableMaker.convertValueIfNecessary(tableVar, this.mRowClass, schemaVersion, valueVar);
        }
        this.writeValue(pipeVar, valueVar);
    }

    private void writeValue(Variable pipeVar, Variable valueVar) {
        MethodMaker mm = pipeVar.methodMaker();
        if (this.mTable.isEvolvable()) {
            Variable prefixLengthVar = mm.field("prefixLength").get();
            Variable lengthVar = valueVar.alength().sub((Object)prefixLengthVar);
            mm.var(RowUtils.class).invoke("encodePrefixPF", new Object[]{pipeVar, lengthVar});
            pipeVar.invoke("write", new Object[]{valueVar, prefixLengthVar, lengthVar});
        } else {
            mm.var(RowUtils.class).invoke("encodePrefixPF", new Object[]{pipeVar, valueVar.alength()});
            pipeVar.invoke("write", new Object[]{valueVar});
        }
    }

    public static void skipKeyAndValue(Pipe pipe) throws IOException {
        pipe.skip((long)RowUtils.decodePrefixPF((DataInput)pipe));
        pipe.skip((long)RowUtils.decodePrefixPF((DataInput)pipe));
    }

    public static void skipValue(Pipe pipe) throws IOException {
        pipe.skip((long)RowUtils.decodePrefixPF((DataInput)pipe));
    }

    public static byte[] decodeKey(Pipe pipe) throws IOException {
        return RemoteProxyMaker.decodeValue(pipe);
    }

    public static byte[] decodeKey(Pipe pipe, int tailLen) throws IOException {
        int length = RowUtils.decodePrefixPF((DataInput)pipe);
        if (length == 0) {
            return new byte[tailLen];
        }
        byte[] bytes = new byte[length + tailLen];
        pipe.readFully(bytes, 0, length);
        return bytes;
    }

    public static byte[] decodeValue(Pipe pipe) throws IOException {
        int length = RowUtils.decodePrefixPF((DataInput)pipe);
        if (length == 0) {
            return RowUtils.EMPTY_BYTES;
        }
        byte[] bytes = new byte[length];
        pipe.readFully(bytes);
        return bytes;
    }

    public static byte[] decodeValue(Pipe pipe, int prefixLength) throws IOException {
        int valueLength = RowUtils.decodePrefixPF((DataInput)pipe);
        byte[] bytes = new byte[prefixLength + valueLength];
        pipe.readFully(bytes, prefixLength, valueLength);
        return bytes;
    }

    public static byte[] load(BaseTable table, Transaction txn, byte[] key, Pipe pipe) throws IOException {
        block4: {
            byte[] value;
            try {
                value = table.mSource.load(txn, key);
            }
            catch (Throwable e) {
                pipe.writeObject((Object)e);
                break block4;
            }
            pipe.writeNull();
            if (value == null) {
                pipe.writeByte(0);
            } else {
                pipe.writeByte(1);
                return value;
            }
        }
        pipe.flush();
        pipe.recycle();
        return null;
    }

    public static void exists(BaseTable table, Transaction txn, byte[] key, Pipe pipe) throws IOException {
        block2: {
            boolean result;
            try {
                result = table.mSource.exists(txn, key);
            }
            catch (Throwable e) {
                pipe.writeObject((Object)e);
                break block2;
            }
            pipe.writeNull();
            RemoteProxyMaker.writeResult(result, pipe);
        }
        pipe.flush();
        pipe.recycle();
    }

    public static void store(BaseTable table, Transaction txn, Object row, byte[] key, byte[] value, Pipe pipe) throws IOException {
        block2: {
            try {
                table.storeAndTrigger(txn, row, key, value);
            }
            catch (Throwable e) {
                pipe.writeObject((Object)e);
                break block2;
            }
            pipe.writeNull();
            pipe.writeByte(1);
        }
        pipe.flush();
        pipe.recycle();
    }

    public static byte[] exchange(BaseTable table, Transaction txn, Object row, byte[] key, byte[] value, Pipe pipe) throws IOException {
        block4: {
            byte[] oldValue;
            try {
                oldValue = table.exchangeAndTrigger(txn, row, key, value);
            }
            catch (Throwable e) {
                pipe.writeObject((Object)e);
                break block4;
            }
            pipe.writeNull();
            if (oldValue == null) {
                pipe.writeByte(0);
            } else {
                pipe.writeByte(1);
                return oldValue;
            }
        }
        pipe.flush();
        pipe.recycle();
        return null;
    }

    public static void insert(BaseTable table, Transaction txn, Object row, byte[] key, byte[] value, Pipe pipe) throws IOException {
        block2: {
            boolean result;
            try {
                result = table.insertAndTrigger(txn, row, key, value);
            }
            catch (Throwable e) {
                pipe.writeObject((Object)e);
                break block2;
            }
            pipe.writeNull();
            RemoteProxyMaker.writeResult(result, pipe);
        }
        pipe.flush();
        pipe.recycle();
    }

    public static void replace(BaseTable table, Transaction txn, Object row, byte[] key, byte[] value, Pipe pipe) throws IOException {
        block2: {
            boolean result;
            try {
                result = table.replaceAndTrigger(txn, row, key, value);
            }
            catch (Throwable e) {
                pipe.writeObject((Object)e);
                break block2;
            }
            pipe.writeNull();
            RemoteProxyMaker.writeResult(result, pipe);
        }
        pipe.flush();
        pipe.recycle();
    }

    public static void update(BaseTable table, Transaction txn, Object row, byte[] key, BaseTable.ValueUpdater updater, Pipe pipe) throws IOException {
        block2: {
            byte[] newValue;
            try {
                newValue = table.updateAndTrigger(txn, row, key, updater);
            }
            catch (Throwable e) {
                pipe.writeObject((Object)e);
                break block2;
            }
            pipe.writeNull();
            pipe.writeByte(newValue != null ? 1 : 0);
        }
        pipe.flush();
        pipe.recycle();
    }

    public static byte[] merge(BaseTable table, Transaction txn, Object row, byte[] key, BaseTable.ValueUpdater updater, Pipe pipe) throws IOException {
        block4: {
            byte[] newValue;
            try {
                newValue = table.updateAndTrigger(txn, row, key, updater);
            }
            catch (Throwable e) {
                pipe.writeObject((Object)e);
                break block4;
            }
            pipe.writeNull();
            if (newValue == null) {
                pipe.writeByte(0);
            } else {
                pipe.writeByte(1);
                return newValue;
            }
        }
        pipe.flush();
        pipe.recycle();
        return null;
    }

    public static boolean mergeReplace(BaseTable table, Transaction txn, Object row, byte[] key, byte[] value, Pipe pipe) throws IOException {
        block4: {
            boolean result;
            try {
                result = table.replaceAndTrigger(txn, row, key, value);
            }
            catch (Throwable e) {
                pipe.writeObject((Object)e);
                break block4;
            }
            pipe.writeNull();
            if (!result) {
                pipe.writeByte(0);
            } else {
                pipe.writeByte(1);
                return true;
            }
        }
        pipe.flush();
        pipe.recycle();
        return false;
    }

    public static void delete(BaseTable table, Transaction txn, byte[] key, Pipe pipe) throws IOException {
        block2: {
            boolean result;
            try {
                result = table.deleteAndTrigger(txn, key);
            }
            catch (Throwable e) {
                pipe.writeObject((Object)e);
                break block2;
            }
            pipe.writeNull();
            RemoteProxyMaker.writeResult(result, pipe);
        }
        pipe.flush();
        pipe.recycle();
    }

    public static void storeAuto(BaseTable table, AutomaticKeyGenerator autogen, Transaction txn, Object row, byte[] key, byte[] value, Pipe pipe) throws IOException {
        block2: {
            try {
                key = table.storeAutoAndTrigger(autogen, txn, row, key, value);
            }
            catch (Throwable e) {
                pipe.writeObject((Object)e);
                break block2;
            }
            pipe.writeNull();
            pipe.writeByte(2);
            autogen.writeTail(key, (DataOutput)pipe);
        }
        pipe.flush();
        pipe.recycle();
    }

    public static void writeResult(boolean result, Pipe pipe) throws IOException {
        pipe.writeByte(result ? 1 : 0);
    }

    public static void handleException(Throwable e, Pipe pipe) {
        RowUtils.closeQuietly((Closeable)pipe);
        if (!(e instanceof IOException)) {
            RowUtils.rethrow(e);
        }
    }

    public static void handleException(Throwable e, Pipe pipe, Closeable c) {
        RowUtils.closeQuietly((Closeable)pipe);
        RowUtils.closeQuietly(c);
        if (!(e instanceof IOException)) {
            RowUtils.rethrow(e);
        }
    }

    public static void currentRowCheck(Object row) {
        if (row == null) {
            throw new IllegalStateException();
        }
    }

    private MethodHandles.Lookup makeConverter() {
        this.addDecodeRow();
        this.addEncodeColumns(false);
        this.addByKeyConvertMethod("load");
        this.addByKeyConvertMethod("exists");
        this.addByKeyConvertMethod("delete");
        this.addStoreConvertMethod("store");
        this.addStoreConvertMethod("exchange");
        this.addStoreConvertMethod("insert");
        this.addStoreConvertMethod("replace");
        this.addUpdateConvertMethod("update");
        this.addUpdateConvertMethod("merge");
        this.addEncodeColumns(true);
        this.addUpdaterMethod("row");
        this.addUpdaterMethod("step");
        this.addUpdaterMethod("update");
        this.addUpdaterMethod("delete");
        return this.mClassMaker.finishLookup();
    }

    private void addByKeyConvertMethod(String variant) {
        MethodMaker mm = this.mClassMaker.addMethod(Pipe.class, variant, new Object[]{RemoteTransaction.class, Pipe.class}).public_();
        Variable txnVar = this.txn(mm.param(0));
        Variable pipeVar = mm.param(1);
        Label tryStart = mm.label().here();
        Variable rowVar = mm.invoke("decodeRow", new Object[]{mm.new_(this.mRowClass, new Object[0]), pipeVar});
        Label finish = mm.label();
        rowVar.ifEq(null, finish);
        Label opTryStart = mm.label().here();
        Variable resultVar = mm.field("table").invoke(variant, new Object[]{txnVar, rowVar});
        Variable makerVar = mm.var(RemoteProxyMaker.class);
        if (variant != "load") {
            mm.catch_(opTryStart, Throwable.class, exVar -> {
                pipeVar.invoke("writeObject", new Object[]{exVar});
                finish.goto_();
            });
            pipeVar.invoke("writeNull", new Object[0]);
            makerVar.invoke("writeResult", new Object[]{resultVar, pipeVar});
        } else {
            Label noOperation = mm.label();
            resultVar.ifFalse(noOperation);
            Variable bytesVar = mm.invoke("encodeValueColumns", new Object[]{rowVar, true});
            mm.catch_(opTryStart, Throwable.class, exVar -> {
                pipeVar.invoke("writeObject", new Object[]{exVar});
                finish.goto_();
            });
            pipeVar.invoke("writeNull", new Object[0]);
            bytesVar.aset((Object)0, (Object)1);
            pipeVar.invoke("write", new Object[]{bytesVar});
            finish.goto_();
            noOperation.here();
            pipeVar.invoke("writeNull", new Object[0]);
            pipeVar.invoke("writeByte", new Object[]{0});
        }
        finish.here();
        pipeVar.invoke("flush", new Object[0]);
        pipeVar.invoke("recycle", new Object[0]);
        mm.return_(null);
        Variable exVar2 = mm.catch_(tryStart, mm.label().here(), Throwable.class);
        makerVar.invoke("handleException", new Object[]{exVar2, pipeVar});
        mm.return_(null);
    }

    private void addStoreConvertMethod(String variant) {
        MethodMaker mm = this.mClassMaker.addMethod(Pipe.class, variant, new Object[]{RemoteTransaction.class, Pipe.class}).public_();
        Variable txnVar = this.txn(mm.param(0));
        Variable pipeVar = mm.param(1);
        Label tryStart = mm.label().here();
        Variable rowVar = mm.invoke("decodeRow", new Object[]{mm.new_(this.mRowClass, new Object[0]), pipeVar});
        Label finish = mm.label();
        rowVar.ifEq(null, finish);
        Variable isAutoVar = null;
        if (variant != "replace" && this.mAutoColumn != null) {
            int columnNum = this.mRowGen.info.keyColumns.size() - 1;
            int mask = RowGen.stateFieldMask(columnNum);
            isAutoVar = rowVar.field(this.mRowGen.stateField(columnNum)).and((Object)mask);
        }
        Label opTryStart = mm.label().here();
        Variable makerVar = mm.var(RemoteProxyMaker.class);
        if (variant != "exchange") {
            Variable resultVar = mm.field("table").invoke(variant, new Object[]{txnVar, rowVar});
            mm.catch_(opTryStart, Throwable.class, exVar -> {
                pipeVar.invoke("writeObject", new Object[]{exVar});
                finish.goto_();
            });
            pipeVar.invoke("writeNull", new Object[0]);
            this.autoCheck(isAutoVar, rowVar, pipeVar, finish);
            if (variant == "store") {
                pipeVar.invoke("writeByte", new Object[]{1});
            } else {
                makerVar.invoke("writeResult", new Object[]{resultVar, pipeVar});
            }
        } else {
            txnVar.set((Object)mm.field("table").invoke("enterScope", new Object[]{txnVar}));
            Label txnStart = mm.label().here();
            Variable resultVar = mm.field("table").invoke(variant, new Object[]{txnVar, rowVar});
            Variable bytesVar = mm.var(byte[].class);
            Label hasOldRow = mm.label();
            resultVar.ifNe(null, hasOldRow);
            bytesVar.set(null);
            Label cont = mm.label().goto_();
            hasOldRow.here();
            bytesVar.set((Object)mm.invoke("encodeValueColumns", new Object[]{resultVar.cast(this.mRowClass), true}));
            cont.here();
            txnVar.invoke("commit", new Object[0]);
            mm.finally_(txnStart, () -> txnVar.invoke("exit", new Object[0]));
            mm.catch_(opTryStart, Throwable.class, exVar -> {
                pipeVar.invoke("writeObject", new Object[]{exVar});
                finish.goto_();
            });
            pipeVar.invoke("writeNull", new Object[0]);
            this.autoCheck(isAutoVar, rowVar, pipeVar, finish);
            Label hasBytes = mm.label();
            bytesVar.ifNe(null, hasBytes);
            pipeVar.invoke("writeByte", new Object[]{0});
            finish.goto_();
            hasBytes.here();
            bytesVar.aset((Object)0, (Object)1);
            pipeVar.invoke("write", new Object[]{bytesVar});
        }
        finish.here();
        pipeVar.invoke("flush", new Object[0]);
        pipeVar.invoke("recycle", new Object[0]);
        mm.return_(null);
        Variable exVar2 = mm.catch_(tryStart, mm.label().here(), Throwable.class);
        makerVar.invoke("handleException", new Object[]{exVar2, pipeVar});
        mm.return_(null);
    }

    private void autoCheck(Variable isAutoVar, Variable rowVar, Variable pipeVar, Label finish) {
        if (isAutoVar != null) {
            MethodMaker mm = isAutoVar.methodMaker();
            Label noAutoKey = mm.label();
            isAutoVar.ifNe((Object)0, noAutoKey);
            pipeVar.invoke("writeByte", new Object[]{2});
            Field columnVar = rowVar.field(this.mAutoColumn.name);
            if (this.mAutoColumn.type == Integer.TYPE) {
                pipeVar.invoke("writeInt", new Object[]{columnVar});
            } else {
                pipeVar.invoke("writeLong", new Object[]{columnVar});
            }
            finish.goto_();
            noAutoKey.here();
        }
    }

    private void addUpdateConvertMethod(String variant) {
        MethodMaker mm = this.mClassMaker.addMethod(Pipe.class, variant, new Object[]{RemoteTransaction.class, Pipe.class}).public_();
        Variable txnVar = this.txn(mm.param(0));
        Variable pipeVar = mm.param(1);
        Label tryStart = mm.label().here();
        Variable rowVar = mm.invoke("decodeRow", new Object[]{mm.new_(this.mRowClass, new Object[0]), pipeVar});
        Label finish = mm.label();
        rowVar.ifEq(null, finish);
        Label opTryStart = mm.label().here();
        Variable makerVar = mm.var(RemoteProxyMaker.class);
        if (variant != "merge") {
            Variable resultVar = mm.field("table").invoke(variant, new Object[]{txnVar, rowVar});
            mm.catch_(opTryStart, Throwable.class, exVar -> {
                pipeVar.invoke("writeObject", new Object[]{exVar});
                finish.goto_();
            });
            pipeVar.invoke("writeNull", new Object[0]);
            makerVar.invoke("writeResult", new Object[]{resultVar, pipeVar});
        } else {
            txnVar.set((Object)mm.field("table").invoke("enterScope", new Object[]{txnVar}));
            Label txnStart = mm.label().here();
            Variable resultVar = mm.field("table").invoke(variant, new Object[]{txnVar, rowVar});
            Label noOperation = mm.label();
            resultVar.ifFalse(noOperation);
            Variable bytesVar = mm.invoke("encodeValueColumns", new Object[]{rowVar.cast(this.mRowClass), true});
            txnVar.invoke("commit", new Object[0]);
            mm.finally_(txnStart, () -> txnVar.invoke("exit", new Object[0]));
            mm.catch_(opTryStart, Throwable.class, exVar -> {
                pipeVar.invoke("writeObject", new Object[]{exVar});
                finish.goto_();
            });
            pipeVar.invoke("writeNull", new Object[0]);
            bytesVar.aset((Object)0, (Object)1);
            pipeVar.invoke("write", new Object[]{bytesVar});
            finish.goto_();
            noOperation.here();
            pipeVar.invoke("writeNull", new Object[0]);
            pipeVar.invoke("writeByte", new Object[]{0});
        }
        finish.here();
        pipeVar.invoke("flush", new Object[0]);
        pipeVar.invoke("recycle", new Object[0]);
        mm.return_(null);
        Variable exVar2 = mm.catch_(tryStart, mm.label().here(), Throwable.class);
        makerVar.invoke("handleException", new Object[]{exVar2, pipeVar});
        mm.return_(null);
    }

    private void addDecodeRow() {
        MethodMaker mm = this.mClassMaker.addMethod(this.mRowClass, "decodeRow", new Object[]{this.mRowClass, Pipe.class});
        mm.private_().static_();
        Variable rowVar = mm.param(0);
        Variable pipeVar = mm.param(1);
        Variable[] stateVars = this.readStateFields(pipeVar);
        Variable makerVar = mm.var(RemoteProxyMaker.class);
        Variable keyVar = makerVar.invoke("decodeKey", new Object[]{pipeVar});
        Variable valueVar = makerVar.invoke("decodeValue", new Object[]{pipeVar});
        Map<String, Integer> rowColumnNumbers = this.mRowGen.columnNumbers();
        String[] rowStateFieldNames = this.mRowGen.stateFields();
        ColumnCodec[] rowKeyCodecs = this.mRowGen.keyCodecs();
        ColumnCodec[] rowValueCodecs = this.mRowGen.valueCodecs();
        Variable offsetVar = mm.var(Integer.TYPE);
        ColumnCodec[] clientCodecs = this.clientCodecs();
        for (int columnNum = 0; columnNum < clientCodecs.length; ++columnNum) {
            if (columnNum == 0 || columnNum == this.mRowHeader.numKeys) {
                offsetVar.set((Object)0);
            }
            int stateFieldNum = RowGen.stateFieldNum(columnNum);
            int stateFieldMask = RowGen.stateFieldMask(columnNum);
            Variable stateVar = stateVars[stateFieldNum].and((Object)stateFieldMask);
            Label skip = mm.label();
            stateVar.ifEq((Object)0, skip);
            Variable bytesVar = columnNum < this.mRowHeader.numKeys ? keyVar : valueVar;
            ColumnCodec codec = clientCodecs[columnNum].bind(mm);
            Variable columnVar = mm.var(codec.mInfo.type);
            codec.decode(columnVar, bytesVar, offsetVar, null);
            String rowFieldName = this.mRowHeader.columnNames[columnNum];
            if (!rowColumnNumbers.containsKey(rowFieldName)) {
                Variable exVar2 = mm.new_(IllegalStateException.class, new Object[]{"Unknown column: " + rowFieldName});
                pipeVar.invoke("writeObject", new Object[]{exVar2});
                mm.return_(null);
            } else {
                Field rowField = rowVar.field(rowFieldName);
                int rowColumnNum = rowColumnNumbers.get(rowFieldName);
                ColumnCodec rowFieldCodec = rowColumnNum < rowKeyCodecs.length ? rowKeyCodecs[rowColumnNum] : rowValueCodecs[rowColumnNum - rowKeyCodecs.length];
                Label tryStart = mm.label().here();
                Converter.convertExact(mm, rowFieldName, codec.mInfo, columnVar, rowFieldCodec.mInfo, (Variable)rowField);
                mm.catch_(tryStart, RuntimeException.class, exVar -> {
                    pipeVar.invoke("writeObject", new Object[]{exVar});
                    mm.return_(null);
                });
                int stateShiftLeft = RowGen.stateFieldShift(rowColumnNum) - RowGen.stateFieldShift(columnNum);
                if (stateShiftLeft > 0) {
                    stateVar.set((Object)stateVar.shl((Object)stateShiftLeft));
                } else if (stateShiftLeft != 0) {
                    stateVar.set((Object)stateVar.ushr((Object)(-stateShiftLeft)));
                }
                int rowStateFieldNum = RowGen.stateFieldNum(rowColumnNum);
                Field rowStateField = rowVar.field(rowStateFieldNames[rowStateFieldNum]);
                if (columnNum == 0) {
                    rowStateField.set((Object)stateVar);
                } else {
                    int mask = ~RowGen.stateFieldMask(rowColumnNum);
                    rowStateField.set((Object)rowStateField.and((Object)mask).or((Object)stateVar));
                }
            }
            skip.here();
        }
        mm.return_((Object)rowVar);
    }

    private void addEncodeColumns(boolean forKey) {
        int numEnd;
        int numStart;
        Variable strictVar;
        MethodMaker mm = forKey ? this.mClassMaker.addMethod(byte[].class, "encodeKeyColumns", new Object[]{this.mRowClass}) : this.mClassMaker.addMethod(byte[].class, "encodeValueColumns", new Object[]{this.mRowClass, Boolean.TYPE});
        mm.private_().static_();
        ColumnCodec[] clientCodecs = this.clientCodecs();
        if (clientCodecs.length == 0) {
            Variable emptyVar = mm.var(byte[].class).setExact((Object)new byte[1]);
            mm.return_((Object)emptyVar);
            return;
        }
        Variable rowVar = mm.param(0);
        Variable variable = strictVar = forKey ? null : mm.param(1);
        if (forKey) {
            numStart = 0;
            numEnd = this.mRowHeader.numKeys;
        } else {
            numStart = this.mRowHeader.numKeys;
            numEnd = clientCodecs.length;
        }
        Label beginEncode = mm.label();
        if (strictVar != null) {
            strictVar.ifFalse(beginEncode);
        }
        for (int columnNum = numStart; columnNum < numEnd; ++columnNum) {
            String fieldName = this.mRowHeader.columnNames[columnNum];
            if (this.mRowGen.info.allColumns.containsKey(fieldName)) continue;
            mm.new_(IllegalStateException.class, new Object[]{"Unknown column: " + fieldName}).throw_();
            if (strictVar != null) continue;
            return;
        }
        beginEncode.here();
        clientCodecs = ColumnCodec.bind(clientCodecs, mm);
        Variable[] fieldVars = new Variable[clientCodecs.length - numStart];
        for (int columnNum = numStart; columnNum < numEnd; ++columnNum) {
            Variable dstVar;
            String fieldName = this.mRowHeader.columnNames[columnNum];
            ColumnInfo dstInfo = clientCodecs[columnNum].mInfo;
            fieldVars[columnNum - numStart] = dstVar = mm.var(dstInfo.type);
            ColumnInfo srcInfo = (ColumnInfo)this.mRowGen.info.allColumns.get(fieldName);
            if (srcInfo == null) {
                Converter.setDefault(mm, dstInfo, dstVar);
                continue;
            }
            Field srcField = rowVar.field(fieldName);
            Label cont = null;
            if (!srcInfo.isPrimitive() && !srcInfo.isNullable()) {
                Label notNull = mm.label();
                srcField.ifNe(null, notNull);
                Converter.setDefault(mm, dstInfo, dstVar);
                cont = mm.label().goto_();
                notNull.here();
            }
            Converter.convertExact(mm, fieldName, srcInfo, (Variable)srcField, dstInfo, dstVar);
            if (cont == null) continue;
            cont.here();
        }
        Variable valueLengthVar = null;
        int minSize = 0;
        for (int columnNum = numStart; columnNum < numEnd; ++columnNum) {
            Variable fieldVar = fieldVars[columnNum - numStart];
            ColumnCodec codec = clientCodecs[columnNum];
            codec.encodePrepare();
            valueLengthVar = codec.encodeSize(fieldVar, valueLengthVar);
            minSize += codec.minSize();
        }
        if (valueLengthVar == null) {
            valueLengthVar = mm.var(Integer.TYPE).set((Object)minSize);
        } else if (minSize != 0) {
            valueLengthVar.inc((Object)minSize);
        }
        Variable utilsVar = mm.var(RowUtils.class);
        Variable fullLengthVar = mm.var(Integer.TYPE).set((Object)1);
        fullLengthVar.inc((Object)utilsVar.invoke("lengthPrefixPF", new Object[]{valueLengthVar}));
        fullLengthVar.inc((Object)valueLengthVar);
        Variable bytesVar = mm.new_(byte[].class, new Object[]{fullLengthVar});
        Variable offsetVar = utilsVar.invoke("encodePrefixPF", new Object[]{bytesVar, 1, valueLengthVar});
        for (int columnNum = numStart; columnNum < numEnd; ++columnNum) {
            Variable fieldVar = fieldVars[columnNum - numStart];
            clientCodecs[columnNum].encode(fieldVar, bytesVar, offsetVar);
        }
        Label cont = mm.label();
        mm.field("assert").ifFalse(cont);
        offsetVar.ifEq((Object)bytesVar.alength(), cont);
        mm.new_(AssertionError.class, new Object[]{mm.concat(new Object[]{offsetVar, " != ", bytesVar.alength()}), null}).throw_();
        cont.here();
        mm.return_((Object)bytesVar);
    }

    private ColumnCodec[] clientCodecs() {
        ColumnCodec[] codecs = this.mClientCodecs;
        if (codecs == null) {
            codecs = ColumnCodec.make(this.mRowHeader);
            this.mClientCodecs = codecs;
        }
        return codecs;
    }

    private record CacheKey(Class<?> tableClass, byte[] descriptor) {
    }
}

