/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.IntFunction;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.Field;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.SchemaVersionColumnCodec;
import org.cojen.tupl.rows.SecondaryInfo;

class RowGen {
    private static final Object MAKER_KEY = new Object();
    final RowInfo info;
    private volatile String[] mStateFields;
    private volatile Map<String, Integer> mColumnNumbers;
    private volatile ColumnCodec[] mKeyCodecs;
    private volatile ColumnCodec[] mValueCodecs;
    private volatile Map<String, ColumnCodec> mKeyCodecMap;
    private volatile Map<String, ColumnCodec> mValueCodecMap;

    RowGen(RowInfo info) {
        this.info = info;
    }

    public ClassMaker beginClassMaker(Class<?> who, Class<?> rowType, String suffix) {
        return RowGen.beginClassMaker(who, rowType, this.info, null, suffix);
    }

    public ClassMaker beginClassMaker(Class<?> who, Class<?> rowType, String subPackage, String suffix) {
        return RowGen.beginClassMaker(who, rowType, this.info, subPackage, suffix);
    }

    public static ClassMaker beginClassMaker(Class<?> who, Class<?> rowType, RowInfo info, String subPackage, String suffix) {
        String name;
        String infoName;
        if (info == null || (infoName = info.name) == null) {
            name = null;
        } else {
            StringBuilder bob = new StringBuilder();
            if (subPackage != null) {
                int ix = info.name.lastIndexOf(46);
                if (ix > 0) {
                    bob.append(info.name, 0, ix).append('.');
                    infoName = info.name.substring(ix + 1);
                }
                bob.append(subPackage).append('.');
            }
            bob.append(infoName);
            if (suffix != null && !suffix.isEmpty()) {
                bob.append('-').append(suffix);
            }
            name = bob.toString();
        }
        return RowGen.beginClassMaker(who, rowType == null ? null : rowType.getClassLoader(), name);
    }

    public static ClassMaker beginClassMaker(Class<?> who, ClassLoader loader, String name) {
        ClassMaker cm = ClassMaker.begin((String)name, (ClassLoader)loader, (Object)MAKER_KEY);
        if (who != null) {
            cm.sourceFile(who.getSimpleName());
        }
        Module thisModule = RowGen.class.getModule();
        Module thatModule = cm.classLoader().getUnnamedModule();
        thisModule.addExports("org.cojen.tupl.core", thatModule);
        thisModule.addExports("org.cojen.tupl.filter", thatModule);
        thisModule.addExports("org.cojen.tupl.rows", thatModule);
        thisModule.addExports("org.cojen.tupl.views", thatModule);
        return cm;
    }

    public ClassMaker anotherClassMaker(Class<?> who, Class<?> peer, String suffix) {
        Object name = this.info.name;
        int ix = ((String)name).lastIndexOf(46);
        if (ix > 0) {
            name = ((String)name).substring(ix + 1);
        }
        if (suffix != null && !suffix.isEmpty()) {
            name = (String)name + "-" + suffix;
        }
        name = peer.getPackageName() + "." + (String)name;
        return RowGen.beginClassMaker(who, peer.getClassLoader().getParent(), (String)name);
    }

    public String[] stateFields() {
        String[] fields = this.mStateFields;
        if (fields == null) {
            fields = this.makeStateFields();
        }
        return fields;
    }

    private String[] makeStateFields() {
        String[] fields = new String[(this.info.allColumns.size() + 15) / 16];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = this.unique("state$" + i);
        }
        this.mStateFields = fields;
        return fields;
    }

    private String unique(String prefix) {
        Object name = prefix;
        while (this.info.allColumns.containsKey(name)) {
            name = (String)name + "$";
        }
        return name;
    }

    public Map<String, Integer> columnNumbers() {
        Map<String, Integer> map = this.mColumnNumbers;
        if (map == null) {
            map = this.makeColumnNumbers();
        }
        return map;
    }

    private Map<String, Integer> makeColumnNumbers() {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>(this.info.allColumns.size() << 1);
        int num = 0;
        for (ColumnInfo ci : this.info.keyColumns.values()) {
            map.put(ci.name, num++);
        }
        for (ColumnCodec codec : this.valueCodecs()) {
            if (codec instanceof SchemaVersionColumnCodec) continue;
            map.put(codec.mInfo.name, num++);
        }
        this.mColumnNumbers = map;
        return map;
    }

    public String stateField(int columnNum) {
        return this.stateFields()[RowGen.stateFieldNum(columnNum)];
    }

    public static int stateFieldNum(int columnNum) {
        return columnNum >> 4;
    }

    public static int stateFieldMask(int columnNum) {
        return RowGen.stateFieldMask(columnNum, 3);
    }

    public static int stateFieldMask(int columnNum, int state) {
        return state << RowGen.stateFieldShift(columnNum);
    }

    public static int stateFieldShift(int columnNum) {
        return (columnNum & 0xF) << 1;
    }

    public ColumnCodec[] codecsCopy() {
        ColumnCodec[] keyCodecs = this.keyCodecs();
        ColumnCodec[] valueCodecs = this.valueCodecs();
        ColumnCodec[] all = new ColumnCodec[keyCodecs.length + valueCodecs.length];
        System.arraycopy(keyCodecs, 0, all, 0, keyCodecs.length);
        System.arraycopy(valueCodecs, 0, all, keyCodecs.length, valueCodecs.length);
        return all;
    }

    public ColumnCodec[] keyCodecs() {
        ColumnCodec[] codecs = this.mKeyCodecs;
        if (codecs == null) {
            codecs = ColumnCodec.make(this.info.keyColumns, 2);
            this.mKeyCodecs = codecs;
        }
        return codecs;
    }

    public ColumnCodec[] valueCodecs() {
        SecondaryInfo sInfo;
        ColumnCodec[] codecs = this.mValueCodecs;
        if (codecs != null) {
            return codecs;
        }
        ArrayList<ColumnInfo> infos = new ArrayList<ColumnInfo>(this.info.valueColumns.values());
        RowInfo rowInfo = this.info;
        if (!(rowInfo instanceof SecondaryInfo) || !(sInfo = (SecondaryInfo)rowInfo).isAltKey()) {
            infos.sort((a, b) -> {
                int ap = a.plainTypeCode();
                int bp = b.plainTypeCode();
                if (ColumnInfo.isPrimitive(ap)) {
                    if (!ColumnInfo.isPrimitive(bp)) {
                        return -1;
                    }
                    if (!a.isNullable()) {
                        if (b.isNullable()) {
                            return -1;
                        }
                    } else if (!b.isNullable()) {
                        return 1;
                    }
                } else if (ColumnInfo.isPrimitive(bp)) {
                    return 1;
                }
                return 0;
            });
            codecs = ColumnCodec.make(infos, 0);
        } else {
            RowInfo primaryInfo = sInfo.primaryInfo;
            Map primaryKeys = primaryInfo.keyColumns;
            infos.sort((a, b) -> {
                int ap = a.plainTypeCode();
                int bp = b.plainTypeCode();
                if (ColumnInfo.isPrimitive(ap)) {
                    if (!ColumnInfo.isPrimitive(bp)) {
                        return -1;
                    }
                } else if (ColumnInfo.isPrimitive(bp)) {
                    return 1;
                }
                if (primaryKeys.containsKey(a.name)) {
                    if (!primaryKeys.containsKey(b.name)) {
                        return -1;
                    }
                } else if (primaryKeys.containsKey(b.name)) {
                    return 1;
                }
                return 0;
            });
            HashMap<String, ColumnCodec> pkCodecs = new HashMap<String, ColumnCodec>();
            for (ColumnCodec codec : primaryInfo.rowGen().keyCodecs()) {
                pkCodecs.put(codec.mInfo.name, codec);
            }
            codecs = ColumnCodec.make(infos, pkCodecs);
        }
        this.mValueCodecs = codecs;
        return codecs;
    }

    public Map<String, ColumnCodec> keyCodecMap() {
        Map<String, ColumnCodec> map = this.mKeyCodecMap;
        if (map == null) {
            this.mKeyCodecMap = map = RowGen.makeCodecMap(this.keyCodecs());
        }
        return map;
    }

    public Map<String, ColumnCodec> valueCodecMap() {
        Map<String, ColumnCodec> map = this.mValueCodecMap;
        if (map == null) {
            this.mValueCodecMap = map = RowGen.makeCodecMap(this.valueCodecs());
        }
        return map;
    }

    private static Map<String, ColumnCodec> makeCodecMap(ColumnCodec[] codecs) {
        LinkedHashMap<String, ColumnCodec> map = new LinkedHashMap<String, ColumnCodec>(codecs.length);
        for (ColumnCodec codec : codecs) {
            map.put(codec.mInfo.name, codec);
        }
        return map;
    }

    void checkSet(MethodMaker mm, Map<String, ColumnInfo> columns, Variable rowVar) {
        this.checkSet(mm, columns, null, num -> rowVar.field(this.stateField(num)));
    }

    void checkSet(MethodMaker mm, Map<String, ColumnInfo> columns, Variable resultVar, IntFunction<Variable> stateFieldAccessor) {
        if (columns.isEmpty()) {
            if (resultVar == null) {
                mm.return_((Object)true);
            } else {
                resultVar.set((Object)true);
            }
            return;
        }
        if (columns.size() == 1) {
            int num = this.columnNumbers().get(columns.values().iterator().next().name);
            Variable retVar = stateFieldAccessor.apply(num).and((Object)RowGen.stateFieldMask(num)).ne((Object)0);
            if (resultVar == null) {
                mm.return_((Object)retVar);
            } else {
                resultVar.set((Object)retVar);
            }
            return;
        }
        Label end = resultVar == null ? null : mm.label();
        int num = 0;
        int mask = 0;
        for (int step = 0; step < 2; ++step) {
            ColumnCodec[] baseCodecs;
            for (ColumnCodec codec : baseCodecs = step == 0 ? this.keyCodecs() : this.valueCodecs()) {
                ColumnInfo info = codec.mInfo;
                if (columns.containsKey(info.name)) {
                    mask |= RowGen.stateFieldMask(num);
                }
                if (!this.isMaskReady(++num, mask)) continue;
                Variable state = stateFieldAccessor.apply(num - 1).get();
                state = state.or((Object)state.and((Object)0x55555555).shl((Object)1));
                state = state.xor((Object)mask);
                if ((mask = this.maskRemainder(num, mask)) != -1) {
                    state = state.and((Object)mask);
                }
                Label cont = mm.label();
                state.ifEq((Object)0, cont);
                if (resultVar == null) {
                    mm.return_((Object)false);
                } else {
                    resultVar.set((Object)false);
                    end.goto_();
                }
                cont.here();
                mask = 0;
            }
        }
        if (resultVar == null) {
            mm.return_((Object)true);
        } else {
            resultVar.set((Object)true);
            end.here();
        }
    }

    void checkDirty(MethodMaker mm, Map<String, ColumnInfo> columns, Variable rowVar) {
        this.checkDirty(mm, columns, null, num -> rowVar.field(this.stateField(num)));
    }

    void checkDirty(MethodMaker mm, Map<String, ColumnInfo> columns, Variable resultVar, IntFunction<Variable> stateFieldAccessor) {
        Label end = resultVar == null ? null : mm.label();
        int num = 0;
        int mask = 0;
        for (int step = 0; step < 2; ++step) {
            ColumnCodec[] baseCodecs;
            for (ColumnCodec codec : baseCodecs = step == 0 ? this.keyCodecs() : this.valueCodecs()) {
                ColumnInfo info = codec.mInfo;
                if (columns.containsKey(info.name)) {
                    mask |= RowGen.stateFieldMask(num);
                }
                if (!this.isMaskReady(++num, mask)) continue;
                Label cont = mm.label();
                stateFieldAccessor.apply(num - 1).and((Object)mask).ifEq((Object)mask, cont);
                if (resultVar == null) {
                    mm.return_((Object)false);
                } else {
                    resultVar.set((Object)false);
                    end.goto_();
                }
                cont.here();
                mask = 0;
            }
        }
        if (resultVar == null) {
            mm.return_((Object)true);
        } else {
            resultVar.set((Object)true);
            end.here();
        }
    }

    void checkAnyDirty(MethodMaker mm, Map<String, ColumnInfo> columns, Variable rowVar) {
        this.checkAnyDirty(mm, columns, null, num -> rowVar.field(this.stateField(num)));
    }

    void checkAnyDirty(MethodMaker mm, Map<String, ColumnInfo> columns, Variable resultVar, IntFunction<Variable> stateFieldAccessor) {
        Label end = resultVar == null ? null : mm.label();
        int num = 0;
        int mask = 0;
        for (int step = 0; step < 2; ++step) {
            ColumnCodec[] baseCodecs;
            for (ColumnCodec codec : baseCodecs = step == 0 ? this.keyCodecs() : this.valueCodecs()) {
                ColumnInfo info = codec.mInfo;
                if (columns.containsKey(info.name)) {
                    mask |= RowGen.stateFieldMask(num, 2);
                }
                if (!this.isMaskReady(++num, mask)) continue;
                Label cont = mm.label();
                stateFieldAccessor.apply(num - 1).and((Object)mask).ifEq((Object)0, cont);
                if (resultVar == null) {
                    mm.return_((Object)true);
                } else {
                    resultVar.set((Object)true);
                    end.goto_();
                }
                cont.here();
                mask = 0;
            }
        }
        if (resultVar == null) {
            mm.return_((Object)false);
        } else {
            resultVar.set((Object)false);
            end.here();
        }
    }

    void requireSet(MethodMaker mm, Map<String, ColumnInfo> columns, Variable rowVar) {
        this.requireSet(mm, columns, (int num) -> rowVar.field(this.stateField(num)));
    }

    void requireSet(MethodMaker mm, Map<String, ColumnInfo> columns, IntFunction<Variable> stateFieldAccessor) {
        String initMessage = "Some required columns are unset";
        if (columns.isEmpty()) {
            mm.new_(IllegalStateException.class, new Object[]{initMessage}).throw_();
            return;
        }
        int initLength = initMessage.length() + 2;
        Variable bob = mm.new_(StringBuilder.class, new Object[]{initLength << 1}).invoke("append", new Object[]{initMessage}).invoke("append", new Object[]{": "});
        boolean first = true;
        for (ColumnInfo info : columns.values()) {
            int num = this.columnNumbers().get(info.name);
            Label isSet = mm.label();
            stateFieldAccessor.apply(num).and((Object)RowGen.stateFieldMask(num)).ifNe((Object)0, isSet);
            if (!first) {
                Label sep = mm.label();
                bob.invoke("length", new Object[0]).ifEq((Object)initLength, sep);
                bob.invoke("append", new Object[]{", "});
                sep.here();
            }
            bob.invoke("append", new Object[]{info.name});
            isSet.here();
            first = false;
        }
        mm.new_(IllegalStateException.class, new Object[]{bob.invoke("toString", new Object[0])}).throw_();
    }

    public void markNonPrimaryKeyColumnsUnset(Variable rowVar) {
        int num = this.info.keyColumns.size();
        int mask = 0;
        for (ColumnCodec codec : this.valueCodecs()) {
            if (!this.isMaskReady(++num, mask |= RowGen.stateFieldMask(num))) continue;
            mask = this.maskRemainder(num, mask);
            Field field = rowVar.field(this.stateField(num - 1));
            if ((mask ^= 0xFFFFFFFF) == 0) {
                field.set((Object)mask);
                continue;
            }
            field.set((Object)field.and((Object)mask));
            mask = 0;
        }
    }

    private boolean isMaskReady(int num, int mask) {
        return mask != 0 && ((num & 0xF) == 0 || num >= this.info.allColumns.size());
    }

    private int maskRemainder(int num, int mask) {
        int shift;
        if (num >= this.info.allColumns.size() && (shift = (num & 0xF) << 1) != 0) {
            mask |= -1 << shift;
        }
        return mask;
    }
}

