/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.RowGen;
import org.cojen.tupl.rows.RowUtils;

final class RowHeader {
    final int numKeys;
    final String[] columnNames;
    final int[] columnTypes;
    final int[] columnFlags;
    private final int mHashCode;

    static RowHeader make(RowGen rowGen) {
        return RowHeader.make(rowGen.keyCodecs(), rowGen.valueCodecs());
    }

    static RowHeader make(ColumnCodec[] keyCodecs, ColumnCodec[] valueCodecs) {
        ColumnInfo info;
        int numColumns = keyCodecs.length + valueCodecs.length;
        String[] columnNames = new String[numColumns];
        int[] columnTypes = new int[numColumns];
        int[] columnFlags = new int[numColumns];
        int num = 0;
        for (ColumnCodec codec : keyCodecs) {
            info = codec.mInfo;
            columnNames[num] = info.name;
            columnTypes[num] = info.typeCode;
            columnFlags[num] = codec.codecFlags();
            ++num;
        }
        for (ColumnCodec codec : valueCodecs) {
            info = codec.mInfo;
            columnNames[num] = info.name;
            columnTypes[num] = info.typeCode;
            columnFlags[num] = codec.codecFlags();
            ++num;
        }
        return new RowHeader(keyCodecs.length, columnNames, columnTypes, columnFlags);
    }

    static RowHeader make(RowGen rowGen, BitSet projection) {
        return RowHeader.make(rowGen.keyCodecs(), rowGen.valueCodecs(), projection);
    }

    static RowHeader make(ColumnCodec[] keyCodecs, ColumnCodec[] valueCodecs, BitSet projection) {
        int numColumns = projection.cardinality();
        String[] columnNames = new String[numColumns];
        int[] columnTypes = new int[numColumns];
        int[] columnFlags = new int[numColumns];
        int num = 0;
        for (int i = 0; i < keyCodecs.length; ++i) {
            if (!projection.get(i)) continue;
            ColumnCodec codec = keyCodecs[i];
            ColumnInfo info = codec.mInfo;
            columnNames[num] = info.name;
            columnTypes[num] = info.typeCode;
            columnFlags[num] = codec.codecFlags();
            ++num;
        }
        int numKeys = num;
        for (int i = 0; i < valueCodecs.length; ++i) {
            if (!projection.get(keyCodecs.length + i)) continue;
            ColumnCodec codec = valueCodecs[i];
            ColumnInfo info = codec.mInfo;
            columnNames[num] = info.name;
            columnTypes[num] = info.typeCode;
            columnFlags[num] = codec.codecFlags();
            ++num;
        }
        return new RowHeader(numKeys, columnNames, columnTypes, columnFlags);
    }

    private RowHeader(int numKeys, String[] columnNames, int[] columnTypes, int[] columnFlags) {
        this.numKeys = numKeys;
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
        this.columnFlags = columnFlags;
        int hashCode = numKeys;
        hashCode = hashCode * 31 + Arrays.hashCode(columnNames);
        hashCode = hashCode * 31 + Arrays.hashCode(columnTypes);
        this.mHashCode = hashCode = hashCode * 31 + Arrays.hashCode(columnFlags);
    }

    private RowHeader(int numKeys, String[] columnNames, int[] columnTypes, int[] columnFlags, int hashCode) {
        this.numKeys = numKeys;
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
        this.columnFlags = columnFlags;
        this.mHashCode = hashCode;
    }

    int numValues() {
        return this.columnNames.length - this.numKeys;
    }

    byte[] encode(boolean lengthField) {
        int numColumns = this.columnNames.length;
        int length = 12 + numColumns * 10;
        if (lengthField) {
            length += 4;
        }
        for (int i = 0; i < numColumns; ++i) {
            length += RowUtils.lengthStringUTF(this.columnNames[i]);
        }
        byte[] bytes = new byte[length];
        int offset = 0;
        if (lengthField) {
            RowUtils.encodeIntBE(bytes, offset, length - 4);
            offset += 4;
        }
        RowUtils.encodeIntBE(bytes, offset, this.mHashCode);
        RowUtils.encodeIntBE(bytes, offset += 4, this.numKeys);
        RowUtils.encodeIntBE(bytes, offset += 4, this.columnNames.length);
        offset += 4;
        for (int i = 0; i < numColumns; ++i) {
            int start = offset + 2;
            int strlen = (offset = RowUtils.encodeStringUTF(bytes, start, this.columnNames[i])) - start;
            if (strlen > 65535) {
                throw new IllegalStateException();
            }
            RowUtils.encodeShortBE(bytes, start - 2, strlen);
            RowUtils.encodeIntBE(bytes, offset, this.columnTypes[i]);
            RowUtils.encodeIntBE(bytes, offset += 4, this.columnFlags[i]);
            offset += 4;
        }
        return bytes;
    }

    static RowHeader decode(byte[] bytes) {
        int hash = RowUtils.decodeIntBE(bytes, 0);
        int numKeys = RowUtils.decodeIntBE(bytes, 4);
        int numColumns = RowUtils.decodeIntBE(bytes, 8);
        int offset = 12;
        String[] columnNames = new String[numColumns];
        int[] columnTypes = new int[numColumns];
        int[] columnFlags = new int[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            short strlen = RowUtils.decodeShortBE(bytes, offset);
            columnNames[i] = RowUtils.decodeStringUTF(bytes, offset += 2, strlen);
            columnTypes[i] = RowUtils.decodeIntBE(bytes, offset += strlen);
            columnFlags[i] = RowUtils.decodeIntBE(bytes, offset += 4);
            offset += 4;
        }
        if (offset != bytes.length) {
            throw new IllegalStateException();
        }
        return new RowHeader(numKeys, columnNames, columnTypes, columnFlags, hash);
    }

    static byte[] readFrom(DataInput in) throws IOException {
        int length = in.readInt();
        byte[] header = new byte[length];
        in.readFully(header);
        return header;
    }

    public int hashCode() {
        return this.mHashCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof RowHeader)) return false;
        RowHeader other = (RowHeader)obj;
        if (this.numKeys != other.numKeys) return false;
        if (!Arrays.equals(this.columnNames, other.columnNames)) return false;
        if (!Arrays.equals(this.columnTypes, other.columnTypes)) return false;
        if (!Arrays.equals(this.columnFlags, other.columnFlags)) return false;
        return true;
    }
}

