/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.cojen.tupl.AlternateKey;
import org.cojen.tupl.Automatic;
import org.cojen.tupl.Hidden;
import org.cojen.tupl.Nullable;
import org.cojen.tupl.PrimaryKey;
import org.cojen.tupl.SecondaryIndex;
import org.cojen.tupl.Unsigned;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.ColumnSet;
import org.cojen.tupl.rows.ColumnSetComparator;
import org.cojen.tupl.rows.RowGen;
import org.cojen.tupl.rows.SecondaryInfo;
import org.cojen.tupl.rows.WeakClassCache;

class RowInfo
extends ColumnSet {
    private static final WeakClassCache<RowInfo> cache = new WeakClassCache();
    final String name;
    NavigableSet<ColumnSet> alternateKeys;
    NavigableSet<ColumnSet> secondaryIndexes;
    private volatile RowGen mRowGen;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RowInfo find(Class<?> rowType) {
        RowInfo info = (RowInfo)cache.get(rowType);
        if (info == null) {
            WeakClassCache<RowInfo> weakClassCache = cache;
            synchronized (weakClassCache) {
                info = (RowInfo)cache.get(rowType);
                if (info == null) {
                    info = RowInfo.examine(rowType);
                    cache.put(rowType, (Object)info);
                }
            }
        }
        return info;
    }

    private static RowInfo examine(Class<?> rowType) {
        LinkedHashSet<String> messages = new LinkedHashSet<String>(1);
        if (!rowType.isInterface()) {
            messages.add("must be an interface");
            RowInfo.errorCheck(rowType, messages);
        }
        RowInfo info = new RowInfo(rowType.getName());
        ColumnInfo autoColumn = info.examineAllColumns(rowType, messages);
        RowInfo.errorCheck(rowType, messages);
        info.examinePrimaryKey(rowType, messages);
        RowInfo.errorCheck(rowType, messages);
        if (autoColumn != null) {
            ColumnInfo column;
            Iterator it = info.keyColumns.values().iterator();
            do {
                column = (ColumnInfo)it.next();
            } while (it.hasNext());
            if (column != autoColumn) {
                messages.add("automatic column must be the last in the primary key");
            }
        }
        AlternateKey altKey = rowType.getAnnotation(AlternateKey.class);
        AlternateKey.Set altKeySet = rowType.getAnnotation(AlternateKey.Set.class);
        if (altKey == null && altKeySet == null) {
            info.alternateKeys = Collections.emptyNavigableSet();
        } else {
            info.alternateKeys = new TreeSet<ColumnSet>(ColumnSetComparator.THE);
            if (altKey != null) {
                info.examineIndex(messages, info.alternateKeys, altKey.value(), true);
            }
            if (altKeySet != null) {
                for (AlternateKey alt : altKeySet.value()) {
                    info.examineIndex(messages, info.alternateKeys, alt.value(), true);
                }
            }
        }
        SecondaryIndex index = rowType.getAnnotation(SecondaryIndex.class);
        SecondaryIndex.Set indexSet = rowType.getAnnotation(SecondaryIndex.Set.class);
        if (index == null && indexSet == null) {
            info.secondaryIndexes = Collections.emptyNavigableSet();
        } else {
            info.secondaryIndexes = new TreeSet<ColumnSet>(ColumnSetComparator.THE);
            info.secondaryIndexes.add(info);
            if (index != null) {
                info.examineIndex(messages, info.secondaryIndexes, index.value(), false);
            }
            if (indexSet != null) {
                for (SecondaryIndex ix : indexSet.value()) {
                    info.examineIndex(messages, info.secondaryIndexes, ix.value(), false);
                }
            }
        }
        RowInfo.errorCheck(rowType, messages);
        info.alternateKeys = info.finishIndexSet(info.alternateKeys);
        info.secondaryIndexes = info.finishIndexSet(info.secondaryIndexes);
        return info;
    }

    RowInfo(String name) {
        this.name = name;
    }

    boolean isAltKey() {
        return false;
    }

    boolean isDistinct(Set<String> projection) {
        if (projection.containsAll(this.keyColumns.keySet())) {
            return true;
        }
        if (this.alternateKeys != null) {
            for (ColumnSet alt : this.alternateKeys) {
                if (!projection.containsAll(alt.keyColumns.keySet())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RowGen rowGen() {
        RowGen gen = this.mRowGen;
        if (gen == null) {
            RowInfo rowInfo = this;
            synchronized (rowInfo) {
                gen = this.mRowGen;
                if (gen == null) {
                    this.mRowGen = gen = new RowGen(this);
                }
            }
        }
        return gen;
    }

    RowInfo withIndexes(RowInfo current) {
        NavigableSet<ColumnSet> withAlternateKeys = this.pruneIndexes(current.alternateKeys);
        NavigableSet<ColumnSet> withSecondaryIndexes = this.pruneIndexes(current.secondaryIndexes);
        if (Objects.equals(this.alternateKeys, withAlternateKeys) && Objects.equals(this.secondaryIndexes, withSecondaryIndexes)) {
            return this;
        }
        RowInfo copy = new RowInfo(this.name);
        copy.allColumns = this.allColumns;
        copy.valueColumns = this.valueColumns;
        copy.keyColumns = this.keyColumns;
        copy.alternateKeys = withAlternateKeys;
        copy.secondaryIndexes = withSecondaryIndexes;
        return copy;
    }

    private NavigableSet<ColumnSet> pruneIndexes(NavigableSet<ColumnSet> set) {
        TreeSet<ColumnSet> copy = null;
        block0: for (ColumnSet cs : set) {
            for (ColumnInfo column : cs.allColumns.values()) {
                if (column.equals(this.allColumns.get(column.name))) continue;
                if (copy == null) {
                    copy = new TreeSet<ColumnSet>((SortedSet<ColumnSet>)set);
                }
                copy.remove(cs);
                continue block0;
            }
        }
        return copy == null ? set : copy;
    }

    String eventString() {
        StringBuilder bob = new StringBuilder();
        if (this instanceof SecondaryInfo) {
            bob.append(this.isAltKey() ? "alternate key" : "secondary index").append(' ');
        }
        bob.append(this.name).append('(');
        return this.appendIndexSpec(bob).append(')').toString();
    }

    @Override
    public String toString() {
        return "name: " + this.name + ", " + super.toString() + ", alternateKeys: " + this.alternateKeys + ", secondaryIndexes: " + this.secondaryIndexes;
    }

    private static void errorCheck(Class<?> rowType, Set<String> messages) {
        if (!messages.isEmpty()) {
            StringBuilder bob = new StringBuilder();
            bob.append("Row type \"").append(rowType.getSimpleName()).append("\" is malformed: ");
            int length = bob.length();
            for (String message : messages) {
                if (bob.length() > length) {
                    bob.append("; ");
                }
                bob.append(message);
            }
            throw new IllegalArgumentException(bob.toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    private ColumnInfo examineAllColumns(Class<?> rowType, Set<String> messages) {
        this.allColumns = new TreeMap<K, V>();
        autoColumn = null;
        for (Method method : rowType.getMethods()) {
            block23: {
                block21: {
                    block22: {
                        if (method.isDefault() || Modifier.isStatic(modifiers = method.getModifiers()) || !Modifier.isAbstract(modifiers)) continue;
                        name = method.getName();
                        type = method.getReturnType();
                        params = method.getParameterTypes();
                        if (type == Void.TYPE) break block21;
                        if (params.length != 0) break block22;
                        if (name.equals("hashCode") || name.equals("toString") || name.equals("clone") && type.isAssignableFrom(rowType) || (info = this.addColumn(messages, name, type)) == null) continue;
                        if (info.accessor != null) {
                            messages.add("duplicate accessor method \"" + name + "\"");
                            continue;
                        }
                        info.accessor = method;
                        break block23;
                    }
                    if (params.length == 1 && (name.equals("equals") && params[0] == Object.class || name.equals("compareTo") && type == Integer.TYPE && (params[0] == Object.class || params[0] == rowType) && Comparable.class.isAssignableFrom(rowType))) {
                        continue;
                    }
                    ** GOTO lbl-1000
                }
                if (params.length == 1) {
                    type = params[0];
                    info = this.addColumn(messages, name, type);
                    if (info == null) continue;
                    if (info.mutator != null) {
                        messages.add("duplicate mutator method \"" + name + "\"");
                        continue;
                    }
                    info.mutator = method;
                } else lbl-1000:
                // 2 sources

                {
                    messages.add("unsupported method \"" + name + "\"");
                    continue;
                }
            }
            if (method.isAnnotationPresent(Nullable.class)) {
                if (info.type.isPrimitive()) {
                    messages.add("column \"" + info.type.getSimpleName() + " " + info.name + "\" cannot be nullable");
                } else {
                    info.typeCode |= 64;
                }
            }
            if (method.isAnnotationPresent(Unsigned.class)) {
                typeCode = info.plainTypeCode();
                if (typeCode >= 16 || typeCode == 0) {
                    messages.add("column \"" + info.type.getSimpleName() + " " + info.name + "\" cannot be unsigned");
                } else {
                    info.typeCode &= -9;
                }
            }
            if ((auto = method.getAnnotation(Automatic.class)) != null) {
                min = auto.min();
                if (min >= (max = auto.max())) {
                    messages.add("illegal automatic range [" + min + ", " + max + "]");
                }
                switch (info.unorderedTypeCode()) {
                    case 5: 
                    case 6: 
                    case 13: 
                    case 14: {
                        if (!info.isAutomatic()) {
                            if (autoColumn == null) {
                                info.autoMin = min;
                                info.autoMax = max;
                                autoColumn = info;
                                break;
                            }
                            messages.add("at most one column can be automatic");
                            break;
                        }
                        if (info.autoMin == min && info.autoMax == max) break;
                        messages.add("inconsistent automatic range");
                        break;
                    }
                    default: {
                        messages.add("column \"" + info.type.getSimpleName() + " " + info.name + "\" cannot be automatic");
                    }
                }
            }
            info.hidden |= method.isAnnotationPresent(Hidden.class);
        }
        for (ColumnInfo info : this.allColumns.values()) {
            if (info.accessor == null) {
                messages.add("no accessor method for column \"" + info.name + "\"");
                continue;
            }
            if (info.mutator != null) continue;
            messages.add("no mutator method for column \"" + info.name + "\"");
        }
        return autoColumn;
    }

    private ColumnInfo addColumn(Set<String> messages, String name, Class<?> type) {
        int typeCode = RowInfo.selectTypeCode(messages, name, type);
        ColumnInfo info = (ColumnInfo)this.allColumns.get(name);
        if (info == null) {
            name = name.intern();
            info = new ColumnInfo();
            info.name = name;
            info.type = type;
            info.typeCode = typeCode;
            this.allColumns.put(name, info);
        } else if (info.type != type) {
            messages.add("column \"" + info.type.getSimpleName() + " " + info.name + "\" doesn't match type \"" + type.getSimpleName() + "\"");
            info = null;
        }
        return info;
    }

    private static int selectTypeCode(Set<String> messages, String name, Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return 13;
            }
            if (type == Long.TYPE) {
                return 14;
            }
            if (type == Boolean.TYPE) {
                return 0;
            }
            if (type == Double.TYPE) {
                return 18;
            }
            if (type == Float.TYPE) {
                return 17;
            }
            if (type == Byte.TYPE) {
                return 11;
            }
            if (type == Character.TYPE) {
                return 20;
            }
            if (type == Short.TYPE) {
                return 12;
            }
        } else if (type.isArray()) {
            int typeCode;
            Class<?> subType = type.getComponentType();
            if (subType.isPrimitive() && (typeCode = RowInfo.selectTypeCode(null, name, subType)) != -1) {
                return typeCode | 0x20;
            }
        } else {
            if (type == String.class) {
                return 24;
            }
            if (type == BigInteger.class) {
                return 28;
            }
            if (type == BigDecimal.class) {
                return 29;
            }
            if (type == Integer.class) {
                return 13;
            }
            if (type == Long.class) {
                return 14;
            }
            if (type == Boolean.class) {
                return 0;
            }
            if (type == Double.class) {
                return 18;
            }
            if (type == Float.class) {
                return 17;
            }
            if (type == Byte.class) {
                return 11;
            }
            if (type == Character.class) {
                return 20;
            }
            if (type == Short.class) {
                return 12;
            }
        }
        if (messages != null) {
            messages.add("column \"" + type.getSimpleName() + " " + name + "\" has an unsupported type");
        }
        return -1;
    }

    private void examinePrimaryKey(Class<?> rowType, Set<String> messages) {
        PrimaryKey pk = rowType.getAnnotation(PrimaryKey.class);
        if (pk == null) {
            messages.add("no PrimaryKey annotation is present");
            return;
        }
        String[] columnNames = pk.value();
        if (columnNames.length == 0) {
            messages.add(RowInfo.noColumns("primary key"));
            return;
        }
        if (columnNames.length > 1) {
            this.keyColumns = new LinkedHashMap(columnNames.length << 1);
        }
        for (String name : columnNames) {
            ColumnInfo info;
            int flags;
            block14: {
                block13: {
                    block12: {
                        flags = 0;
                        if (!name.startsWith("+")) break block12;
                        name = name.substring(1);
                        break block13;
                    }
                    if (!name.startsWith("-")) break block14;
                    name = name.substring(1);
                    flags |= 0x80;
                }
                if (name.startsWith("!")) {
                    name = name.substring(1);
                    flags |= 0x100;
                }
            }
            if ((info = (ColumnInfo)this.allColumns.get(name)) == null) {
                messages.add(RowInfo.notExist("primary key", name));
                return;
            }
            if ((flags & 0x100) != 0 && !info.isNullable()) {
                flags &= 0xFFFFFEFF;
            }
            info.typeCode |= flags;
            name = info.name;
            if (this.keyColumns == null) {
                this.keyColumns = Map.of(name, info);
                continue;
            }
            if (this.keyColumns.put(name, info) == null) continue;
            messages.add(RowInfo.duplicate("primary key", name));
            return;
        }
        this.valueColumns = new TreeMap();
        for (Map.Entry entry : this.allColumns.entrySet()) {
            String name = (String)entry.getKey();
            if (this.keyColumns.containsKey(name)) continue;
            this.valueColumns.put(name, (ColumnInfo)entry.getValue());
        }
    }

    private void examineIndex(Set<String> messages, NavigableSet<ColumnSet> fullSet, String[] columnNames, boolean forAltKey) {
        ColumnSet set = this.examineIndex(messages, columnNames, forAltKey);
        if (set != null) {
            fullSet.add(set);
        }
    }

    ColumnSet examineIndex(Set<String> messages, String[] columnNames, boolean forAltKey) {
        if (columnNames.length == 0) {
            if (messages != null) {
                messages.add(RowInfo.noColumns(forAltKey ? "alternate key" : "secondary index"));
            }
            return null;
        }
        ColumnSet set = new ColumnSet();
        if (!forAltKey || columnNames.length > 1) {
            set.keyColumns = new LinkedHashMap<String, ColumnInfo>(columnNames.length << 1);
        }
        for (String name : columnNames) {
            ColumnInfo info;
            int flags;
            Boolean descending;
            block36: {
                block35: {
                    block34: {
                        descending = null;
                        flags = 0;
                        if (!name.startsWith("+")) break block34;
                        name = name.substring(1);
                        descending = false;
                        break block35;
                    }
                    if (!name.startsWith("-")) break block36;
                    name = name.substring(1);
                    descending = true;
                }
                if (name.startsWith("!")) {
                    name = name.substring(1);
                    flags |= 0x100;
                }
            }
            if ((info = (ColumnInfo)this.allColumns.get(name)) == null) {
                if (messages != null) {
                    messages.add(RowInfo.notExist(forAltKey ? "alternate key" : "secondary index", name));
                }
                return null;
            }
            if ((flags & 0x100) != 0 && !info.isNullable()) {
                flags &= 0xFFFFFEFF;
            }
            name = info.name;
            if (descending == null) {
                info = RowInfo.withUnspecifiedType(info);
            } else {
                int typeCode = info.typeCode;
                if (descending.booleanValue()) {
                    if (!info.isDescending()) {
                        typeCode |= 0x80;
                    }
                } else if (info.isDescending()) {
                    typeCode &= 0xFFFFFF7F;
                }
                if ((typeCode |= flags) != info.typeCode) {
                    info = info.copy();
                    info.typeCode = typeCode;
                }
            }
            if (set.keyColumns == null) {
                set.keyColumns = new HashMap<String, ColumnInfo>(1);
                set.keyColumns.put(name, info);
                continue;
            }
            if (set.keyColumns.put(name, info) == null) continue;
            if (messages != null) {
                messages.add(RowInfo.duplicate(forAltKey ? "alternate key" : "secondary index", name));
            }
            return null;
        }
        boolean hasFullPrimaryKey = set.keyColumns.keySet().containsAll(this.keyColumns.keySet());
        if (forAltKey) {
            if (hasFullPrimaryKey) {
                if (messages != null) {
                    messages.add("alternate key contains all columns of the primary key");
                }
                return null;
            }
            set.valueColumns = new TreeMap<String, ColumnInfo>();
            for (ColumnInfo pkColumn : this.keyColumns.values()) {
                if (set.keyColumns.containsKey(pkColumn.name)) continue;
                set.valueColumns.put(pkColumn.name, RowInfo.withUnspecifiedType(pkColumn));
            }
        } else {
            if (hasFullPrimaryKey) {
                int remaining = this.keyColumns.size();
                Iterator<Map.Entry<String, ColumnInfo>> it = set.keyColumns.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, ColumnInfo> entry = it.next();
                    if (remaining > 0) {
                        if (!this.keyColumns.containsKey(entry.getKey())) continue;
                        --remaining;
                        continue;
                    }
                    it.remove();
                    if (set.valueColumns == null) {
                        set.valueColumns = new TreeMap<String, ColumnInfo>();
                    }
                    set.valueColumns.put(entry.getKey(), entry.getValue());
                }
            } else {
                for (ColumnInfo pkColumn : this.keyColumns.values()) {
                    if (set.keyColumns.containsKey(pkColumn.name)) continue;
                    set.keyColumns.put(pkColumn.name, RowInfo.withUnspecifiedType(pkColumn));
                }
            }
            if (set.valueColumns == null) {
                set.valueColumns = Collections.emptyNavigableMap();
            }
        }
        return set;
    }

    private static String notExist(String prefix, String name) {
        return prefix + " refers to a column that doesn't exist: " + name;
    }

    private static String duplicate(String prefix, String name) {
        return prefix + " refers to a column more than once: " + name;
    }

    private static String noColumns(String prefix) {
        return prefix + " doesn't specify any columns";
    }

    private static ColumnInfo withUnspecifiedType(ColumnInfo info) {
        info = info.copy();
        info.typeCode = -1;
        return info;
    }

    private NavigableSet<ColumnSet> finishIndexSet(NavigableSet<ColumnSet> initialSet) {
        TreeSet<ColumnSet> nextSet = new TreeSet<ColumnSet>(new ColumnSetComparator(true));
        nextSet.addAll(initialSet.descendingSet());
        TreeSet<ColumnSet> finalSet = new TreeSet<ColumnSet>(ColumnSetComparator.THE);
        Iterator<ColumnSet> it = nextSet.iterator();
        while (it.hasNext()) {
            ColumnSet set = it.next();
            it.remove();
            this.fixTypes(set.keyColumns);
            this.fixTypes(set.valueColumns);
            set.allColumns = new TreeMap<String, ColumnInfo>();
            set.allColumns.putAll(set.keyColumns);
            set.allColumns.putAll(set.valueColumns);
            finalSet.add(set);
        }
        finalSet.remove(this);
        return finalSet;
    }

    private void fixTypes(Map<String, ColumnInfo> columns) {
        for (Map.Entry<String, ColumnInfo> entry : columns.entrySet()) {
            ColumnInfo info = entry.getValue();
            if (info.typeCode != -1) continue;
            entry.setValue((ColumnInfo)this.allColumns.get(info.name));
        }
    }
}

