/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.cojen.maker.Bootstrap;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.Field;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.UnsetColumnException;
import org.cojen.tupl.rows.ArrayStringMaker;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.ComparatorMaker;
import org.cojen.tupl.rows.RowGen;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.TableMaker;
import org.cojen.tupl.rows.WeakClassCache;

public class RowMaker {
    private static final WeakClassCache<Class<?>> cache = new WeakClassCache();
    private final Class<?> mRowType;
    private final RowGen mRowGen;
    private final RowInfo mRowInfo;
    private final ClassMaker mClassMaker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> Class<? extends R> find(Class<R> rowType) {
        Class<?> clazz = (Class<?>)cache.get(rowType);
        if (clazz == null) {
            WeakClassCache<Class<?>> weakClassCache = cache;
            synchronized (weakClassCache) {
                clazz = (Class)cache.get(rowType);
                if (clazz == null) {
                    clazz = new RowMaker(rowType, RowInfo.find(rowType).rowGen()).finish();
                    cache.put(rowType, (Object)clazz);
                }
            }
        }
        return clazz;
    }

    public static <R> MethodHandle makePopulator(Class<R> rowType) {
        Class<R> rowClass = RowMaker.find(rowType);
        RowInfo rowInfo = RowInfo.find(rowType);
        RowGen rowGen = rowInfo.rowGen();
        ClassMaker cm = rowGen.beginClassMaker(null, rowType, "").final_();
        Class[] paramTypes = new Class[1 + rowInfo.allColumns.size()];
        paramTypes[0] = rowType;
        int i = 1;
        for (ColumnInfo info : rowInfo.allColumns.values()) {
            paramTypes[i++] = info.type;
        }
        MethodType mt = MethodType.methodType(rowType, paramTypes);
        MethodMaker mm = cm.addMethod("_", mt).static_();
        Variable rowVar = mm.var(rowClass);
        Variable rowParam = mm.param(0);
        Label correctType = mm.label();
        rowParam.instanceOf(rowClass).ifTrue(correctType);
        rowVar.set((Object)mm.new_(rowClass, new Object[0]));
        Label ready = mm.label().goto_();
        correctType.here();
        rowVar.set((Object)rowParam.cast(rowClass));
        ready.here();
        int i2 = 1;
        for (ColumnInfo info : rowInfo.allColumns.values()) {
            rowVar.field(info.name).set((Object)mm.param(i2++));
        }
        TableMaker.markAllClean(rowVar, rowGen, rowGen);
        mm.return_((Object)rowVar);
        MethodHandles.Lookup lookup = cm.finishHidden();
        try {
            return lookup.findStatic(lookup.lookupClass(), "_", mt);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private RowMaker(Class<?> rowType, RowGen rowGen) {
        this.mRowType = rowType;
        this.mRowGen = rowGen;
        this.mRowInfo = rowGen.info;
        this.mClassMaker = rowGen.beginClassMaker(this.getClass(), rowType, "").implement(rowType).implement(Cloneable.class).final_().public_();
    }

    private Class<?> finish() {
        this.mClassMaker.addConstructor(new Object[0]).public_();
        for (ColumnInfo info : this.mRowInfo.allColumns.values()) {
            this.mClassMaker.addField(info.type, info.name).public_();
        }
        for (String name : this.mRowGen.stateFields()) {
            this.mClassMaker.addField(Integer.TYPE, name);
        }
        Map<String, Integer> columnNumbers = this.mRowGen.columnNumbers();
        for (ColumnInfo info : this.mRowInfo.allColumns.values()) {
            int num = columnNumbers.get(info.name);
            this.addAccessor(num, info);
            this.addMutator(num, info);
        }
        this.addHashCode();
        this.addEquals();
        this.addToString();
        this.addClone();
        this.addCompareTo();
        return this.mClassMaker.finish();
    }

    private void addAccessor(int columnNum, ColumnInfo info) {
        if (info.accessor == null) {
            return;
        }
        MethodMaker mm = this.addMethod(info.accessor).public_();
        Label unset = mm.label();
        this.stateField(mm, columnNum).and((Object)RowGen.stateFieldMask(columnNum)).ifEq((Object)0, unset);
        mm.return_((Object)mm.field(info.name));
        unset.here();
        mm.new_(UnsetColumnException.class, new Object[]{info.name}).throw_();
    }

    private void addMutator(int columnNum, ColumnInfo info) {
        if (info.mutator == null) {
            return;
        }
        MethodMaker mm = this.addMethod(info.mutator).public_();
        if (!info.isNullable() && !info.isPrimitive()) {
            Label notNull = mm.label();
            mm.param(0).ifNe(null, notNull);
            mm.var(RowUtils.class).invoke("nullColumnException", new Object[]{info.name}).throw_();
            notNull.here();
        }
        mm.field(info.name).set((Object)mm.param(0));
        Field state = this.stateField(mm, columnNum);
        state.set((Object)state.or((Object)RowGen.stateFieldMask(columnNum)));
    }

    public static CallSite indyObjectMethod(MethodHandles.Lookup lookup, String name, MethodType mt, Class<?> rowType) {
        MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)lookup, (String)name, (MethodType)mt);
        TypeDescriptor.OfField retType = mt.returnType();
        if (retType == String.class) {
            RowMaker.addToString(mm, rowType, mm.param(0));
        } else if (retType == Integer.TYPE) {
            RowMaker.addHashCode(mm, rowType, mm.param(0));
        } else {
            RowMaker.addEquals(mm, rowType, mm.param(0), mm.param(1));
        }
        return new ConstantCallSite(mm.finish());
    }

    private void addHashCode() {
        MethodMaker mm = this.mClassMaker.addMethod(Integer.TYPE, "hashCode", new Object[0]).public_();
        if (this.mRowInfo.allColumns.isEmpty()) {
            mm.return_((Object)0);
        } else {
            Bootstrap indy = mm.var(RowMaker.class).indy("indyObjectMethod", new Object[]{this.mRowType});
            mm.return_((Object)indy.invoke(Integer.TYPE, "hashCode", null, new Object[]{mm.this_()}));
        }
    }

    private static void addHashCode(MethodMaker mm, Class<?> rowType, Variable rowObject) {
        String[] stateFields;
        RowInfo rowInfo = RowInfo.find(rowType);
        RowGen rowGen = rowInfo.rowGen();
        Variable hash = mm.var(Integer.TYPE).set((Object)rowInfo.name.hashCode());
        for (String stateField : stateFields = rowInfo.rowGen().stateFields()) {
            hash.set((Object)hash.mul((Object)31).add((Object)rowObject.field(stateField)));
        }
        Map<String, Integer> columnNumbers = rowGen.columnNumbers();
        for (ColumnInfo info : rowInfo.allColumns.values()) {
            Class<Object> invoker;
            String name = info.name;
            Label unset = mm.label();
            int num = columnNumbers.get(name);
            rowObject.field(rowGen.stateField(num)).and((Object)RowGen.stateFieldMask(num)).ifEq((Object)0, unset);
            hash.set((Object)hash.mul((Object)31));
            Field field = rowObject.field(name);
            String method = "hashCode";
            if (info.type.isPrimitive()) {
                invoker = info.type;
            } else if (!info.type.isArray()) {
                invoker = Objects.class;
            } else {
                invoker = Arrays.class;
                if (info.type.getComponentType().isArray()) {
                    method = "deepHashCode";
                }
            }
            hash.inc((Object)mm.var(invoker).invoke(method, new Object[]{field}));
            unset.here();
        }
        mm.return_((Object)hash);
    }

    private void addEquals() {
        MethodMaker mm = this.mClassMaker.addMethod(Boolean.TYPE, "equals", new Object[]{Object.class}).public_();
        Bootstrap indy = mm.var(RowMaker.class).indy("indyObjectMethod", new Object[]{this.mRowType});
        mm.return_((Object)indy.invoke(Boolean.TYPE, "equals", null, new Object[]{mm.this_(), mm.param(0)}));
    }

    private static void addEquals(MethodMaker mm, Class<?> rowType, Variable rowObject, Variable otherObject) {
        String[] stateFields;
        RowInfo rowInfo = RowInfo.find(rowType);
        RowGen rowGen = rowInfo.rowGen();
        Label cont = mm.label();
        rowObject.ifNe((Object)otherObject, cont);
        mm.return_((Object)true);
        cont.here();
        Label notEqual = mm.label();
        otherObject.instanceOf((Object)rowObject).ifFalse(notEqual);
        Variable other = otherObject.cast((Object)rowObject);
        for (String name : stateFields = rowGen.stateFields()) {
            rowObject.field(name).ifNe((Object)other.field(name), notEqual);
        }
        Map<String, Integer> columnNumbers = rowGen.columnNumbers();
        for (ColumnInfo info : rowInfo.allColumns.values()) {
            String name;
            name = info.name;
            Label unset = mm.label();
            int num = columnNumbers.get(name);
            rowObject.field(rowGen.stateField(num)).and((Object)RowGen.stateFieldMask(num)).ifEq((Object)0, unset);
            Field field = rowObject.field(name);
            Field otherField = other.field(name);
            if (info.type.isPrimitive()) {
                field.ifNe((Object)otherField, notEqual);
            } else {
                String method = info.isArray() ? "deepEquals" : "equals";
                mm.var(Objects.class).invoke(method, new Object[]{field, otherField}).ifFalse(notEqual);
            }
            unset.here();
        }
        mm.return_((Object)true);
        notEqual.here();
        mm.return_((Object)false);
    }

    private void addToString() {
        MethodMaker mm = this.mClassMaker.addMethod(String.class, "toString", new Object[0]).public_();
        Bootstrap indy = mm.var(RowMaker.class).indy("indyObjectMethod", new Object[]{this.mRowType});
        mm.return_((Object)indy.invoke(String.class, "toString", null, new Object[]{mm.this_()}));
    }

    private static void addToString(MethodMaker mm, Class<?> rowType, Variable rowObject) {
        RowInfo rowInfo = RowInfo.find(rowType);
        RowGen rowGen = rowInfo.rowGen();
        Variable bob = mm.new_(StringBuilder.class, new Object[0]);
        Variable initSize = bob.invoke("append", new Object[]{mm.var(Class.class).set(rowType).invoke("getName", new Object[0])}).invoke("append", new Object[]{Character.valueOf('{')}).invoke("length", new Object[0]);
        int num = 0;
        for (ColumnInfo info : rowInfo.keyColumns.values()) {
            RowMaker.append(mm, rowGen, rowObject, bob, initSize, num, info);
            ++num;
        }
        for (ColumnCodec codec : rowGen.valueCodecs()) {
            RowMaker.append(mm, rowGen, rowObject, bob, initSize, num, codec.mInfo);
            ++num;
        }
        mm.return_((Object)bob.invoke("append", new Object[]{Character.valueOf('}')}).invoke("toString", new Object[0]));
    }

    private static void append(MethodMaker mm, RowGen rowGen, Variable rowObject, Variable bob, Variable initSize, int num, ColumnInfo info) {
        if (info.hidden) {
            return;
        }
        Label unset = mm.label();
        int mask = RowGen.stateFieldMask(num);
        Variable stateVar = rowObject.field(rowGen.stateField(num)).and((Object)mask);
        stateVar.ifEq((Object)0, unset);
        Label sep = mm.label();
        bob.invoke("length", new Object[0]).ifEq((Object)initSize, sep);
        bob.invoke("append", new Object[]{", "});
        sep.here();
        Label clean = mm.label();
        stateVar.ifNe((Object)mask, clean);
        bob.invoke("append", new Object[]{Character.valueOf('*')});
        clean.here();
        bob.invoke("append", new Object[]{info.name}).invoke("append", new Object[]{Character.valueOf('=')});
        Field value = rowObject.field(info.name);
        if (info.isArray()) {
            MethodHandle mh = ArrayStringMaker.make(info.type, info.isUnsignedInteger());
            bob.set((Object)mm.invoke(mh, new Object[]{bob, value, 16}));
        } else {
            if (info.isUnsignedInteger()) {
                if (info.isNullable()) {
                    Label notNull = mm.label();
                    value.ifNe(null, notNull);
                    bob.invoke("append", new Object[]{"null"});
                    mm.goto_(unset);
                    notNull.here();
                }
                switch (info.plainTypeCode()) {
                    default: {
                        throw new AssertionError();
                    }
                    case 3: {
                        value = value.cast(Integer.TYPE).and((Object)255);
                        break;
                    }
                    case 4: {
                        value = value.cast(Integer.TYPE).and((Object)65535);
                    }
                    case 5: 
                    case 6: 
                }
                value = value.invoke("toUnsignedString", new Object[]{value});
            }
            bob.invoke("append", new Object[]{value});
        }
        unset.here();
    }

    private void addClone() {
        MethodMaker mm = this.mClassMaker.addMethod(this.mRowType, "clone", new Object[0]).public_();
        Variable clone = mm.super_().invoke("clone", new Object[0]).cast((Object)this.mClassMaker);
        for (ColumnInfo info : this.mRowInfo.allColumns.values()) {
            if (!info.isArray()) continue;
            Field field = clone.field(info.name);
            Label isNull = mm.label();
            field.ifEq(null, isNull);
            field.set((Object)field.invoke("clone", new Object[0]).cast(info.type));
            isNull.here();
        }
        mm.return_((Object)clone);
        mm = this.mClassMaker.addMethod(Object.class, "clone", new Object[0]).public_().bridge();
        mm.return_((Object)mm.this_().invoke(this.mRowType, "clone", null, new Object[0]));
    }

    private void addCompareTo() {
        if (!Comparable.class.isAssignableFrom(this.mRowType) || this.isDefaultMethod("compareTo", Object.class) || this.isDefaultMethod("compareTo", this.mRowType)) {
            return;
        }
        MethodMaker mm = this.mClassMaker.addMethod(Integer.TYPE, "compareTo", new Object[]{this.mClassMaker}).public_();
        Bootstrap indy = mm.var(RowMaker.class).indy("indyCompare", new Object[]{this.mRowType});
        mm.return_((Object)indy.invoke(Integer.TYPE, "compare", null, new Object[]{mm.this_(), mm.param(0)}));
        mm = this.mClassMaker.addMethod(Integer.TYPE, "compareTo", new Object[]{this.mRowType}).public_().bridge();
        mm.return_((Object)mm.this_().invoke("compareTo", new Object[]{mm.param(0).cast((Object)this.mClassMaker)}));
        mm = this.mClassMaker.addMethod(Integer.TYPE, "compareTo", new Object[]{Object.class}).public_().bridge();
        mm.return_((Object)mm.this_().invoke("compareTo", new Object[]{mm.param(0).cast((Object)this.mClassMaker)}));
    }

    public static CallSite indyCompare(MethodHandles.Lookup lookup, String name, MethodType mt, Class<?> rowType) {
        MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)lookup, (String)name, (MethodType)mt);
        new ComparatorMaker(rowType).makeCompare(mm);
        return new ConstantCallSite(mm.finish());
    }

    private Field stateField(MethodMaker mm, int columnNum) {
        return mm.field(this.mRowGen.stateField(columnNum));
    }

    private MethodMaker addMethod(Method m) {
        return this.mClassMaker.addMethod(m.getReturnType(), m.getName(), (Object[])m.getParameterTypes());
    }

    private boolean isDefaultMethod(String name, Class<?> ... paramTypes) {
        try {
            return this.mRowType.getMethod(name, paramTypes).isDefault();
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

