/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.invoke.VarHandle;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.cojen.maker.Bootstrap;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.Field;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.Entry;
import org.cojen.tupl.core.RowPredicate;
import org.cojen.tupl.filter.AndFilter;
import org.cojen.tupl.filter.ColumnFilter;
import org.cojen.tupl.filter.ColumnToArgFilter;
import org.cojen.tupl.filter.ColumnToColumnFilter;
import org.cojen.tupl.filter.GroupFilter;
import org.cojen.tupl.filter.InFilter;
import org.cojen.tupl.filter.OrFilter;
import org.cojen.tupl.filter.RowFilter;
import org.cojen.tupl.filter.TrueFilter;
import org.cojen.tupl.filter.Visitor;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.rows.ArrayStringMaker;
import org.cojen.tupl.rows.BaseTable;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.CompareUtils;
import org.cojen.tupl.rows.ConvertCallSite;
import org.cojen.tupl.rows.DecodeVisitor;
import org.cojen.tupl.rows.ExceptionCallSite;
import org.cojen.tupl.rows.RowGen;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowMaker;
import org.cojen.tupl.rows.RowStore;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.SwitchCallSite;

public class RowPredicateMaker {
    private static volatile long cPackageNum;
    private static final VarHandle cPackageNumHandle;
    private final WeakReference<RowStore> mStoreRef;
    private final Class<? extends RowPredicate> mBaseClass;
    private final Class<?> mRowType;
    private final RowGen mRowGen;
    private final RowGen mPrimaryRowGen;
    private final long mPrimaryIndexId;
    private final long mIndexId;
    private final RowFilter mFilter;
    private final WeakReference<RowFilter> mFilterRef;
    private final String mFilterStr;
    private final RowFilter[][] mRanges;
    private final ClassMaker mClassMaker;
    private final MethodMaker mCtorMaker;
    private final ColumnCodec[] mCodecs;
    private ColumnCodec[] mPrimaryCodecs;

    RowPredicateMaker(WeakReference<RowStore> storeRef, Class<? extends RowPredicate> baseClass, Class<?> rowType, RowGen rowGen, RowGen primaryRowGen, long primaryIndexId, long indexId, RowFilter filter, String filterStr, RowFilter[][] ranges) {
        this.mStoreRef = storeRef;
        this.mBaseClass = baseClass;
        this.mRowType = rowType;
        this.mRowGen = rowGen;
        this.mPrimaryRowGen = primaryRowGen;
        this.mPrimaryIndexId = primaryIndexId;
        this.mIndexId = indexId;
        this.mFilter = filter;
        this.mFilterRef = new WeakReference<RowFilter>(filter);
        this.mFilterStr = filterStr;
        this.mRanges = ranges;
        String packageName = "p" + cPackageNumHandle.getAndAdd(1L);
        this.mClassMaker = rowGen.beginClassMaker(this.getClass(), rowType, packageName, "predicate").final_().extend(baseClass).implement(RowPredicate.class);
        this.mCtorMaker = this.mClassMaker.addConstructor(new Object[]{Object[].class}).varargs();
        this.mCtorMaker.invokeSuperConstructor(new Object[0]);
        this.mCodecs = rowGen.codecsCopy();
    }

    RowPredicateMaker(Class<?> rowType, RowGen rowGen, RowFilter filter, String filterStr) {
        this.mStoreRef = null;
        this.mBaseClass = null;
        this.mRowType = rowType;
        this.mRowGen = rowGen;
        this.mPrimaryRowGen = null;
        this.mPrimaryIndexId = 0L;
        this.mIndexId = 0L;
        this.mFilter = filter;
        this.mFilterRef = new WeakReference<RowFilter>(filter);
        this.mFilterStr = filterStr;
        this.mRanges = null;
        this.mClassMaker = rowGen.beginClassMaker(this.getClass(), rowType, null, "predicate").final_().implement(Predicate.class);
        this.mCtorMaker = this.mClassMaker.addConstructor(new Object[]{Object[].class}).varargs();
        this.mCtorMaker.invokeSuperConstructor(new Object[0]);
        this.mCodecs = rowGen.codecsCopy();
    }

    Class<? extends RowPredicate> finish() {
        HashMap<String, ColumnCodec> defined = new HashMap<String, ColumnCodec>();
        if (this.mRanges == null) {
            this.makeAllFields(defined, this.mFilter, false, true);
        } else {
            for (RowFilter[] range : this.mRanges) {
                this.makeAllFields(defined, range[2], false, true);
            }
            for (RowFilter[] range : this.mRanges) {
                this.makeAllFields(defined, range[0], false, false);
                this.makeAllFields(defined, range[1], false, false);
            }
            for (RowFilter[] range : this.mRanges) {
                this.makeAllFields(defined, range[3], true, false);
            }
        }
        if (!RowPredicate.None.class.isAssignableFrom(this.mBaseClass)) {
            this.addRowTestMethod();
            this.addPartialRowTestMethod();
            this.addFullDecodeTestMethod();
            this.addKeyTestMethod();
        }
        this.addToStringMethod();
        return this.mClassMaker.finish();
    }

    MethodHandle finishPlain() {
        this.makeAllFields(new HashMap<String, ColumnCodec>(), this.mFilter, false, true);
        this.addDirectRowTestMethod();
        MethodHandles.Lookup lookup = this.mClassMaker.finishHidden();
        try {
            MethodType mt = MethodType.methodType(Void.TYPE, Object[].class);
            MethodHandle mh = lookup.findConstructor(lookup.lookupClass(), mt);
            return mh.asType(MethodType.methodType(Predicate.class, Object[].class));
        }
        catch (Throwable e) {
            throw RowUtils.rethrow(e);
        }
    }

    private void makeAllFields(HashMap<String, ColumnCodec> defined, RowFilter filter, boolean primaryOnly, boolean init) {
        if (filter != null) {
            filter.accept(new FieldMaker(defined, primaryOnly, init));
        }
    }

    private ColumnCodec codecFor(String colName, boolean primaryOnly) {
        Integer num;
        ColumnCodec[] codecs = this.mCodecs;
        if (primaryOnly || (num = this.mRowGen.columnNumbers().get(colName)) == null) {
            if (this.mPrimaryRowGen != null) {
                num = this.mPrimaryRowGen.columnNumbers().get(colName);
                if (num != null && (codecs = this.mPrimaryCodecs) == null) {
                    codecs = this.mPrimaryRowGen.codecsCopy();
                    this.mPrimaryCodecs = codecs;
                }
            } else {
                throw new IllegalStateException("Column is unavailable for filtering: " + colName);
            }
        }
        int colNum = num;
        ColumnCodec codec = codecs[colNum];
        if (codec.mMaker != this.mCtorMaker) {
            codecs[colNum] = codec = codec.bind(this.mCtorMaker);
        }
        return codec;
    }

    private void addToStringMethod() {
        MethodMaker mm = this.mClassMaker.addMethod(String.class, "toString", new Object[0]).public_();
        Bootstrap indy = mm.var(RowPredicateMaker.class).indy("indyToString", new Object[]{this.mRowType, this.mFilterRef, this.mFilterStr});
        mm.return_((Object)indy.invoke(String.class, "toString", null, new Object[]{mm.this_()}));
    }

    private void addRowTestMethod() {
        MethodMaker mm = this.mClassMaker.addMethod(Boolean.TYPE, "test", new Object[]{Object.class}).public_();
        Bootstrap indy = mm.var(RowPredicateMaker.class).indy("indyRowTest", new Object[]{this.mRowType, this.mFilterRef, this.mFilterStr});
        Class<?> rowClass = RowMaker.find(this.mRowType);
        mm.return_((Object)indy.invoke(Boolean.TYPE, "test", null, new Object[]{mm.param(0).cast(rowClass), mm.this_()}));
    }

    private void addDirectRowTestMethod() {
        MethodMaker mm = this.mClassMaker.addMethod(Boolean.TYPE, "test", new Object[]{Object.class}).public_();
        Class<?> rowClass = RowMaker.find(this.mRowType);
        RowTestMaker tm = new RowTestMaker(mm, mm.param(0).cast(rowClass), mm.this_());
        this.mFilter.accept(tm);
        tm.finish();
    }

    public static CallSite indyRowTest(MethodHandles.Lookup lookup, String name, MethodType mt, Class<?> rowType, WeakReference<RowFilter> filterRef, String filterStr) {
        RowFilter filter = (RowFilter)filterRef.get();
        if (filter == null) {
            filter = BaseTable.parseFilter(rowType, filterStr);
        }
        MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)lookup, (String)name, (MethodType)mt);
        RowTestMaker tm = new RowTestMaker(mm, mm.param(0), mm.param(1));
        filter.accept(tm);
        tm.finish();
        return new ConstantCallSite(mm.finish());
    }

    private void addPartialRowTestMethod() {
    }

    private void addFullDecodeTestMethod() {
        MethodMaker mm = this.mClassMaker.addMethod(Boolean.TYPE, "test", new Object[]{byte[].class, byte[].class}).public_();
        Variable keyVar = mm.param(0);
        Variable valueVar = mm.param(1);
        if (this.mPrimaryIndexId == this.mIndexId && this.mRowType != Entry.class) {
            Bootstrap indy = mm.var(RowPredicateMaker.class).indy("indySchemaDecodeTest", new Object[]{this.mStoreRef, this.mRowType, this.mIndexId, this.mFilterRef, this.mFilterStr});
            Variable schemaVersionVar = mm.var(RowUtils.class).invoke("decodeSchemaVersion", new Object[]{valueVar});
            mm.return_((Object)indy.invoke(Boolean.TYPE, "test", null, new Object[]{schemaVersionVar, keyVar, valueVar, mm.this_()}));
        } else {
            Bootstrap indy = mm.var(RowPredicateMaker.class).indy("indyDecodeTest", new Object[]{this.mStoreRef, this.mRowType, this.mPrimaryIndexId, this.mIndexId, this.mFilterRef, this.mFilterStr});
            mm.return_((Object)indy.invoke(Boolean.TYPE, "test", null, new Object[]{keyVar, valueVar, mm.this_()}));
        }
    }

    public static CallSite indySchemaDecodeTest(MethodHandles.Lookup lookup, String name, MethodType mt, WeakReference<RowStore> storeRef, Class<?> rowType, long primaryIndexId, WeakReference<RowFilter> filterRef, String filterStr) {
        DecodeTestMaker dtm = new DecodeTestMaker(lookup, mt, storeRef, rowType, primaryIndexId, filterRef, filterStr);
        return new SwitchCallSite(lookup, mt, dtm);
    }

    private void addKeyTestMethod() {
        RowFilter filter = this.mFilter.retain(this.mRowGen.info.keyColumns, true, TrueFilter.THE);
        if (filter == TrueFilter.THE) {
            return;
        }
        WeakReference<RowFilter> filterRef = this.mFilterRef;
        String filterStr = this.mFilterStr;
        if (!filter.equals(this.mFilter)) {
            filterRef = new WeakReference<RowFilter>(filter);
            filterStr = filter.toString();
        }
        MethodMaker mm = this.mClassMaker.addMethod(Boolean.TYPE, "test", new Object[]{byte[].class}).public_();
        Bootstrap indy = mm.var(RowPredicateMaker.class).indy("indyDecodeTest", new Object[]{this.mStoreRef, this.mRowType, this.mPrimaryIndexId, this.mIndexId, filterRef, filterStr});
        mm.return_((Object)indy.invoke(Boolean.TYPE, "test", null, new Object[]{mm.param(0), mm.this_()}));
    }

    public static CallSite indyDecodeTest(MethodHandles.Lookup lookup, String name, MethodType mt, WeakReference<RowStore> storeRef, Class<?> rowType, long primaryIndexId, long indexId, WeakReference<RowFilter> filterRef, String filterStr) {
        return ExceptionCallSite.make(() -> {
            MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)lookup, (String)name, (MethodType)mt);
            RowStore store = (RowStore)storeRef.get();
            if (store == null) {
                mm.new_(DatabaseException.class, new Object[]{"Closed"}).throw_();
            } else {
                RowInfo rowInfo;
                try {
                    rowInfo = store.currentRowInfo(rowType, primaryIndexId, indexId);
                }
                catch (Throwable e) {
                    return new ExceptionCallSite.Failed(mt, mm, e);
                }
                RowFilter filter = (RowFilter)filterRef.get();
                if (filter == null) {
                    filter = BaseTable.parseFilter(rowType, filterStr);
                }
                Variable predicateVar = mm.param(mt.parameterCount() - 1);
                DecodeVisitor visitor = new DecodeVisitor(mm, 0, rowInfo.rowGen(), predicateVar, null, 0);
                visitor.applyFilter(filter);
                visitor.finishPredicate();
            }
            return mm.finish();
        });
    }

    public static CallSite indyToString(MethodHandles.Lookup lookup, String name, MethodType mt, Class<?> rowType, WeakReference<RowFilter> filterRef, String filterStr) {
        RowFilter filter = (RowFilter)filterRef.get();
        if (filter == null) {
            filter = BaseTable.parseFilter(rowType, filterStr);
        }
        MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)lookup, (String)name, (MethodType)mt);
        ToStringMaker sm = new ToStringMaker(mm, mm.param(0));
        filter.accept(sm);
        mm.return_((Object)sm.mBuilderVar.invoke("toString", new Object[0]));
        return new ConstantCallSite(mm.finish());
    }

    static {
        try {
            cPackageNumHandle = MethodHandles.lookup().findStaticVarHandle(RowPredicateMaker.class, "cPackageNum", Long.TYPE);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    private class FieldMaker
    extends Visitor {
        private final HashMap<String, ColumnCodec> mDefined;
        private final boolean mPrimaryOnly;
        private final boolean mInit;

        FieldMaker(HashMap<String, ColumnCodec> defined, boolean primaryOnly, boolean init) {
            this.mDefined = defined;
            this.mPrimaryOnly = primaryOnly;
            this.mInit = init;
        }

        @Override
        public void visit(ColumnToArgFilter filter) {
            String colName = filter.column().name;
            String argFieldName = ColumnCodec.argFieldName(colName, filter.argument());
            boolean hasField = this.mDefined.containsKey(argFieldName);
            if (!this.mPrimaryOnly && hasField) {
                return;
            }
            ColumnCodec codec = RowPredicateMaker.this.codecFor(colName, this.mPrimaryOnly);
            if (this.mPrimaryOnly && codec.equals(this.mDefined.get(argFieldName))) {
                return;
            }
            TypeDescriptor.OfField<Class<?>> argType = filter.column().type;
            boolean in = ColumnToArgFilter.isIn(filter.operator());
            if (in) {
                argType = argType.arrayType();
            }
            Variable argVar = RowPredicateMaker.this.mCtorMaker.param(0).aget((Object)(filter.argument() - 1));
            argVar = ConvertCallSite.make(RowPredicateMaker.this.mCtorMaker, argType, argVar);
            if (!hasField) {
                codec.defineArgField(argVar, argFieldName, argVar);
            }
            codec.filterDefineExtraFields(in, (Variable)(this.mInit ? argVar : null), argFieldName);
            this.mDefined.put(argFieldName, codec);
        }
    }

    private static class RowTestMaker
    extends Visitor {
        private final MethodMaker mMaker;
        private final Variable mRowVar;
        private final Variable mPredicateVar;
        private Label mPass;
        private Label mFail;

        RowTestMaker(MethodMaker mm, Variable rowVar, Variable predicateVar) {
            this.mMaker = mm;
            this.mRowVar = rowVar;
            this.mPredicateVar = predicateVar;
            this.mPass = mm.label();
            this.mFail = mm.label();
        }

        void finish() {
            this.mFail.here();
            this.mMaker.return_((Object)false);
            this.mPass.here();
            this.mMaker.return_((Object)true);
        }

        @Override
        public void visit(OrFilter filter) {
            RowFilter[] subFilters;
            Label originalFail = this.mFail;
            for (RowFilter subFilter : subFilters = filter.subFilters()) {
                this.mFail = this.mMaker.label();
                subFilter.accept(this);
                this.mFail.here();
            }
            this.mMaker.goto_(originalFail);
            this.mFail = originalFail;
        }

        @Override
        public void visit(AndFilter filter) {
            RowFilter[] subFilters;
            Label originalPass = this.mPass;
            for (RowFilter subFilter : subFilters = filter.subFilters()) {
                this.mPass = this.mMaker.label();
                subFilter.accept(this);
                this.mPass.here();
            }
            this.mMaker.goto_(originalPass);
            this.mPass = originalPass;
        }

        @Override
        public void visit(ColumnToArgFilter filter) {
            ColumnInfo ci = filter.column();
            String colName = ci.name;
            Field colVar = this.mRowVar.field(colName);
            String argFieldName = ColumnCodec.argFieldName(colName, filter.argument());
            Field argVar = this.mPredicateVar.field(argFieldName);
            CompareUtils.compare(this.mMaker, ci, (Variable)colVar, ci, (Variable)argVar, filter.operator(), this.mPass, this.mFail);
        }

        @Override
        public void visit(ColumnToColumnFilter filter) {
            ColumnInfo c1 = filter.column();
            Field c1Var = this.mRowVar.field(c1.name);
            ColumnInfo c2 = filter.otherColumn();
            Field c2Var = this.mRowVar.field(c2.name);
            CompareUtils.compare(this.mMaker, c1, (Variable)c1Var, c2, (Variable)c2Var, filter.operator(), this.mPass, this.mFail);
        }
    }

    private static class DecodeTestMaker
    implements IntFunction<Object> {
        private final MethodHandles.Lookup mLookup;
        private final MethodType mMethodType;
        private final WeakReference<RowStore> mStoreRef;
        private final Class<?> mRowType;
        private final long mPrimaryIndexId;
        private final String mFilterStr;
        private WeakReference<RowFilter> mFilterRef;

        DecodeTestMaker(MethodHandles.Lookup lookup, MethodType mt, WeakReference<RowStore> storeRef, Class<?> rowType, long primaryIndexId, WeakReference<RowFilter> filterRef, String filterStr) {
            this.mLookup = lookup;
            this.mMethodType = mt.dropParameterTypes(0, 1);
            this.mStoreRef = storeRef;
            this.mRowType = rowType;
            this.mPrimaryIndexId = primaryIndexId;
            this.mFilterStr = filterStr;
            this.mFilterRef = filterRef;
        }

        @Override
        public Object apply(int schemaVersion) {
            MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)this.mLookup, (String)"test", (MethodType)this.mMethodType);
            RowStore store = (RowStore)this.mStoreRef.get();
            if (store == null) {
                mm.new_(DatabaseException.class, new Object[]{"Closed"}).throw_();
            } else {
                RowInfo rowInfo;
                try {
                    rowInfo = store.rowInfo(this.mRowType, this.mPrimaryIndexId, schemaVersion);
                }
                catch (Throwable e) {
                    return new ExceptionCallSite.Failed(this.mMethodType, mm, e);
                }
                RowFilter filter = (RowFilter)this.mFilterRef.get();
                if (filter == null) {
                    filter = BaseTable.parseFilter(this.mRowType, this.mFilterStr);
                    this.mFilterRef = new WeakReference<RowFilter>(filter);
                }
                int valueOffset = RowUtils.lengthPrefixPF(schemaVersion);
                RowGen rowGen = rowInfo.rowGen();
                Variable predicateVar = mm.param(2);
                DecodeVisitor visitor = new DecodeVisitor(mm, valueOffset, rowGen, predicateVar, null, 0);
                visitor.applyFilter(filter);
                visitor.finishPredicate();
            }
            return mm.finish();
        }
    }

    private static class ToStringMaker
    extends Visitor {
        private final MethodMaker mMaker;
        private final Variable mPredicateVar;
        Variable mBuilderVar;

        ToStringMaker(MethodMaker mm, Variable predicateVar) {
            this.mMaker = mm;
            this.mPredicateVar = predicateVar;
            this.mBuilderVar = mm.new_(StringBuilder.class, new Object[0]);
        }

        @Override
        public void visit(OrFilter filter) {
            RowFilter[] subFilters = filter.subFilters();
            if (subFilters.length == 0) {
                this.mBuilderVar = this.mBuilderVar.invoke("append", new Object[]{Character.valueOf('F')});
            } else {
                this.appendGroupFilter(filter, subFilters);
            }
        }

        @Override
        public void visit(AndFilter filter) {
            RowFilter[] subFilters = filter.subFilters();
            if (subFilters.length == 0) {
                this.mBuilderVar = this.mBuilderVar.invoke("append", new Object[]{Character.valueOf('T')});
            } else {
                this.appendGroupFilter(filter, subFilters);
            }
        }

        @Override
        public void visit(InFilter filter) {
            int op = filter.operator();
            if (op == 7) {
                this.mBuilderVar = this.mBuilderVar.invoke("append", new Object[]{Character.valueOf('!')}).invoke("append", new Object[]{Character.valueOf('(')});
            }
            this.mBuilderVar = this.mBuilderVar.invoke("append", new Object[]{filter.column().name}).invoke("append", new Object[]{Character.valueOf(' ')}).invoke("append", new Object[]{"in"}).invoke("append", new Object[]{Character.valueOf(' ')});
            this.appendArgument(filter.column(), filter.argument());
            if (op == 7) {
                this.mBuilderVar = this.mBuilderVar.invoke("append", new Object[]{Character.valueOf(')')});
            }
        }

        @Override
        public void visit(ColumnToArgFilter filter) {
            this.appendColumnAndOp(filter);
            this.appendArgument(filter.column(), filter.argument());
        }

        @Override
        public void visit(ColumnToColumnFilter filter) {
            this.appendColumnAndOp(filter);
            this.mBuilderVar = this.mBuilderVar.invoke("append", new Object[]{filter.otherColumn().name});
        }

        protected void appendArgument(ColumnInfo column, int argNum) {
            if (column.hidden) {
                this.mBuilderVar = this.mBuilderVar.invoke("append", new Object[]{Character.valueOf('?')}).invoke("append", new Object[]{argNum});
                return;
            }
            Field argValue = this.mPredicateVar.field(ColumnCodec.argFieldName(column.name, argNum));
            Class argType = argValue.classType();
            if (argType.isArray()) {
                MethodHandle mh = ArrayStringMaker.make(argType, column.isUnsignedInteger());
                this.mBuilderVar = this.mMaker.invoke(mh, new Object[]{this.mBuilderVar, argValue, 16});
                return;
            }
            if (!column.isUnsignedInteger()) {
                int code = column.plainTypeCode();
                if (code == 24 || code == 20) {
                    this.mMaker.var(RowUtils.class).invoke("appendQuotedString", new Object[]{this.mBuilderVar, argValue});
                } else {
                    this.mBuilderVar = this.mBuilderVar.invoke("append", new Object[]{argValue});
                }
                return;
            }
            Variable strValue = this.mMaker.var(String.class);
            Label cont = null;
            if (column.isNullable()) {
                Label notNull = this.mMaker.label();
                argValue.ifNe(null, notNull);
                strValue.set((Object)"null");
                cont = this.mMaker.label().goto_();
                notNull.here();
            }
            switch (column.plainTypeCode()) {
                default: {
                    throw new AssertionError();
                }
                case 3: {
                    argValue = argValue.cast(Integer.TYPE).and((Object)255);
                    break;
                }
                case 4: {
                    argValue = argValue.cast(Integer.TYPE).and((Object)65535);
                }
                case 5: 
                case 6: 
            }
            strValue.set((Object)argValue.invoke("toUnsignedString", new Object[]{argValue}));
            if (cont != null) {
                cont.here();
            }
            this.mBuilderVar = this.mBuilderVar.invoke("append", new Object[]{strValue});
        }

        private void appendColumnAndOp(ColumnFilter filter) {
            this.mBuilderVar = this.mBuilderVar.invoke("append", new Object[]{filter.column().name}).invoke("append", new Object[]{Character.valueOf(' ')}).invoke("append", new Object[]{filter.operatorString()}).invoke("append", new Object[]{Character.valueOf(' ')});
        }

        private void appendGroupFilter(GroupFilter filter, RowFilter[] subFilters) {
            char opChar = filter.opChar();
            for (int i = 0; i < subFilters.length; ++i) {
                RowFilter sub;
                if (i != 0) {
                    this.mBuilderVar = this.mBuilderVar.invoke("append", new Object[]{Character.valueOf(' ')}).invoke("append", new Object[]{Character.valueOf(opChar)}).invoke("append", new Object[]{Character.valueOf(opChar)}).invoke("append", new Object[]{Character.valueOf(' ')});
                }
                if ((sub = subFilters[i]) instanceof GroupFilter) {
                    this.mBuilderVar = this.mBuilderVar.invoke("append", new Object[]{Character.valueOf('(')});
                    sub.accept(this);
                    this.mBuilderVar = this.mBuilderVar.invoke("append", new Object[]{Character.valueOf(')')});
                    continue;
                }
                sub.accept(this);
            }
        }
    }
}

