/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.DataInput;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.Scanner;
import org.cojen.tupl.rows.CodeUtils;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.Converter;
import org.cojen.tupl.rows.RowHeader;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowMaker;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.TableMaker;
import org.cojen.tupl.rows.WeakCache;

public abstract class RowReader<R, DIN extends DataInput>
implements Scanner<R> {
    private static final WeakCache<CacheKey, Decoder, Object> cDecoders = new WeakCache<CacheKey, Decoder, Object>(){

        @Override
        protected Decoder newValue(CacheKey key, Object unused) {
            return RowReader.makeDecoder(key.mRowType, key.mHeader);
        }
    };
    private final Class<R> mRowType;
    private DIN mIn;
    private final long mSize;
    private final int mCharacteristics;
    private Decoder<R> mDecoder;
    private int mDecoderId;
    private R mRow;
    private byte[] mRowData;
    private Decoder[] mDecoders;
    private int mNumDecoders;

    public RowReader(Class<R> rowType, DIN in) throws IOException {
        this.mRowType = rowType;
        this.mIn = in;
        try {
            int characteristics = in.readInt();
            this.mSize = (characteristics & 0x40) == 0 ? Long.MAX_VALUE : in.readLong();
            this.mCharacteristics = characteristics;
            this.doStep(null);
        }
        catch (Throwable e) {
            throw RowUtils.fail(this, e);
        }
    }

    @Override
    public final long estimateSize() {
        return this.mSize;
    }

    @Override
    public final int characteristics() {
        return this.mCharacteristics;
    }

    @Override
    public final R row() {
        return this.mRow;
    }

    @Override
    public final R step() throws IOException {
        try {
            return this.doStep(null);
        }
        catch (Throwable e) {
            throw RowUtils.fail(this, e);
        }
    }

    @Override
    public final R step(R row) throws IOException {
        Objects.requireNonNull(row);
        try {
            return this.doStep(row);
        }
        catch (Throwable e) {
            throw RowUtils.fail(this, e);
        }
    }

    @Override
    public final void close() throws IOException {
        this.close(false);
    }

    private void close(boolean finished) throws IOException {
        DIN in = this.mIn;
        if (in != null) {
            this.mIn = null;
            this.mDecoder = null;
            this.mRow = null;
            this.mRowData = null;
            this.mDecoders = null;
            this.close(in, finished);
        }
    }

    protected abstract void close(DIN var1, boolean var2) throws IOException;

    private R doStep(R row) throws IOException {
        DIN in = this.mIn;
        if (in == null) {
            return null;
        }
        int prefix = in.readUnsignedByte();
        if (prefix != 1) {
            if (prefix == 0) {
                this.close(true);
                return null;
            }
            if (prefix == 2) {
                int decoderId;
                CacheKey key = new CacheKey(this.mRowType, RowHeader.readFrom(in));
                Decoder decoder = (Decoder)cDecoders.obtain((Object)key, null);
                if (this.mDecoder == null) {
                    decoderId = 0;
                } else if (this.mDecoders == null) {
                    decoderId = 1;
                    this.mDecoders = new Decoder[]{this.mDecoder, decoder};
                    this.mNumDecoders = 2;
                } else {
                    decoderId = this.mNumDecoders;
                    if (decoderId >= this.mDecoders.length) {
                        int newLen = Math.min(this.mDecoders.length << 1, Integer.MAX_VALUE);
                        this.mDecoders = Arrays.copyOf(this.mDecoders, newLen);
                    }
                    this.mDecoders[decoderId] = decoder;
                    this.mNumDecoders = decoderId + 1;
                }
                this.mDecoder = decoder;
                this.mDecoderId = decoderId;
            } else {
                int decoderId;
                int n = decoderId = prefix < 255 ? prefix - 5 : in.readInt();
                if (this.mDecoders != null) {
                    this.mDecoder = this.mDecoders[decoderId];
                } else if (decoderId != 0) {
                    throw new IllegalStateException();
                }
            }
        }
        this.mRow = this.mDecoder.decodeRow(this, row);
        return this.mRow;
    }

    public final int readRowLength() throws IOException {
        int len = this.mIn.readShort();
        return len >= 0 ? len : this.readIntRowLength(len);
    }

    private int readIntRowLength(int len) throws IOException {
        return (len << 16 | this.mIn.readUnsignedShort()) & Integer.MAX_VALUE;
    }

    public final byte[] readRowBytes(int length) throws IOException {
        byte[] rowData = this.mRowData;
        if (rowData == null || rowData.length < length) {
            this.mRowData = rowData = new byte[length];
        }
        this.mIn.readFully(rowData, 0, length);
        return rowData;
    }

    private static <R> Decoder<R> makeDecoder(Class<R> rowType, byte[] header) {
        Variable keyEndVar;
        RowInfo rowInfo = RowInfo.find(rowType);
        Class<R> rowClass = RowMaker.find(rowType);
        RowHeader rh = RowHeader.decode(header);
        ColumnCodec[] codecs = ColumnCodec.make(rh);
        ClassMaker cm = rowInfo.rowGen().beginClassMaker(RowReader.class, rowType, "reader");
        cm.public_().final_().implement(Decoder.class);
        cm.addField(Decoder.class, "THE").private_().static_();
        MethodMaker mm = cm.addConstructor(new Object[0]).private_();
        mm.invokeSuperConstructor(new Object[0]);
        mm.field("THE").set((Object)mm.this_());
        mm = cm.addMethod(Object.class, "decodeRow", new Object[]{RowReader.class, Object.class}).public_();
        Variable rowVar = CodeUtils.castOrNew(mm.param(1), rowClass);
        Variable readerVar = mm.param(0);
        Variable valueEndVar = readerVar.invoke("readRowLength", new Object[0]);
        Variable dataVar = readerVar.invoke("readRowBytes", new Object[]{valueEndVar});
        Variable offsetVar = mm.var(Integer.TYPE);
        if (rh.numValues() == 0 || rh.numKeys == 0 || !codecs[rh.numKeys - 1].isLast()) {
            offsetVar.set((Object)0);
            keyEndVar = null;
        } else {
            keyEndVar = dataVar.aget((Object)0).cast(Integer.TYPE).and((Object)255);
            Label bigKey = mm.label();
            keyEndVar.ifGe((Object)128, bigKey);
            keyEndVar.inc((Object)1);
            offsetVar.set((Object)1);
            Label cont = mm.label().goto_();
            bigKey.here();
            Variable rowUtils = mm.var(RowUtils.class);
            keyEndVar.set((Object)rowUtils.invoke("decodeIntBE", new Object[]{dataVar, 0}).and((Object)Integer.MAX_VALUE).add((Object)4));
            offsetVar.set((Object)4);
            cont.here();
        }
        codecs = ColumnCodec.bind(codecs, mm);
        HashMap<String, ColumnInfo> decodedColumns = new HashMap<String, ColumnInfo>();
        for (int i = 0; i < codecs.length; ++i) {
            ColumnCodec codec = codecs[i];
            String name = codec.mInfo.name;
            ColumnInfo colInfo = (ColumnInfo)rowInfo.allColumns.get(name);
            Variable endVar = valueEndVar;
            if (keyEndVar != null && i == rh.numKeys - 1) {
                endVar = keyEndVar;
                keyEndVar = null;
            }
            if (colInfo == null) {
                codec.decodeSkip(dataVar, offsetVar, endVar);
                continue;
            }
            Converter.decodeExact(mm, name, dataVar, offsetVar, endVar, codec, colInfo, (Variable)rowVar.field(name));
            decodedColumns.put(name, colInfo);
        }
        TableMaker.markClean(rowVar, rowInfo.rowGen(), decodedColumns);
        mm.return_((Object)rowVar);
        try {
            MethodHandles.Lookup lookup = cm.finishHidden();
            MethodHandle mh = lookup.findConstructor(lookup.lookupClass(), MethodType.methodType(Void.TYPE));
            return mh.invoke();
        }
        catch (Throwable e) {
            throw RowUtils.rethrow(e);
        }
    }

    public static interface Decoder<R> {
        public R decodeRow(RowReader var1, R var2) throws IOException;
    }

    private static final class CacheKey {
        final Class mRowType;
        final byte[] mHeader;

        CacheKey(Class rowType, byte[] header) {
            this.mRowType = rowType;
            this.mHeader = header;
        }

        public int hashCode() {
            return this.mRowType.hashCode() ^ RowUtils.decodeIntBE(this.mHeader, 0);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof CacheKey)) return false;
            CacheKey other = (CacheKey)obj;
            if (this.mRowType != other.mRowType) return false;
            if (!Arrays.equals(this.mHeader, other.mHeader)) return false;
            return true;
        }
    }
}

