/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Comparator;
import org.cojen.tupl.Entry;
import org.cojen.tupl.Scanner;
import org.cojen.tupl.Sorter;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.rows.ArrayScanner;
import org.cojen.tupl.rows.BaseTable;
import org.cojen.tupl.rows.DecodePartialMaker;
import org.cojen.tupl.rows.RowConsumer;
import org.cojen.tupl.rows.RowDecoder;
import org.cojen.tupl.rows.RowEvaluator;
import org.cojen.tupl.rows.RowGen;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowStore;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.RowWriter;
import org.cojen.tupl.rows.ScanBatch;
import org.cojen.tupl.rows.ScannerScanner;
import org.cojen.tupl.rows.SecondaryInfo;
import org.cojen.tupl.rows.SortDecoderMaker;
import org.cojen.tupl.rows.SortedQueryLauncher;
import org.cojen.tupl.rows.Transcoder;
import org.cojen.tupl.rows.WriteRowMaker;

final class RowSorter<R>
extends ScanBatch<R>
implements RowConsumer<R> {
    private static final int EXTERNAL_THRESHOLD = 1000000;
    private ScanBatch<R> mFirstBatch;
    private ScanBatch<R> mLastBatch;

    RowSorter() {
    }

    static <R> Scanner<R> sort(SortedQueryLauncher<R> launcher, Transaction txn, Object ... args) throws IOException {
        RowSorter<R> sorter = new RowSorter<R>();
        Scanner<RowSorter<RowSorter<R>>> source = launcher.mSource.newScanner(txn, sorter, args);
        int numRows = 0;
        RowSorter<R> c = source.row();
        while (c != null) {
            if (++numRows >= 1000000) {
                return sorter.finishExternal(launcher, source);
            }
            c = source.step(c);
        }
        Comparator comparator = launcher.mComparator;
        if (numRows == 0) {
            return new ARS(comparator);
        }
        Object[] rows = new Object[numRows];
        ScanBatch<Object> first = sorter.mFirstBatch;
        sorter.mFirstBatch = null;
        sorter.mLastBatch = null;
        first.decodeAllRows(rows, 0);
        Arrays.parallelSort(rows, comparator);
        return new ARS<Object>(launcher.mTable, rows, comparator);
    }

    static <R> void sortWrite(SortedQueryLauncher<R> launcher, RowWriter writer, Transaction txn, Object ... args) throws IOException {
        Object info;
        Scanner<Entry> sorted;
        External<R> ext = new External<R>(launcher);
        try {
            ext.transferAll(launcher.mSource.newScanner(txn, ext, args));
            sorted = ext.finishScan();
        }
        catch (Throwable e) {
            throw ext.failed(e);
        }
        MethodHandle mh = launcher.mWriteRow;
        if (mh == null) {
            info = ext.mSortedInfo;
            RowGen rowGen = ((RowInfo)info).rowGen();
            byte[] spec = DecodePartialMaker.makeFullSpec(rowGen, null, launcher.projection());
            launcher.mWriteRow = mh = WriteRowMaker.makeWriteRowHandle((RowInfo)info, spec);
        }
        try {
            info = sorted;
            try {
                Entry e = sorted.row();
                while (e != null) {
                    mh.invokeExact(writer, e.key(), e.value());
                    e = sorted.step(e);
                }
            }
            finally {
                if (info != null) {
                    info.close();
                }
            }
        }
        catch (Throwable e) {
            throw RowUtils.rethrow(e);
        }
    }

    @Override
    public void beginBatch(Scanner scanner, RowEvaluator<R> evaluator) {
        ScanBatch batch;
        if (this.mLastBatch == null) {
            this.mFirstBatch = batch = this;
        } else {
            batch = new ScanBatch();
            this.mLastBatch.appendNext(batch);
        }
        this.mLastBatch = batch;
        batch.mEvaluator = evaluator;
    }

    @Override
    public void accept(byte[] key, byte[] value) throws IOException {
        this.mLastBatch.addEntry(key, value);
    }

    private Scanner<R> finishExternal(SortedQueryLauncher<R> launcher, Scanner source) throws IOException {
        External ext = new External(launcher);
        try {
            RowDecoder decoder = launcher.mDecoder;
            if (decoder == null) {
                launcher.mDecoder = decoder = SortDecoderMaker.findDecoder(ext.mRowType, ext.mSortedInfo, launcher.projection());
            }
            ScanBatch<R> batch = this.mFirstBatch;
            this.mFirstBatch = null;
            this.mLastBatch = null;
            byte[][] kvPairs = null;
            do {
                ext.assignTranscoder(batch.mEvaluator);
                kvPairs = batch.transcode(ext.mTranscoder, ext.mSorter, kvPairs);
            } while ((batch = batch.detachNext()) != null);
            ext.transferAll(source);
            return new SRS(ext.finishScan(), decoder, launcher.mComparator);
        }
        catch (Throwable e) {
            throw ext.failed(e);
        }
    }

    private static class ARS<R>
    extends ArrayScanner<R> {
        private final Comparator<R> mComparator;

        ARS(Comparator<R> comparator) {
            this.mComparator = comparator;
        }

        ARS(BaseTable<R> table, R[] rows, Comparator<R> comparator) {
            super(table, rows);
            this.mComparator = comparator;
        }

        @Override
        public Comparator<R> getComparator() {
            return this.mComparator;
        }
    }

    private static final class External<R>
    implements RowConsumer<R> {
        final RowStore mRowStore;
        final Sorter mSorter;
        final Class<?> mRowType;
        final SecondaryInfo mSortedInfo;
        Transcoder mTranscoder;
        private byte[][] mBatch;
        private int mBatchSize;

        External(SortedQueryLauncher<R> launcher) throws IOException {
            this.mRowStore = launcher.mTable.rowStore();
            this.mSorter = this.mRowStore.mDatabase.newSorter();
            this.mRowType = launcher.mTable.rowType();
            SecondaryInfo sortedInfo = launcher.mSortedInfo;
            if (sortedInfo == null) {
                launcher.mSortedInfo = sortedInfo = SortDecoderMaker.findSortedInfo(this.mRowType, launcher.mSpec, launcher.projection(), true);
            }
            this.mSortedInfo = sortedInfo;
            this.mBatch = new byte[100][];
        }

        void assignTranscoder(RowEvaluator<R> evaluator) {
            this.mTranscoder = this.mRowStore.findSortTranscoder(this.mRowType, evaluator, this.mSortedInfo);
        }

        void transferAll(Scanner source) throws IOException {
            while (source.step(this) != null) {
            }
        }

        Scanner<Entry> finishScan() throws IOException {
            this.flush();
            this.mBatch = null;
            return this.mSorter.finishScan();
        }

        RuntimeException failed(Throwable e) {
            try {
                this.mSorter.reset();
            }
            catch (Throwable e2) {
                RowUtils.suppress(e, e2);
            }
            throw RowUtils.rethrow(e);
        }

        @Override
        public void beginBatch(Scanner scanner, RowEvaluator<R> evaluator) throws IOException {
            this.flush();
            this.assignTranscoder(evaluator);
        }

        @Override
        public void accept(byte[] key, byte[] value) throws IOException {
            byte[][] batch = this.mBatch;
            int size = this.mBatchSize;
            this.mTranscoder.transcode(key, value, batch, size);
            if ((size += 2) < batch.length) {
                this.mBatchSize = size;
            } else {
                this.mSorter.addBatch(batch, 0, size >> 1);
                this.mBatchSize = 0;
            }
        }

        private void flush() throws IOException {
            if (this.mBatchSize > 0) {
                this.mSorter.addBatch(this.mBatch, 0, this.mBatchSize >> 1);
                this.mBatchSize = 0;
            }
        }
    }

    private static class SRS<R>
    extends ScannerScanner<R> {
        private final Comparator<R> mComparator;

        SRS(Scanner<Entry> scanner, RowDecoder<R> decoder, Comparator<R> comparator) throws IOException {
            super(scanner, decoder);
            this.mComparator = comparator;
        }

        @Override
        public int characteristics() {
            return 1300;
        }

        @Override
        public Comparator<R> getComparator() {
            return this.mComparator;
        }
    }
}

