/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.cojen.tupl.CorruptDatabaseException;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.DeletedIndexException;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.Entry;
import org.cojen.tupl.Index;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.SchemaChangeException;
import org.cojen.tupl.Table;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.UniqueConstraintException;
import org.cojen.tupl.View;
import org.cojen.tupl.core.CoreDatabase;
import org.cojen.tupl.core.LHashTable;
import org.cojen.tupl.core.RowPredicateLock;
import org.cojen.tupl.core.ScanVisitor;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.rows.ArrayKey;
import org.cojen.tupl.rows.BaseTable;
import org.cojen.tupl.rows.BaseTableIndex;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.ColumnSet;
import org.cojen.tupl.rows.ColumnSetComparator;
import org.cojen.tupl.rows.DynamicTableMaker;
import org.cojen.tupl.rows.Encoder;
import org.cojen.tupl.rows.IndexBackfill;
import org.cojen.tupl.rows.JoinedTableMaker;
import org.cojen.tupl.rows.NoSuchIndexException;
import org.cojen.tupl.rows.RowEvaluator;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.SecondaryInfo;
import org.cojen.tupl.rows.SortTranscoderMaker;
import org.cojen.tupl.rows.StaticTableMaker;
import org.cojen.tupl.rows.TableManager;
import org.cojen.tupl.rows.Transcoder;
import org.cojen.tupl.rows.WeakCache;
import org.cojen.tupl.util.Runner;

public final class RowStore {
    private final WeakReference<RowStore> mSelfRef = new WeakReference<RowStore>(this);
    final CoreDatabase mDatabase;
    private final Index mSchemata;
    private final WeakCache<Index, TableManager<?>, Object> mTableManagers;
    private final LHashTable.Obj<RowPredicateLock<?>> mIndexLocks;
    private WeakCache<TranscoderKey, Transcoder, SecondaryInfo> mSortTranscoderCache;
    private static final VarHandle cSortTranscoderCacheHandle;
    volatile boolean mStallTasks;
    private static final int K_SECONDARY = 1;
    private static final int K_TYPE_NAME = 2;
    private static final int K_DROPPED = 3;
    private static final int TASK_DELETE_SCHEMA = 1;
    private static final int TASK_NOTIFY_SCHEMA = 2;

    public RowStore(CoreDatabase db, Index schemata) throws IOException {
        this.mDatabase = db;
        this.mSchemata = schemata;
        this.mTableManagers = new WeakCache();
        this.mIndexLocks = new LHashTable.Obj(8);
        this.registerToUpdateSchemata();
        Runner.start(() -> {
            try {
                this.finishAllWorkflowTasks();
            }
            catch (Throwable e) {
                this.uncaught(e);
            }
        });
    }

    WeakReference<RowStore> ref() {
        return this.mSelfRef;
    }

    public Index schemata() {
        return this.mSchemata;
    }

    public void scanAllIndexes(ScanVisitor visitor) throws IOException {
        visitor.apply(this.mSchemata);
        try (Cursor c = this.mSchemata.newCursor(null);){
            byte[] key;
            c.first();
            while ((key = c.key()) != null) {
                if (key.length <= 8) {
                    c.next();
                    continue;
                }
                long indexId = RowUtils.decodeLongBE(key, 0);
                if (indexId == 0L || RowUtils.decodeIntBE(key, 8) != 0 || RowUtils.decodeIntBE(key, 12) != 1) {
                    if (++indexId == 0L) {
                        break;
                    }
                    c.findNearbyGe(RowStore.key(indexId));
                    continue;
                }
                Index secondaryIndex = this.mDatabase.indexById(RowUtils.decodeLongLE(c.value(), 0));
                if (secondaryIndex != null) {
                    visitor.apply(secondaryIndex);
                }
                c.next();
            }
        }
    }

    public Object toRow(Index ix, byte[] key) {
        BaseTable table;
        TableManager manager = (TableManager)this.mTableManagers.get(ix);
        if (manager != null && (table = manager.mostRecentTable()) != null) {
            try {
                return table.toRow(key);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableManager<?> tableManager(Index ix) {
        TableManager manager = (TableManager)this.mTableManagers.get(ix);
        if (manager == null) {
            WeakCache<Index, TableManager<?>, Object> weakCache = this.mTableManagers;
            synchronized (weakCache) {
                manager = (TableManager)this.mTableManagers.get(ix);
                if (manager == null) {
                    manager = new TableManager(this, ix);
                    this.mTableManagers.put((Object)ix, manager);
                }
            }
        }
        return manager;
    }

    <R> RowPredicateLock<R> indexLock(Index index) {
        return this.indexLock(index.id());
    }

    <R> RowPredicateLock<R> indexLock(long indexId) {
        RowPredicateLock<?> lock = this.mIndexLocks.getValue(indexId);
        if (lock == null) {
            lock = this.makeIndexLock(indexId);
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RowPredicateLock<?> makeIndexLock(long indexId) {
        LHashTable.Obj<RowPredicateLock<?>> obj = this.mIndexLocks;
        synchronized (obj) {
            RowPredicateLock<Object> lock = this.mIndexLocks.getValue(indexId);
            if (lock == null) {
                lock = this.mDatabase.newRowPredicateLock(indexId);
                VarHandle.storeStoreFence();
                ((LHashTable.ObjEntry)this.mIndexLocks.insert((long)indexId)).value = lock;
            }
            return lock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIndexLock(long indexId) {
        LHashTable.Obj<RowPredicateLock<?>> obj = this.mIndexLocks;
        synchronized (obj) {
            this.mIndexLocks.remove(indexId);
        }
    }

    public <R> Table<R> asTable(Index ix, Class<R> type) throws IOException {
        return this.openTable(ix, type);
    }

    private <R> BaseTable<R> openTable(Index ix, Class<R> type) throws IOException {
        return this.tableManager(ix).asTable(this, ix, type);
    }

    <R> BaseTable<R> findTable(long indexId, Class<R> type) throws IOException {
        Index ix = this.mDatabase.indexById(indexId);
        if (ix == null) {
            throw new DeletedIndexException();
        }
        return this.openTable(ix, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <R> BaseTable<R> makeTable(TableManager<R> manager, Index ix, Class<R> type, Supplier<BaseTable<R>> doubleCheck, Consumer<BaseTable<R>> consumer) throws IOException {
        BaseTable table;
        RowInfo info = RowInfo.find(type);
        boolean evolvable = type != Entry.class;
        Transaction txn = this.mSchemata.newTransaction(DurabilityMode.NO_FLUSH);
        try {
            txn.lockMode(LockMode.REPEATABLE_READ);
            RowInfo currentInfo = this.decodeExisting(txn, null, ix.id());
            if (doubleCheck != null && (table = doubleCheck.get()) != null) {
                BaseTable baseTable = table;
                return baseTable;
            }
            if (currentInfo != null) {
                RowStore.checkSchema(type.getName(), currentInfo, info);
            }
            RowPredicateLock<R> indexLock = this.indexLock(ix);
            try {
                if (evolvable) {
                    MethodHandle mh = new DynamicTableMaker(type, info.rowGen(), this, ix.id()).finish();
                    table = mh.invoke(manager, ix, indexLock);
                } else {
                    Class<?> tableClass = StaticTableMaker.obtain(type, RowInfo.find(type).rowGen());
                    table = (BaseTable)tableClass.getConstructor(TableManager.class, Index.class, RowPredicateLock.class).newInstance(manager, ix, indexLock);
                }
            }
            catch (Throwable e) {
                throw RowUtils.rethrow(e);
            }
            if (consumer != null) {
                consumer.accept(table);
            }
        }
        finally {
            txn.reset();
        }
        if (!evolvable) {
            return table;
        }
        try {
            this.schemaVersion(info, true, ix.id(), false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return table;
    }

    private static boolean checkSchema(String typeName, RowInfo oldInfo, RowInfo newInfo) {
        if (oldInfo.matches(newInfo) && RowStore.matches(oldInfo.alternateKeys, newInfo.alternateKeys) && RowStore.matches(oldInfo.secondaryIndexes, newInfo.secondaryIndexes)) {
            return true;
        }
        if (!oldInfo.keyColumns.equals(newInfo.keyColumns)) {
            throw new SchemaChangeException("Cannot alter primary key: " + typeName);
        }
        RowStore.checkIndexes(typeName, "alternate keys", oldInfo.alternateKeys, newInfo.alternateKeys);
        RowStore.checkIndexes(typeName, "secondary indexes", oldInfo.secondaryIndexes, newInfo.secondaryIndexes);
        return false;
    }

    private static void checkIndexes(String typeName, String which, NavigableSet<ColumnSet> oldSet, NavigableSet<ColumnSet> newSet) {
        if (oldSet.isEmpty() || newSet.isEmpty() || RowStore.matches(oldSet, newSet)) {
            return;
        }
        Encoder encoder = new Encoder(64);
        NavigableMap<byte[], ColumnSet> oldMap = RowStore.indexMap('_', encoder, oldSet);
        NavigableMap<byte[], ColumnSet> newMap = RowStore.indexMap('_', encoder, newSet);
        Iterator oldIt = oldMap.entrySet().iterator();
        Iterator newIt = newMap.entrySet().iterator();
        Map.Entry oldEntry = null;
        Map.Entry newEntry = null;
        while (true) {
            int cmp;
            if (oldEntry == null) {
                if (!oldIt.hasNext()) break;
                oldEntry = oldIt.next();
            }
            if (newEntry == null) {
                if (!newIt.hasNext()) break;
                newEntry = newIt.next();
            }
            if ((cmp = Arrays.compareUnsigned((byte[])oldEntry.getKey(), (byte[])newEntry.getKey())) == 0) {
                if (!((ColumnSet)oldEntry.getValue()).matches((ColumnSet)newEntry.getValue())) {
                    throw new SchemaChangeException("Cannot alter " + which + ": " + typeName);
                }
                oldEntry = null;
                newEntry = null;
                continue;
            }
            if (cmp < 0) {
                oldEntry = null;
                continue;
            }
            newEntry = null;
        }
    }

    private static boolean matches(NavigableSet<ColumnSet> a, NavigableSet<ColumnSet> b) {
        Iterator<ColumnSet> ia = a.iterator();
        Iterator<ColumnSet> ib = b.iterator();
        while (ia.hasNext()) {
            if (ib.hasNext() && ia.next().matches(ib.next())) continue;
            return false;
        }
        return !ib.hasNext();
    }

    private static NavigableMap<byte[], ColumnSet> indexMap(char type, Encoder encoder, NavigableSet<ColumnSet> set) {
        TreeMap<byte[], ColumnSet> map = new TreeMap<byte[], ColumnSet>(RowUtils.KEY_COMPARATOR);
        for (ColumnSet cs : set) {
            map.put(EncodedRowInfo.encodeDescriptor(type, encoder, cs), cs);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> BaseTableIndex<R> indexTable(BaseTable<R> primaryTable, boolean alt, String ... columns) throws IOException {
        ArrayKey.Obj key = ArrayKey.make((Object)alt, columns);
        WeakCache indexTables = primaryTable.mTableManager.indexTables();
        BaseTableIndex table = (BaseTableIndex)indexTables.get(key);
        if (table == null) {
            WeakCache weakCache = indexTables;
            synchronized (weakCache) {
                table = (BaseTableIndex)indexTables.get(key);
                if (table == null) {
                    table = this.makeIndexTable(indexTables, primaryTable, alt, columns);
                    if (table == null) {
                        throw new NoSuchIndexException((alt ? "Alternate key" : "Secondary index") + " not found: " + Arrays.toString(columns));
                    }
                    indexTables.put(key, table);
                }
            }
        }
        return table;
    }

    private <R> BaseTableIndex<R> makeIndexTable(WeakCache<Object, BaseTableIndex<R>, Object> indexTables, BaseTable<R> primaryTable, boolean alt, String ... columns) throws IOException {
        byte[] descriptor;
        SecondaryInfo indexRowInfo;
        long indexId;
        RowInfo rowInfo;
        Class rowType;
        block14: {
            rowType = primaryTable.rowType();
            rowInfo = RowInfo.find(rowType);
            ColumnSet cs = rowInfo.examineIndex(null, columns, alt);
            if (cs == null) {
                return null;
            }
            Encoder encoder = new Encoder(columns.length * 16);
            char type = alt ? (char)'A' : 'I';
            byte[] search = EncodedRowInfo.encodeDescriptor(type, encoder, cs);
            View secondariesView = this.viewExtended(primaryTable.mSource.id(), 1);
            secondariesView = secondariesView.viewPrefix(new byte[]{(byte)type}, 0);
            try (Cursor c = secondariesView.newCursor(null);){
                c.first();
                while (c.key() != null) {
                    if (RowStore.descriptorMatches(search, c.key()) && c.value()[8] == 65) {
                        indexId = RowUtils.decodeLongLE(c.value(), 0);
                        indexRowInfo = RowStore.secondaryRowInfo(RowInfo.find(rowType), c.key());
                        descriptor = c.key();
                        break block14;
                    }
                    c.next();
                }
            }
            return null;
        }
        ArrayKey.Bytes key = ArrayKey.make(descriptor);
        BaseTableIndex table = (BaseTableIndex)indexTables.get(key);
        if (table != null) {
            return table;
        }
        Index ix = this.mDatabase.indexById(indexId);
        if (ix == null) {
            return null;
        }
        indexRowInfo.alternateKeys = Collections.emptyNavigableSet();
        indexRowInfo.secondaryIndexes = Collections.emptyNavigableSet();
        RowPredicateLock<R> indexLock = this.indexLock(ix);
        try {
            DynamicTableMaker maker = new DynamicTableMaker(rowType, rowInfo.rowGen(), indexRowInfo.rowGen(), descriptor, this, primaryTable.mSource.id());
            MethodHandle mh = maker.finish();
            BaseTable unjoined = mh.invoke(primaryTable.mTableManager, ix, indexLock);
            JoinedTableMaker maker2 = new JoinedTableMaker(rowType, rowInfo.rowGen(), indexRowInfo.rowGen(), descriptor, primaryTable.getClass(), unjoined.getClass());
            mh = maker2.finish();
            table = mh.invoke(ix, indexLock, primaryTable, unjoined);
        }
        catch (Throwable e) {
            throw RowUtils.rethrow(e);
        }
        indexTables.put((Object)key, (Object)table);
        return table;
    }

    private static boolean descriptorMatches(byte[] search, byte[] found) {
        if (search.length != found.length) {
            return false;
        }
        int offset = 1;
        for (int part = 1; part <= 2; ++part) {
            int numColumns = RowUtils.decodePrefixPF(search, offset);
            if (numColumns != RowUtils.decodePrefixPF(found, offset)) {
                return false;
            }
            offset += RowUtils.lengthPrefixPF(numColumns);
            for (int i = 0; i < numColumns; ++i) {
                int foundTypeCode;
                int searchTypeCode;
                if (part == 1 && (searchTypeCode = RowUtils.decodeIntBE(search, offset) ^ Integer.MIN_VALUE) != -1 && (searchTypeCode & 0x80) != ((foundTypeCode = RowUtils.decodeIntBE(found, offset) ^ Integer.MIN_VALUE) & 0x80)) {
                    return false;
                }
                int nameLength = RowUtils.decodePrefixPF(search, offset += 4);
                if (nameLength != RowUtils.decodePrefixPF(found, offset)) {
                    return false;
                }
                if (!Arrays.equals(search, offset += RowUtils.lengthPrefixPF(nameLength), offset + nameLength, found, offset, offset + nameLength)) {
                    return false;
                }
                offset += nameLength;
            }
        }
        return offset == search.length;
    }

    private void registerToUpdateSchemata() {
        this.mDatabase.uponLeader(this::updateSchemata, this::registerToUpdateSchemata);
    }

    private void updateSchemata() {
        List<TableManager<?>> managers = this.mTableManagers.copyValues();
        if (managers != null) {
            try {
                for (TableManager<?> manager : managers) {
                    BaseTable<?> table = manager.mostRecentTable();
                    if (table == null) continue;
                    RowInfo info = RowInfo.find(table.rowType());
                    long indexId = manager.mPrimaryIndex.id();
                    this.schemaVersion(info, true, indexId, true);
                }
            }
            catch (IOException iOException) {
            }
            catch (Throwable e) {
                this.uncaught(e);
            }
        }
    }

    private void uncaught(Throwable e) {
        if (!this.mDatabase.isClosed()) {
            RowUtils.uncaught(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySchema(long indexId) throws IOException {
        try {
            byte[] taskKey = this.newTaskKey(2, indexId);
            Transaction txn = this.beginWorkflowTask(taskKey);
            if (this.mStallTasks) {
                txn.reset();
                return;
            }
            try {
                this.doNotifySchema(null, indexId);
                this.mSchemata.delete(txn, taskKey);
            }
            finally {
                txn.reset();
            }
        }
        catch (Throwable e) {
            this.uncaught(e);
        }
    }

    private boolean doNotifySchema(byte[] taskKey, long indexId) throws IOException {
        Index ix = this.mDatabase.indexById(indexId);
        if (ix != null) {
            this.examineSecondaries(this.tableManager(ix));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void examineSecondaries(TableManager<?> manager) throws IOException {
        long indexId = manager.mPrimaryIndex.id();
        Transaction txn = this.mDatabase.newTransaction(DurabilityMode.NO_FLUSH);
        try {
            txn.lockTimeout(-1L, null);
            byte[] value = this.mSchemata.load(txn, RowStore.key(indexId));
            if (value == null) {
                return;
            }
            long tableVersion = RowUtils.decodeLongLE(value, 4);
            txn.lockMode(LockMode.READ_COMMITTED);
            manager.update(tableVersion, this, txn, this.viewExtended(indexId, 1));
        }
        finally {
            txn.reset();
        }
    }

    public Object acquireLocksNoPush(Transaction txn, long indexId, byte[] key, byte[] value) throws LockFailureException {
        return this.indexLock(indexId).acquireLocksNoPush(txn, key, value);
    }

    public Runnable redoDeleteIndex(long indexId, Supplier<Runnable> taskFactory) throws IOException {
        byte[] value = this.viewExtended(indexId, 3).load(Transaction.BOGUS, RowUtils.EMPTY_BYTES);
        if (value == null) {
            return null;
        }
        long primaryIndexId = RowUtils.decodeLongLE(value, 0);
        byte[] descriptor = Arrays.copyOfRange(value, 8, value.length);
        return this.deleteIndex(primaryIndexId, indexId, descriptor, null, taskFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activateSecondaryIndex(IndexBackfill backfill, boolean success) throws IOException {
        long indexId = backfill.mManager.mPrimaryIndex.id();
        long secondaryId = backfill.mSecondaryIndex.id();
        boolean activated = false;
        Transaction txn = this.mDatabase.newTransaction(DurabilityMode.NO_REDO);
        try {
            long tableVersion;
            txn.lockTimeout(-1L, null);
            try (Cursor c = this.mSchemata.newCursor(txn);){
                c.find(RowStore.key(indexId));
                byte[] value = c.value();
                if (value == null) {
                    return;
                }
                tableVersion = RowUtils.decodeLongLE(value, 4);
                RowUtils.encodeLongLE(value, 4, ++tableVersion);
                c.store(value);
            }
            View secondariesView = this.viewExtended(indexId, 1);
            if (success) {
                try (Cursor c = secondariesView.newCursor(txn);){
                    c.find(backfill.mSecondaryDescriptor);
                    byte[] value = c.value();
                    if (value != null && value[8] == 66 && RowUtils.decodeLongLE(value, 0) == secondaryId) {
                        value[8] = 65;
                        c.store(value);
                        activated = true;
                    }
                }
            }
            backfill.mManager.update(tableVersion, this, txn, secondariesView);
            txn.commit();
        }
        finally {
            txn.reset();
        }
        if (activated) {
            this.mDatabase.checkpoint();
        }
    }

    public Runnable deleteSchema(byte[] indexKey) throws IOException {
        try (Cursor c = this.mSchemata.viewPrefix(indexKey, 0).newCursor(Transaction.BOGUS);){
            c.autoload(false);
            c.first();
            if (c.key() == null) {
                Runnable runnable = null;
                return runnable;
            }
        }
        byte[] taskKey = this.newTaskKey(1, indexKey);
        Transaction txn = this.beginWorkflowTask(taskKey);
        if (this.mStallTasks) {
            txn.reset();
            return null;
        }
        return () -> {
            try {
                try {
                    this.doDeleteSchema(null, null, indexKey);
                    this.mSchemata.delete(txn, taskKey);
                }
                finally {
                    txn.reset();
                }
            }
            catch (IOException e) {
                throw RowUtils.rethrow(e);
            }
        };
    }

    private boolean doDeleteSchema(Transaction txn, byte[] taskKey, byte[] indexKey) throws IOException {
        long primaryIndexId = RowUtils.decodeLongBE(indexKey, 0);
        this.removeIndexLock(primaryIndexId);
        ArrayList<Runnable> deleteTasks = null;
        try (Cursor c = this.mSchemata.viewPrefix(indexKey, 0).newCursor(Transaction.BOGUS);){
            byte[] key;
            c.autoload(false);
            c.first();
            while ((key = c.key()) != null) {
                if (key.length >= 16 && RowUtils.decodeIntBE(key, 8) == 0 && RowUtils.decodeIntBE(key, 12) == 1) {
                    Index secondaryIndex;
                    c.load();
                    byte[] value = c.value();
                    if (value != null && value.length >= 8 && (secondaryIndex = this.mDatabase.indexById(RowUtils.decodeLongLE(c.value(), 0))) != null) {
                        byte[] descriptor = Arrays.copyOfRange(key, 16, key.length);
                        Runnable task = this.deleteIndex(primaryIndexId, 0L, descriptor, secondaryIndex, null);
                        if (deleteTasks == null) {
                            deleteTasks = new ArrayList<Runnable>();
                        }
                        deleteTasks.add(task);
                    }
                }
                c.delete();
                c.next();
            }
        }
        if (deleteTasks == null) {
            return true;
        }
        ArrayList<Runnable> tasks = deleteTasks;
        Runner.start(() -> {
            try {
                try {
                    for (Runnable task : tasks) {
                        task.run();
                    }
                    this.mSchemata.delete(txn, taskKey);
                    txn.commit();
                }
                finally {
                    txn.reset();
                }
            }
            catch (Throwable e) {
                this.uncaught(e);
            }
        });
        return false;
    }

    private byte[] newTaskKey(int taskType, byte[] indexKey) {
        byte[] taskKey = new byte[20];
        System.arraycopy(indexKey, 0, taskKey, 8, 8);
        RowUtils.encodeIntBE(taskKey, 16, taskType);
        return taskKey;
    }

    private byte[] newTaskKey(int taskType, long indexKey) {
        byte[] taskKey = new byte[20];
        RowUtils.encodeLongBE(taskKey, 8, indexKey);
        RowUtils.encodeIntBE(taskKey, 16, taskType);
        return taskKey;
    }

    private Transaction beginWorkflowTask(byte[] taskKey) throws IOException {
        Transaction txn = this.mDatabase.newTransaction(DurabilityMode.NO_REDO);
        try {
            this.mSchemata.lockUpgradable(txn, taskKey);
            this.mSchemata.store(Transaction.BOGUS, taskKey, RowUtils.EMPTY_BYTES);
        }
        catch (Throwable e) {
            txn.reset(e);
            throw e;
        }
        return txn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void finishAllWorkflowTasks() throws IOException {
        txn = this.mDatabase.newTransaction(DurabilityMode.NO_REDO);
        try {
            txn.lockMode(LockMode.UNSAFE);
            prefix = new byte[8];
            c = this.mSchemata.viewPrefix(prefix, 0).newCursor(txn);
            try {
                c.autoload(false);
                c.first();
                while (c.key() != null) {
                    block13: {
                        if (!txn.tryLockUpgradable(this.mSchemata.id(), c.key(), 0L).isHeld()) break block13;
                        c.load();
                        taskValue = c.value();
                        if (taskValue == null) ** GOTO lbl24
                        if (!this.runRecoveredWorkflowTask(txn, c.key(), taskValue)) {
                            txn = this.mDatabase.newTransaction(DurabilityMode.NO_REDO);
                            txn.lockMode(LockMode.UNSAFE);
                            c.link(txn);
                        } else {
                            c.delete();
lbl24:
                            // 2 sources

                            txn.unlock();
                        }
                    }
                    c.next();
                }
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
        }
        finally {
            txn.reset();
        }
    }

    private boolean runRecoveredWorkflowTask(Transaction txn, byte[] taskKey, byte[] taskValue) throws IOException {
        byte[] indexKey = new byte[8];
        System.arraycopy(taskKey, 8, indexKey, 0, 8);
        int taskType = RowUtils.decodeIntBE(taskKey, 16);
        return switch (taskType) {
            default -> throw new CorruptDatabaseException("Unknown task: " + taskType);
            case 1 -> this.doDeleteSchema(txn, taskKey, indexKey);
            case 2 -> this.doNotifySchema(taskKey, RowUtils.decodeLongBE(indexKey, 0));
        };
    }

    private Runnable deleteIndex(long primaryIndexId, long secondaryIndexId, byte[] descriptor, Index secondaryIndex, Supplier<Runnable> taskFactory) throws IOException {
        String eventStr;
        if (secondaryIndex != null) {
            secondaryIndexId = secondaryIndex.id();
        }
        this.tableManager(this.mDatabase.indexById(primaryIndexId)).removeFromIndexTables(secondaryIndexId);
        EventListener listener = this.mDatabase.eventListener();
        if (listener == null) {
            eventStr = null;
        } else {
            RowInfo secondaryInfo = null;
            try {
                RowInfo primaryInfo = this.decodeExisting(null, null, primaryIndexId);
                secondaryInfo = RowStore.secondaryRowInfo(primaryInfo, descriptor);
            }
            catch (Exception primaryInfo) {
                // empty catch block
            }
            eventStr = secondaryInfo == null ? String.valueOf(secondaryIndexId) : secondaryInfo.eventString();
        }
        RowPredicateLock lock = this.indexLock(secondaryIndexId);
        if (lock == null) {
            if (listener != null) {
                listener.notify(EventType.TABLE_INDEX_INFO, "Dropping %1$s", eventStr);
            }
            Runnable task = taskFactory == null ? this.mDatabase.deleteIndex(secondaryIndex) : taskFactory.get();
            if (listener == null) {
                return task;
            }
            return () -> {
                task.run();
                listener.notify(EventType.TABLE_INDEX_INFO, "Finished dropping %1$s", eventStr);
            };
        }
        long fSecondaryIndexId = secondaryIndexId;
        return () -> {
            try {
                Transaction txn = this.mDatabase.newTransaction();
                try {
                    txn.lockTimeout(-1L, null);
                    Runnable mustWait = null;
                    if (listener != null) {
                        mustWait = () -> listener.notify(EventType.TABLE_INDEX_INFO, "Waiting to drop %1$s", eventStr);
                    }
                    lock.withExclusiveNoRedo(txn, mustWait, () -> this.lambda$deleteIndex$5(listener, eventStr, (Supplier)taskFactory, secondaryIndex));
                    txn.commit();
                }
                finally {
                    txn.exit();
                }
                this.removeIndexLock(fSecondaryIndexId);
            }
            catch (Throwable e) {
                this.uncaught(e);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int schemaVersion(RowInfo info, boolean mostRecent, long indexId, boolean notify) throws IOException {
        int schemaVersion;
        LinkedHashMap<Index, byte[]> secondariesToDelete;
        block75: {
            if (this.mDatabase.indexById(indexId) == null) {
                throw new DeletedIndexException();
            }
            secondariesToDelete = null;
            Transaction txn = this.mSchemata.newTransaction(DurabilityMode.SYNC);
            try (Cursor current = this.mSchemata.newCursor(txn);){
                byte[] value;
                EncodedRowInfo encoded;
                boolean isTempIndex;
                long tableVersion;
                block72: {
                    txn.lockTimeout(-1L, null);
                    current.find(RowStore.key(indexId));
                    if (current.value() == null) {
                        tableVersion = 0L;
                    } else {
                        RowInfo info2;
                        schemaVersion = RowUtils.decodeIntLE(current.value(), 0);
                        RowInfo currentInfo = this.decodeExisting(txn, info.name, indexId, current.value(), schemaVersion);
                        if (RowStore.checkSchema(info.name, currentInfo, info)) {
                            int n = schemaVersion;
                            return n;
                        }
                        if (!mostRecent && (info2 = info.withIndexes(currentInfo)) != info && RowStore.checkSchema(info.name, currentInfo, info = info2)) {
                            int n = schemaVersion;
                            return n;
                        }
                        tableVersion = RowUtils.decodeLongLE(current.value(), 4);
                    }
                    isTempIndex = this.mDatabase.isInTrash(txn, indexId);
                    if (isTempIndex) {
                        txn.durabilityMode(DurabilityMode.NO_REDO);
                    }
                    encoded = new EncodedRowInfo(info);
                    try (Cursor byHash = this.mSchemata.newCursor(txn);){
                        byHash.find(RowStore.key(indexId, encoded.primaryHash | Integer.MIN_VALUE));
                        byte[] schemaVersions = byHash.value();
                        if (schemaVersions != null) {
                            for (int pos = 0; pos < schemaVersions.length; pos += 4) {
                                schemaVersion = RowUtils.decodeIntLE(schemaVersions, pos);
                                RowInfo existing = this.decodeExisting(txn, info.name, indexId, null, schemaVersion);
                                if (!info.matches(existing)) {
                                    continue;
                                }
                                break block72;
                            }
                        }
                        View versionView = this.mSchemata.viewGt(RowStore.key(indexId)).viewLt(RowStore.key(indexId, Integer.MIN_VALUE));
                        try (Cursor highest = versionView.newCursor(txn);){
                            highest.autoload(false);
                            highest.last();
                            if (highest.value() == null) {
                                schemaVersion = 1;
                            } else {
                                byte[] key = highest.key();
                                schemaVersion = RowUtils.decodeIntBE(key, key.length - 4) + 1;
                            }
                            highest.findNearby(RowStore.key(indexId, schemaVersion));
                            highest.store(encoded.primaryData);
                        }
                        schemaVersions = schemaVersions == null ? new byte[4] : Arrays.copyOfRange(schemaVersions, 0, schemaVersions.length + 4);
                        RowUtils.encodeIntLE(schemaVersions, schemaVersions.length - 4, schemaVersion);
                        byHash.store(schemaVersions);
                    }
                }
                RowUtils.encodeIntLE(encoded.currentData, 0, schemaVersion);
                RowUtils.encodeLongLE(encoded.currentData, 4, ++tableVersion);
                current.store(encoded.currentData);
                View nameView = this.viewExtended(indexId, 2);
                try (Cursor c = nameView.newCursor(txn);){
                    c.find(RowUtils.EMPTY_BYTES);
                    byte[] nameBytes = RowUtils.encodeStringUTF(info.name);
                    if (!Arrays.equals(nameBytes, c.value())) {
                        c.store(nameBytes);
                    }
                }
                if (!mostRecent) {
                    txn.commit();
                    break block75;
                }
                TreeSet<byte[]> secondaries = encoded.secondaries;
                View secondariesView = this.viewExtended(indexId, 1);
                TableManager<?> manager = null;
                try (Cursor c = secondariesView.newCursor(txn);){
                    byte[] key;
                    c.first();
                    while ((key = c.key()) != null) {
                        value = c.value();
                        Index secondaryIndex = this.mDatabase.indexById(RowUtils.decodeLongLE(value, 0));
                        if (secondaryIndex == null) {
                            c.store(null);
                        } else if (!secondaries.contains(key)) {
                            if (value[8] != 68) {
                                value[8] = 68;
                                c.store(value);
                            }
                            byte[] droppedEntry = new byte[8 + key.length];
                            RowUtils.encodeLongLE(droppedEntry, 0, indexId);
                            System.arraycopy(key, 0, droppedEntry, 8, key.length);
                            View droppedView = this.viewExtended(secondaryIndex.id(), 3);
                            droppedView.store(txn, RowUtils.EMPTY_BYTES, droppedEntry);
                            if (manager == null) {
                                manager = this.tableManager(this.mDatabase.indexById(indexId));
                            }
                            manager.removeFromIndexTables(secondaryIndex.id());
                            if (secondariesToDelete == null) {
                                secondariesToDelete = new LinkedHashMap<Index, byte[]>();
                            }
                            secondariesToDelete.put(secondaryIndex, c.key());
                        }
                        c.next();
                    }
                }
                c = secondariesView.newCursor(txn);
                try {
                    Iterator<byte[]> it = secondaries.iterator();
                    while (it.hasNext()) {
                        c.findNearby(it.next());
                        value = c.value();
                        if (value != null) {
                            it.remove();
                            if (value[8] != 68) continue;
                            value[8] = 66;
                            c.store(value);
                            continue;
                        }
                        if (!isTempIndex) continue;
                        it.remove();
                        value = new byte[9];
                        RowUtils.encodeLongLE(value, 0, this.mDatabase.newTemporaryIndex().id());
                        value[8] = 66;
                        c.store(value);
                    }
                }
                finally {
                    if (c != null) {
                        c.close();
                    }
                }
                long[] ids = new long[secondaries.size()];
                this.mDatabase.createSecondaryIndexes(txn, indexId, ids, () -> {
                    try {
                        int i = 0;
                        for (byte[] desc : secondaries) {
                            byte[] value = new byte[9];
                            RowUtils.encodeLongLE(value, 0, ids[i++]);
                            value[8] = 66;
                            if (secondariesView.insert(txn, desc, value)) continue;
                            throw new UniqueConstraintException();
                        }
                    }
                    catch (IOException e) {
                        RowUtils.rethrow(e);
                    }
                });
            }
            finally {
                txn.reset();
            }
        }
        if (secondariesToDelete != null) {
            for (Map.Entry entry : secondariesToDelete.entrySet()) {
                try {
                    Index secondaryIndex = (Index)entry.getKey();
                    byte[] descriptor = (byte[])entry.getValue();
                    Runner.start(this.deleteIndex(indexId, 0L, descriptor, secondaryIndex, null));
                }
                catch (IOException iOException) {}
            }
        }
        if (!notify) return schemaVersion;
        this.notifySchema(indexId);
        return schemaVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    RowInfo rowInfo(Class<?> rowType, long indexId, int schemaVersion) throws IOException, CorruptDatabaseException {
        RowInfo info;
        block16: {
            if (schemaVersion == 0) {
                if (rowType == null) {
                    info = this.decodePrimaryKey(null, null, indexId);
                    break block16;
                } else {
                    RowInfo fullInfo = RowInfo.find(rowType);
                    if (fullInfo.valueColumns.isEmpty()) {
                        return fullInfo;
                    }
                    RowInfo info2 = new RowInfo(fullInfo.name);
                    info2.keyColumns = fullInfo.keyColumns;
                    info2.valueColumns = Collections.emptyNavigableMap();
                    info2.allColumns = new TreeMap(info2.keyColumns);
                    return info2;
                }
            }
            Transaction txn = this.mSchemata.newTransaction(DurabilityMode.NO_FLUSH);
            txn.lockMode(LockMode.REPEATABLE_READ);
            try (Cursor c = this.mSchemata.newCursor(txn);){
                byte[] buf;
                c.autoload(false);
                c.find(RowStore.key(indexId));
                RowInfo current = null;
                if (c.value() != null && rowType != null && RowUtils.decodeIntLE(buf = new byte[4], 0) == schemaVersion) {
                    current = RowInfo.find(rowType);
                }
                c.autoload(true);
                c.findNearby(RowStore.key(indexId, schemaVersion));
                String typeName = rowType == null ? null : rowType.getName();
                info = RowStore.decodeExisting(typeName, null, c.value());
                if (info != null && current != null && current.allColumns.equals(info.allColumns)) {
                    RowInfo rowInfo = current;
                    return rowInfo;
                }
            }
            finally {
                txn.reset();
            }
        }
        if (info != null) return info;
        throw new CorruptDatabaseException("Schema version not found: " + schemaVersion + ", indexId=" + indexId);
    }

    static byte[] secondaryDescriptor(SecondaryInfo info) {
        return RowStore.secondaryDescriptor(info, info.isAltKey());
    }

    static byte[] secondaryDescriptor(ColumnSet cs, boolean isAltKey) {
        Encoder encoder = new Encoder(cs.allColumns.size() * 16);
        return EncodedRowInfo.encodeDescriptor(isAltKey ? (char)'A' : 'I', encoder, cs);
    }

    static SecondaryInfo secondaryRowInfo(RowInfo primaryInfo, byte[] desc) {
        byte type = desc[0];
        int offset = 1;
        SecondaryInfo info = new SecondaryInfo(primaryInfo, type == 65);
        int numKeys = RowUtils.decodePrefixPF(desc, offset);
        offset += RowUtils.lengthPrefixPF(numKeys);
        info.keyColumns = new LinkedHashMap(numKeys);
        for (int i = 0; i < numKeys; ++i) {
            offset = RowStore.decodeIndexColumn(primaryInfo, desc, offset, info.keyColumns);
        }
        int numValues = RowUtils.decodePrefixPF(desc, offset);
        if (numValues == 0) {
            info.valueColumns = Collections.emptyNavigableMap();
        } else {
            offset += RowUtils.lengthPrefixPF(numValues);
            info.valueColumns = new TreeMap();
            do {
                offset = RowStore.decodeIndexColumn(primaryInfo, desc, offset, info.valueColumns);
            } while (--numValues > 0);
        }
        info.allColumns = new TreeMap(info.keyColumns);
        info.allColumns.putAll(info.valueColumns);
        return info;
    }

    private static int decodeIndexColumn(RowInfo primaryInfo, byte[] desc, int offset, Map<String, ColumnInfo> columns) {
        ColumnInfo column;
        block4: {
            int typeCode;
            block3: {
                block2: {
                    typeCode = RowUtils.decodeIntBE(desc, offset) ^ Integer.MIN_VALUE;
                    int nameLength = RowUtils.decodePrefixPF(desc, offset += 4);
                    String name = RowUtils.decodeStringUTF(desc, offset += RowUtils.lengthPrefixPF(nameLength), nameLength);
                    offset += nameLength;
                    column = (ColumnInfo)primaryInfo.allColumns.get(name);
                    if (column != null) break block2;
                    name = name.intern();
                    column = new ColumnInfo();
                    column.name = name;
                    break block3;
                }
                if (column.typeCode == typeCode) break block4;
                column = column.copy();
            }
            column.typeCode = typeCode;
            column.assignType();
        }
        columns.put(column.name, column);
        return offset;
    }

    static SecondaryInfo[] secondaryRowInfos(RowInfo primaryInfo, byte[][] descriptors) {
        SecondaryInfo[] infos = new SecondaryInfo[descriptors.length];
        for (int i = 0; i < descriptors.length; ++i) {
            infos[i] = RowStore.secondaryRowInfo(primaryInfo, descriptors[i]);
        }
        return infos;
    }

    RowInfo currentRowInfo(Class<?> rowType, long primaryIndexId, long indexId) throws IOException {
        RowInfo primaryInfo = RowInfo.find(rowType);
        if (primaryIndexId == indexId) {
            return primaryInfo;
        }
        Index primaryIndex = this.mDatabase.indexById(primaryIndexId);
        if (primaryIndex == null) {
            return null;
        }
        TableManager<?> manager = this.tableManager(primaryIndex);
        View secondariesView = this.viewExtended(primaryIndexId, 1);
        try (Cursor c = secondariesView.newCursor(null);){
            c.first();
            while (c.key() != null) {
                if (indexId == RowUtils.decodeLongLE(c.value(), 0)) {
                    SecondaryInfo secondaryInfo = manager.secondaryInfo(primaryInfo, c.key());
                    return secondaryInfo;
                }
                c.next();
            }
        }
        return null;
    }

    private View viewExtended(long indexId, int key) {
        byte[] prefix = new byte[16];
        RowUtils.encodeLongBE(prefix, 0, indexId);
        RowUtils.encodeIntBE(prefix, 12, key);
        return this.mSchemata.viewPrefix(prefix, prefix.length);
    }

    RowInfo decodePrimaryKey(Transaction txn, String typeName, long indexId) throws IOException {
        byte[] primaryData = null;
        View allVersions = this.mSchemata.viewGe(RowStore.key(indexId, 1)).viewLe(RowStore.key(indexId, Integer.MAX_VALUE));
        try (Cursor c = allVersions.newCursor(txn);){
            c.first();
            while (c.key() != null) {
                byte[] value = c.value();
                if (primaryData == null || value.length < primaryData.length) {
                    primaryData = value;
                }
                c.next();
            }
        }
        if (primaryData == null) {
            return null;
        }
        RowInfo info = RowStore.decodeExisting(this.currentName(txn, indexId), null, primaryData);
        if (!info.valueColumns.isEmpty()) {
            info.valueColumns = Collections.emptyNavigableMap();
            info.allColumns = new TreeMap(info.keyColumns);
        }
        return info;
    }

    RowInfo decodeExisting(Transaction txn, String typeName, long indexId) throws IOException {
        byte[] currentData = this.mSchemata.load(txn, RowStore.key(indexId));
        if (currentData == null) {
            return null;
        }
        return this.decodeExisting(txn, typeName, indexId, currentData, RowUtils.decodeIntLE(currentData, 0));
    }

    private RowInfo decodeExisting(Transaction txn, String typeName, long indexId, byte[] currentData, int schemaVersion) throws IOException {
        byte[] primaryData = this.mSchemata.load(txn, RowStore.key(indexId, schemaVersion));
        if (typeName == null) {
            typeName = this.currentName(txn, indexId);
        }
        return RowStore.decodeExisting(typeName, currentData, primaryData);
    }

    private String currentName(Transaction txn, long indexId) throws IOException {
        byte[] currentName = this.viewExtended(indexId, 2).load(txn, RowUtils.EMPTY_BYTES);
        if (currentName == null) {
            return String.valueOf(indexId);
        }
        return RowUtils.decodeStringUTF(currentName, 0, currentName.length);
    }

    private static RowInfo decodeExisting(String typeName, byte[] currentData, byte[] primaryData) throws CorruptDatabaseException {
        int encodingVersion;
        if (primaryData == null) {
            return null;
        }
        int pos = 0;
        if ((encodingVersion = primaryData[pos++] & 0xFF) != 1) {
            throw new CorruptDatabaseException("Unknown encoding version: " + encodingVersion);
        }
        RowInfo info = new RowInfo(typeName);
        info.allColumns = new TreeMap();
        String[] names = new String[RowUtils.decodePrefixPF(primaryData, pos)];
        pos += RowUtils.lengthPrefixPF(names.length);
        for (int i = 0; i < names.length; ++i) {
            int nameLen = RowUtils.decodePrefixPF(primaryData, pos);
            String name = RowUtils.decodeStringUTF(primaryData, pos += RowUtils.lengthPrefixPF(nameLen), nameLen).intern();
            names[i] = name;
            ColumnInfo ci = new ColumnInfo();
            ci.name = name;
            ci.typeCode = RowUtils.decodeIntLE(primaryData, pos += nameLen);
            pos += 4;
            info.allColumns.put(name, ci);
        }
        info.keyColumns = new LinkedHashMap();
        pos = RowStore.decodeColumns(primaryData, pos, names, info.keyColumns);
        info.valueColumns = new TreeMap();
        pos = RowStore.decodeColumns(primaryData, pos, names, info.valueColumns);
        if (info.valueColumns.isEmpty()) {
            info.valueColumns = Collections.emptyNavigableMap();
        }
        if (pos < primaryData.length) {
            throw new CorruptDatabaseException("Trailing primary data: " + pos + " < " + primaryData.length);
        }
        if (currentData != null) {
            info.alternateKeys = new TreeSet<ColumnSet>(ColumnSetComparator.THE);
            pos = RowStore.decodeColumnSets(currentData, 12, names, info.alternateKeys);
            if (info.alternateKeys.isEmpty()) {
                info.alternateKeys = Collections.emptyNavigableSet();
            }
            info.secondaryIndexes = new TreeSet<ColumnSet>(ColumnSetComparator.THE);
            pos = RowStore.decodeColumnSets(currentData, pos, names, info.secondaryIndexes);
            if (info.secondaryIndexes.isEmpty()) {
                info.secondaryIndexes = Collections.emptyNavigableSet();
            }
            if (pos < currentData.length) {
                throw new CorruptDatabaseException("Trailing current data: " + pos + " < " + currentData.length);
            }
        }
        return info;
    }

    private static int decodeColumns(byte[] data, int pos, String[] names, Map<String, ColumnInfo> columns) {
        int num = RowUtils.decodePrefixPF(data, pos);
        pos += RowUtils.lengthPrefixPF(num);
        for (int i = 0; i < num; ++i) {
            int columnNumber = RowUtils.decodePrefixPF(data, pos);
            ColumnInfo ci = new ColumnInfo();
            ci.name = names[columnNumber];
            ci.typeCode = RowUtils.decodeIntLE(data, pos += RowUtils.lengthPrefixPF(columnNumber));
            pos += 4;
            ci.assignType();
            columns.put(ci.name, ci);
        }
        return pos;
    }

    private static int decodeColumnSets(byte[] data, int pos, String[] names, Set<ColumnSet> columnSets) {
        int size = RowUtils.decodePrefixPF(data, pos);
        pos += RowUtils.lengthPrefixPF(size);
        for (int i = 0; i < size; ++i) {
            ColumnSet cs = new ColumnSet();
            cs.allColumns = new TreeMap<String, ColumnInfo>();
            pos = RowStore.decodeColumns(data, pos, names, cs.allColumns);
            cs.keyColumns = new LinkedHashMap<String, ColumnInfo>();
            pos = RowStore.decodeColumns(data, pos, names, cs.keyColumns);
            cs.valueColumns = new TreeMap<String, ColumnInfo>();
            pos = RowStore.decodeColumns(data, pos, names, cs.valueColumns);
            if (cs.valueColumns.isEmpty()) {
                cs.valueColumns = Collections.emptyNavigableMap();
            }
            columnSets.add(cs);
        }
        return pos;
    }

    private static byte[] key(long indexId) {
        byte[] key = new byte[8];
        RowUtils.encodeLongBE(key, 0, indexId);
        return key;
    }

    private static byte[] key(long indexId, int suffix) {
        byte[] key = new byte[12];
        RowUtils.encodeLongBE(key, 0, indexId);
        RowUtils.encodeIntBE(key, 8, suffix);
        return key;
    }

    <R> Transcoder findSortTranscoder(Class<?> rowType, RowEvaluator<R> evaluator, SecondaryInfo sortedInfo) {
        WeakCache existing;
        WeakCache<TranscoderKey, Transcoder, SecondaryInfo> cache = this.mSortTranscoderCache;
        if (cache == null && (existing = cSortTranscoderCacheHandle.compareAndExchange(this, null, cache = new WeakCache<TranscoderKey, Transcoder, SecondaryInfo>(){

            @Override
            protected Transcoder newValue(TranscoderKey key, SecondaryInfo sortedInfo) {
                Class<?> rowType = key.mRowType;
                RowInfo rowInfo = RowInfo.find(rowType);
                if (key.mSecondaryDesc != null) {
                    rowInfo = RowStore.secondaryRowInfo(rowInfo, key.mSecondaryDesc);
                }
                return SortTranscoderMaker.makeTranscoder(RowStore.this, rowType, rowInfo, key.mTableId, sortedInfo);
            }
        })) != null) {
            cache = existing;
        }
        TranscoderKey key = new TranscoderKey(rowType, evaluator, sortedInfo.indexSpec());
        return (Transcoder)cache.obtain((Object)key, (Object)sortedInfo);
    }

    private /* synthetic */ void lambda$deleteIndex$5(EventListener listener, String eventStr, Supplier taskFactory, Index secondaryIndex) {
        try {
            if (listener != null) {
                listener.notify(EventType.TABLE_INDEX_INFO, "Dropping %1$s", eventStr);
            }
            Runnable task = taskFactory == null ? this.mDatabase.deleteIndex(secondaryIndex) : (Runnable)taskFactory.get();
            task.run();
            if (listener != null) {
                listener.notify(EventType.TABLE_INDEX_INFO, "Finished dropping %1$s", eventStr);
            }
        }
        catch (Throwable e) {
            this.uncaught(e);
        }
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            cSortTranscoderCacheHandle = lookup.findVarHandle(RowStore.class, "mSortTranscoderCache", WeakCache.class);
        }
        catch (Throwable e) {
            throw RowUtils.rethrow(e);
        }
    }

    private static class EncodedRowInfo {
        final String[] names;
        final byte[] primaryData;
        final int primaryHash;
        final byte[] currentData;
        final TreeSet<byte[]> secondaries;

        EncodedRowInfo(RowInfo info) {
            this.names = new String[info.allColumns.size()];
            HashMap<String, Integer> columnNameMap = new HashMap<String, Integer>();
            Encoder encoder = new Encoder(this.names.length * 16);
            encoder.writeByte(1);
            encoder.writePrefixPF(this.names.length);
            int columnNumber = 0;
            for (ColumnInfo column : info.allColumns.values()) {
                String name = column.name;
                columnNameMap.put(name, columnNumber);
                this.names[columnNumber++] = name;
                encoder.writeStringUTF(name);
                encoder.writeIntLE(column.typeCode);
            }
            EncodedRowInfo.encodeColumns(encoder, info.keyColumns.values(), columnNameMap);
            EncodedRowInfo.encodeColumns(encoder, info.valueColumns.values(), columnNameMap);
            this.primaryData = encoder.toByteArray();
            this.primaryHash = Arrays.hashCode(this.primaryData);
            encoder.reset(0);
            encoder.writeIntLE(0);
            encoder.writeLongLE(0L);
            EncodedRowInfo.encodeColumnSets(encoder, info.alternateKeys, columnNameMap);
            EncodedRowInfo.encodeColumnSets(encoder, info.secondaryIndexes, columnNameMap);
            this.currentData = encoder.toByteArray();
            this.secondaries = new TreeSet(RowUtils.KEY_COMPARATOR);
            info.alternateKeys.forEach(cs -> this.secondaries.add(EncodedRowInfo.encodeDescriptor('A', encoder, cs)));
            info.secondaryIndexes.forEach(cs -> this.secondaries.add(EncodedRowInfo.encodeDescriptor('I', encoder, cs)));
        }

        private static void encodeColumns(Encoder encoder, Collection<ColumnInfo> columns, Map<String, Integer> columnNameMap) {
            encoder.writePrefixPF(columns.size());
            for (ColumnInfo column : columns) {
                encoder.writePrefixPF(columnNameMap.get(column.name));
                encoder.writeIntLE(column.typeCode);
            }
        }

        private static void encodeColumnSets(Encoder encoder, Collection<ColumnSet> columnSets, Map<String, Integer> columnNameMap) {
            encoder.writePrefixPF(columnSets.size());
            for (ColumnSet cs : columnSets) {
                EncodedRowInfo.encodeColumns(encoder, cs.allColumns.values(), columnNameMap);
                EncodedRowInfo.encodeColumns(encoder, cs.keyColumns.values(), columnNameMap);
                EncodedRowInfo.encodeColumns(encoder, cs.valueColumns.values(), columnNameMap);
            }
        }

        private static byte[] encodeDescriptor(char type, Encoder encoder, ColumnSet cs) {
            encoder.reset(0);
            encoder.writeByte((byte)type);
            EncodedRowInfo.encodeColumns(encoder, cs.keyColumns);
            EncodedRowInfo.encodeColumns(encoder, cs.valueColumns);
            return encoder.toByteArray();
        }

        private static void encodeColumns(Encoder encoder, Map<String, ColumnInfo> columns) {
            encoder.writePrefixPF(columns.size());
            for (ColumnInfo column : columns.values()) {
                encoder.writeIntBE(column.typeCode ^ Integer.MIN_VALUE);
                encoder.writeStringUTF(column.name);
            }
        }
    }

    private static final class TranscoderKey {
        final Class<?> mRowType;
        final long mTableId;
        final byte[] mSecondaryDesc;
        final String mSortedInfoSpec;

        TranscoderKey(Class<?> rowType, RowEvaluator<?> evaluator, String sortedInfoSpec) {
            this.mRowType = rowType;
            this.mTableId = evaluator.evolvableTableId();
            this.mSecondaryDesc = evaluator.secondaryDescriptor();
            this.mSortedInfoSpec = sortedInfoSpec;
        }

        public int hashCode() {
            int hash = this.mRowType.hashCode();
            hash = hash * 31 + (int)this.mTableId;
            hash = hash * 31 + Arrays.hashCode(this.mSecondaryDesc);
            hash = hash * 31 + this.mSortedInfoSpec.hashCode();
            return hash;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof TranscoderKey)) return false;
            TranscoderKey other = (TranscoderKey)obj;
            if (this.mRowType != other.mRowType) return false;
            if (this.mTableId != other.mTableId) return false;
            if (!Arrays.equals(this.mSecondaryDesc, other.mSecondaryDesc)) return false;
            if (!this.mSortedInfoSpec.equals(other.mSortedInfoSpec)) return false;
            return true;
        }
    }
}

