/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.core.Utils;

public class RowUtils
extends Utils {
    static final byte NULL_BYTE_LOW = 0;
    static final byte NULL_BYTE_HIGH = -1;
    static final byte NOT_NULL_BYTE_HIGH = -128;
    static final byte NOT_NULL_BYTE_LOW = 127;
    static final byte TERMINATOR = 1;

    public static int lengthPrefixPF(int value) {
        return value < 128 ? 1 : 4;
    }

    public static int encodePrefixPF(byte[] dst, int dstOffset, int value) {
        if (value < 128) {
            dst[dstOffset++] = (byte)value;
        } else {
            RowUtils.encodeIntBE(dst, dstOffset, value | Integer.MIN_VALUE);
            dstOffset += 4;
        }
        return dstOffset;
    }

    public static void encodePrefixPF(DataOutput out, int value) throws IOException {
        if (value < 128) {
            out.writeByte(value);
        } else {
            out.writeInt(value | Integer.MIN_VALUE);
        }
    }

    public static int decodePrefixPF(byte[] src, int srcOffset) {
        int value = src[srcOffset];
        if (value < 0) {
            value = RowUtils.decodeIntBE(src, srcOffset) & Integer.MAX_VALUE;
        }
        return value;
    }

    public static int decodePrefixPF(DataInput in) throws IOException {
        int length = in.readByte();
        if (length < 0) {
            length = (length & 0x7F) << 24 | in.readUnsignedShort() << 8 | in.readUnsignedByte();
        }
        return length;
    }

    public static int skipBytesPF(byte[] src, int srcOffset) {
        int length;
        if ((length = src[srcOffset++]) < 0) {
            length = RowUtils.decodeIntBE(src, srcOffset - 1) & Integer.MAX_VALUE;
            srcOffset += 3;
        }
        return srcOffset + length;
    }

    public static int skipNullableBytesPF(byte[] src, int srcOffset) {
        int length;
        if ((length = src[srcOffset++]) < 0) {
            length = RowUtils.decodeIntBE(src, srcOffset - 1) & Integer.MAX_VALUE;
            srcOffset += 3;
        }
        if (length != 0) {
            srcOffset += length - 1;
        }
        return srcOffset;
    }

    public static int lengthStringUTF(String value) {
        int strLength = value.length();
        long encodedLen = strLength;
        for (int i = 0; i < strLength; ++i) {
            char c2;
            char c = value.charAt(i);
            if (c < '\u0080') continue;
            if (c <= '\u07ff') {
                ++encodedLen;
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff' && i + 1 < strLength && (c2 = value.charAt(i + 1)) >= '\udc00' && c2 <= '\udfff') {
                ++i;
            }
            encodedLen += 2L;
        }
        return Math.toIntExact(encodedLen);
    }

    public static int encodeStringUTF(byte[] dst, int dstOffset, String value) {
        int strLength = value.length();
        for (int i = 0; i < strLength; ++i) {
            char c2;
            int c = value.charAt(i);
            if (c <= 127) {
                dst[dstOffset++] = (byte)c;
                continue;
            }
            if (c <= 2047) {
                dst[dstOffset++] = (byte)(0xC0 | c >> 6);
                dst[dstOffset++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c >= 55296 && c <= 56319 && i + 1 < strLength && (c2 = value.charAt(i + 1)) >= '\udc00' && c2 <= '\udfff') {
                c = 65536 + ((c & 0x3FF) << 10 | c2 & 0x3FF);
                ++i;
                dst[dstOffset++] = (byte)(0xF0 | c >> 18);
                dst[dstOffset++] = (byte)(0x80 | c >> 12 & 0x3F);
            } else {
                dst[dstOffset++] = (byte)(0xE0 | c >> 12);
            }
            dst[dstOffset++] = (byte)(0x80 | c >> 6 & 0x3F);
            dst[dstOffset++] = (byte)(0x80 | c & 0x3F);
        }
        return dstOffset;
    }

    public static byte[] encodeStringUTF(String value) {
        return value == null ? null : value.getBytes(StandardCharsets.UTF_8);
    }

    public static String decodeStringUTF(byte[] src, int srcOffset, int length) {
        return RowUtils.utf8(src, srcOffset, length);
    }

    public static int lengthStringLex(String str) {
        return str == null ? 1 : RowUtils.doLengthStringLex(str);
    }

    private static int doLengthStringLex(String str) {
        int strLength = str.length();
        long encodedLen = 1 + strLength;
        for (int i = 0; i < strLength; ++i) {
            char c2;
            char c = str.charAt(i);
            if (c < '~') continue;
            if (c <= '\u307d') {
                ++encodedLen;
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff' && i + 1 < strLength && (c2 = str.charAt(i + 1)) >= '\udc00' && c2 <= '\udfff') {
                ++i;
                ++encodedLen;
                continue;
            }
            encodedLen += 2L;
        }
        return Math.toIntExact(encodedLen);
    }

    public static int encodeStringLex(byte[] dst, int dstOffset, String str) {
        return RowUtils.encodeStringLex(dst, dstOffset, str, 0);
    }

    public static int encodeStringLexDesc(byte[] dst, int dstOffset, String str) {
        return RowUtils.encodeStringLex(dst, dstOffset, str, -1);
    }

    private static int encodeStringLex(byte[] dst, int dstOffset, String str, int xorMask) {
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char c2;
            int a;
            int c = str.charAt(i) + 2;
            if (c <= 127) {
                dst[dstOffset++] = (byte)(c ^ xorMask);
                continue;
            }
            if (c <= 12415) {
                a = (c -= 128) * 21846 >> 22;
                dst[dstOffset++] = (byte)((0x80 | a) ^ xorMask);
                dst[dstOffset++] = (byte)((c -= (a << 7) + (a << 6)) + 32 ^ xorMask);
                continue;
            }
            if (c - 2 >= 55296 && c - 2 <= 56319 && i + 1 < length && (c2 = str.charAt(i + 1)) >= '\udc00' && c2 <= '\udfff') {
                c = ((c - 2 & 0x3FF) << 10 | c2 & 0x3FF) + 65538;
                ++i;
            }
            c -= 12416;
            if ((c -= ((a = (int)((long)c * 21845L >> 22)) << 7) + (a << 6)) == 192) {
                ++a;
                c = 0;
            }
            dst[dstOffset + 2] = (byte)(c + 32 ^ xorMask);
            c = a * 21846 >> 22;
            dst[dstOffset++] = (byte)((0xC0 | c) ^ xorMask);
            dst[dstOffset++] = (byte)((a -= (c << 7) + (c << 6)) + 32 ^ xorMask);
            ++dstOffset;
        }
        dst[dstOffset++] = (byte)(1 ^ xorMask);
        return dstOffset;
    }

    public static int lengthStringLex(byte[] src, int srcOffset) {
        byte b;
        int start = srcOffset;
        while (-2 > (b = src[srcOffset++]) || b >= 2) {
        }
        return srcOffset - start;
    }

    public static String decodeStringLex(byte[] src, int srcOffset, int length) {
        return RowUtils.decodeStringLex(src, srcOffset, length, 0);
    }

    public static String decodeStringLexDesc(byte[] src, int srcOffset, int length) {
        return RowUtils.decodeStringLex(src, srcOffset, length, -1);
    }

    private static String decodeStringLex(byte[] src, int srcOffset, int length, int xorMask) {
        if (length <= 1) {
            byte b = src[srcOffset];
            if (b == -1 || b == 0) {
                return null;
            }
            return "";
        }
        char[] chars = new char[length - 1];
        int charLen = 0;
        int endOffset = srcOffset + length - 1;
        block4: while (srcOffset < endOffset) {
            int c = (src[srcOffset++] ^ xorMask) & 0xFF;
            switch (c >> 5) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    chars[charLen++] = (char)(c - 2);
                    continue block4;
                }
                case 4: 
                case 5: {
                    chars[charLen++] = (char)(((c &= 0x3F) << 7) + (c << 6) + ((src[srcOffset++] ^ xorMask) & 0xFF) + 94);
                    continue block4;
                }
            }
            c &= 0x1F;
            c = (c << 7) + (c << 6) + ((src[srcOffset++] ^ xorMask) & 0xFF) - 32;
            c = (c << 7) + (c << 6) + ((src[srcOffset++] ^ xorMask) & 0xFF) + 12382;
            if (c >= 65536) {
                chars[charLen++] = (char)(0xD800 | (c -= 65536) >> 10 & 0x3FF);
                chars[charLen++] = (char)(0xDC00 | c & 0x3FF);
                continue;
            }
            chars[charLen++] = (char)c;
        }
        return new String(chars, 0, charLen);
    }

    public static byte[] encodeBigInteger(BigInteger value) {
        return value == null ? null : value.toByteArray();
    }

    public static int encodeBigIntegerLex(byte[] dst, int dstOffset, byte[] src) {
        int len = src.length;
        byte msb = src[0];
        if (len < 127) {
            dst[dstOffset++] = (byte)(msb < 0 ? 128 - len : len + 127);
        } else {
            if (msb < 0) {
                dst[dstOffset++] = 1;
                RowUtils.encodeIntBE(dst, dstOffset, -len);
            } else {
                dst[dstOffset++] = -2;
                RowUtils.encodeIntBE(dst, dstOffset, len);
            }
            dstOffset += 4;
        }
        System.arraycopy(src, 0, dst, dstOffset, len);
        return dstOffset += len;
    }

    public static int encodeBigIntegerLexDesc(byte[] dst, int dstOffset, byte[] src) {
        int len = src.length;
        byte msb = src[0];
        if (len < 127) {
            dst[dstOffset++] = (byte)(msb < 0 ? len + 127 : 128 - len);
        } else {
            if (msb < 0) {
                dst[dstOffset++] = -2;
                RowUtils.encodeIntBE(dst, dstOffset, len);
            } else {
                dst[dstOffset++] = 1;
                RowUtils.encodeIntBE(dst, dstOffset, -len);
            }
            dstOffset += 4;
        }
        for (byte b : src) {
            dst[dstOffset++] = ~b;
        }
        return dstOffset;
    }

    public static long decodeBigIntegerLexHeader(byte[] src, int srcOffset) {
        int len;
        int header;
        if ((header = src[srcOffset++] & 0xFF) == 255 || header == 0) {
            return srcOffset;
        }
        if (header > 1 && header < 254) {
            len = header < 128 ? 128 - header : header - 127;
        } else {
            len = Math.abs(RowUtils.decodeIntBE(src, srcOffset));
            srcOffset += 4;
        }
        return (long)len << 32 | (long)srcOffset;
    }

    public static void flip(byte[] b, int off, int len) {
        int end = off + len;
        for (int i = off; i < end; ++i) {
            b[i] = ~b[i];
        }
    }

    public static int skipBigDecimal(byte[] src, int srcOffset) {
        return RowUtils.skipBytesPF(src, (int)(RowUtils.decodeSignedVarInt(src, srcOffset) >> 32));
    }

    public static int skipNullableBigDecimal(byte[] src, int srcOffset) {
        srcOffset = (src[srcOffset] & 0xFF) < 248 ? RowUtils.skipBigDecimal(src, srcOffset) : ++srcOffset;
        return srcOffset;
    }

    public static int decodeSchemaVersion(byte[] src) {
        if (src.length == 0) {
            return 0;
        }
        int version = src[0];
        if (version < 0) {
            version = RowUtils.decodeIntBE(src, 0) & Integer.MAX_VALUE;
        }
        return version;
    }

    public static int skipSchemaVersion(byte[] src) {
        return (src[0] >>> 30) + 1;
    }

    public static int encodeFloatSign(int bits) {
        return bits ^= bits < 0 ? -1 : Integer.MIN_VALUE;
    }

    public static long encodeFloatSign(long bits) {
        return bits ^= bits < 0L ? -1L : Long.MIN_VALUE;
    }

    public static int encodeFloatSignDesc(int bits) {
        if (bits >= 0) {
            bits ^= Integer.MAX_VALUE;
        }
        return bits;
    }

    public static long encodeFloatSignDesc(long bits) {
        if (bits >= 0L) {
            bits ^= Long.MAX_VALUE;
        }
        return bits;
    }

    public static int decodeFloatSign(int bits) {
        return bits ^= bits < 0 ? Integer.MIN_VALUE : -1;
    }

    public static long decodeFloatSign(long bits) {
        return bits ^= bits < 0L ? Long.MIN_VALUE : -1L;
    }

    public static int decodeFloatSignDesc(int bits) {
        if (bits >= 0) {
            bits ^= Integer.MAX_VALUE;
        }
        return bits;
    }

    public static long decodeFloatSignDesc(long bits) {
        if (bits >= 0L) {
            bits ^= Long.MAX_VALUE;
        }
        return bits;
    }

    public static int floatToBitsCompare(float v) {
        int bits = Float.floatToRawIntBits(v);
        if (bits < 0) {
            bits ^= Integer.MAX_VALUE;
        }
        return bits;
    }

    public static long floatToBitsCompare(double v) {
        long bits = Double.doubleToRawLongBits(v);
        if (bits < 0L) {
            bits ^= Long.MAX_VALUE;
        }
        return bits;
    }

    public static byte[] increment(byte[] value, byte[] overflow) {
        if (!RowUtils.increment(value, 0, value.length)) {
            return overflow;
        }
        return value;
    }

    public static IllegalArgumentException nullColumnException(String name) {
        return new IllegalArgumentException("Cannot be null: " + name);
    }

    public static boolean isRepeatable(Transaction txn) {
        return txn != null && txn.lockMode().isRepeatable();
    }

    public static boolean isUnsafe(Transaction txn) {
        return txn != null && txn.lockMode() == LockMode.UNSAFE;
    }

    public static boolean isUnlocked(Transaction txn) {
        return txn != null && txn.lockMode().noReadLock;
    }

    public static void appendQuotedString(StringBuilder bob, char c) {
        char quote = c != '\'' ? (char)'\'' : '\"';
        bob.append(quote).append(c).append(quote);
    }

    public static void appendQuotedString(StringBuilder bob, Character c) {
        if (c == null) {
            bob.append("null");
        } else {
            bob.append(c.charValue());
        }
    }

    public static void appendQuotedString(StringBuilder bob, String s) {
        if (s == null) {
            bob.append("null");
        } else {
            char quote = '\"';
            if (s.indexOf(34) >= 0) {
                if (s.indexOf(39) < 0) {
                    quote = '\'';
                } else {
                    s = s.replace("\"", "\\\"");
                }
            }
            bob.append(quote).append(s).append(quote);
        }
    }
}

