/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import org.cojen.tupl.Scanner;
import org.cojen.tupl.rows.RowConsumer;
import org.cojen.tupl.rows.RowEvaluator;

public final class RowWriter<R>
implements RowConsumer<R> {
    private final DataOutput mOut;
    private byte[] mActiveHeader;
    private HashMap<byte[], Integer> mAllHeaders;
    private RowEvaluator mEvaluator;
    private boolean mWrittenCharacteristics;

    RowWriter(DataOutput out) {
        this.mOut = out;
    }

    public void writeCharacteristics(int characteristics, long size) throws IOException {
        if (this.mWrittenCharacteristics) {
            throw new IllegalStateException();
        }
        this.mOut.writeInt(characteristics);
        if ((characteristics & 0x40) != 0) {
            this.mOut.writeLong(size);
        }
        this.mWrittenCharacteristics = true;
    }

    @Override
    public void beginBatch(Scanner scanner, RowEvaluator<R> evaluator) throws IOException {
        this.mEvaluator = evaluator;
        if (!this.mWrittenCharacteristics) {
            int characteristics = scanner.characteristics();
            this.mOut.writeInt(characteristics);
            if ((characteristics & 0x40) != 0) {
                this.mOut.writeLong(scanner.estimateSize());
            }
            this.mWrittenCharacteristics = true;
        }
    }

    @Override
    public void accept(byte[] key, byte[] value) throws IOException {
        this.mEvaluator.writeRow(this, key, value);
    }

    public void writeHeader(byte[] header) throws IOException {
        if (header == this.mActiveHeader) {
            this.mOut.writeByte(1);
        } else {
            this.doWriteHeader(header);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doWriteHeader(byte[] header) throws IOException {
        block4: {
            if (this.mActiveHeader == null) ** GOTO lbl-1000
            if (this.mAllHeaders != null) break block4;
            this.mAllHeaders = new HashMap<K, V>();
            this.mAllHeaders.put(this.mActiveHeader, 0);
            ** GOTO lbl-1000
        }
        newId = this.mAllHeaders.size();
        existingId = this.mAllHeaders.putIfAbsent(header, newId);
        if (existingId != null) {
            id = existingId;
            if (id <= 249) {
                this.mOut.writeByte(id + 5);
            } else {
                this.mOut.writeByte(255);
                this.mOut.writeInt(id);
            }
        } else lbl-1000:
        // 3 sources

        {
            this.mOut.writeByte(2);
            this.mOut.write(header);
        }
        this.mActiveHeader = header;
    }

    public void writeRowLength(int length) throws IOException {
        if (length <= Short.MAX_VALUE) {
            this.mOut.writeShort(length);
        } else {
            this.mOut.writeInt(length | Integer.MIN_VALUE);
        }
    }

    public void writeRowAndKeyLength(int rowLength, int keyLength) throws IOException {
        if (keyLength <= 127) {
            this.writeRowLength(rowLength + 1);
            this.mOut.writeByte(keyLength);
        } else {
            this.writeRowLength(rowLength + 4);
            this.mOut.writeInt(keyLength | Integer.MIN_VALUE);
        }
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this.mOut.write(bytes);
    }

    public void writeBytes(byte[] bytes, int offset) throws IOException {
        this.mOut.write(bytes, offset, bytes.length - offset);
    }

    public void writeBytes(byte[] bytes, int offset, int length) throws IOException {
        this.mOut.write(bytes, offset, length);
    }
}

