/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.IOException;
import org.cojen.tupl.Sorter;
import org.cojen.tupl.rows.RowEvaluator;
import org.cojen.tupl.rows.Transcoder;

class ScanBatch<R> {
    private Block mFirstBlock;
    private Block mLastBlock;
    private ScanBatch<R> mNextBatch;
    RowEvaluator<R> mEvaluator;

    ScanBatch() {
        this.mFirstBlock = this.mLastBlock = new Block();
    }

    final void addEntry(byte[] key, byte[] value) {
        Block block = this.mLastBlock;
        int size = block.mSize;
        byte[][] entries = block.mEntries;
        if (size >= entries.length) {
            this.mLastBlock = block = block.extend();
            entries = block.mEntries;
            size = 0;
        }
        entries[size++] = key;
        entries[size++] = value;
        block.mSize = size;
    }

    private int decodeRows(R[] rows, int offset) throws IOException {
        Block block = this.mFirstBlock;
        this.mFirstBlock = null;
        this.mLastBlock = null;
        do {
            byte[][] entries = block.mEntries;
            for (int i = 0; i < entries.length; i += 2) {
                byte[] key = entries[i];
                if (key == null) {
                    return offset;
                }
                byte[] value = entries[i + 1];
                rows[offset++] = this.mEvaluator.decodeRow(null, key, value);
            }
        } while ((block = block.mNextBlock) != null);
        return offset;
    }

    final int decodeAllRows(R[] rows, int offset) throws IOException {
        ScanBatch<R> batch = this;
        do {
            offset = batch.decodeRows(rows, offset);
        } while ((batch = batch.detachNext()) != null);
        return offset;
    }

    final byte[][] transcode(Transcoder t, Sorter sorter, byte[][] kvPairs) throws IOException {
        int capacity = this.mLastBlock.mEntries.length;
        if (kvPairs == null || ((byte[][])kvPairs).length < capacity) {
            kvPairs = new byte[capacity][];
        }
        Block block = this.mFirstBlock;
        this.mFirstBlock = null;
        this.mLastBlock = null;
        do {
            byte[] key;
            int i;
            byte[][] entries = block.mEntries;
            for (i = 0; i < entries.length && (key = entries[i]) != null; i += 2) {
                t.transcode(key, entries[i + 1], (byte[][])kvPairs, i);
            }
            sorter.addBatch((byte[][])kvPairs, 0, i >> 1);
        } while ((block = block.mNextBlock) != null);
        return kvPairs;
    }

    final void appendNext(ScanBatch<R> batch) {
        this.mNextBatch = batch;
    }

    final ScanBatch<R> detachNext() {
        ScanBatch<R> next = this.mNextBatch;
        this.mNextBatch = null;
        this.mEvaluator = null;
        return next;
    }

    static final class Block {
        private static final int FIRST_BLOCK_CAPACITY = 16;
        private static final int HIGHEST_BLOCK_CAPACITY = 1024;
        private final byte[][] mEntries;
        private int mSize;
        private Block mNextBlock;

        Block() {
            this(16);
        }

        Block(int capacity) {
            this.mEntries = new byte[capacity][];
        }

        Block extend() {
            Block block;
            this.mNextBlock = block = new Block(Math.min(this.mEntries.length << 1, 1024));
            return block;
        }
    }
}

