/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.IOException;
import java.util.Set;
import org.cojen.tupl.Scanner;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Updater;
import org.cojen.tupl.diag.QueryPlan;
import org.cojen.tupl.rows.BaseTable;
import org.cojen.tupl.rows.QueryLauncher;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.RowWriter;
import org.cojen.tupl.rows.ScanControllerFactory;

final class ScanQueryLauncher<R>
implements QueryLauncher<R> {
    private final BaseTable<R> mTable;
    private final ScanControllerFactory<R> mFactory;
    private final Set<String> mProjection;

    ScanQueryLauncher(BaseTable<R> table, ScanControllerFactory<R> factory, Set<String> projection) {
        this.mTable = table;
        this.mFactory = factory;
        this.mProjection = projection;
    }

    @Override
    public Scanner<R> newScanner(Transaction txn, R row, Object ... args) throws IOException {
        return this.mTable.newScanner(txn, row, this.mFactory.scanController(args));
    }

    @Override
    public Updater<R> newUpdater(Transaction txn, R row, Object ... args) throws IOException {
        return this.mTable.newUpdater(txn, row, this.mFactory.scanController(args));
    }

    @Override
    public void scanWrite(Transaction txn, RowWriter writer, Object ... args) throws IOException {
        Scanner<RowWriter> scanner = this.newScanner(txn, writer, args);
        try {
            while (scanner.step(writer) != null) {
            }
        }
        catch (Throwable e) {
            RowUtils.closeQuietly(scanner);
            throw RowUtils.rethrow(e);
        }
    }

    @Override
    public QueryPlan plan(Object ... args) {
        return this.mFactory.plan(args);
    }

    @Override
    public Set<String> projection() {
        return this.mProjection;
    }
}

