/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.IOException;
import org.cojen.tupl.Entry;
import org.cojen.tupl.Scanner;
import org.cojen.tupl.rows.RowDecoder;

abstract class ScannerScanner<R>
implements Scanner<R> {
    private final Scanner<Entry> mScanner;
    private final RowDecoder<R> mDecoder;
    private R mRow;

    ScannerScanner(Scanner<Entry> scanner, RowDecoder<R> decoder) throws IOException {
        this.mScanner = scanner;
        this.mDecoder = decoder;
        this.mRow = decoder.decodeRow(null, scanner.row());
    }

    @Override
    public final R row() {
        return this.mRow;
    }

    @Override
    public final R step() throws IOException {
        return this.step(null);
    }

    @Override
    public final R step(R dst) throws IOException {
        Scanner<Entry> s = this.mScanner;
        Entry e = s.row();
        R row = e != null && (e = s.step(e)) != null ? (R)this.mDecoder.decodeRow(dst, e) : null;
        this.mRow = row;
        return row;
    }

    @Override
    public final void close() throws IOException {
        this.mRow = null;
        this.mScanner.close();
    }

    @Override
    public final long estimateSize() {
        return Long.MAX_VALUE;
    }
}

