/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.RowUtils;

final class SchemaVersionColumnCodec
extends ColumnCodec {
    private final int mVersion;

    SchemaVersionColumnCodec(int version, MethodMaker mm) {
        super(null, mm);
        this.mVersion = version < 128 ? version : version | Integer.MIN_VALUE;
    }

    private SchemaVersionColumnCodec(MethodMaker mm, int version) {
        super(null, mm);
        this.mVersion = version;
    }

    @Override
    ColumnCodec bind(MethodMaker mm) {
        return new SchemaVersionColumnCodec(mm, this.mVersion);
    }

    @Override
    protected final boolean doEquals(Object obj) {
        return ((SchemaVersionColumnCodec)obj).mVersion == this.mVersion;
    }

    @Override
    protected final int doHashCode() {
        return this.mVersion;
    }

    @Override
    int codecFlags() {
        return 0;
    }

    @Override
    int minSize() {
        return this.mVersion < 0 ? 4 : 1;
    }

    @Override
    void encodePrepare() {
    }

    @Override
    void encodeSkip() {
    }

    @Override
    Variable encodeSize(Variable srcVar, Variable totalVar) {
        return totalVar;
    }

    @Override
    void encode(Variable srcVar, Variable dstVar, Variable offsetVar) {
        if (this.mVersion >= 0) {
            dstVar.aset((Object)offsetVar, (Object)((byte)this.mVersion));
            offsetVar.inc((Object)1);
        } else {
            this.mMaker.var(RowUtils.class).invoke("encodeIntBE", new Object[]{dstVar, offsetVar, this.mVersion});
            offsetVar.inc((Object)4);
        }
    }

    @Override
    void decode(Variable dstVar, Variable srcVar, Variable offsetVar, Variable endVar) {
        throw new UnsupportedOperationException();
    }

    @Override
    void decodeSkip(Variable srcVar, Variable offsetVar, Variable endVar) {
        throw new UnsupportedOperationException();
    }
}

