/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.IOException;
import java.util.Comparator;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.View;
import org.cojen.tupl.rows.RowEvaluator;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.ScanController;

public abstract class SingleScanController<R>
implements ScanController<R>,
RowEvaluator<R> {
    private final byte[] mLowBound;
    private final byte[] mHighBound;
    private final boolean mLowInclusive;
    private final boolean mHighInclusive;
    private final boolean mReverse;

    protected SingleScanController(byte[] lowBound, boolean lowInclusive, byte[] highBound, boolean highInclusive, boolean reverse) {
        if (!reverse) {
            this.mLowBound = lowBound;
            this.mLowInclusive = lowInclusive;
            this.mHighBound = highBound;
            this.mHighInclusive = highInclusive;
        } else {
            this.mLowBound = highBound;
            this.mLowInclusive = highInclusive;
            this.mHighBound = lowBound;
            this.mHighInclusive = lowInclusive;
        }
        this.mReverse = reverse;
    }

    protected SingleScanController(boolean reverse, byte[] lowBound, boolean lowInclusive, byte[] highBound, boolean highInclusive) {
        this.mLowBound = lowBound;
        this.mLowInclusive = lowInclusive;
        this.mHighBound = highBound;
        this.mHighInclusive = highInclusive;
        this.mReverse = reverse;
    }

    protected SingleScanController(SingleScanController from) {
        this(true, from.mHighBound, from.mHighInclusive, from.mLowBound, from.mLowInclusive);
    }

    @Override
    public boolean isJoined() {
        return false;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 4369;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final Cursor newCursor(View view, Transaction txn) throws IOException {
        byte[] high;
        byte[] low;
        if (this.mReverse) {
            view = view.viewReverse();
        }
        if ((low = this.mLowBound) != null) {
            if (low == EMPTY) {
                view = view.viewLt(low);
                return view.newCursor(txn);
            }
            view = this.mLowInclusive ? view.viewGe(low) : view.viewGt(low);
        }
        if ((high = this.mHighBound) == null) return view.newCursor(txn);
        view = this.mHighInclusive ? view.viewLe(high) : view.viewLt(high);
        return view.newCursor(txn);
    }

    @Override
    public final RowEvaluator<R> evaluator() {
        return this;
    }

    @Override
    public final boolean next() {
        return false;
    }

    protected final byte[] lowBound() {
        return this.mLowBound;
    }

    protected final boolean lowInclusive() {
        return this.mLowInclusive;
    }

    protected final byte[] highBound() {
        return this.mHighBound;
    }

    protected final boolean highInclusive() {
        return this.mHighInclusive;
    }

    protected final boolean isReverse() {
        return this.mReverse;
    }

    protected final boolean isTooLow(byte[] key) {
        byte[] low = this.lowBound();
        if (low == null) {
            return false;
        }
        int cmp = this.comparator().compare(key, low);
        return cmp < 0 || cmp == 0 && !this.lowInclusive();
    }

    protected final boolean isTooHigh(byte[] key) {
        byte[] high = this.highBound();
        if (high == null) {
            return false;
        }
        int cmp = this.comparator().compare(key, high);
        return cmp > 0 || cmp == 0 && !this.highInclusive();
    }

    protected final int compareLow(SingleScanController other) {
        int cmp;
        byte[] thisLow = this.lowBound();
        byte[] otherLow = other.lowBound();
        if (thisLow == null) {
            cmp = otherLow == null ? 0 : -1;
        } else if (otherLow == null) {
            cmp = 1;
        } else {
            cmp = this.comparator().compare(thisLow, otherLow);
            if (cmp == 0) {
                cmp = -Boolean.compare(this.lowInclusive(), other.lowInclusive());
            }
        }
        return cmp;
    }

    protected final int compareHigh(SingleScanController other) {
        int cmp;
        byte[] thisHigh = this.highBound();
        byte[] otherHigh = other.highBound();
        if (thisHigh == null) {
            cmp = otherHigh == null ? 0 : 1;
        } else if (otherHigh == null) {
            cmp = -1;
        } else {
            cmp = this.comparator().compare(thisHigh, otherHigh);
            if (cmp == 0) {
                cmp = Boolean.compare(this.highInclusive(), other.highInclusive());
            }
        }
        return cmp;
    }

    protected final Comparator<byte[]> comparator() {
        Comparator cmp = RowUtils.KEY_COMPARATOR;
        if (this.mReverse) {
            cmp = cmp.reversed();
        }
        return cmp;
    }
}

