/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.VarHandle;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.cojen.tupl.rows.RefCache;

class SoftCache<K, V, H>
extends RefCache<K, V, H> {
    private Entry<K, V>[] mEntries;
    private int mSize;

    public SoftCache() {
        this.clear();
    }

    @Override
    public synchronized void clear() {
        this.mEntries = new Entry[2];
        this.mSize = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SoftReference<V> getRef(K key) {
        Reference ref = this.poll();
        if (ref != null) {
            SoftCache softCache = this;
            synchronized (softCache) {
                this.cleanup(ref);
            }
        }
        Entry<K, V>[] entries = this.mEntries;
        Entry<K, V> e = entries[key.hashCode() & entries.length - 1];
        while (e != null) {
            if (e.matches(key)) {
                return e;
            }
            e = e.mNext;
        }
        return null;
    }

    @Override
    public synchronized SoftReference<V> put(K key, V value) {
        Reference ref = this.poll();
        if (ref != null) {
            this.cleanup(ref);
        }
        Entry<K, V>[] entries = this.mEntries;
        int hash = key.hashCode();
        int index = hash & entries.length - 1;
        Entry<K, V> e = entries[index];
        Entry<K, V> prev = null;
        while (e != null) {
            if (e.matches(key)) {
                e.clear();
                Entry<K, V> newEntry = this.newEntry(key, value, hash);
                if (prev == null) {
                    newEntry.mNext = e.mNext;
                } else {
                    prev.mNext = e.mNext;
                    newEntry.mNext = entries[index];
                }
                VarHandle.storeStoreFence();
                entries[index] = newEntry;
                return newEntry;
            }
            prev = e;
            e = e.mNext;
        }
        if (this.mSize >= this.mEntries.length) {
            Entry[] newEntries = new Entry[entries.length << 1];
            int size = 0;
            int i = entries.length;
            while (--i >= 0) {
                Entry<K, V> existing = entries[i];
                while (existing != null) {
                    Entry<K, V> e2 = existing;
                    existing = existing.mNext;
                    if (e2.refersTo(null)) continue;
                    ++size;
                    index = e2.mHash & newEntries.length - 1;
                    e2.mNext = newEntries[index];
                    newEntries[index] = e2;
                }
            }
            entries = newEntries;
            this.mEntries = newEntries;
            this.mSize = size;
            index = hash & entries.length - 1;
        }
        Entry<K, V> newEntry = this.newEntry(key, value, hash);
        newEntry.mNext = entries[index];
        VarHandle.storeStoreFence();
        entries[index] = newEntry;
        ++this.mSize;
        return newEntry;
    }

    @Override
    public synchronized void removeKey(K key) {
        Reference ref;
        Entry<K, V>[] entries = this.mEntries;
        int index = key.hashCode() & entries.length - 1;
        Entry<K, V> e = entries[index];
        Entry<K, V> prev = null;
        while (e != null) {
            if (e.matches(key)) {
                e.clear();
                if (prev == null) {
                    entries[index] = e.mNext;
                } else {
                    prev.mNext = e.mNext;
                }
                --this.mSize;
                break;
            }
            prev = e;
            e = e.mNext;
        }
        if ((ref = this.poll()) != null) {
            this.cleanup(ref);
        }
    }

    @Override
    protected void cleanup(Object ref) {
        Entry<K, V>[] entries = this.mEntries;
        block0: do {
            Entry cleared = (Entry)ref;
            int ix = cleared.mHash & entries.length - 1;
            Entry<K, V> e = entries[ix];
            Entry<K, V> prev = null;
            while (e != null) {
                if (e == cleared) {
                    if (prev == null) {
                        entries[ix] = e.mNext;
                    } else {
                        prev.mNext = e.mNext;
                    }
                    --this.mSize;
                    continue block0;
                }
                prev = e;
                e = e.mNext;
            }
        } while ((ref = this.poll()) != null);
    }

    protected Entry<K, V> newEntry(K key, V value, int hash) {
        return new Entry<K, V>(key, value, hash, this);
    }

    protected static class Entry<K, V>
    extends SoftReference<V> {
        protected final K mKey;
        final int mHash;
        Entry<K, V> mNext;

        protected Entry(K key, V value, int hash, ReferenceQueue<Object> queue) {
            super(value, queue);
            this.mKey = key;
            this.mHash = hash;
        }

        protected boolean matches(K key) {
            return this.mKey.equals(key);
        }
    }
}

