/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.CodeUtils;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.OrderBy;
import org.cojen.tupl.rows.RowDecoder;
import org.cojen.tupl.rows.RowGen;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowMaker;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.SecondaryInfo;
import org.cojen.tupl.rows.WeakCache;

class SortDecoderMaker {
    private static final WeakCache<DecoderKey, RowDecoder, SecondaryInfo> cDecoders = new WeakCache<DecoderKey, RowDecoder, SecondaryInfo>(){

        @Override
        protected RowDecoder newValue(DecoderKey key, SecondaryInfo sortedInfo) {
            Set<String> projection = key.projection();
            if (projection != null && projection.equals(sortedInfo.allColumns.keySet())) {
                return (RowDecoder)this.obtain(key.withNullProjection(), sortedInfo);
            }
            return SortDecoderMaker.makeDecoder(key.rowType, sortedInfo, key.projection());
        }
    };
    private static final WeakCache<InfoKey, SecondaryInfo, RowInfo> cSortedInfos = new WeakCache<InfoKey, SecondaryInfo, RowInfo>(){

        @Override
        protected SecondaryInfo newValue(InfoKey key, RowInfo rowInfo) {
            Set<String> projection = key.projection();
            if (projection != null) {
                if (rowInfo == null) {
                    rowInfo = RowInfo.find(key.rowType);
                }
                if (projection.equals(rowInfo.allColumns.keySet())) {
                    return (SecondaryInfo)this.obtain(key.withNullProjection(), rowInfo);
                }
            }
            return SortDecoderMaker.newSortedInfo(key.rowType, key.orderBySpec, projection, key.allowDuplicates);
        }
    };

    SortDecoderMaker() {
    }

    static SecondaryInfo findSortedInfo(Class<?> rowType, String orderBySpec, Set<String> projection, boolean allowDuplicates) {
        InfoKey key = new InfoKey(rowType, orderBySpec, projection, allowDuplicates);
        return (SecondaryInfo)cSortedInfos.obtain((Object)key, null);
    }

    static <R> RowDecoder<R> findDecoder(Class<?> rowType, SecondaryInfo sortedInfo, Set<String> projection) {
        DecoderKey key = new DecoderKey(rowType, sortedInfo.indexSpec(), projection);
        return (RowDecoder)cDecoders.obtain((Object)key, (Object)sortedInfo);
    }

    static SecondaryInfo newSortedInfo(Class<?> rowType, String orderBySpec, Set<String> projection, boolean allowDuplicates) {
        RowInfo rowInfo = RowInfo.find(rowType);
        if (projection == null) {
            projection = rowInfo.allColumns.keySet();
        }
        Set<String> available = allowDuplicates ? rowInfo.allColumns.keySet() : projection;
        SecondaryInfo sortedInfo = new SecondaryInfo(rowInfo, false);
        sortedInfo.keyColumns = new LinkedHashMap();
        OrderBy orderBy = OrderBy.forSpec(rowInfo, orderBySpec);
        for (Map.Entry e : orderBy.entrySet()) {
            ColumnInfo orderColumn = ((OrderBy.Rule)e.getValue()).asColumn();
            if (!available.contains(orderColumn.name)) {
                throw new IllegalArgumentException();
            }
            sortedInfo.keyColumns.put(orderColumn.name, orderColumn);
        }
        boolean hasDuplicates = false;
        for (ColumnInfo keyColumn : rowInfo.keyColumns.values()) {
            if (!available.contains(keyColumn.name)) {
                hasDuplicates = true;
                continue;
            }
            if (sortedInfo.keyColumns.containsKey(keyColumn.name)) continue;
            sortedInfo.keyColumns.put(keyColumn.name, keyColumn);
        }
        if (!hasDuplicates) {
            for (String colName : projection) {
                if (!available.contains(colName)) {
                    throw new IllegalArgumentException();
                }
                if (sortedInfo.keyColumns.containsKey(colName)) continue;
                if (sortedInfo.valueColumns == null) {
                    sortedInfo.valueColumns = new TreeMap();
                }
                sortedInfo.valueColumns.put(colName, (ColumnInfo)rowInfo.allColumns.get(colName));
            }
        } else {
            for (String colName : available) {
                if (sortedInfo.keyColumns.containsKey(colName)) continue;
                sortedInfo.keyColumns.put(colName, (ColumnInfo)rowInfo.allColumns.get(colName));
            }
        }
        if (sortedInfo.valueColumns == null) {
            sortedInfo.valueColumns = Collections.emptyNavigableMap();
        }
        sortedInfo.allColumns = new TreeMap();
        sortedInfo.allColumns.putAll(sortedInfo.keyColumns);
        sortedInfo.allColumns.putAll(sortedInfo.valueColumns);
        return sortedInfo;
    }

    private static RowDecoder makeDecoder(Class<?> rowType, SecondaryInfo sortedInfo, Set<String> projection) {
        if (projection == null) {
            projection = sortedInfo.allColumns.keySet();
        }
        RowInfo rowInfo = RowInfo.find(rowType);
        RowGen rowGen = rowInfo.rowGen();
        Class<?> rowClass = RowMaker.find(rowType);
        ClassMaker cm = rowGen.anotherClassMaker(SortDecoderMaker.class, rowClass, null).implement(RowDecoder.class).final_();
        cm.addField(RowDecoder.class, "THE").private_().static_();
        MethodMaker mm = cm.addConstructor(new Object[0]).private_();
        mm.invokeSuperConstructor(new Object[0]);
        mm.field("THE").set((Object)mm.this_());
        mm = cm.addMethod(Object.class, "decodeRow", new Object[]{Object.class, byte[].class, byte[].class}).public_();
        Variable rowVar = mm.param(0);
        Variable keyVar = mm.param(1);
        Variable valueVar = mm.param(2);
        Label notRow = mm.label();
        Variable typedRowVar = CodeUtils.castOrNew(rowVar, rowClass, notRow);
        Label hasTypedRow = mm.label();
        typedRowVar.ifNe(null, hasTypedRow);
        typedRowVar.set((Object)mm.new_(rowClass, new Object[0]));
        hasTypedRow.here();
        RowGen sortedRowGen = sortedInfo.rowGen();
        SortDecoderMaker.decodeColumns(projection, mm, typedRowVar, keyVar, sortedRowGen.keyCodecs());
        SortDecoderMaker.decodeColumns(projection, mm, typedRowVar, valueVar, sortedRowGen.valueCodecs());
        ColumnCodec[] keyCodecs = rowGen.keyCodecs();
        ColumnCodec[] valueCodecs = rowGen.valueCodecs();
        int maxNum = rowInfo.allColumns.size();
        int mask = 0;
        int num = 0;
        while (num < maxNum) {
            ColumnCodec codec = num < keyCodecs.length ? keyCodecs[num] : valueCodecs[num - keyCodecs.length];
            if (projection.contains(codec.mInfo.name)) {
                mask |= RowGen.stateFieldMask(num, 1);
            }
            if ((++num & 0xF) != 0 && num < maxNum) continue;
            typedRowVar.field(sortedRowGen.stateField(num - 1)).set((Object)mask);
            mask = 0;
        }
        mm.return_((Object)typedRowVar);
        notRow.here();
        CodeUtils.acceptAsRowConsumerAndReturn(rowVar, rowClass, keyVar, valueVar);
        try {
            MethodHandles.Lookup lookup = cm.finishHidden();
            MethodHandle mh = lookup.findConstructor(lookup.lookupClass(), MethodType.methodType(Void.TYPE));
            return mh.invoke();
        }
        catch (Throwable e) {
            throw RowUtils.rethrow(e);
        }
    }

    private static void decodeColumns(Set<String> projection, MethodMaker mm, Variable rowVar, Variable srcVar, ColumnCodec[] codecs) {
        if (codecs.length != 0) {
            codecs = ColumnCodec.bind(codecs, mm);
            Variable offsetVar = mm.var(Integer.TYPE).set((Object)0);
            for (int i = 0; i < codecs.length; ++i) {
                ColumnCodec codec = codecs[i];
                String name = codec.mInfo.name;
                if (projection.contains(name)) {
                    codec.decode((Variable)rowVar.field(name), srcVar, offsetVar, null);
                    continue;
                }
                if (i >= codecs.length - 1) continue;
                codec.decodeSkip(srcVar, offsetVar, null);
            }
        }
    }

    private record InfoKey(Class<?> rowType, String orderBySpec, Set<String> projection, boolean allowDuplicates) {
        InfoKey withNullProjection() {
            return new InfoKey(this.rowType, this.orderBySpec, null, this.allowDuplicates);
        }
    }

    private record DecoderKey(Class<?> rowType, String sortedInfoSpec, Set<String> projection) {
        DecoderKey withNullProjection() {
            return new DecoderKey(this.rowType, this.sortedInfoSpec, null);
        }
    }
}

