/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.WeakReference;
import org.cojen.maker.Bootstrap;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.rows.ExceptionCallSite;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowStore;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.SecondaryInfo;
import org.cojen.tupl.rows.SwitchCallSite;
import org.cojen.tupl.rows.Transcoder;
import org.cojen.tupl.rows.TransformMaker;

public class SortTranscoderMaker {
    static Transcoder makeTranscoder(RowStore rs, Class<?> rowType, RowInfo rowInfo, long tableId, SecondaryInfo sortedInfo) {
        ClassMaker cm = rowInfo.rowGen().beginClassMaker(SortTranscoderMaker.class, rowType, null).implement(Transcoder.class).final_();
        cm.addField(Transcoder.class, "THE").private_().static_();
        MethodMaker mm = cm.addConstructor(new Object[0]).private_();
        mm.invokeSuperConstructor(new Object[0]);
        mm.field("THE").set((Object)mm.this_());
        mm = cm.addMethod(null, "transcode", new Object[]{byte[].class, byte[].class, byte[][].class, Integer.TYPE});
        mm.public_();
        if (tableId == 0L || rowInfo instanceof SecondaryInfo) {
            SortTranscoderMaker.transcode(mm, rowInfo, sortedInfo, 0);
        } else {
            Variable keyVar = mm.param(0);
            Variable valueVar = mm.param(1);
            Variable kvPairsVar = mm.param(2);
            Variable offsetVar = mm.param(3);
            byte[] targetDesc = RowStore.secondaryDescriptor(sortedInfo, false);
            Bootstrap indy = mm.var(SortTranscoderMaker.class).indy("indyTranscode", new Object[]{rs.ref(), rowType, tableId, targetDesc});
            Variable schemaVersion = mm.var(RowUtils.class).invoke("decodeSchemaVersion", new Object[]{valueVar});
            indy.invoke(null, "transcode", null, new Object[]{schemaVersion, keyVar, valueVar, kvPairsVar, offsetVar});
        }
        try {
            MethodHandles.Lookup lookup = cm.finishHidden();
            MethodHandle mh = lookup.findConstructor(lookup.lookupClass(), MethodType.methodType(Void.TYPE));
            return mh.invoke();
        }
        catch (Throwable e) {
            throw RowUtils.rethrow(e);
        }
    }

    private static <R> void transcode(MethodMaker mm, RowInfo info, RowInfo targetInfo, int sourceOffset) {
        TransformMaker tm = new TransformMaker(null, info, null);
        tm.addKeyTarget(targetInfo, 0, true);
        if (!targetInfo.valueColumns.isEmpty()) {
            tm.addValueTarget(targetInfo, 0, true);
        }
        Variable keyVar = mm.param(0);
        Variable valueVar = mm.param(1);
        Variable kvPairsVar = mm.param(2);
        Variable offsetVar = mm.param(3);
        tm.begin(mm, null, keyVar, valueVar, sourceOffset);
        kvPairsVar.aset((Object)offsetVar, (Object)tm.encode(0));
        offsetVar.inc((Object)1);
        if (!targetInfo.valueColumns.isEmpty()) {
            kvPairsVar.aset((Object)offsetVar, (Object)tm.encode(1));
        } else {
            kvPairsVar.aset((Object)offsetVar, (Object)mm.var(RowUtils.class).field("EMPTY_BYTES"));
        }
    }

    public static SwitchCallSite indyTranscode(MethodHandles.Lookup lookup, String name, MethodType mt, WeakReference<RowStore> storeRef, Class<?> rowType, long indexId, byte[] targetDesc) {
        return new SwitchCallSite(lookup, mt, schemaVersion -> {
            RowInfo sourceInfo;
            MethodType mtx = mt.dropParameterTypes(0, 1);
            RowStore store = (RowStore)storeRef.get();
            if (store == null) {
                MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)lookup, (String)"transcode", (MethodType)mtx);
                mm.new_(DatabaseException.class, new Object[]{"Closed"}).throw_();
                return mm.finish();
            }
            try {
                sourceInfo = store.rowInfo(rowType, indexId, schemaVersion);
            }
            catch (Exception e) {
                MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)lookup, (String)"transcode", (MethodType)mtx);
                return new ExceptionCallSite.Failed(mtx, mm, e);
            }
            MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)lookup, (String)"transcode", (MethodType)mtx);
            SecondaryInfo targetInfo = RowStore.secondaryRowInfo(sourceInfo, targetDesc);
            int sourceOffset = RowUtils.lengthPrefixPF(schemaVersion);
            SortTranscoderMaker.transcode(mm, sourceInfo, targetInfo, sourceOffset);
            return mm.finish();
        });
    }
}

