/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.Comparator;
import java.util.Set;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.Scanner;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Updater;
import org.cojen.tupl.diag.QueryPlan;
import org.cojen.tupl.rows.BaseTable;
import org.cojen.tupl.rows.OrderBy;
import org.cojen.tupl.rows.QueryLauncher;
import org.cojen.tupl.rows.RowDecoder;
import org.cojen.tupl.rows.RowSorter;
import org.cojen.tupl.rows.RowWriter;
import org.cojen.tupl.rows.SecondaryInfo;
import org.cojen.tupl.rows.WrappedUpdater;

final class SortedQueryLauncher<R>
implements QueryLauncher<R> {
    final BaseTable<R> mTable;
    final QueryLauncher<R> mSource;
    final String mSpec;
    final Comparator<R> mComparator;
    SecondaryInfo mSortedInfo;
    RowDecoder<R> mDecoder;
    MethodHandle mWriteRow;

    SortedQueryLauncher(BaseTable<R> table, QueryLauncher<R> source, OrderBy orderBy) {
        this.mTable = table;
        this.mSource = source;
        this.mSpec = orderBy.spec();
        this.mComparator = table.comparator(this.mSpec);
    }

    @Override
    public Scanner<R> newScanner(Transaction txn, R row, Object ... args) throws IOException {
        return RowSorter.sort(this, txn, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Updater<R> newUpdater(Transaction txn, R row, Object ... args) throws IOException {
        Scanner<R> scanner;
        if (txn != null) {
            Scanner<R> scanner2;
            if (txn.lockMode() != LockMode.UNSAFE) {
                txn.enter();
            }
            try {
                scanner2 = this.newScanner(txn, row, args);
                txn.commit();
            }
            finally {
                txn.exit();
            }
            return new WrappedUpdater<R>(this.mTable, txn, scanner2);
        }
        txn = this.mTable.mSource.newTransaction(null);
        try {
            scanner = this.newScanner(txn, row, args);
        }
        catch (Throwable e) {
            txn.exit();
            throw e;
        }
        return new WrappedUpdater.EndCommit<R>(this.mTable, txn, scanner);
    }

    @Override
    public void scanWrite(Transaction txn, RowWriter writer, Object ... args) throws IOException {
        writer.writeCharacteristics(1300, 0L);
        RowSorter.sortWrite(this, writer, txn, args);
    }

    @Override
    public QueryPlan plan(Object ... args) {
        return new QueryPlan.Sort(OrderBy.splitSpec(this.mSpec), this.mSource.plan(args));
    }

    @Override
    public Set<String> projection() {
        return this.mSource.projection();
    }
}

