/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.cojen.maker.Field;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.Index;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.UnmodifiableViewException;
import org.cojen.tupl.core.RowPredicateLock;
import org.cojen.tupl.rows.ArrayKey;
import org.cojen.tupl.rows.AutomaticKeyGenerator;
import org.cojen.tupl.rows.BaseTable;
import org.cojen.tupl.rows.BaseTableIndex;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.ColumnSet;
import org.cojen.tupl.rows.DecodePartialMaker;
import org.cojen.tupl.rows.RowGen;
import org.cojen.tupl.rows.RowStore;
import org.cojen.tupl.rows.RowWriter;
import org.cojen.tupl.rows.SecondaryInfo;
import org.cojen.tupl.rows.TableBasicsMaker;
import org.cojen.tupl.rows.TableMaker;
import org.cojen.tupl.rows.TableManager;
import org.cojen.tupl.rows.Trigger;
import org.cojen.tupl.rows.WeakCache;
import org.cojen.tupl.rows.WriteRowMaker;
import org.cojen.tupl.views.ViewUtils;

class StaticTableMaker
extends TableMaker {
    private static final WeakCache<Object, Class<?>, RowGen> cCache = new WeakCache<Object, Class<?>, RowGen>(){

        @Override
        protected Class<?> newValue(Object key, RowGen rowGen) {
            if (key instanceof Class) {
                Class type = (Class)key;
                return new StaticTableMaker(type, rowGen).finish();
            }
            ArrayKey.ObjPrefixBytes pair = (ArrayKey.ObjPrefixBytes)key;
            Class type = (Class)pair.prefix;
            byte[] secondaryDesc = pair.array;
            SecondaryInfo indexRowInfo = RowStore.secondaryRowInfo(rowGen.info, secondaryDesc);
            indexRowInfo.alternateKeys = Collections.emptyNavigableSet();
            indexRowInfo.secondaryIndexes = Collections.emptyNavigableSet();
            RowGen codecGen = indexRowInfo.rowGen();
            return new StaticTableMaker(type, rowGen, codecGen, secondaryDesc).finish();
        }
    };
    private final ColumnInfo mAutoColumn;

    static Class<?> obtain(Class<?> type, RowGen rowGen) {
        return (Class)cCache.obtain(type, (Object)rowGen);
    }

    static Class<?> obtain(Class<?> type, RowGen rowGen, byte[] secondaryDesc) {
        return (Class)cCache.obtain((Object)ArrayKey.make(type, secondaryDesc), (Object)rowGen);
    }

    private StaticTableMaker(Class<?> type, RowGen rowGen) {
        this(type, rowGen, rowGen, null);
    }

    private StaticTableMaker(Class<?> type, RowGen rowGen, RowGen codecGen, byte[] secondaryDesc) {
        super(type, rowGen, codecGen, secondaryDesc);
        ColumnInfo auto = null;
        if (this.isPrimaryTable()) {
            for (ColumnInfo column : codecGen.info.keyColumns.values()) {
                if (!column.isAutomatic()) continue;
                auto = column;
                break;
            }
        }
        this.mAutoColumn = auto;
    }

    Class<?> finish() {
        MethodMaker mm;
        Class<BaseTable> baseClass;
        String suffix;
        if (this.isPrimaryTable()) {
            suffix = "table";
            baseClass = BaseTable.class;
        } else {
            suffix = "unjoined";
            baseClass = BaseTableIndex.class;
        }
        this.mClassMaker = this.mCodecGen.beginClassMaker(this.getClass(), this.mRowType, suffix).public_().extend(baseClass).implement(TableBasicsMaker.find(this.mRowType));
        if (this.isEvolvable()) {
            this.mClassMaker.abstract_();
        }
        MethodMaker ctor = this.mClassMaker.addConstructor(new Object[]{TableManager.class, Index.class, RowPredicateLock.class});
        ctor.invokeSuperConstructor(new Object[]{ctor.param(0), ctor.param(1), ctor.param(2)});
        if (!this.isEvolvable()) {
            ctor.public_();
        }
        this.addCheckSet("checkPrimaryKeySet", this.mCodecGen.info.keyColumns);
        if (this.isPrimaryTable()) {
            this.addCheckSet("checkAllSet", this.mCodecGen.info.allColumns);
            this.addRequireSet("requireAllSet", this.mCodecGen.info.allColumns);
        }
        int i = 0;
        for (ColumnSet altKey : this.mCodecGen.info.alternateKeys) {
            this.addCheckSet("checkAltKeySet$" + i, altKey.keyColumns);
            ++i;
        }
        if (this.isPrimaryTable() && !this.mCodecGen.info.valueColumns.isEmpty()) {
            this.addCheckAllDirty("checkValueAllDirty", this.mCodecGen.info.valueColumns);
        }
        this.addCheckAnyDirty("checkPrimaryKeyAnyDirty", this.mCodecGen.info.keyColumns);
        this.addCheckAllDirty("checkPrimaryKeyAllDirty", this.mCodecGen.info.keyColumns);
        ColumnCodec[] keyCodecs = this.mCodecGen.keyCodecs();
        this.addEncodeColumnsMethod("encodePrimaryKey", keyCodecs);
        this.addDecodeColumnsMethod("decodePrimaryKey", keyCodecs);
        this.addUpdatePrimaryKeyMethod();
        this.addDecodePartialHandle();
        MethodMaker doEncode = this.mClassMaker.addMethod(byte[].class, "doEncodeValue", new Object[]{this.mRowClass}).protected_();
        MethodMaker doDecode = this.mClassMaker.addMethod(null, "doDecodeValue", new Object[]{this.mRowClass, byte[].class}).protected_();
        if (this.isEvolvable()) {
            doEncode.abstract_();
            doDecode.abstract_();
        } else {
            if (this.isPrimaryTable()) {
                this.addEncodeColumnsMethod("encodeValue", this.mCodecGen.valueCodecs());
                this.addUpdateValueMethod(0);
            } else {
                this.mClassMaker.addMethod(byte[].class, "encodeValue", new Object[]{this.mRowClass}).static_().new_(UnmodifiableViewException.class, new Object[0]).throw_();
                this.mClassMaker.addMethod(byte[].class, "updateValue", new Object[]{this.mRowClass, byte[].class}).static_().new_(UnmodifiableViewException.class, new Object[0]).throw_();
            }
            this.addDecodeColumnsMethod("decodeValue", this.mCodecGen.valueCodecs());
            doEncode.return_((Object)doEncode.invoke("encodeValue", new Object[]{doEncode.param(0)}));
            doDecode.invoke("decodeValue", new Object[]{doDecode.param(0), doDecode.param(1)});
        }
        if (this.mAutoColumn != null) {
            Number maxVal;
            Number minVal;
            Class autoGenApplierClass;
            Class autoGenClass;
            if (this.mAutoColumn.type == Integer.TYPE) {
                autoGenClass = this.mAutoColumn.isUnsigned() ? AutomaticKeyGenerator.OfUInt.class : AutomaticKeyGenerator.OfInt.class;
                autoGenApplierClass = AutomaticKeyGenerator.OfInt.Applier.class;
                minVal = (int)Math.max(this.mAutoColumn.autoMin, Integer.MIN_VALUE);
                maxVal = (int)Math.min(this.mAutoColumn.autoMax, Integer.MAX_VALUE);
            } else {
                autoGenClass = this.mAutoColumn.isUnsigned() ? AutomaticKeyGenerator.OfULong.class : AutomaticKeyGenerator.OfLong.class;
                autoGenApplierClass = AutomaticKeyGenerator.OfLong.Applier.class;
                minVal = this.mAutoColumn.autoMin;
                maxVal = this.mAutoColumn.autoMax;
            }
            this.mClassMaker.implement(autoGenApplierClass);
            this.mClassMaker.addField(autoGenClass, "autogen").final_();
            ctor.field("autogen").set((Object)ctor.new_(autoGenClass, new Object[]{ctor.param(1), minVal, maxVal, ctor.this_()}));
            MethodMaker mm2 = this.mClassMaker.addMethod(RowPredicateLock.Closer.class, "applyToRow", new Object[]{Transaction.class, Object.class, this.mAutoColumn.type});
            mm2.public_();
            Variable rowVar = mm2.param(1).cast((Object)this.mRowClass);
            rowVar.field(this.mAutoColumn.name).set((Object)mm2.param(2));
            mm2.return_((Object)mm2.field("mIndexLock").invoke("tryOpenAcquire", new Object[]{mm2.param(0), rowVar, null, null}));
            mm2 = this.mClassMaker.addMethod(RowPredicateLock.Closer.class, "tryOpenAcquire", new Object[]{Transaction.class, byte[].class, byte[].class});
            mm2.public_();
            mm2.return_((Object)mm2.field("mIndexLock").invoke("tryOpenAcquire", new Object[]{mm2.param(0), null, mm2.param(1), mm2.param(2)}));
            TreeMap<String, ColumnInfo> allButAuto = new TreeMap<String, ColumnInfo>(this.mCodecGen.info.allColumns);
            allButAuto.remove(this.mAutoColumn.name);
            this.addCheckSet("checkAllButAutoSet", allButAuto);
            this.addStoreAutoMethod();
        }
        this.addByKeyMethod("load");
        this.addByKeyMethod("exists");
        if (this.isPrimaryTable()) {
            this.addByKeyMethod("delete");
            this.addStoreMethod("store", null);
            this.addStoreMethod("exchange", this.mRowType);
            this.addStoreMethod("insert", Boolean.TYPE);
            this.addStoreMethod("replace", Boolean.TYPE);
            mm = this.mClassMaker.addMethod(Boolean.TYPE, "doUpdate", new Object[]{Transaction.class, this.mRowClass, Boolean.TYPE}).protected_();
            if (this.isEvolvable()) {
                mm.abstract_();
            } else {
                this.addDoUpdateMethod(mm);
            }
            this.addUpdateMethod("update", false);
            this.addUpdateMethod("merge", true);
        }
        this.addMarkAllCleanMethod();
        this.addToRowMethod();
        this.addPlanMethod(0);
        this.addPlanMethod(1);
        if (!this.isPrimaryTable()) {
            this.addSecondaryDescriptorMethod();
        } else if (!this.isEvolvable()) {
            this.addUnfilteredMethods(0L);
        }
        if (!this.isEvolvable()) {
            mm = this.mClassMaker.addMethod(null, "writeRow", new Object[]{RowWriter.class, byte[].class, byte[].class}).static_();
            WriteRowMaker.makeWriteRow(mm, this.mRowInfo, 0, null);
        }
        return this.mClassMaker.finish();
    }

    private void addCheckSet(String name, Map<String, ColumnInfo> columns) {
        MethodMaker mm = this.mClassMaker.addMethod(Boolean.TYPE, name, new Object[]{this.mRowClass}).static_();
        this.mRowGen.checkSet(mm, columns, mm.param(0));
    }

    private void addCheckAllDirty(String name, Map<String, ColumnInfo> columns) {
        MethodMaker mm = this.mClassMaker.addMethod(Boolean.TYPE, name, new Object[]{this.mRowClass}).static_();
        this.mRowGen.checkDirty(mm, columns, mm.param(0));
    }

    private void addCheckAnyDirty(String name, Map<String, ColumnInfo> columns) {
        MethodMaker mm = this.mClassMaker.addMethod(Boolean.TYPE, name, new Object[]{this.mRowClass}).static_();
        this.mRowGen.checkAnyDirty(mm, columns, mm.param(0));
    }

    private void addRequireSet(String name, Map<String, ColumnInfo> columns) {
        MethodMaker mm = this.mClassMaker.addMethod(null, name, new Object[]{this.mRowClass}).static_();
        this.mRowGen.requireSet(mm, columns, mm.param(0));
    }

    private void addUpdatePrimaryKeyMethod() {
        MethodMaker mm = this.mClassMaker.addMethod(byte[].class, "updatePrimaryKey", new Object[]{this.mRowClass, byte[].class}).static_();
        Variable rowVar = mm.param(0);
        Label partiallyDirty = mm.label();
        mm.invoke("checkPrimaryKeyAllDirty", new Object[]{rowVar}).ifFalse(partiallyDirty);
        mm.return_((Object)mm.invoke("encodePrimaryKey", new Object[]{rowVar}));
        partiallyDirty.here();
        Variable tableVar = mm.class_();
        TableMaker.UpdateEntry ue = StaticTableMaker.encodeUpdateKey(mm, this.mRowInfo, tableVar, rowVar, mm.param(1));
        mm.return_((Object)ue.newEntryVar);
    }

    private void addUpdateValueMethod(int schemaVersion) {
        MethodMaker mm = this.mClassMaker.addMethod(byte[].class, "updateValue", new Object[]{this.mRowClass, byte[].class}).static_();
        Variable rowVar = mm.param(0);
        Label partiallyDirty = mm.label();
        mm.invoke("checkValueAllDirty", new Object[]{rowVar}).ifFalse(partiallyDirty);
        mm.return_((Object)mm.invoke("encodeValue", new Object[]{rowVar}));
        partiallyDirty.here();
        Variable tableVar = mm.class_();
        TableMaker.UpdateEntry ue = StaticTableMaker.encodeUpdateValue(mm, this.mRowInfo, schemaVersion, tableVar, rowVar, mm.param(1));
        mm.return_((Object)ue.newEntryVar);
    }

    @Override
    protected void finishDoUpdate(MethodMaker mm, Variable rowVar, Variable mergeVar, Variable cursorVar) {
        StaticTableMaker.finishDoUpdate(mm, this.mRowInfo, 0, this.supportsTriggers() ? 1 : 0, true, mm.this_(), rowVar, mergeVar, cursorVar);
    }

    private void addDecodePartialHandle() {
        Variable decoder;
        MethodMaker mm = this.mClassMaker.addMethod(MethodHandle.class, "makeDecodePartialHandle", new Object[]{byte[].class, Integer.TYPE}).protected_();
        Variable spec = mm.param(0);
        Variable lookup = mm.var(MethodHandles.class).invoke("lookup", new Object[0]);
        if (this.isEvolvable()) {
            Variable schemaVersion = mm.param(1);
            Variable storeRefVar = mm.invoke("rowStoreRef", new Object[0]);
            Variable thisClassVar = mm.invoke("getClass", new Object[0]);
            Variable tableIdVar = mm.field("mSource").invoke("id", new Object[0]);
            decoder = mm.var(DecodePartialMaker.class).invoke("makeDecoder", new Object[]{lookup, storeRefVar, this.mRowType, this.mRowClass, thisClassVar, tableIdVar, spec, schemaVersion});
        } else {
            Variable thisClassVar = mm.invoke("getClass", new Object[0]);
            Variable secondaryDescVar = mm.var(byte[].class).setExact((Object)this.mSecondaryDescriptor);
            decoder = mm.var(DecodePartialMaker.class).invoke("makeDecoder", new Object[]{lookup, this.mRowType, this.mRowClass, thisClassVar, secondaryDescVar, spec});
        }
        mm.return_((Object)decoder);
    }

    private void addByKeyMethod(String variant) {
        Variable valueVar;
        MethodMaker mm = this.mClassMaker.addMethod(Boolean.TYPE, variant, new Object[]{Transaction.class, Object.class}).public_();
        Variable txnVar = mm.param(0);
        Variable rowVar = mm.param(1).cast((Object)this.mRowClass);
        Label ready = mm.label();
        mm.invoke("checkPrimaryKeySet", new Object[]{rowVar}).ifTrue(ready);
        mm.new_(IllegalStateException.class, new Object[]{"Primary key isn't fully specified"}).throw_();
        ready.here();
        Variable keyVar = mm.invoke("encodePrimaryKey", new Object[]{rowVar});
        Field source = mm.field("mSource");
        if (variant != "delete" || !this.supportsTriggers()) {
            valueVar = source.invoke(variant, new Object[]{txnVar, keyVar});
        } else {
            Variable triggerVar = mm.var(Trigger.class);
            Label skipLabel = mm.label();
            StaticTableMaker.prepareForTrigger(mm, mm.this_(), triggerVar, skipLabel);
            Label triggerStart = mm.label().here();
            txnVar.set((Object)mm.var(ViewUtils.class).invoke("enterScope", new Object[]{source, txnVar}));
            Label txnStart = mm.label().here();
            Variable cursorVar = source.invoke("newCursor", new Object[]{txnVar});
            Label cursorStart = mm.label().here();
            cursorVar.invoke("find", new Object[]{keyVar});
            Variable oldValueVar = cursorVar.invoke("value", new Object[0]);
            Label commit = mm.label();
            oldValueVar.ifEq(null, commit);
            triggerVar.invoke("delete", new Object[]{txnVar, rowVar, keyVar, oldValueVar});
            commit.here();
            cursorVar.invoke("commit", new Object[]{null});
            mm.return_((Object)oldValueVar.ne(null));
            mm.finally_(cursorStart, () -> cursorVar.invoke("reset", new Object[0]));
            mm.finally_(txnStart, () -> txnVar.invoke("exit", new Object[0]));
            skipLabel.here();
            assert (variant == "delete");
            valueVar = source.invoke(variant, new Object[]{txnVar, keyVar});
            mm.finally_(triggerStart, () -> triggerVar.invoke("releaseShared", new Object[0]));
        }
        if (variant != "load") {
            mm.return_((Object)valueVar);
        } else {
            Label notNull = mm.label();
            valueVar.ifNe(null, notNull);
            this.markValuesUnset(rowVar);
            mm.return_((Object)false);
            notNull.here();
            mm.invoke("doDecodeValue", new Object[]{rowVar, valueVar});
            this.markAllClean(rowVar);
            mm.return_((Object)true);
        }
    }

    private void addStoreMethod(String variant, Class returnType) {
        MethodMaker mm = this.mClassMaker.addMethod((Object)returnType, variant, new Object[]{Transaction.class, Object.class}).public_();
        Variable txnVar = mm.param(0);
        Variable rowVar = mm.param(1).cast((Object)this.mRowClass);
        Label ready = mm.label();
        mm.invoke("checkAllSet", new Object[]{rowVar}).ifTrue(ready);
        if (variant != "replace" && this.mAutoColumn != null) {
            Label notReady = mm.label();
            mm.invoke("checkAllButAutoSet", new Object[]{rowVar}).ifFalse(notReady);
            mm.invoke("storeAuto", new Object[]{txnVar, rowVar});
            if (variant == "exchange") {
                mm.return_(null);
            } else if (variant == "insert") {
                mm.return_((Object)true);
            } else {
                mm.return_();
            }
            notReady.here();
        }
        mm.invoke("requireAllSet", new Object[]{rowVar});
        ready.here();
        Variable keyVar = mm.invoke("encodePrimaryKey", new Object[]{rowVar});
        Variable valueVar = mm.invoke("doEncodeValue", new Object[]{rowVar});
        Variable resultVar = null;
        if (!this.supportsTriggers()) {
            resultVar = this.storeNoTrigger(mm, variant, txnVar, rowVar, keyVar, valueVar);
        } else {
            Label cont = mm.label();
            Variable triggerVar = mm.var(Trigger.class);
            Label skipLabel = mm.label();
            StaticTableMaker.prepareForTrigger(mm, mm.this_(), triggerVar, skipLabel);
            Label triggerStart = mm.label().here();
            Variable source = mm.field("mSource").get();
            txnVar.set((Object)mm.var(ViewUtils.class).invoke("enterScope", new Object[]{source, txnVar}));
            Label txnStart = mm.label().here();
            Variable cursorVar = source.invoke("newCursor", new Object[]{txnVar});
            Label cursorStart = mm.label().here();
            if (variant == "replace") {
                cursorVar.invoke("find", new Object[]{keyVar});
                Variable oldValueVar = cursorVar.invoke("value", new Object[0]);
                Label passed = mm.label();
                oldValueVar.ifNe(null, passed);
                mm.return_((Object)false);
                passed.here();
                cursorVar.invoke("store", new Object[]{valueVar});
                mm.invoke("redoPredicateMode", new Object[]{txnVar});
                triggerVar.invoke("store", new Object[]{txnVar, rowVar, keyVar, oldValueVar, valueVar});
                txnVar.invoke("commit", new Object[0]);
                this.markAllClean(rowVar);
                mm.return_((Object)true);
            } else {
                mm.invoke("redoPredicateMode", new Object[]{txnVar});
                Variable closerVar = mm.field("mIndexLock").invoke("openAcquire", new Object[]{txnVar, rowVar});
                Label opStart = mm.label().here();
                if (variant == "insert") {
                    cursorVar.invoke("autoload", new Object[]{false});
                    cursorVar.invoke("find", new Object[]{keyVar});
                    mm.finally_(opStart, () -> closerVar.invoke("close", new Object[0]));
                    Label passed = mm.label();
                    cursorVar.invoke("value", new Object[0]).ifEq(null, passed);
                    mm.return_((Object)false);
                    passed.here();
                    triggerVar.invoke("insert", new Object[]{txnVar, rowVar, keyVar, valueVar});
                    cursorVar.invoke("commit", new Object[]{valueVar});
                    this.markAllClean(rowVar);
                    mm.return_((Object)true);
                } else {
                    cursorVar.invoke("find", new Object[]{keyVar});
                    mm.finally_(opStart, () -> closerVar.invoke("close", new Object[0]));
                    Variable oldValueVar = cursorVar.invoke("value", new Object[0]);
                    Label wasNull = mm.label();
                    oldValueVar.ifEq(null, wasNull);
                    triggerVar.invoke("store", new Object[]{txnVar, rowVar, keyVar, oldValueVar, valueVar});
                    Label commit = mm.label().goto_();
                    wasNull.here();
                    triggerVar.invoke("insert", new Object[]{txnVar, rowVar, keyVar, valueVar});
                    commit.here();
                    cursorVar.invoke("commit", new Object[]{valueVar});
                    if (variant == "store") {
                        this.markAllClean(rowVar);
                        mm.return_();
                    } else {
                        resultVar = oldValueVar;
                        mm.goto_(cont);
                    }
                }
            }
            mm.finally_(cursorStart, () -> cursorVar.invoke("reset", new Object[0]));
            mm.finally_(txnStart, () -> txnVar.invoke("exit", new Object[0]));
            skipLabel.here();
            Variable storeResultVar = this.storeNoTrigger(mm, variant, txnVar, rowVar, keyVar, valueVar);
            if (resultVar == null) {
                resultVar = storeResultVar;
            } else {
                resultVar.set((Object)storeResultVar);
            }
            mm.finally_(triggerStart, () -> triggerVar.invoke("releaseShared", new Object[0]));
            cont.here();
        }
        if (returnType == null) {
            this.markAllClean(rowVar);
            return;
        }
        if (variant != "exchange") {
            Label failed = mm.label();
            resultVar.ifFalse(failed);
            this.markAllClean(rowVar);
            failed.here();
            mm.return_((Object)resultVar);
            return;
        }
        this.markAllClean(rowVar);
        Label found = mm.label();
        resultVar.ifNe(null, found);
        mm.return_(null);
        found.here();
        Variable copyVar = mm.new_((Object)this.mRowClass, new Object[0]);
        StaticTableMaker.copyFields(rowVar, copyVar, this.mCodecGen.info.keyColumns.values());
        mm.invoke("doDecodeValue", new Object[]{copyVar, resultVar});
        this.markAllClean(copyVar);
        mm.return_((Object)copyVar);
        mm = this.mClassMaker.addMethod(Object.class, variant, new Object[]{Transaction.class, Object.class}).public_().bridge();
        mm.return_((Object)mm.this_().invoke((Object)returnType, variant, null, new Object[]{mm.param(0), mm.param(1)}));
    }

    private Variable storeNoTrigger(MethodMaker mm, String variant, Variable txnVar, Variable rowVar, Variable keyVar, Variable valueVar) {
        return mm.invoke(variant + "NoTrigger", new Object[]{txnVar, rowVar, keyVar, valueVar});
    }

    private void addStoreAutoMethod() {
        MethodMaker mm = this.mClassMaker.addMethod(null, "storeAuto", new Object[]{Transaction.class, this.mRowClass});
        Variable txnVar = mm.param(0);
        Variable rowVar = mm.param(1);
        Variable keyVar = mm.invoke("encodePrimaryKey", new Object[]{rowVar});
        Variable valueVar = mm.invoke("doEncodeValue", new Object[]{rowVar});
        txnVar.set((Object)mm.var(ViewUtils.class).invoke("enterScopex", new Object[]{mm.field("mSource"), txnVar}));
        Label txnStart = mm.label().here();
        mm.invoke("redoPredicateMode", new Object[]{txnVar});
        if (!this.supportsTriggers()) {
            mm.field("autogen").invoke("store", new Object[]{txnVar, rowVar, keyVar, valueVar});
            txnVar.invoke("commit", new Object[0]);
            this.markAllClean(rowVar);
            mm.return_();
        } else {
            Variable triggerVar = mm.var(Trigger.class);
            Label skipLabel = mm.label();
            StaticTableMaker.prepareForTrigger(mm, mm.this_(), triggerVar, skipLabel);
            Label triggerStart = mm.label().here();
            mm.field("autogen").invoke("store", new Object[]{txnVar, rowVar, keyVar, valueVar});
            triggerVar.invoke("insert", new Object[]{txnVar, rowVar, keyVar, valueVar});
            Label commitLabel = mm.label().goto_();
            skipLabel.here();
            mm.field("autogen").invoke("store", new Object[]{txnVar, rowVar, keyVar, valueVar});
            commitLabel.here();
            txnVar.invoke("commit", new Object[0]);
            this.markAllClean(rowVar);
            mm.return_();
            mm.finally_(triggerStart, () -> triggerVar.invoke("releaseShared", new Object[0]));
        }
        mm.finally_(txnStart, () -> txnVar.invoke("exit", new Object[0]));
    }

    private void addUpdateMethod(String variant, boolean merge) {
        MethodMaker mm = this.mClassMaker.addMethod(Boolean.TYPE, variant, new Object[]{Transaction.class, Object.class}).public_();
        Variable txnVar = mm.param(0);
        Variable rowVar = mm.param(1).cast((Object)this.mRowClass);
        Field source = mm.field("mSource");
        txnVar.set((Object)mm.var(ViewUtils.class).invoke("enterScope", new Object[]{source, txnVar}));
        Label tryStart = mm.label().here();
        mm.return_((Object)mm.invoke("doUpdate", new Object[]{txnVar, rowVar, merge}));
        mm.finally_(tryStart, () -> txnVar.invoke("exit", new Object[0]));
    }

    private void addMarkAllCleanMethod() {
        MethodMaker mm = this.mClassMaker.addMethod(null, "markAllClean", new Object[]{this.mRowClass}).public_().static_();
        this.markAllClean(mm.param(0));
    }

    private void addToRowMethod() {
        MethodMaker mm = this.mClassMaker.addMethod((Object)this.mRowType, "toRow", new Object[]{byte[].class}).protected_();
        Variable rowVar = mm.new_((Object)this.mRowClass, new Object[0]);
        mm.invoke("decodePrimaryKey", new Object[]{rowVar, mm.param(0)});
        StaticTableMaker.markClean(rowVar, this.mRowGen, this.mCodecGen.info.keyColumns);
        mm.return_((Object)rowVar);
        mm = this.mClassMaker.addMethod(Object.class, "toRow", new Object[]{byte[].class}).protected_().bridge();
        mm.return_((Object)mm.this_().invoke((Object)this.mRowType, "toRow", null, new Object[]{mm.param(0)}));
    }

    private void addSecondaryDescriptorMethod() {
        MethodMaker mm = this.mClassMaker.addMethod(byte[].class, "secondaryDescriptor", new Object[0]).protected_();
        mm.return_((Object)mm.var(byte[].class).setExact((Object)this.mSecondaryDescriptor));
    }
}

