/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.VarHandle;
import java.util.function.IntFunction;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.ExceptionCallSite;

public class SwitchCallSite
extends MutableCallSite {
    private static final int MAX_CASES = 100;
    private final IntFunction<Object> mGenerator;
    private Entry[] mEntries;
    private int mSize;

    SwitchCallSite(MethodHandles.Lookup lookup, MethodType mt, IntFunction<Object> generator) {
        super(mt);
        this.mGenerator = generator;
        this.makeDelegator(lookup);
    }

    private synchronized MethodHandle makeDelegator(MethodHandles.Lookup lookup) {
        MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)lookup, (String)"switch", (MethodType)this.type());
        if (this.mSize == 0) {
            this.makeDefault(mm);
        } else {
            MethodType mt = this.type().dropParameterTypes(0, 1);
            Object[] remainingParams = new Object[mt.parameterCount()];
            for (int i = 0; i < remainingParams.length; ++i) {
                remainingParams[i] = mm.param(i + 1);
            }
            Variable keyVar = mm.param(0);
            if (this.mSize >= 100) {
                Variable dcsVar = mm.var(SwitchCallSite.class).setExact((Object)this);
                Variable caseVar = dcsVar.invoke("findCase", new Object[]{keyVar});
                Label found = mm.label();
                caseVar.ifNe(null, found);
                caseVar.set((Object)dcsVar.invoke("newCaseDirect", new Object[]{keyVar}));
                found.here();
                mm.return_((Object)caseVar.invoke((Object)mt.returnType(), "invokeExact", null, remainingParams));
                MethodHandle mh = mm.finish();
                this.setTarget(mh);
                return mh;
            }
            int[] cases = new int[this.mSize];
            Label[] labels = new Label[cases.length];
            Label defLabel = mm.label();
            int num = 0;
            for (Entry e : this.mEntries) {
                while (e != null) {
                    cases[num] = e.key;
                    labels[num++] = mm.label();
                    e = e.next;
                }
            }
            keyVar.switch_(defLabel, cases, labels);
            for (int i = 0; i < cases.length; ++i) {
                labels[i].here();
                Variable result = mm.invoke(this.findCase(cases[i]), remainingParams);
                if (result == null) {
                    mm.return_();
                    continue;
                }
                mm.return_((Object)result);
            }
            defLabel.here();
            MethodMaker defMaker = mm.classMaker().addMethod("default", this.type());
            defMaker.static_().private_();
            this.makeDefault(defMaker);
            Object[] allParams = new Object[this.type().parameterCount()];
            for (int i = 0; i < allParams.length; ++i) {
                allParams[i] = mm.param(i);
            }
            Variable result = mm.invoke("default", allParams);
            if (result == null) {
                mm.return_();
            } else {
                mm.return_((Object)result);
            }
        }
        MethodHandle mh = mm.finish();
        this.setTarget(mh);
        return mh;
    }

    private void makeDefault(MethodMaker mm) {
        Variable scsVar = mm.var(SwitchCallSite.class).setExact((Object)this);
        Variable lookupVar = mm.var(MethodHandles.class).invoke("lookup", new Object[0]);
        Variable newCaseVar = scsVar.invoke("newCase", new Object[]{lookupVar, mm.param(0)});
        Object[] allParams = new Object[this.type().parameterCount()];
        for (int i = 0; i < allParams.length; ++i) {
            allParams[i] = mm.param(i);
        }
        Variable result = newCaseVar.invoke((Object)this.type().returnType(), "invokeExact", null, allParams);
        if (result == null) {
            mm.return_();
        } else {
            mm.return_((Object)result);
        }
    }

    public synchronized MethodHandle newCase(MethodHandles.Lookup lookup, int key) {
        if (this.mEntries != null && this.findCase(key) != null) {
            return this.getTarget();
        }
        CallSite cs = ExceptionCallSite.make(() -> this.mGenerator.apply(key));
        this.putCase(key, cs.dynamicInvoker());
        return this.makeDelegator(lookup);
    }

    public synchronized MethodHandle newCaseDirect(int key) {
        MethodHandle caseHandle = this.findCase(key);
        if (caseHandle == null) {
            CallSite cs = ExceptionCallSite.make(() -> this.mGenerator.apply(key));
            caseHandle = cs.dynamicInvoker();
            this.putCase(key, caseHandle);
        }
        return caseHandle;
    }

    public MethodHandle findCase(int key) {
        Entry[] entries = this.mEntries;
        if (entries != null) {
            Entry e = entries[key & entries.length - 1];
            while (e != null) {
                if (e.key == key) {
                    return e.mh;
                }
                e = e.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodHandle getCase(MethodHandles.Lookup lookup, int key) {
        MethodHandle mh = this.findCase(key);
        if (mh == null) {
            SwitchCallSite switchCallSite = this;
            synchronized (switchCallSite) {
                if (this.mSize < 100) {
                    this.newCase(lookup, key);
                    mh = this.findCase(key);
                } else {
                    mh = this.newCaseDirect(key);
                }
            }
        }
        return mh;
    }

    private void putCase(int key, MethodHandle mh) {
        Entry[] entries = this.mEntries;
        if (entries == null) {
            this.mEntries = entries = new Entry[4];
        } else if (this.mSize >= entries.length) {
            Entry[] newEntries = new Entry[entries.length << 1];
            int i = entries.length;
            while (--i >= 0) {
                Entry e = entries[i];
                while (e != null) {
                    Entry next = e.next;
                    int index = e.key & newEntries.length - 1;
                    e.next = newEntries[index];
                    newEntries[index] = e;
                    e = next;
                }
            }
            entries = newEntries;
            this.mEntries = newEntries;
        }
        int index = key & entries.length - 1;
        Entry e = new Entry(key, mh);
        e.next = entries[index];
        VarHandle.storeStoreFence();
        entries[index] = e;
        ++this.mSize;
    }

    private static class Entry {
        final int key;
        final MethodHandle mh;
        Entry next;

        Entry(int key, MethodHandle mh) {
            this.key = key;
            this.mh = mh;
        }
    }
}

