/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import org.cojen.maker.ClassMaker;
import org.cojen.maker.Field;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.Table;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.RowGen;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowMaker;
import org.cojen.tupl.rows.WeakClassCache;

class TableBasicsMaker {
    private static final WeakClassCache<Class<?>> cCache = new WeakClassCache();

    TableBasicsMaker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> find(Class<?> rowType) {
        Class<?> clazz = (Class<?>)cCache.get(rowType);
        if (clazz == null) {
            WeakClassCache<Class<?>> weakClassCache = cCache;
            synchronized (weakClassCache) {
                clazz = (Class)cCache.get(rowType);
                if (clazz == null) {
                    clazz = TableBasicsMaker.make(rowType, RowInfo.find(rowType).rowGen());
                    cCache.put(rowType, (Object)clazz);
                }
            }
        }
        return clazz;
    }

    private static Class<?> make(Class<?> rowType, RowGen rowGen) {
        Class<?> rowClass = RowMaker.find(rowType);
        ClassMaker cm = rowGen.beginClassMaker(TableBasicsMaker.class, rowType, "basics").interface_().implement(Table.class);
        cm.addMethod(Class.class, "rowType", new Object[0]).public_().return_(rowType);
        MethodMaker mm = cm.addMethod(rowType, "newRow", new Object[0]).public_();
        mm.return_((Object)mm.new_(rowClass, new Object[0]));
        mm = cm.addMethod(Object.class, "newRow", new Object[0]).public_().bridge();
        mm.return_((Object)mm.this_().invoke(rowType, "newRow", null, new Object[0]));
        mm = cm.addMethod(rowType, "cloneRow", new Object[]{Object.class}).public_();
        mm.return_((Object)mm.param(0).cast(rowClass).invoke("clone", new Object[0]));
        mm = cm.addMethod(Object.class, "cloneRow", new Object[]{Object.class}).public_().bridge();
        mm.return_((Object)mm.this_().invoke(rowType, "cloneRow", null, new Object[]{mm.param(0)}));
        mm = cm.addMethod(null, "unsetRow", new Object[]{Object.class}).public_();
        Variable rowVar = mm.param(0).cast(rowClass);
        for (ColumnInfo info : rowGen.info.allColumns.values()) {
            Field field = rowVar.field(info.name);
            if (info.type.isPrimitive()) continue;
            field.set(null);
        }
        for (String name : rowGen.stateFields()) {
            rowVar.field(name).set((Object)0);
        }
        mm = cm.addMethod(null, "copyRow", new Object[]{Object.class, Object.class}).public_();
        Variable srcRowVar = mm.param(0).cast(rowClass);
        Variable dstRowVar = mm.param(1).cast(rowClass);
        for (ColumnInfo info : rowGen.info.allColumns.values()) {
            dstRowVar.field(info.name).set((Object)srcRowVar.field(info.name));
        }
        for (String name : rowGen.stateFields()) {
            dstRowVar.field(name).set((Object)srcRowVar.field(name));
        }
        return cm.finish();
    }
}

