/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collection;
import java.util.Map;
import org.cojen.maker.Bootstrap;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.Field;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.Entry;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.diag.QueryPlan;
import org.cojen.tupl.rows.CodeUtils;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.Converter;
import org.cojen.tupl.rows.RowGen;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowMaker;
import org.cojen.tupl.rows.RowStore;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.RowWriter;
import org.cojen.tupl.rows.SingleScanController;
import org.cojen.tupl.rows.Trigger;

public class TableMaker {
    protected final Class<?> mRowType;
    protected final RowGen mRowGen;
    protected final RowInfo mRowInfo;
    protected final RowGen mCodecGen;
    protected final Class<?> mRowClass;
    protected final byte[] mSecondaryDescriptor;
    protected ClassMaker mClassMaker;

    TableMaker(Class<?> type, RowGen rowGen, RowGen codecGen, byte[] secondaryDesc) {
        this.mRowType = type;
        this.mRowGen = rowGen;
        this.mRowInfo = rowGen.info;
        this.mCodecGen = codecGen;
        this.mRowClass = RowMaker.find(type);
        this.mSecondaryDescriptor = secondaryDesc;
    }

    protected MethodHandle doFinish(MethodType mt) {
        try {
            MethodHandles.Lookup lookup = this.mClassMaker.finishLookup();
            return lookup.findConstructor(lookup.lookupClass(), mt);
        }
        catch (Throwable e) {
            throw RowUtils.rethrow(e);
        }
    }

    protected boolean isPrimaryTable() {
        return this.mRowGen == this.mCodecGen;
    }

    protected boolean supportsTriggers() {
        return this.isEvolvable();
    }

    protected boolean isEvolvable() {
        return this.isPrimaryTable() && this.mRowType != Entry.class;
    }

    protected static Field findField(Variable row, ColumnCodec codec) {
        ColumnInfo info = codec.mInfo;
        return info == null ? null : row.field(info.name);
    }

    protected static void copyFields(Variable srcRow, Variable dstRow, Collection<ColumnInfo> infos) {
        for (ColumnInfo info : infos) {
            Field srcField = srcRow.field(info.name);
            if (info.isArray()) {
                srcField = srcField.get();
                Label isNull = null;
                if (info.isNullable()) {
                    isNull = srcRow.methodMaker().label();
                    srcField.ifEq(null, isNull);
                }
                srcField.set((Object)srcField.invoke("clone", new Object[0]).cast(info.type));
                if (isNull != null) {
                    isNull.here();
                }
            }
            dstRow.field(info.name).set((Object)srcField);
        }
    }

    protected void markAllClean(Variable rowVar) {
        TableMaker.markAllClean(rowVar, this.mRowGen, this.mCodecGen);
    }

    protected static void markAllClean(Variable rowVar, RowGen rowGen, RowGen codecGen) {
        if (rowGen == codecGen) {
            int i;
            int mask = 0x55555555;
            String[] stateFields = rowGen.stateFields();
            for (i = 0; i < stateFields.length - 1; ++i) {
                rowVar.field(stateFields[i]).set((Object)mask);
            }
            rowVar.field(stateFields[i]).set((Object)(mask >>>= 32 - ((rowGen.info.allColumns.size() & 0xF) << 1)));
        } else {
            TableMaker.markClean(rowVar, rowGen, codecGen.info.allColumns);
        }
    }

    protected static void markClean(Variable rowVar, RowGen rowGen, Map<String, ColumnInfo> columns) {
        int maxNum = rowGen.info.allColumns.size();
        int num = 0;
        int mask = 0;
        for (int step = 0; step < 2; ++step) {
            ColumnCodec[] baseCodecs;
            for (ColumnCodec codec : baseCodecs = step == 0 ? rowGen.keyCodecs() : rowGen.valueCodecs()) {
                if (columns.containsKey(codec.mInfo.name)) {
                    mask |= RowGen.stateFieldMask(num, 1);
                }
                if ((++num & 0xF) != 0 && num < maxNum) continue;
                rowVar.field(rowGen.stateField(num - 1)).set((Object)mask);
                mask = 0;
            }
        }
    }

    protected static void markAllUndirty(Variable rowVar, RowInfo info) {
        Field field;
        int i;
        int mask = 0x55555555;
        String[] stateFields = info.rowGen().stateFields();
        for (i = 0; i < stateFields.length - 1; ++i) {
            field = rowVar.field(stateFields[i]);
            field.set((Object)field.and((Object)mask));
        }
        field = rowVar.field(stateFields[i]);
        field.set((Object)field.and((Object)(mask >>>= 32 - ((info.allColumns.size() & 0xF) << 1))));
    }

    protected void markValuesUnset(Variable rowVar) {
        if (this.isPrimaryTable()) {
            this.mRowGen.markNonPrimaryKeyColumnsUnset(rowVar);
            return;
        }
        Map keyColumns = this.mCodecGen.info.keyColumns;
        int maxNum = this.mRowInfo.allColumns.size();
        int num = 0;
        int mask = 0;
        for (int step = 0; step < 2; ++step) {
            ColumnCodec[] baseCodecs;
            for (ColumnCodec codec : baseCodecs = step == 0 ? this.mRowGen.keyCodecs() : this.mRowGen.valueCodecs()) {
                if (!keyColumns.containsKey(codec.mInfo.name)) {
                    mask |= RowGen.stateFieldMask(num);
                }
                if ((++num & 0xF) != 0 && num < maxNum) continue;
                Field field = rowVar.field(this.mRowGen.stateField(num - 1));
                if ((mask ^= 0xFFFFFFFF) == 0) {
                    field.set((Object)mask);
                    continue;
                }
                field.set((Object)field.and((Object)mask));
                mask = 0;
            }
        }
    }

    protected static void prepareForTrigger(MethodMaker mm, Variable tableVar, Variable triggerVar, Label skipLabel) {
        Label acquireTriggerLabel = mm.label().here();
        triggerVar.set((Object)tableVar.invoke("trigger", new Object[0]));
        triggerVar.invoke("acquireShared", new Object[0]);
        Variable modeVar = triggerVar.invoke("mode", new Object[0]);
        modeVar.ifEq((Object)1, skipLabel);
        Label activeLabel = mm.label();
        modeVar.ifNe((Object)2, activeLabel);
        triggerVar.invoke("releaseShared", new Object[0]);
        mm.goto_(acquireTriggerLabel);
        activeLabel.here();
    }

    protected void addEncodeColumnsMethod(String name, ColumnCodec[] codecs) {
        MethodMaker mm = this.mClassMaker.addMethod(byte[].class, name, new Object[]{this.mRowClass}).static_();
        if (this.mRowType == Entry.class && codecs.length == 1) {
            mm.return_((Object)mm.param(0).field(codecs[0].mInfo.name));
            return;
        }
        TableMaker.addEncodeColumns(mm, ColumnCodec.bind(codecs, mm));
    }

    protected static void addEncodeColumns(MethodMaker mm, ColumnCodec[] codecs) {
        Variable dstVar;
        if (codecs.length == 0) {
            mm.return_((Object)mm.var(RowUtils.class).field("EMPTY_BYTES"));
            return;
        }
        int minSize = 0;
        for (ColumnCodec codec : codecs) {
            minSize += codec.minSize();
            codec.encodePrepare();
        }
        Variable totalVar = null;
        for (ColumnCodec codec : codecs) {
            Field srcVar = TableMaker.findField(mm.param(0), codec);
            totalVar = codec.encodeSize((Variable)srcVar, totalVar);
        }
        if (totalVar == null) {
            dstVar = mm.new_(byte[].class, new Object[]{minSize});
        } else {
            if (minSize != 0) {
                totalVar = totalVar.add((Object)minSize);
            }
            dstVar = mm.new_(byte[].class, new Object[]{totalVar});
        }
        Variable offsetVar = mm.var(Integer.TYPE).set((Object)0);
        for (ColumnCodec codec : codecs) {
            codec.encode((Variable)TableMaker.findField(mm.param(0), codec), dstVar, offsetVar);
        }
        mm.return_((Object)dstVar);
    }

    protected void addDecodeColumnsMethod(String name, ColumnCodec[] codecs) {
        MethodMaker mm = this.mClassMaker.addMethod(null, name, new Object[]{this.mRowClass, byte[].class}).static_().public_();
        if (this.mRowType == Entry.class && codecs.length == 1) {
            mm.param(0).field(codecs[0].mInfo.name).set((Object)mm.param(1));
            return;
        }
        TableMaker.addDecodeColumns(mm, this.mRowInfo, codecs, 0);
    }

    protected static void addDecodeColumns(MethodMaker mm, RowInfo dstRowInfo, ColumnCodec[] srcCodecs, int fixedOffset) {
        srcCodecs = ColumnCodec.bind(srcCodecs, mm);
        Variable srcVar = mm.param(1);
        Variable offsetVar = mm.var(Integer.TYPE).set((Object)fixedOffset);
        for (ColumnCodec srcCodec : srcCodecs) {
            String name = srcCodec.mInfo.name;
            ColumnInfo dstInfo = (ColumnInfo)dstRowInfo.allColumns.get(name);
            if (dstInfo == null) {
                srcCodec.decodeSkip(srcVar, offsetVar, null);
                continue;
            }
            Variable rowVar = mm.param(0);
            Field dstVar = rowVar.field(name);
            Converter.decodeLossy(mm, srcVar, offsetVar, null, srcCodec, dstInfo, (Variable)dstVar);
        }
    }

    protected static UpdateEntry encodeUpdateKey(MethodMaker mm, RowInfo rowInfo, Variable tableVar, Variable rowVar, Variable originalVar) {
        RowGen rowGen = rowInfo.rowGen();
        ColumnCodec[] codecs = rowGen.keyCodecs();
        return TableMaker.encodeUpdateEntry(mm, rowGen, codecs, 0, tableVar, rowVar, originalVar);
    }

    protected static UpdateEntry encodeUpdateValue(MethodMaker mm, RowInfo rowInfo, int schemaVersion, Variable tableVar, Variable rowVar, Variable originalVar) {
        RowGen rowGen = rowInfo.rowGen();
        ColumnCodec[] codecs = rowGen.valueCodecs();
        return TableMaker.encodeUpdateEntry(mm, rowGen, codecs, schemaVersion, tableVar, rowVar, originalVar);
    }

    private static UpdateEntry encodeUpdateEntry(MethodMaker mm, RowGen rowGen, ColumnCodec[] codecs, int schemaVersion, Variable tableVar, Variable rowVar, Variable originalVar) {
        int fixedOffset;
        if (schemaVersion == 0) {
            fixedOffset = 0;
        } else {
            TableMaker.convertValueIfNecessary(tableVar, rowVar, schemaVersion, originalVar);
            fixedOffset = schemaVersion < 128 ? 1 : 4;
        }
        Map<String, Integer> columnNumbers = rowGen.columnNumbers();
        codecs = ColumnCodec.bind(codecs, mm);
        Variable[] offsetVars = new Variable[codecs.length];
        Variable offsetVar = mm.var(Integer.TYPE).set((Object)fixedOffset);
        Variable newSizeVar = mm.var(Integer.TYPE).set((Object)fixedOffset);
        String stateFieldName = null;
        Variable stateField = null;
        for (int i = 0; i < codecs.length; ++i) {
            ColumnCodec codec = codecs[i];
            codec.encodePrepare();
            offsetVars[i] = offsetVar.get();
            codec.decodeSkip(originalVar, offsetVar, null);
            ColumnInfo info = codec.mInfo;
            int num = columnNumbers.get(info.name);
            String sfName = rowGen.stateField(num);
            if (!sfName.equals(stateFieldName)) {
                stateFieldName = sfName;
                stateField = rowVar.field(stateFieldName).get();
            }
            int sfMask = RowGen.stateFieldMask(num);
            Label isDirty = mm.label();
            stateField.and((Object)sfMask).ifEq((Object)sfMask, isDirty);
            codec.encodeSkip();
            newSizeVar.inc((Object)offsetVar.sub((Object)offsetVars[i]));
            Label cont = mm.label().goto_();
            isDirty.here();
            newSizeVar.inc((Object)codec.minSize());
            codec.encodeSize((Variable)rowVar.field(info.name), newSizeVar);
            cont.here();
        }
        Variable newEntryVar = mm.new_(byte[].class, new Object[]{newSizeVar});
        Variable srcOffsetVar = mm.var(Integer.TYPE).set((Object)0);
        Variable dstOffsetVar = mm.var(Integer.TYPE).set((Object)0);
        Variable spanLengthVar = mm.var(Integer.TYPE).set((Object)fixedOffset);
        Variable sysVar = mm.var(System.class);
        for (int i = 0; i < codecs.length; ++i) {
            ColumnCodec codec = codecs[i];
            ColumnInfo info = codec.mInfo;
            int num = columnNumbers.get(info.name);
            Variable endVar = i + 1 < codecs.length ? offsetVars[i + 1] : originalVar.alength();
            Variable columnLenVar = endVar.sub((Object)offsetVars[i]);
            String sfName = rowGen.stateField(num);
            if (!sfName.equals(stateFieldName)) {
                stateFieldName = sfName;
                stateField = rowVar.field(stateFieldName).get();
            }
            int sfMask = RowGen.stateFieldMask(num);
            Label isDirty = mm.label();
            stateField.and((Object)sfMask).ifEq((Object)sfMask, isDirty);
            Label cont = mm.label();
            spanLengthVar.inc((Object)columnLenVar);
            mm.goto_(cont);
            isDirty.here();
            Label noSpan = mm.label();
            spanLengthVar.ifEq((Object)0, noSpan);
            sysVar.invoke("arraycopy", new Object[]{originalVar, srcOffsetVar, newEntryVar, dstOffsetVar, spanLengthVar});
            srcOffsetVar.inc((Object)spanLengthVar);
            dstOffsetVar.inc((Object)spanLengthVar);
            spanLengthVar.set((Object)0);
            noSpan.here();
            codec.encode((Variable)rowVar.field(info.name), newEntryVar, dstOffsetVar);
            srcOffsetVar.inc((Object)columnLenVar);
            cont.here();
        }
        Label noSpan = mm.label();
        spanLengthVar.ifEq((Object)0, noSpan);
        sysVar.invoke("arraycopy", new Object[]{originalVar, srcOffsetVar, newEntryVar, dstOffsetVar, spanLengthVar});
        noSpan.here();
        UpdateEntry ue = new UpdateEntry();
        ue.newEntryVar = newEntryVar;
        ue.offsetVars = offsetVars;
        return ue;
    }

    static void convertValueIfNecessary(Variable tableVar, Object rowClass, Object schemaVersion, Variable valueVar) {
        MethodMaker mm = valueVar.methodMaker();
        Variable decodeVersion = mm.var(RowUtils.class).invoke("decodeSchemaVersion", new Object[]{valueVar});
        Label sameVersion = mm.label();
        decodeVersion.ifEq(schemaVersion, sameVersion);
        Variable tempRowVar = mm.new_(rowClass, new Object[0]);
        tableVar.invoke("decodeValue", new Object[]{tempRowVar, valueVar});
        valueVar.set((Object)tableVar.invoke("encodeValue", new Object[]{tempRowVar}));
        sameVersion.here();
    }

    protected void addDoUpdateMethod() {
        MethodMaker mm = this.mClassMaker.addMethod(Boolean.TYPE, "doUpdate", new Object[]{Transaction.class, this.mRowClass, Boolean.TYPE}).protected_();
        this.addDoUpdateMethod(mm);
    }

    protected void addDoUpdateMethod(MethodMaker mm) {
        Label triggerStart;
        Variable triggerVar;
        Label cont;
        Variable txnVar = mm.param(0);
        Variable rowVar = mm.param(1);
        Variable mergeVar = mm.param(2);
        Label ready = mm.label();
        mm.invoke("checkPrimaryKeySet", new Object[]{rowVar}).ifTrue(ready);
        mm.new_(IllegalStateException.class, new Object[]{"Primary key isn't fully specified"}).throw_();
        ready.here();
        Variable keyVar = mm.invoke("encodePrimaryKey", new Object[]{rowVar});
        Field source = mm.field("mSource");
        Variable cursorVar = source.invoke("newCursor", new Object[]{txnVar});
        Label cursorStart = mm.label().here();
        if (this.mCodecGen.info.valueColumns.isEmpty()) {
            cont = null;
        } else {
            cont = mm.label();
            mm.invoke("checkValueAllDirty", new Object[]{rowVar}).ifFalse(cont);
        }
        if (!this.supportsTriggers()) {
            triggerVar = null;
            triggerStart = null;
        } else {
            triggerVar = mm.var(Trigger.class);
            Label skipLabel = mm.label();
            TableMaker.prepareForTrigger(mm, mm.this_(), triggerVar, skipLabel);
            triggerStart = mm.label().here();
            cursorVar.invoke("find", new Object[]{keyVar});
            Variable oldValueVar = cursorVar.invoke("value", new Object[0]);
            Label replace = mm.label();
            oldValueVar.ifNe(null, replace);
            mm.return_((Object)false);
            replace.here();
            Variable valueVar = mm.invoke("encodeValue", new Object[]{rowVar});
            cursorVar.invoke("store", new Object[]{valueVar});
            mm.invoke("redoPredicateMode", new Object[]{txnVar});
            triggerVar.invoke("store", new Object[]{txnVar, rowVar, keyVar, oldValueVar, valueVar});
            txnVar.invoke("commit", new Object[0]);
            this.markAllClean(rowVar);
            mm.return_((Object)true);
            skipLabel.here();
        }
        cursorVar.invoke("autoload", new Object[]{false});
        cursorVar.invoke("find", new Object[]{keyVar});
        Label replace = mm.label();
        cursorVar.invoke("value", new Object[0]).ifNe(null, replace);
        mm.return_((Object)false);
        replace.here();
        cursorVar.invoke("commit", new Object[]{mm.invoke("encodeValue", new Object[]{rowVar})});
        if (triggerStart != null) {
            mm.finally_(triggerStart, () -> triggerVar.invoke("releaseShared", new Object[0]));
        }
        this.markAllClean(rowVar);
        mm.return_((Object)true);
        if (cont == null) {
            return;
        }
        cont.here();
        cursorVar.invoke("find", new Object[]{keyVar});
        Label hasValue = mm.label();
        cursorVar.invoke("value", new Object[0]).ifNe(null, hasValue);
        mm.return_((Object)false);
        hasValue.here();
        this.finishDoUpdate(mm, rowVar, mergeVar, cursorVar);
        mm.return_((Object)true);
        mm.finally_(cursorStart, () -> cursorVar.invoke("reset", new Object[0]));
    }

    protected void finishDoUpdate(MethodMaker mm, Variable rowVar, Variable mergeVar, Variable cursorVar) {
        throw new UnsupportedOperationException();
    }

    protected static void finishDoUpdate(MethodMaker mm, RowInfo rowInfo, int schemaVersion, int triggers, boolean returnTrue, Variable tableVar, Variable rowVar, Variable mergeVar, Variable cursorVar) {
        Variable valueVar = cursorVar.invoke("value", new Object[0]);
        UpdateEntry ue = TableMaker.encodeUpdateValue(mm, rowInfo, schemaVersion, tableVar, rowVar, valueVar);
        Variable newValueVar = ue.newEntryVar;
        Variable[] offsetVars = ue.offsetVars;
        if (triggers == 0) {
            cursorVar.invoke("commit", new Object[]{newValueVar});
        }
        Label doMerge = mm.label();
        mergeVar.ifTrue(doMerge);
        if (triggers != 0) {
            Variable triggerVar = mm.var(Trigger.class);
            Label skipLabel = mm.label();
            TableMaker.prepareForTrigger(mm, tableVar, triggerVar, skipLabel);
            Label triggerStart = mm.label().here();
            cursorVar.invoke("store", new Object[]{newValueVar});
            Variable txnVar = cursorVar.invoke("link", new Object[0]);
            tableVar.invoke("redoPredicateMode", new Object[]{txnVar});
            Variable keyVar = cursorVar.invoke("key", new Object[0]);
            triggerVar.invoke("storeP", new Object[]{txnVar, rowVar, keyVar, valueVar, newValueVar});
            txnVar.invoke("commit", new Object[0]);
            Label cont = mm.label().goto_();
            skipLabel.here();
            cursorVar.invoke("commit", new Object[]{newValueVar});
            mm.finally_(triggerStart, () -> triggerVar.invoke("releaseShared", new Object[0]));
            cont.here();
        }
        TableMaker.markAllUndirty(rowVar, rowInfo);
        if (returnTrue) {
            mm.return_((Object)true);
        } else {
            mm.return_();
        }
        doMerge.here();
        RowGen rowGen = rowInfo.rowGen();
        Map<String, Integer> columnNumbers = rowGen.columnNumbers();
        ColumnCodec[] codecs = ColumnCodec.bind(rowGen.valueCodecs(), mm);
        String stateFieldName = null;
        Variable stateField = null;
        for (int i = 0; i < codecs.length; ++i) {
            ColumnCodec codec = codecs[i];
            ColumnInfo info = codec.mInfo;
            int num = columnNumbers.get(info.name);
            String sfName = rowGen.stateField(num);
            if (!sfName.equals(stateFieldName)) {
                stateFieldName = sfName;
                stateField = rowVar.field(stateFieldName).get();
            }
            int sfMask = RowGen.stateFieldMask(num);
            Label cont = mm.label();
            stateField.and((Object)sfMask).ifEq((Object)sfMask, cont);
            codec.decode((Variable)rowVar.field(info.name), valueVar, offsetVars[i], null);
            cont.here();
        }
        if (triggers != 0) {
            Variable triggerVar = mm.var(Trigger.class);
            Label skipLabel = mm.label();
            TableMaker.prepareForTrigger(mm, tableVar, triggerVar, skipLabel);
            Label triggerStart = mm.label().here();
            Variable txnVar = cursorVar.invoke("link", new Object[0]);
            Variable keyVar = cursorVar.invoke("key", new Object[0]);
            triggerVar.invoke("store", new Object[]{txnVar, rowVar, keyVar, valueVar, newValueVar});
            cursorVar.invoke("commit", new Object[]{newValueVar});
            Label cont = mm.label().goto_();
            skipLabel.here();
            cursorVar.invoke("commit", new Object[]{newValueVar});
            mm.finally_(triggerStart, () -> triggerVar.invoke("releaseShared", new Object[0]));
            cont.here();
        }
        TableMaker.markAllClean(rowVar, rowGen, rowGen);
    }

    protected void addPlanMethod(int option) {
        Object name = "plan";
        if ((option & 1) != 0) {
            name = (String)name + "Reverse";
        }
        MethodMaker mm = this.mClassMaker.addMethod(QueryPlan.class, (String)name, new Object[]{Object[].class}).varargs().public_();
        Bootstrap condy = mm.var(TableMaker.class).condy("condyPlan", new Object[]{this.mRowType, this.mSecondaryDescriptor, option});
        mm.return_((Object)condy.invoke(QueryPlan.class, "plan"));
    }

    public static QueryPlan condyPlan(MethodHandles.Lookup lookup, String name, Class type, Class rowType, byte[] secondaryDesc, int option) {
        String which;
        RowInfo rowInfo;
        RowInfo primaryRowInfo = RowInfo.find(rowType);
        if (secondaryDesc == null) {
            rowInfo = primaryRowInfo;
            which = "primary key";
        } else {
            rowInfo = RowStore.secondaryRowInfo(primaryRowInfo, secondaryDesc);
            which = rowInfo.isAltKey() ? "alternate key" : "secondary index";
        }
        boolean reverse = (option & 1) != 0;
        QueryPlan plan = new QueryPlan.FullScan(rowInfo.name, which, rowInfo.keySpec(), reverse);
        if ((option & 2) != 0) {
            rowInfo = primaryRowInfo;
            plan = new QueryPlan.PrimaryJoin(rowInfo.name, rowInfo.keySpec(), plan);
        }
        return plan;
    }

    protected void addUnfilteredMethods(long tableId) {
        MethodMaker mm = this.mClassMaker.addMethod(SingleScanController.class, "unfiltered", new Object[0]).protected_();
        Bootstrap condyClass = mm.var(TableMaker.class).condy("condyDefineUnfiltered", new Object[]{this.mRowType, this.mRowClass, tableId, this.mSecondaryDescriptor});
        Variable scanControllerCtor = condyClass.invoke(MethodHandle.class, "unfiltered");
        Object[] paramTypes = new Class[]{byte[].class, Boolean.TYPE, byte[].class, Boolean.TYPE, Boolean.TYPE};
        mm.return_((Object)scanControllerCtor.invoke(SingleScanController.class, "invokeExact", paramTypes, new Object[]{null, false, null, false, false}));
        mm = this.mClassMaker.addMethod(SingleScanController.class, "unfilteredReverse", new Object[0]).protected_();
        scanControllerCtor = mm.var(MethodHandle.class).set((Object)scanControllerCtor);
        mm.return_((Object)scanControllerCtor.invoke(SingleScanController.class, "invokeExact", paramTypes, new Object[]{null, false, null, false, true}));
    }

    public static MethodHandle condyDefineUnfiltered(MethodHandles.Lookup lookup, String name, Class type, Class rowType, Class rowClass, long tableId, byte[] secondaryDesc) throws Throwable {
        RowGen rowGen;
        RowInfo rowInfo = RowInfo.find(rowType);
        RowGen codecGen = rowGen = rowInfo.rowGen();
        if (secondaryDesc != null) {
            codecGen = RowStore.secondaryRowInfo(rowInfo, secondaryDesc).rowGen();
        }
        ClassMaker cm = RowGen.beginClassMaker(TableMaker.class, rowType, rowInfo, null, name).extend(SingleScanController.class).public_();
        MethodType ctorType = MethodType.methodType(Void.TYPE, byte[].class, Boolean.TYPE, byte[].class, Boolean.TYPE, Boolean.TYPE);
        MethodMaker mm = cm.addConstructor(ctorType).protected_();
        mm.invokeSuperConstructor(new Object[]{mm.param(0), mm.param(1), mm.param(2), mm.param(3), mm.param(4)});
        mm = cm.addConstructor(new Object[]{SingleScanController.class}).protected_();
        mm.invokeSuperConstructor(new Object[]{mm.param(0)});
        cm.addMethod(Long.TYPE, "evolvableTableId", new Object[0]).public_().final_().return_((Object)tableId);
        if (secondaryDesc != null) {
            mm = cm.addMethod(byte[].class, "secondaryDescriptor", new Object[0]).public_();
            mm.return_((Object)mm.var(byte[].class).setExact((Object)secondaryDesc));
        }
        mm = cm.addMethod(Object.class, "evalRow", new Object[]{Cursor.class, LockResult.class, Object.class}).public_();
        Variable cursorVar = mm.param(0);
        Variable keyVar = cursorVar.invoke("key", new Object[0]);
        Variable valueVar = cursorVar.invoke("value", new Object[0]);
        Variable rowVar = mm.param(2);
        Label notRow = mm.label();
        Variable typedRowVar = CodeUtils.castOrNew(rowVar, rowClass, notRow);
        Variable tableVar = mm.var(lookup.lookupClass());
        tableVar.invoke("decodePrimaryKey", new Object[]{typedRowVar, keyVar});
        tableVar.invoke("decodeValue", new Object[]{typedRowVar, valueVar});
        TableMaker.markAllClean(typedRowVar, rowGen, codecGen);
        mm.return_((Object)typedRowVar);
        notRow.here();
        CodeUtils.acceptAsRowConsumerAndReturn(rowVar, rowClass, keyVar, valueVar);
        mm = cm.addMethod(Object.class, "decodeRow", new Object[]{Object.class, byte[].class, byte[].class}).public_();
        Variable rowVar2 = CodeUtils.castOrNew(mm.param(0), rowClass);
        Variable tableVar2 = mm.var(lookup.lookupClass());
        tableVar2.invoke("decodePrimaryKey", new Object[]{rowVar2, mm.param(1)});
        tableVar2.invoke("decodeValue", new Object[]{rowVar2, mm.param(2)});
        TableMaker.markAllClean(rowVar2, rowGen, codecGen);
        mm.return_((Object)rowVar2);
        mm = cm.addMethod(null, "writeRow", new Object[]{RowWriter.class, byte[].class, byte[].class}).public_();
        Variable tableVar3 = mm.var(lookup.lookupClass());
        tableVar3.invoke("writeRow", new Object[]{mm.param(0), mm.param(1), mm.param(2)});
        mm = cm.addMethod(byte[].class, "updateKey", new Object[]{Object.class, byte[].class}).public_();
        rowVar2 = mm.param(0).cast((Object)rowClass);
        tableVar2 = mm.var(lookup.lookupClass());
        Label unchanged = mm.label();
        tableVar2.invoke("checkPrimaryKeyAnyDirty", new Object[]{rowVar2}).ifFalse(unchanged);
        mm.return_((Object)tableVar2.invoke("updatePrimaryKey", new Object[]{rowVar2, mm.param(1)}));
        unchanged.here();
        mm.return_(null);
        mm = cm.addMethod(byte[].class, "updateValue", new Object[]{Object.class, byte[].class}).public_();
        rowVar2 = mm.param(0).cast((Object)rowClass);
        tableVar2 = mm.var(lookup.lookupClass());
        mm.return_((Object)tableVar2.invoke("updateValue", new Object[]{rowVar2, mm.param(1)}));
        if (rowGen == codecGen && rowType != Entry.class) {
            mm = cm.addMethod(MethodHandle.class, "decodeValueHandle", new Object[]{Integer.TYPE}).protected_().static_();
            tableVar3 = mm.var(lookup.lookupClass());
            mm.return_((Object)tableVar3.invoke("decodeValueHandle", new Object[]{mm.param(0)}));
        }
        lookup = cm.finishLookup();
        MethodHandle mh = lookup.findConstructor(lookup.lookupClass(), ctorType);
        return mh.asType(mh.type().changeReturnType(SingleScanController.class));
    }

    protected static class UpdateEntry {
        Variable newEntryVar;
        Variable[] offsetVars;

        protected UpdateEntry() {
        }
    }
}

