/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import org.cojen.tupl.CorruptDatabaseException;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.Index;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.View;
import org.cojen.tupl.rows.BaseTable;
import org.cojen.tupl.rows.BaseTableIndex;
import org.cojen.tupl.rows.IndexBackfill;
import org.cojen.tupl.rows.IndexTriggerMaker;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowStore;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.SecondaryInfo;
import org.cojen.tupl.rows.Trigger;
import org.cojen.tupl.rows.WeakCache;
import org.cojen.tupl.rows.WeakClassCache;
import org.cojen.tupl.util.Worker;

public final class TableManager<R> {
    final WeakReference<RowStore> mRowStoreRef;
    final Index mPrimaryIndex;
    private final WeakClassCache<BaseTable<R>> mTables;
    private volatile WeakReference<BaseTable<R>> mMostRecentTable;
    private final ConcurrentSkipListMap<byte[], WeakReference<SecondaryInfo>> mIndexInfos;
    private TreeMap<byte[], IndexBackfill<R>> mIndexBackfills;
    private WeakReference<Worker> mWorkerRef;
    private volatile WeakCache<Object, BaseTableIndex<R>, Object> mIndexTables;
    private long mTableVersion;

    TableManager(RowStore rs, Index primaryIndex) {
        this.mRowStoreRef = rs.ref();
        this.mPrimaryIndex = primaryIndex;
        this.mTables = new WeakClassCache();
        this.mIndexInfos = new ConcurrentSkipListMap(RowUtils.KEY_COMPARATOR);
    }

    public Index primaryIndex() {
        return this.mPrimaryIndex;
    }

    BaseTable<R> asTable(RowStore rs, Index ix, Class<R> type) throws IOException {
        Worker worker;
        BaseTable<R> table = this.tryFindTable(type);
        if (table != null) {
            return table;
        }
        table = rs.makeTable(this, ix, type, () -> this.tryFindTable(type), t -> {
            WeakClassCache<BaseTable<R>> weakClassCache = this.mTables;
            synchronized (weakClassCache) {
                this.mMostRecentTable = this.mTables.put(type, t);
            }
        });
        rs.examineSecondaries(this);
        if (this.mWorkerRef != null && (worker = (Worker)this.mWorkerRef.get()) != null && ix.isEmpty()) {
            worker.join(false);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseTable<R> tryFindTable(Class<R> type) {
        BaseTable table;
        Reference ref = this.mTables.getRef(type);
        if (ref == null || (table = (BaseTable)ref.get()) == null) {
            WeakClassCache<BaseTable<R>> weakClassCache = this.mTables;
            synchronized (weakClassCache) {
                ref = this.mTables.getRef(type);
                if (ref == null) {
                    table = null;
                } else {
                    table = (BaseTable)ref.get();
                    if (table != null) {
                        this.mMostRecentTable = ref;
                    }
                }
            }
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WeakCache<Object, BaseTableIndex<R>, Object> indexTables() {
        WeakCache<Object, BaseTableIndex<Object>, Object> indexTables = this.mIndexTables;
        if (indexTables == null) {
            TableManager tableManager = this;
            synchronized (tableManager) {
                indexTables = this.mIndexTables;
                if (indexTables == null) {
                    this.mIndexTables = indexTables = new WeakCache();
                }
            }
        }
        return indexTables;
    }

    synchronized void removeFromIndexTables(long secondaryIndexId) {
        if (this.mIndexTables != null && this.mIndexTables.removeValues(table -> table.mSource.id() == secondaryIndexId)) {
            this.mIndexTables = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BaseTable<R> mostRecentTable() {
        WeakReference<BaseTable<R>> ref = this.mMostRecentTable;
        if (ref != null) {
            BaseTable table = (BaseTable)ref.get();
            if (table != null) {
                return table;
            }
            WeakClassCache<BaseTable<R>> weakClassCache = this.mTables;
            synchronized (weakClassCache) {
                if (this.mMostRecentTable == ref) {
                    this.mMostRecentTable = null;
                }
            }
        }
        return null;
    }

    SecondaryInfo secondaryInfo(RowInfo primaryInfo, byte[] desc) {
        SecondaryInfo info;
        WeakReference<SecondaryInfo> infoRef = this.mIndexInfos.get(desc);
        if (infoRef == null || (info = (SecondaryInfo)infoRef.get()) == null) {
            info = RowStore.secondaryRowInfo(primaryInfo, desc);
            this.mIndexInfos.put(desc, new WeakReference<SecondaryInfo>(info));
        }
        return info;
    }

    boolean update(long tableVersion, RowStore rs, Transaction txn, View secondaries) throws IOException {
        if (tableVersion == this.mTableVersion) {
            return false;
        }
        List tables = this.mTables.copyValues();
        if (tables != null) {
            for (BaseTable table : tables) {
                Class rowType = table.rowType();
                RowInfo primaryInfo = RowInfo.find(rowType);
                this.update(table, rowType, primaryInfo, rs, txn, secondaries);
                table.clearQueryCache();
            }
        } else {
            RowInfo primaryInfo = rs.decodeExisting(txn, null, this.mPrimaryIndex.id());
            if (primaryInfo != null) {
                this.update(null, null, primaryInfo, rs, txn, secondaries);
            }
        }
        this.mTableVersion = tableVersion;
        return true;
    }

    private void update(BaseTable<R> table, Class<R> rowType, RowInfo primaryInfo, RowStore rs, Transaction txn, View secondaries) throws IOException {
        int numIndexes = 0;
        try (Cursor c = secondaries.newCursor(txn);){
            c.first();
            while (c.key() != null) {
                byte state = c.value()[8];
                if (state != 68) {
                    ++numIndexes;
                }
                c.next();
            }
        }
        Iterator it = this.mIndexInfos.keySet().iterator();
        while (it.hasNext()) {
            byte[] desc = (byte[])it.next();
            if (secondaries.exists(txn, desc)) continue;
            it.remove();
            this.removeIndexBackfill(desc);
        }
        ArrayList<IndexBackfill<R>> newBackfills = null;
        IndexTriggerMaker<R> maker = null;
        if (numIndexes > 0) {
            maker = new IndexTriggerMaker<R>(rowType, primaryInfo, numIndexes);
        }
        try (Cursor c = secondaries.newCursor(txn);){
            byte[] byArray;
            int i = 0;
            c.first();
            while ((byArray = c.key()) != null) {
                block34: {
                    Index index;
                    byte state;
                    long indexId;
                    block33: {
                        byte[] value = c.value();
                        indexId = RowUtils.decodeLongLE(value, 0);
                        state = value[8];
                        if (state == 66) break block33;
                        this.removeIndexBackfill(byArray);
                        if (state == 68) break block34;
                    }
                    if ((index = rs.mDatabase.indexById(indexId)) == null) {
                        throw new CorruptDatabaseException("Secondary index is missing: " + indexId);
                    }
                    maker.mSecondaryDescriptors[i] = byArray;
                    maker.mSecondaryInfos[i] = this.secondaryInfo(primaryInfo, byArray);
                    maker.mSecondaryIndexes[i] = index;
                    maker.mSecondaryLocks[i] = rs.indexLock(index);
                    if (state == 66) {
                        IndexBackfill<R> backfill;
                        if (this.mIndexBackfills == null) {
                            this.mIndexBackfills = new TreeMap(RowUtils.KEY_COMPARATOR);
                        }
                        if ((backfill = this.mIndexBackfills.get(byArray)) == null) {
                            backfill = maker.makeBackfill(rs, this.mPrimaryIndex.id(), this, i);
                            this.mIndexBackfills.put(byArray, backfill);
                            if (newBackfills == null) {
                                newBackfills = new ArrayList<IndexBackfill<R>>();
                            }
                            newBackfills.add(backfill);
                        }
                        maker.mBackfills[i] = backfill;
                    }
                    ++i;
                }
                c.next();
            }
        }
        if (this.mIndexBackfills != null && this.mIndexBackfills.isEmpty()) {
            this.mIndexBackfills = null;
        }
        if (table != null && table.supportsSecondaries()) {
            Trigger<R> trigger = null;
            if (maker != null) {
                trigger = maker.makeTrigger(rs, this.mPrimaryIndex.id(), table);
            }
            table.setTrigger(trigger);
        }
        if (newBackfills != null && !newBackfills.isEmpty()) {
            Worker worker;
            if (this.mWorkerRef == null || (worker = (Worker)this.mWorkerRef.get()) == null) {
                worker = Worker.make(Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, r -> {
                    Thread t = new Thread(r);
                    t.setDaemon(true);
                    return t;
                });
                this.mWorkerRef = new WeakReference<Worker>(worker);
            }
            for (IndexBackfill indexBackfill : newBackfills) {
                rs.mDatabase.addRedoListener(indexBackfill);
                worker.enqueue(indexBackfill);
            }
        }
    }

    private void removeIndexBackfill(byte[] desc) {
        if (this.mIndexBackfills != null) {
            this.mIndexBackfills.remove(desc);
        }
    }
}

