/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cojen.maker.Field;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.ColumnInfo;
import org.cojen.tupl.rows.Converter;
import org.cojen.tupl.rows.RowGen;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowUtils;
import org.cojen.tupl.rows.VoidColumnCodec;

class TransformMaker<R> {
    private final Class<R> mRowType;
    private final RowInfo mRowInfo;
    private final Map<String, Availability> mAvailable;
    private List<Target> mTargets;
    private MethodMaker mMaker;
    private Variable mRowVar;
    private Variable mKeyVar;
    private Variable mValueVar;
    private Object mValueOffset;
    private Map<String, ColumnSource> mColumnSources;
    private Variable[] mDiffBitMap;
    private boolean mRequiresRow;

    public TransformMaker(Class<R> rowType, RowInfo rowInfo, Map<String, Availability> available) {
        this(rowType, rowInfo, available, true);
    }

    private TransformMaker(Class<R> rowType, RowInfo rowInfo, Map<String, Availability> available, boolean validate) {
        if (validate) {
            block9: {
                if (rowInfo == null) {
                    if (rowType != null) {
                        rowInfo = RowInfo.find(rowType);
                    } else {
                        Objects.requireNonNull(rowInfo);
                    }
                }
                if (available != null) {
                    for (Availability avail : available.values()) {
                        if (avail == Availability.NEVER) continue;
                        break block9;
                    }
                    available = null;
                }
            }
            if (available == null) {
                rowType = null;
            } else if (rowType == null) {
                throw new IllegalArgumentException();
            }
        }
        this.mRowType = rowType;
        this.mRowInfo = rowInfo;
        this.mAvailable = available;
        this.mTargets = new ArrayList<Target>();
    }

    public int addKeyTarget(RowInfo rowInfo, int offset, boolean eager) {
        return this.addTarget(true, rowInfo, offset, eager);
    }

    public int addValueTarget(RowInfo rowInfo, int offset, boolean eager) {
        return this.addTarget(false, rowInfo, offset, eager);
    }

    private int addTarget(boolean isKey, RowInfo rowInfo, int offset, boolean eager) {
        if (this.mColumnSources != null) {
            throw new IllegalStateException();
        }
        this.mTargets.add(new Target(isKey, rowInfo, offset, eager));
        return this.mTargets.size() - 1;
    }

    public boolean onlyNeedsKeys() {
        this.buildColumnSources();
        for (ColumnSource source : this.mColumnSources.values()) {
            if (source.mIsKey) continue;
            return false;
        }
        return true;
    }

    public void begin(MethodMaker mm, Variable rowVar, Variable keyVar, Variable valueVar, int valueOffset) {
        this.setup(mm, rowVar, keyVar, valueVar, valueOffset);
        this.findColumns(false);
    }

    public TransformMaker<R> beginValueDiff(MethodMaker mm, Variable rowVar, Variable keyVar, Variable valueVar, int valueOffset, Variable oldValueVar) {
        ColumnSource source;
        this.setup(mm, rowVar, keyVar, valueVar, valueOffset);
        for (ColumnSource source2 : this.mColumnSources.values()) {
            if (source2.mIsKey) continue;
            source2.mForceFind = true;
        }
        TransformMaker<R> oldMaker = new TransformMaker<R>(this.mRowType, this.mRowInfo, this.mAvailable, false);
        oldMaker.mTargets = TransformMaker.cloneTargets(this.mTargets);
        this.findColumns(true);
        oldMaker.setup(mm, rowVar, keyVar, oldValueVar, this.mValueOffset);
        int numValues = 0;
        for (ColumnSource columnSource : oldMaker.mColumnSources.values()) {
            if (columnSource.mIsKey) continue;
            columnSource.mAvailability = Availability.NEVER;
            if (!columnSource.mustFind()) continue;
            ++numValues;
        }
        oldMaker.findColumns(oldMaker.mValueVar, false, numValues, false);
        for (Map.Entry entry : this.mColumnSources.entrySet()) {
            source = (ColumnSource)entry.getValue();
            if (!source.mIsKey) continue;
            oldMaker.mColumnSources.put((String)entry.getKey(), source);
        }
        Variable[] bitMap = new Variable[TransformMaker.numBitMapWords(this.mColumnSources)];
        for (ColumnSource columnSource : oldMaker.mColumnSources.values()) {
            source = this.mColumnSources.get(columnSource.mCodec.mInfo.name);
            if (source.mIsKey || source.mCodec instanceof VoidColumnCodec) continue;
            int slot = source.mSlot;
            Variable bitsVar = bitMap[TransformMaker.bitMapWord(slot)];
            if (bitsVar == null) {
                bitMap[TransformMaker.bitMapWord((int)slot)] = bitsVar = mm.var(Long.TYPE).set((Object)0);
            }
            Label same = mm.label();
            Variable columnVar = source.accessColumn(this);
            if (columnVar != null && source.isPrimitive()) {
                columnVar.ifEq((Object)columnSource.accessColumn(oldMaker), same);
            } else {
                this.mMaker.var(Arrays.class).invoke("equals", new Object[]{source.mSrcVar, source.mStartVar, source.mEndVar, columnSource.mSrcVar, columnSource.mStartVar, columnSource.mEndVar}).ifTrue(same);
            }
            bitsVar.set((Object)bitsVar.or((Object)TransformMaker.bitMapWordMask(slot)));
            same.here();
        }
        oldMaker.mDiffBitMap = bitMap;
        for (Target target : oldMaker.mTargets) {
            target.assignValueSourceMasks(oldMaker.mColumnSources);
        }
        for (Target target : this.mTargets) {
            this.prepareColumns(target);
            oldMaker.prepareColumns(target);
        }
        return oldMaker;
    }

    public boolean diffValueCheck(Label skip, int ... targetIds) {
        boolean notSkipped = false;
        Label modified = this.mMaker.label();
        for (int i = 0; i < this.mDiffBitMap.length; ++i) {
            Variable word = this.mDiffBitMap[i];
            if (word == null) continue;
            long mask = 0L;
            for (int targetId : targetIds) {
                mask |= this.mTargets.get((int)targetId).mSourceMasks[i];
            }
            if (mask == 0L) continue;
            notSkipped = true;
            word.and((Object)mask).ifNe((Object)0L, modified);
        }
        if (notSkipped) {
            this.mMaker.goto_(skip);
            modified.here();
        }
        return notSkipped;
    }

    public Variable encode(int targetId) {
        Target target = this.mTargets.get(targetId);
        this.encodeColumns(target);
        return target.mEncodedVar;
    }

    public boolean requiresRow() {
        return this.mRequiresRow;
    }

    private void setup(MethodMaker mm, Variable rowVar, Variable keyVar, Variable valueVar, int valueOffset) {
        this.setup(mm, rowVar, keyVar, valueVar, valueOffset < 0 ? null : Integer.valueOf(valueOffset));
    }

    private void setup(MethodMaker mm, Variable rowVar, Variable keyVar, Variable valueVar, Object valueOffset) {
        this.buildColumnSources();
        Objects.requireNonNull(mm);
        if (this.mMaker != null) {
            throw new IllegalStateException();
        }
        if (this.mAvailable == null) {
            rowVar = null;
        }
        this.mMaker = mm;
        this.mRowVar = rowVar;
        this.mKeyVar = keyVar;
        this.mValueVar = valueVar;
        this.mValueOffset = valueOffset;
    }

    private void buildColumnSources() {
        if (this.mColumnSources != null) {
            return;
        }
        RowGen srcGen = this.mRowInfo.rowGen();
        Map<String, ColumnCodec> keyCodecMap = srcGen.keyCodecMap();
        Map<String, ColumnCodec> valueCodecMap = srcGen.valueCodecMap();
        HashMap<String, ColumnSource> sources = new HashMap<String, ColumnSource>();
        for (Target target : this.mTargets) {
            RowGen rowGen = target.mRowInfo.rowGen();
            ColumnCodec[] targetCodecs = target.mIsKey ? rowGen.keyCodecs() : rowGen.valueCodecs();
            this.buildColumnSources(sources, keyCodecMap, true, target, targetCodecs);
            this.buildColumnSources(sources, valueCodecMap, false, target, targetCodecs);
            this.buildVoidColumnSources(sources, targetCodecs);
        }
        for (ColumnSource source : sources.values()) {
            if (source.mAvailability != Availability.CONDITIONAL || !source.isPrimitive() && source.hasMismatches()) continue;
            source.mAvailability = Availability.NEVER;
        }
        this.mColumnSources = sources;
    }

    private void buildColumnSources(Map<String, ColumnSource> sources, Map<String, ColumnCodec> srcCodecMap, boolean srcIsKey, Target target, ColumnCodec[] targetCodecs) {
        for (ColumnCodec targetCodec : targetCodecs) {
            String name = targetCodec.mInfo.name;
            ColumnCodec srcCodec = srcCodecMap.get(name);
            if (srcCodec == null) continue;
            ColumnSource source = sources.get(name);
            if (source == null) {
                Availability availability;
                int slot = sources.size();
                if (this.mAvailable == null || (availability = this.mAvailable.get(name)) == null) {
                    availability = Availability.NEVER;
                }
                source = new ColumnSource(slot, srcIsKey, srcCodec, availability);
                sources.put(name, source);
            }
            source.addTarget(targetCodec, target.mEager);
        }
    }

    private void buildVoidColumnSources(Map<String, ColumnSource> sources, ColumnCodec[] targetCodecs) {
        for (ColumnCodec targetCodec : targetCodecs) {
            String name = targetCodec.mInfo.name;
            if (sources.containsKey(name)) continue;
            int slot = sources.size();
            VoidColumnCodec srcCodec = new VoidColumnCodec(targetCodec.mInfo, null);
            sources.put(name, new ColumnSource(slot, false, srcCodec, Availability.NEVER));
        }
    }

    private void findColumns(boolean keepValueOffset) {
        int numKeys = 0;
        int numValues = 0;
        for (ColumnSource source : this.mColumnSources.values()) {
            if (!source.mustFind()) continue;
            if (source.mIsKey) {
                ++numKeys;
                continue;
            }
            ++numValues;
        }
        this.findColumns(this.mKeyVar, true, numKeys, false);
        this.findColumns(this.mValueVar, false, numValues, keepValueOffset);
    }

    private void findColumns(Variable srcVar, boolean fromKey, int num, boolean keepValueOffset) {
        ColumnCodec[] codecs;
        if (srcVar == null || num == 0) {
            return;
        }
        Variable offsetVar = this.mMaker.var(Integer.TYPE);
        if (fromKey) {
            codecs = this.mRowInfo.rowGen().keyCodecs();
            offsetVar.set((Object)0);
        } else {
            codecs = this.mRowInfo.rowGen().valueCodecs();
            if (this.mValueOffset == null) {
                offsetVar.set((Object)this.mMaker.var(RowUtils.class).invoke("skipSchemaVersion", new Object[]{srcVar}));
                if (keepValueOffset) {
                    this.mValueOffset = offsetVar.get();
                }
            } else {
                offsetVar.set(this.mValueOffset);
            }
        }
        codecs = ColumnCodec.bind(codecs, this.mMaker);
        Variable endVar = null;
        for (ColumnCodec codec : codecs) {
            ColumnSource source = this.mColumnSources.get(codec.mInfo.name);
            if (source == null || !source.mustFind()) {
                endVar = null;
                codec.decodeSkip(srcVar, offsetVar, null);
                continue;
            }
            if (source.mIsKey != fromKey) {
                throw new AssertionError();
            }
            Variable startVar = endVar;
            if (startVar == null) {
                startVar = this.mMaker.var(Integer.TYPE).set((Object)offsetVar);
            }
            if (source.mustDecodeEagerly()) {
                Variable columnVar = this.mMaker.var(codec.mInfo.type);
                codec.decode(columnVar, srcVar, offsetVar, null);
                source.initColumnVar(columnVar);
            } else {
                codec.decodeSkip(srcVar, offsetVar, null);
            }
            endVar = this.mMaker.var(Integer.TYPE).set((Object)offsetVar);
            source.mSrcVar = srcVar;
            source.mStartVar = startVar;
            source.mEndVar = endVar;
            if (--num > 0) continue;
            return;
        }
        throw new AssertionError();
    }

    private static int numBitMapWords(Map<String, ColumnSource> columnSources) {
        return columnSources.size() + 63 >> 6;
    }

    private static int bitMapWord(int slot) {
        return slot >> 6;
    }

    private static long bitMapWordMask(int slot) {
        return 1L << (slot & 0x3F);
    }

    private void prepareColumns(Target target) {
        ColumnCodec[] codecs;
        if (target.mEncodedVar != null) {
            return;
        }
        RowGen targetGen = target.mRowInfo.rowGen();
        for (ColumnCodec codec : codecs = target.mIsKey ? targetGen.keyCodecs() : targetGen.valueCodecs()) {
            ColumnSource source = this.mColumnSources.get(codec.mInfo.name);
            if (source.mustCopyBytes(codec)) continue;
            source.prepareColumn(this);
        }
    }

    private void encodeColumns(Target target) {
        Variable encodedVar;
        ColumnCodec[] codecs;
        if (target.mEncodedVar != null) {
            return;
        }
        RowGen targetGen = target.mRowInfo.rowGen();
        ColumnCodec[] columnCodecArray = codecs = target.mIsKey ? targetGen.keyCodecs() : targetGen.valueCodecs();
        if (codecs.length == 0) {
            target.mEncodedVar = target.mOffset == 0 ? this.mMaker.var(RowUtils.class).field("EMPTY_BYTES") : this.mMaker.new_(byte[].class, new Object[]{target.mOffset});
            return;
        }
        codecs = ColumnCodec.bind(codecs, this.mMaker);
        int minSize = target.mOffset;
        for (ColumnCodec codec : codecs) {
            ColumnSource source = this.mColumnSources.get(codec.mInfo.name);
            if (source.mustCopyBytes(codec) || source.hasStash(codec) != null) continue;
            minSize += codec.minSize();
            codec.encodePrepare();
            source.prepareColumn(this);
        }
        Variable totalVar = null;
        for (ColumnCodec codec : codecs) {
            ColumnSource source = this.mColumnSources.get(codec.mInfo.name);
            if (source.mustCopyBytes(codec)) {
                totalVar = codec.accum(totalVar, source.mEndVar.sub((Object)source.mStartVar));
                continue;
            }
            ColumnTarget stash = source.hasStash(codec);
            if (stash == null) {
                Variable columnVar = source.accessColumn(this);
                totalVar = codec.encodeSize(columnVar, totalVar);
                continue;
            }
            totalVar = codec.accum(totalVar, stash.mLengthVar);
        }
        if (totalVar == null) {
            encodedVar = this.mMaker.new_(byte[].class, new Object[]{minSize});
        } else {
            if (minSize != 0) {
                totalVar = totalVar.add((Object)minSize);
            }
            encodedVar = this.mMaker.new_(byte[].class, new Object[]{totalVar});
        }
        Variable offsetVar = this.mMaker.var(Integer.TYPE).set((Object)target.mOffset);
        for (int i = 0; i < codecs.length; ++i) {
            ColumnCodec codec;
            codec = codecs[i];
            String name = codec.mInfo.name;
            ColumnSource source = this.mColumnSources.get(name);
            if (source.mustCopyBytes(codec)) {
                Variable lengthVar = source.mEndVar.sub((Object)source.mStartVar);
                this.mMaker.var(System.class).invoke("arraycopy", new Object[]{source.mSrcVar, source.mStartVar, encodedVar, offsetVar, lengthVar});
                if (i >= codecs.length - 1) continue;
                offsetVar.inc((Object)lengthVar);
                continue;
            }
            ColumnTarget stash = source.hasStash(codec);
            if (stash != null) {
                this.mMaker.var(System.class).invoke("arraycopy", new Object[]{stash.mEncodedVar, stash.mStartVar, encodedVar, offsetVar, stash.mLengthVar});
                if (i >= codecs.length - 1) continue;
                offsetVar.inc((Object)stash.mLengthVar);
                continue;
            }
            Variable columnVar = source.mColumnVar;
            stash = source.shouldStash(codec, target);
            if (stash != null) {
                stash.mEncodedVar = encodedVar;
                stash.mStartVar = offsetVar.get();
                codec.encode(columnVar, encodedVar, offsetVar);
                stash.mLengthVar = offsetVar.sub((Object)stash.mStartVar);
                continue;
            }
            codec.encode(columnVar, encodedVar, offsetVar);
        }
        target.mEncodedVar = encodedVar;
    }

    private static List<Target> cloneTargets(List<Target> targets) {
        ArrayList<Target> clone = new ArrayList<Target>(targets.size());
        for (Target t : targets) {
            clone.add(t.clone());
        }
        return clone;
    }

    static enum Availability {
        ALWAYS,
        NEVER,
        CONDITIONAL;

    }

    private static class Target
    implements Cloneable {
        final boolean mIsKey;
        final RowInfo mRowInfo;
        final int mOffset;
        final boolean mEager;
        Variable mEncodedVar;
        long[] mSourceMasks;

        Target(boolean isKey, RowInfo rowInfo, int offset, boolean eager) {
            this.mIsKey = isKey;
            this.mRowInfo = rowInfo;
            this.mOffset = offset;
            this.mEager = eager;
        }

        void assignValueSourceMasks(Map<String, ColumnSource> sources) {
            long[] masks = new long[TransformMaker.numBitMapWords(sources)];
            Map columns = this.mIsKey ? this.mRowInfo.keyColumns : this.mRowInfo.valueColumns;
            for (String name : columns.keySet()) {
                ColumnSource source = sources.get(name);
                if (source.mIsKey) continue;
                int slot = source.mSlot;
                int n = TransformMaker.bitMapWord(slot);
                masks[n] = masks[n] | TransformMaker.bitMapWordMask(slot);
            }
            this.mSourceMasks = masks;
        }

        public Target clone() {
            try {
                return (Target)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw RowUtils.rethrow(e);
            }
        }
    }

    private static class ColumnSource {
        final int mSlot;
        final boolean mIsKey;
        final ColumnCodec mCodec;
        Availability mAvailability;
        final Map<ColumnCodec, ColumnTarget> mColumnTargets;
        ColumnInfo mTargetInfo;
        boolean mEager;
        int mMatches;
        boolean mForceFind;
        Variable mSrcVar;
        Variable mStartVar;
        Variable mEndVar;
        Variable mColumnVar;
        Variable mColumnSetVar;
        boolean mColumnAccessCheck;

        ColumnSource(int slot, boolean isKey, ColumnCodec codec, Availability availability) {
            this.mSlot = slot;
            this.mIsKey = isKey;
            this.mCodec = codec;
            this.mAvailability = availability;
            this.mColumnTargets = new HashMap<ColumnCodec, ColumnTarget>();
        }

        ColumnTarget addTarget(ColumnCodec targetCodec, boolean eager) {
            if (this.mTargetInfo == null) {
                this.mTargetInfo = targetCodec.mInfo;
                if (this.mTargetInfo.type == null) {
                    this.mTargetInfo.assignType();
                }
            } else if (!this.mTargetInfo.isCompatibleWith(targetCodec.mInfo)) {
                throw new IllegalStateException();
            }
            this.mEager |= eager;
            ColumnTarget target = this.mColumnTargets.get(targetCodec);
            if (target == null) {
                if (this.mCodec.equals(targetCodec)) {
                    this.mMatches = 1;
                }
                target = new ColumnTarget();
                this.mColumnTargets.put(targetCodec, target);
            }
            ++target.mUsageCount;
            return target;
        }

        boolean isPrimitive() {
            return this.mCodec.mInfo.type.isPrimitive();
        }

        boolean hasMismatches() {
            return this.mMatches < this.mColumnTargets.size();
        }

        boolean mustDecodeEagerly() {
            if (this.mAvailability != Availability.NEVER) {
                return false;
            }
            if (this.isPrimitive()) {
                return true;
            }
            return this.mEager && this.hasMismatches();
        }

        boolean mustFind() {
            if (this.mCodec instanceof VoidColumnCodec) {
                return false;
            }
            if (!this.mForceFind && this.mAvailability == Availability.ALWAYS) {
                if (this.isPrimitive()) {
                    return false;
                }
                return this.mMatches != 0;
            }
            return true;
        }

        boolean mustCopyBytes(ColumnCodec targetCodec) {
            return this.mSrcVar != null && targetCodec.equals(this.mCodec) && this.mustFind();
        }

        ColumnTarget hasStash(ColumnCodec targetCodec) {
            ColumnTarget columnTarget = this.mColumnTargets.get(targetCodec);
            if (columnTarget != null && columnTarget.mEncodedVar != null) {
                return columnTarget;
            }
            return null;
        }

        ColumnTarget shouldStash(ColumnCodec targetCodec, Target target) {
            ColumnTarget columnTarget;
            if (target.mEager && !this.isPrimitive() && (columnTarget = this.mColumnTargets.get(targetCodec)) != null && columnTarget.mUsageCount > 1) {
                return columnTarget;
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void prepareColumn(TransformMaker tm) {
            if (this.mColumnVar != null) {
                return;
            }
            ColumnCodec columnCodec = this.mCodec;
            if (columnCodec instanceof VoidColumnCodec) {
                VoidColumnCodec vcc = (VoidColumnCodec)columnCodec;
                this.mColumnVar = tm.mMaker.var(vcc.mInfo.type);
                vcc.decode(this.mColumnVar, null, null, null);
                return;
            }
            if (this.mAvailability == Availability.ALWAYS) {
                this.mColumnVar = tm.mRowVar.field(this.mCodec.mInfo.name);
                return;
            }
            this.mColumnVar = tm.mMaker.var(this.mTargetInfo.type);
            if (this.mEager) {
                if (this.mAvailability != Availability.CONDITIONAL) throw new AssertionError();
                this.decodeColumn(tm);
                return;
            } else {
                this.mColumnAccessCheck = true;
                this.mColumnVar.clear();
                if (!this.isPrimitive() && !this.mTargetInfo.isNullable()) return;
                this.mColumnSetVar = tm.mMaker.var(Boolean.TYPE).set((Object)false);
            }
        }

        void initColumnVar(Variable columnVar) {
            if (this.mColumnVar != null) {
                throw new IllegalStateException();
            }
            if (this.mCodec.mInfo.isCompatibleWith(this.mTargetInfo)) {
                this.mColumnVar = columnVar;
            } else {
                this.mColumnVar = columnVar.methodMaker().var(this.mTargetInfo.type);
                this.setToColumnVar(columnVar);
            }
        }

        private void setToColumnVar(Variable columnVar) {
            if (this.mCodec.mInfo.isCompatibleWith(this.mTargetInfo)) {
                this.mColumnVar.set((Object)columnVar);
            } else {
                MethodMaker mm = columnVar.methodMaker();
                Converter.convertLossy(mm, this.mCodec.mInfo, columnVar, this.mTargetInfo, this.mColumnVar);
            }
        }

        Variable accessColumn(TransformMaker tm) {
            if (this.mColumnAccessCheck) {
                Label isSet = tm.mMaker.label();
                if (this.mColumnSetVar == null) {
                    this.mColumnVar.ifNe(null, isSet);
                    this.decodeColumn(tm);
                } else {
                    this.mColumnSetVar.ifTrue(isSet);
                    this.decodeColumn(tm);
                    this.mColumnSetVar.set((Object)true);
                }
                isSet.here();
            } else if (this.mColumnVar instanceof Field) {
                tm.mRequiresRow = true;
            }
            return this.mColumnVar;
        }

        private void decodeColumn(TransformMaker tm) {
            MethodMaker mm = tm.mMaker;
            Label cont = null;
            if (this.mAvailability != Availability.NEVER) {
                Variable rowVar = tm.mRowVar;
                RowInfo rowInfo = tm.mRowInfo;
                if (rowVar == null || rowInfo == null) {
                    throw new AssertionError();
                }
                tm.mRequiresRow = true;
                RowGen rowGen = rowInfo.rowGen();
                String columnName = this.mCodec.mInfo.name;
                int columnNum = rowGen.columnNumbers().get(columnName);
                String stateField = rowGen.stateField(columnNum);
                int stateFieldMask = RowGen.stateFieldMask(columnNum);
                Label mustDecode = mm.label();
                rowVar.field(stateField).and((Object)stateFieldMask).ifNe((Object)stateFieldMask, mustDecode);
                this.setToColumnVar((Variable)rowVar.field(columnName));
                cont = mm.label().goto_();
                mustDecode.here();
            }
            Variable offsetVar = this.mStartVar.get();
            this.mCodec.bind(mm).decode(this.mColumnVar, this.mSrcVar, offsetVar, null);
            if (cont != null) {
                cont.here();
            }
        }
    }

    private static class ColumnTarget {
        int mUsageCount;
        Variable mEncodedVar;
        Variable mStartVar;
        Variable mLengthVar;

        private ColumnTarget() {
        }
    }
}

