/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.VarHandle;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.cojen.tupl.rows.RefCache;

public class WeakCache<K, V, H>
extends RefCache<K, V, H> {
    private Entry<K, V>[] mEntries;
    private int mSize;

    public WeakCache() {
        this.clear();
    }

    @Override
    public synchronized void clear() {
        this.mEntries = new Entry[2];
        this.mSize = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WeakReference<V> getRef(K key) {
        Reference ref = this.poll();
        if (ref != null) {
            WeakCache weakCache = this;
            synchronized (weakCache) {
                this.cleanup(ref);
            }
        }
        Entry<K, V>[] entries = this.mEntries;
        Entry<K, V> e = entries[key.hashCode() & entries.length - 1];
        while (e != null) {
            if (e.matches(key)) {
                return e;
            }
            e = e.mNext;
        }
        return null;
    }

    @Override
    public synchronized WeakReference<V> put(K key, V value) {
        Reference ref = this.poll();
        if (ref != null) {
            this.cleanup(ref);
        }
        Entry<K, V>[] entries = this.mEntries;
        int hash = key.hashCode();
        int index = hash & entries.length - 1;
        Entry<K, V> e = entries[index];
        Entry<K, V> prev = null;
        while (e != null) {
            if (e.matches(key)) {
                e.clear();
                Entry<K, V> newEntry = this.newEntry(key, value, hash);
                if (prev == null) {
                    newEntry.mNext = e.mNext;
                } else {
                    prev.mNext = e.mNext;
                    newEntry.mNext = entries[index];
                }
                VarHandle.storeStoreFence();
                entries[index] = newEntry;
                return newEntry;
            }
            prev = e;
            e = e.mNext;
        }
        if (this.mSize >= this.mEntries.length) {
            Entry[] newEntries = new Entry[entries.length << 1];
            int size = 0;
            int i = entries.length;
            while (--i >= 0) {
                Entry<K, V> existing = entries[i];
                while (existing != null) {
                    Entry<K, V> e2 = existing;
                    existing = existing.mNext;
                    if (e2.refersTo(null)) continue;
                    ++size;
                    index = e2.mHash & newEntries.length - 1;
                    e2.mNext = newEntries[index];
                    newEntries[index] = e2;
                }
            }
            entries = newEntries;
            this.mEntries = newEntries;
            this.mSize = size;
            index = hash & entries.length - 1;
        }
        Entry<K, V> newEntry = this.newEntry(key, value, hash);
        newEntry.mNext = entries[index];
        VarHandle.storeStoreFence();
        entries[index] = newEntry;
        ++this.mSize;
        return newEntry;
    }

    @Override
    public synchronized void removeKey(K key) {
        Reference ref;
        Entry<K, V>[] entries = this.mEntries;
        int index = key.hashCode() & entries.length - 1;
        Entry<K, V> e = entries[index];
        Entry<K, V> prev = null;
        while (e != null) {
            if (e.matches(key)) {
                e.clear();
                if (prev == null) {
                    entries[index] = e.mNext;
                } else {
                    prev.mNext = e.mNext;
                }
                --this.mSize;
                break;
            }
            prev = e;
            e = e.mNext;
        }
        if ((ref = this.poll()) != null) {
            this.cleanup(ref);
        }
    }

    public synchronized boolean removeValues(Predicate<V> p) {
        Entry<K, V>[] entries = this.mEntries;
        int i = entries.length;
        while (--i >= 0) {
            Entry<K, V> e = entries[i];
            Entry<K, V> prev = null;
            while (e != null) {
                Object value = e.get();
                if (value == null || p.test(value)) {
                    if (prev == null) {
                        entries[i] = e.mNext;
                    } else {
                        prev.mNext = e.mNext;
                    }
                    --this.mSize;
                } else {
                    prev = e;
                }
                e = e.mNext;
            }
        }
        return this.mSize == 0;
    }

    synchronized K[] copyKeys(IntFunction<K[]> generator) {
        Reference ref = this.poll();
        if (ref != null) {
            this.cleanup(ref);
        }
        K[] keys = generator.apply(this.mSize);
        Entry<K, V>[] entries = this.mEntries;
        int k = 0;
        for (int i = 0; i < entries.length; ++i) {
            Entry<K, V> e = entries[i];
            while (e != null) {
                keys[k++] = e.mKey;
                e = e.mNext;
            }
        }
        return keys;
    }

    List<V> copyValues() {
        return this.findValues(null, (list, value) -> {
            if (list == null) {
                list = new ArrayList<Object>();
            }
            list.add(value);
            return list;
        });
    }

    synchronized <C> C findValues(C collection, BiFunction<C, V, C> fun) {
        Entry<K, V>[] entries;
        Entry<K, V>[] entryArray = entries = this.mEntries;
        int n = entryArray.length;
        for (int i = 0; i < n; ++i) {
            Entry<K, V> entry;
            Entry<K, V> e = entry = entryArray[i];
            while (e != null) {
                Object value = e.get();
                if (value != null) {
                    collection = fun.apply(collection, value);
                }
                e = e.mNext;
            }
        }
        Reference ref = this.poll();
        if (ref != null) {
            this.cleanup(ref);
        }
        return collection;
    }

    @Override
    protected void cleanup(Object ref) {
        Entry<K, V>[] entries = this.mEntries;
        block0: do {
            Entry cleared = (Entry)ref;
            int ix = cleared.mHash & entries.length - 1;
            Entry<K, V> e = entries[ix];
            Entry<K, V> prev = null;
            while (e != null) {
                if (e == cleared) {
                    if (prev == null) {
                        entries[ix] = e.mNext;
                    } else {
                        prev.mNext = e.mNext;
                    }
                    --this.mSize;
                    continue block0;
                }
                prev = e;
                e = e.mNext;
            }
        } while ((ref = this.poll()) != null);
    }

    protected Entry<K, V> newEntry(K key, V value, int hash) {
        return new Entry<K, V>(key, value, hash, this);
    }

    protected static class Entry<K, V>
    extends WeakReference<V> {
        protected final K mKey;
        final int mHash;
        Entry<K, V> mNext;

        protected Entry(K key, V value, int hash, ReferenceQueue<Object> queue) {
            super(value, queue);
            this.mKey = key;
            this.mHash = hash;
        }

        protected boolean matches(K key) {
            return this.mKey.equals(key);
        }
    }
}

