/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.io.IOException;
import java.util.Objects;
import org.cojen.tupl.Scanner;
import org.cojen.tupl.Table;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Updater;
import org.cojen.tupl.rows.RowUtils;

class WrappedUpdater<R>
implements Updater<R> {
    protected final Table<R> mTable;
    protected final Transaction mTxn;
    protected final Scanner<R> mScanner;

    WrappedUpdater(Table<R> table, Transaction txn, Scanner<R> scanner) {
        this.mTable = table;
        this.mTxn = txn;
        this.mScanner = scanner;
    }

    @Override
    public final R row() {
        return this.mScanner.row();
    }

    @Override
    public R step() throws IOException {
        try {
            return this.mScanner.step();
        }
        catch (Throwable e) {
            this.exception(e);
            throw e;
        }
    }

    @Override
    public R step(R row) throws IOException {
        try {
            return this.mScanner.step(row);
        }
        catch (Throwable e) {
            this.exception(e);
            throw e;
        }
    }

    @Override
    public final R update() throws IOException {
        try {
            this.mTable.update(this.mTxn, this.current());
        }
        catch (Throwable e) {
            this.exception(e);
            throw e;
        }
        return this.step();
    }

    @Override
    public final R update(R row) throws IOException {
        Objects.requireNonNull(row);
        try {
            this.mTable.update(this.mTxn, this.current());
        }
        catch (Throwable e) {
            this.exception(e);
            throw e;
        }
        return this.step(row);
    }

    @Override
    public final R delete() throws IOException {
        try {
            this.mTable.delete(this.mTxn, this.current());
        }
        catch (Throwable e) {
            this.exception(e);
            throw e;
        }
        return this.step();
    }

    @Override
    public final R delete(R row) throws IOException {
        Objects.requireNonNull(row);
        try {
            this.mTable.delete(this.mTxn, this.current());
        }
        catch (Throwable e) {
            this.exception(e);
            throw e;
        }
        return this.step(row);
    }

    @Override
    public final long estimateSize() {
        return this.mScanner.estimateSize();
    }

    @Override
    public final int characteristics() {
        return this.mScanner.characteristics();
    }

    @Override
    public void close() throws IOException {
        this.mScanner.close();
    }

    protected void exception(Throwable e) throws IOException {
    }

    private R current() {
        R current = this.row();
        if (current == null) {
            throw new IllegalStateException();
        }
        return current;
    }

    public static final class EndCommit<R>
    extends WrappedUpdater<R> {
        EndCommit(Table<R> table, Transaction txn, Scanner<R> scanner) {
            super(table, txn, scanner);
        }

        @Override
        public R step() throws IOException {
            try {
                Object row = this.mScanner.step();
                if (row == null) {
                    this.exception(null);
                }
                return row;
            }
            catch (Throwable e) {
                this.exception(e);
                throw e;
            }
        }

        @Override
        public R step(R row) throws IOException {
            try {
                row = this.mScanner.step(row);
                if (row == null) {
                    this.exception(null);
                }
                return row;
            }
            catch (Throwable e) {
                this.exception(e);
                throw e;
            }
        }

        @Override
        public void close() throws IOException {
            this.exception(null);
            this.mScanner.close();
        }

        @Override
        protected void exception(Throwable e) throws IOException {
            try {
                this.mTxn.commit();
            }
            catch (Throwable e2) {
                if (e == null) {
                    throw e2;
                }
                RowUtils.suppress(e, e2);
            }
        }
    }
}

