/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.rows;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.rows.ColumnCodec;
import org.cojen.tupl.rows.DecodePartialMaker;
import org.cojen.tupl.rows.ExceptionCallSite;
import org.cojen.tupl.rows.RowGen;
import org.cojen.tupl.rows.RowHeader;
import org.cojen.tupl.rows.RowInfo;
import org.cojen.tupl.rows.RowStore;
import org.cojen.tupl.rows.RowWriter;
import org.cojen.tupl.rows.SwitchCallSite;

public class WriteRowMaker {
    public static SwitchCallSite indyWriteRow(MethodHandles.Lookup lookup, String name, MethodType mt, WeakReference<RowStore> storeRef, Class<?> rowType, long tableId, byte[] projectionSpec) {
        return new SwitchCallSite(lookup, mt, schemaVersion -> {
            MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)lookup, null, (String)"writeRow", (Object[])new Object[]{RowWriter.class, byte[].class, byte[].class});
            RowStore store = (RowStore)storeRef.get();
            if (store == null) {
                mm.new_(DatabaseException.class, new Object[]{"Closed"}).throw_();
            } else {
                RowInfo rowInfo;
                try {
                    rowInfo = store.rowInfo(rowType, tableId, schemaVersion);
                }
                catch (Exception e) {
                    return new ExceptionCallSite.Failed(MethodType.methodType(Void.TYPE, RowWriter.class, byte[].class, byte[].class), mm, e);
                }
                WriteRowMaker.makeWriteRow(mm, rowInfo, schemaVersion < 128 ? 1 : 4, projectionSpec);
            }
            return mm.finish();
        });
    }

    public static MethodHandle makeWriteRowHandle(WeakReference<RowStore> storeRef, Class<?> rowType, long tableId, byte[] projectionSpec) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType mt = MethodType.methodType(Void.TYPE, Integer.TYPE, RowWriter.class, byte[].class, byte[].class);
        return WriteRowMaker.indyWriteRow(lookup, "writeRow", mt, storeRef, rowType, tableId, projectionSpec).dynamicInvoker();
    }

    public static MethodHandle makeWriteRowHandle(RowInfo rowInfo, byte[] projectionSpec) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodMaker mm = MethodMaker.begin((MethodHandles.Lookup)lookup, null, (String)"writeRow", (Object[])new Object[]{RowWriter.class, byte[].class, byte[].class});
        WriteRowMaker.makeWriteRow(mm, rowInfo, 0, projectionSpec);
        return mm.finish();
    }

    public static void makeWriteRow(MethodMaker mm, RowInfo rowInfo, int valueOffset, byte[] projectionSpec) {
        List<Range> valueRanges;
        Variable rowLengthVar;
        ColumnCodec lastKeyCodec;
        List<Range> keyRanges;
        Variable keyLengthVar;
        RowHeader rh;
        BitSet projSet;
        RowGen rowGen = rowInfo.rowGen();
        Variable writerVar = mm.param(0);
        Variable keyVar = mm.param(1);
        Variable valueVar = mm.param(2);
        if (projectionSpec == null) {
            projSet = null;
            rh = RowHeader.make(rowGen);
        } else {
            projSet = DecodePartialMaker.decodeSpec(projectionSpec)[0];
            rh = RowHeader.make(rowGen, projSet);
        }
        Variable headerVar = mm.var(byte[].class).setExact((Object)rh.encode(true));
        writerVar.invoke("writeHeader", new Object[]{headerVar});
        ColumnCodec[] keyCodecs = rowGen.keyCodecs();
        ColumnCodec[] valueCodecs = rowGen.valueCodecs();
        if (rh.numKeys == 0) {
            keyLengthVar = mm.var(Integer.TYPE).set((Object)0);
            keyRanges = List.of();
            lastKeyCodec = null;
        } else if (projSet == null || DecodePartialMaker.allRequested(projSet, 0, keyCodecs.length)) {
            keyLengthVar = keyVar.alength();
            keyRanges = List.of(new Range(0, keyLengthVar));
            lastKeyCodec = keyCodecs[rh.numKeys - 1];
        } else {
            keyRanges = new ArrayList();
            lastKeyCodec = WriteRowMaker.prepareRanges(keyRanges, projSet, 0, keyCodecs, keyVar, 0);
            keyLengthVar = mm.var(Integer.TYPE).set((Object)0);
            WriteRowMaker.incLength(keyLengthVar, keyRanges);
        }
        if (rh.numValues() == 0) {
            rowLengthVar = keyLengthVar;
            valueRanges = List.of();
        } else if (projSet == null || DecodePartialMaker.allRequested(projSet, keyCodecs.length, keyCodecs.length + valueCodecs.length)) {
            Variable valueLengthVar = valueVar.alength().sub((Object)valueOffset);
            rowLengthVar = keyLengthVar.add((Object)valueLengthVar);
            valueRanges = List.of(new Range(valueOffset, valueLengthVar));
        } else {
            valueRanges = new ArrayList();
            WriteRowMaker.prepareRanges(valueRanges, projSet, keyCodecs.length, valueCodecs, valueVar, valueOffset);
            rowLengthVar = keyLengthVar.get();
            WriteRowMaker.incLength(rowLengthVar, valueRanges);
        }
        if (rh.numValues() == 0 || lastKeyCodec == null || !lastKeyCodec.isLast()) {
            writerVar.invoke("writeRowLength", new Object[]{rowLengthVar});
        } else {
            writerVar.invoke("writeRowAndKeyLength", new Object[]{rowLengthVar, keyLengthVar});
        }
        WriteRowMaker.writeRanges(writerVar, keyVar, keyRanges);
        WriteRowMaker.writeRanges(writerVar, valueVar, valueRanges);
    }

    private static ColumnCodec prepareRanges(List<Range> ranges, BitSet projSet, int projOffset, ColumnCodec[] codecs, Variable bytesVar, int bytesStart) {
        codecs = ColumnCodec.bind(codecs, bytesVar.methodMaker());
        int numColumns = 0;
        for (int i = 0; i < codecs.length; ++i) {
            if (!projSet.get(projOffset + i)) continue;
            ++numColumns;
        }
        MethodMaker mm = bytesVar.methodMaker();
        Variable offsetVar = mm.var(Integer.TYPE).set((Object)bytesStart);
        boolean gap = true;
        ColumnCodec lastCodec = null;
        for (int i = 0; numColumns > 0 && i < codecs.length; ++i) {
            Variable length;
            Integer start;
            ColumnCodec codec = codecs[i];
            if (!projSet.get(projOffset + i)) {
                codec.decodeSkip(bytesVar, offsetVar, null);
                gap = true;
                continue;
            }
            Integer n = start = i == 0 ? Integer.valueOf(bytesStart) : offsetVar.get();
            if (i < codecs.length - 1) {
                codec.decodeSkip(bytesVar, offsetVar, null);
                length = offsetVar.sub((Object)start);
            } else {
                length = bytesVar.alength().sub((Object)start);
            }
            if (gap) {
                ranges.add(new Range(start, length));
            } else {
                ranges.get((int)(ranges.size() - 1)).length.inc((Object)length);
            }
            --numColumns;
            gap = false;
            lastCodec = codec;
        }
        return lastCodec;
    }

    private static void incLength(Variable lengthVar, List<Range> ranges) {
        for (Range range : ranges) {
            lengthVar.inc((Object)range.length);
        }
    }

    private static void writeRanges(Variable writerVar, Variable bytesVar, List<Range> ranges) {
        for (Range range : ranges) {
            writerVar.invoke("writeBytes", new Object[]{bytesVar, range.start, range.length});
        }
    }

    private static class Range {
        Object start;
        Variable length;

        Range(Object start, Variable length) {
            this.start = start;
            this.length = length;
        }
    }
}

