/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.tools;

import org.cojen.tupl.Database;
import org.cojen.tupl.DatabaseConfig;
import org.cojen.tupl.Index;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.VerificationObserver;

public class Verify
extends VerificationObserver {
    private int failed;
    private long totalNodeCount;
    private long totalEntryCount;
    private long totalFreeBytes;
    private long totalLargeValues;

    public static void main(String[] args) throws Exception {
        DatabaseConfig config = new DatabaseConfig().createFilePath(false).baseFilePath(args[0]).eventListener(EventListener.printTo(System.out));
        if (args.length > 1) {
            config.minCacheSize(Long.parseLong(args[1]));
        }
        Database db = Database.open(config);
        System.out.println(db.stats());
        Verify v = new Verify();
        db.verify(v);
        System.out.println(v);
        System.exit(v.failed);
    }

    @Override
    public boolean indexBegin(Index ix, int height) {
        System.out.println("Index: " + ix.nameString() + ", height: " + height);
        return super.indexBegin(ix, height);
    }

    @Override
    public boolean indexNodePassed(long id, int level, int entryCount, int freeBytes, int largeValueCount) {
        this.totalEntryCount += (long)entryCount;
        this.totalFreeBytes += (long)freeBytes;
        this.totalLargeValues += (long)largeValueCount;
        if (++this.totalNodeCount % 10000L == 0L) {
            System.out.println(this);
        }
        return true;
    }

    @Override
    public boolean indexNodeFailed(long id, int level, String message) {
        this.failed = 1;
        return super.indexNodeFailed(id, level, message);
    }

    public String toString() {
        return "nodeCount: " + this.totalNodeCount + ", entryCount: " + this.totalEntryCount + ", freeBytes: " + this.totalFreeBytes + ", largeValues: " + this.totalLargeValues;
    }
}

