/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.ThreadLocalRandom;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.util.Latch;
import org.cojen.tupl.util.Parker;

public abstract class Clutch
extends Latch {
    private static final VarHandle cContendedSlotHandle;
    private volatile int mContendedSlot = -1;

    public static Clutch make() {
        return new Impl(Impl.sharedPack());
    }

    public static Clutch make(int initialState) {
        return new Impl(Impl.sharedPack(), initialState);
    }

    public Clutch() {
    }

    public Clutch(int initialState) {
        super(initialState);
    }

    public final boolean isContended() {
        return this.mContendedSlot >= 0;
    }

    @Override
    public final boolean tryAcquireExclusive() {
        if (!super.tryAcquireExclusive()) {
            return false;
        }
        int slot = this.mContendedSlot;
        if (slot >= 0) {
            if (!this.getPack().tryUnregisterExclusive(slot, this)) {
                super.releaseExclusive();
                return false;
            }
            this.mContendedSlot = -1;
        }
        return true;
    }

    @Override
    public final boolean tryAcquireExclusiveNanos(long nanosTimeout) throws InterruptedException {
        int slot;
        if (nanosTimeout < 0L) {
            this.acquireExclusiveInterruptibly();
            return true;
        }
        long start = System.nanoTime();
        if (!super.tryAcquireExclusiveNanos(nanosTimeout)) {
            return false;
        }
        if ((nanosTimeout -= System.nanoTime() - start) < 0L) {
            nanosTimeout = 0L;
        }
        if ((slot = this.mContendedSlot) >= 0) {
            if (!this.getPack().tryUnregisterExclusiveNanos(slot, this, nanosTimeout)) {
                super.releaseExclusive();
                return false;
            }
            this.mContendedSlot = -1;
        }
        return true;
    }

    @Override
    public final void acquireExclusive() {
        super.acquireExclusive();
        int slot = this.mContendedSlot;
        if (slot >= 0) {
            this.getPack().unregisterExclusive(slot);
            this.mContendedSlot = -1;
        }
    }

    @Override
    public final void acquireExclusiveInterruptibly() throws InterruptedException {
        super.acquireExclusiveInterruptibly();
        int slot = this.mContendedSlot;
        if (slot >= 0) {
            this.getPack().tryUnregisterExclusiveNanos(slot, this, -1L);
            this.mContendedSlot = -1;
        }
    }

    @Override
    public final void uponExclusive(Runnable cont) {
        super.uponExclusive(() -> {
            int slot = this.mContendedSlot;
            if (slot >= 0) {
                this.getPack().unregisterExclusive(slot);
                this.mContendedSlot = -1;
            }
            cont.run();
        });
    }

    public final void downgrade(boolean contended) {
        Pack pack;
        int slot;
        if (contended && (slot = (pack = this.getPack()).tryRegister(this)) >= 0) {
            this.mContendedSlot = slot;
            if (!pack.tryAcquireShared(slot, this)) {
                throw new AssertionError();
            }
            super.releaseExclusive();
            return;
        }
        super.downgrade();
    }

    public final void releaseExclusive(boolean contended) {
        if (contended) {
            this.mContendedSlot = this.getPack().tryRegister(this);
        }
        super.releaseExclusive();
    }

    @Override
    public final boolean tryAcquireShared() {
        int slot = this.mContendedSlot;
        if (slot < 0 || !this.getPack().tryAcquireShared(slot, this)) {
            if (!super.tryAcquireShared()) {
                return false;
            }
            this.uncontendedMode();
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final boolean tryAcquireSharedNanos(long nanosTimeout) throws InterruptedException {
        block11: {
            block10: {
                if (nanosTimeout < 0L) {
                    this.acquireSharedInterruptibly();
                    return true;
                }
                slot = this.mContendedSlot;
                if (slot < 0) break block10;
                if (this.getPack().tryAcquireShared(slot, this)) {
                    return true;
                }
                ** GOTO lbl-1000
            }
            start = System.nanoTime();
            result = this.acquireSharedUncontendedNanos(nanosTimeout);
            if (result <= 0) {
                if (result == 0) {
                    return false;
                }
                if ((nanosTimeout -= System.nanoTime() - start) < 0L) {
                    nanosTimeout = 0L;
                }
                ** if (!Clutch.shouldSwitchToContendedMode()) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    if (!super.tryAcquireShared()) {
                        if (!super.tryAcquireExclusiveNanos((long)nanosTimeout)) {
                            return false;
                        } else {
                            ** GOTO lbl21
                        }
lbl21:
                        // 2 sources

                        this.contendedMode();
                        return true;
                    } else {
                        ** GOTO lbl23
                    }
lbl23:
                    // 2 sources

                    ** GOTO lbl27
                }
            }
            break block11;
lbl-1000:
            // 2 sources

            {
                if (!super.tryAcquireSharedNanos(nanosTimeout)) {
                    return false;
                }
            }
        }
        this.uncontendedMode();
        return true;
    }

    @Override
    public final boolean acquireSharedUncontended() {
        int slot = this.mContendedSlot;
        if (slot < 0 || !this.getPack().tryAcquireShared(slot, this)) {
            if (!super.acquireSharedUncontended()) {
                return false;
            }
            this.uncontendedMode();
        }
        return true;
    }

    @Override
    public final int acquireSharedUncontendedNanos(long nanosTimeout) throws InterruptedException {
        int slot = this.mContendedSlot;
        if (slot < 0 || !this.getPack().tryAcquireShared(slot, this)) {
            int result = super.acquireSharedUncontendedNanos(nanosTimeout);
            if (result <= 0) {
                return result;
            }
            this.uncontendedMode();
        }
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void acquireShared() {
        block6: {
            block5: {
                slot = this.mContendedSlot;
                if (slot < 0) break block5;
                if (this.getPack().tryAcquireShared(slot, this)) {
                    return;
                }
                ** GOTO lbl-1000
            }
            if (!super.acquireSharedUncontended()) {
                ** if (!Clutch.shouldSwitchToContendedMode()) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    if (!super.tryAcquireShared()) {
                        super.acquireExclusive();
                        this.contendedMode();
                        return;
                    } else {
                        ** GOTO lbl13
                    }
lbl13:
                    // 2 sources

                    ** GOTO lbl16
                }
            }
            break block6;
lbl-1000:
            // 2 sources

            {
                super.acquireShared();
            }
        }
        this.uncontendedMode();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void acquireSharedInterruptibly() throws InterruptedException {
        block6: {
            block5: {
                slot = this.mContendedSlot;
                if (slot < 0) break block5;
                if (this.getPack().tryAcquireShared(slot, this)) {
                    return;
                }
                ** GOTO lbl-1000
            }
            if (super.acquireSharedUncontendedNanos(-1L) <= 0) {
                ** if (!Clutch.shouldSwitchToContendedMode()) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    if (!super.tryAcquireShared()) {
                        super.acquireExclusiveInterruptibly();
                        this.contendedMode();
                        return;
                    } else {
                        ** GOTO lbl13
                    }
lbl13:
                    // 2 sources

                    ** GOTO lbl16
                }
            }
            break block6;
lbl-1000:
            // 2 sources

            {
                super.acquireSharedInterruptibly();
            }
        }
        this.uncontendedMode();
    }

    private static boolean shouldSwitchToContendedMode() {
        return (ThreadLocalRandom.current().nextInt() & 0xFF) == 0;
    }

    private void contendedMode() {
        Pack pack = this.getPack();
        int slot = this.mContendedSlot;
        if (slot < 0) {
            slot = pack.tryRegister(this);
            if (slot < 0) {
                super.downgrade();
                return;
            }
            this.mContendedSlot = slot;
        }
        if (!pack.tryAcquireShared(slot, this)) {
            throw new AssertionError();
        }
        super.releaseExclusive();
    }

    private void uncontendedMode() {
        int slot = this.mContendedSlot;
        if (slot >= 0) {
            if (!this.getPack().tryAcquireShared(slot, this)) {
                throw new AssertionError();
            }
            super.releaseShared();
        }
    }

    @Override
    public final boolean tryUpgrade() {
        return cContendedSlotHandle.get(this) < 0 && super.tryUpgrade();
    }

    @Override
    public final void releaseShared() {
        int slot = cContendedSlotHandle.get(this);
        if (slot < 0) {
            super.releaseShared();
        } else {
            this.getPack().releaseShared(slot);
        }
    }

    @Override
    public String toString() {
        if (this.mContendedSlot < 0) {
            return super.toString();
        }
        StringBuilder b = new StringBuilder();
        Clutch.appendMiniString(b, this);
        return b.append('{').append("state=").append("contended").append('}').toString();
    }

    protected abstract Pack getPack();

    static {
        try {
            cContendedSlotHandle = MethodHandles.lookup().findVarHandle(Clutch.class, "mContendedSlot", Integer.TYPE);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    private static class Impl
    extends Clutch {
        private static final int PACK_LIMIT = 16;
        private static Pack cSharedPack;
        private static int cShareCount;
        private final Pack mPack;

        static synchronized Pack sharedPack() {
            Pack pack = cSharedPack;
            if (pack == null || cShareCount >= 16) {
                cSharedPack = pack = new Pack(16);
                cShareCount = 1;
            } else {
                ++cShareCount;
            }
            return pack;
        }

        private Impl(Pack pack) {
            this.mPack = pack;
        }

        private Impl(Pack pack, int initialState) {
            super(initialState);
            this.mPack = pack;
        }

        @Override
        protected Pack getPack() {
            return this.mPack;
        }
    }

    public static class Pack
    extends Latch {
        private static final VarHandle cObjectArrayHandle = MethodHandles.arrayElementVarHandle(Object[].class);
        private static final VarHandle cIntArrayHandle = MethodHandles.arrayElementVarHandle(int[].class);
        private final int mCores;
        private final Object[] mSlots;
        private final int[] mCounters;
        private final int[] mThreadStripes;

        public Pack(int numSlots) {
            this(numSlots, Runtime.getRuntime().availableProcessors());
        }

        public Pack(int numSlots, int cores) {
            if (cores < 1) {
                throw new IllegalArgumentException();
            }
            this.mCores = cores;
            this.mSlots = new Object[numSlots];
            this.mCounters = new int[numSlots * cores];
            this.mThreadStripes = new int[cores * 4];
        }

        final int tryRegister(Clutch clutch) {
            Clutch existingClutch;
            Object[] slots = this.mSlots;
            int slot = ThreadLocalRandom.current().nextInt(slots.length);
            Object existing = cObjectArrayHandle.getVolatile(slots, slot);
            if (existing == null) {
                if (cObjectArrayHandle.compareAndSet(slots, slot, null, clutch)) {
                    return slot;
                }
                existing = cObjectArrayHandle.getVolatile(slots, slot);
            }
            if (existing instanceof Clutch && (existingClutch = (Clutch)existing).tryAcquireExclusive()) {
                existingClutch.releaseExclusive();
                if (cObjectArrayHandle.compareAndSet(slots, slot, null, clutch)) {
                    return slot;
                }
            }
            return -1;
        }

        final boolean tryUnregisterExclusive(int slot, Clutch clutch) {
            if (this.isZero(slot)) {
                cObjectArrayHandle.setVolatile(this.mSlots, slot, this);
                if (this.isZero(slot)) {
                    cObjectArrayHandle.setVolatile(this.mSlots, slot, null);
                    return true;
                }
                cObjectArrayHandle.setVolatile(this.mSlots, slot, clutch);
            }
            return false;
        }

        final boolean tryUnregisterExclusiveNanos(int slot, Clutch clutch, long nanosTimeout) throws InterruptedException {
            cObjectArrayHandle.setVolatile(this.mSlots, slot, Thread.currentThread());
            if (nanosTimeout < 0L) {
                while (!this.isZero(slot)) {
                    Parker.park(this);
                    if (!Thread.interrupted()) continue;
                    cObjectArrayHandle.setVolatile(this.mSlots, slot, clutch);
                    throw new InterruptedException();
                }
            } else if (!this.isZero(slot)) {
                long start = System.nanoTime();
                while (true) {
                    Parker.parkNanos(this, nanosTimeout);
                    if (Thread.interrupted()) {
                        cObjectArrayHandle.setVolatile(this.mSlots, slot, clutch);
                        throw new InterruptedException();
                    }
                    if (this.isZero(slot)) break;
                    long now = System.nanoTime();
                    if ((nanosTimeout -= now - start) <= 0L) {
                        cObjectArrayHandle.setVolatile(this.mSlots, slot, clutch);
                        return false;
                    }
                    start = now;
                }
            }
            cObjectArrayHandle.setVolatile(this.mSlots, slot, null);
            return true;
        }

        final void unregisterExclusive(int slot) {
            cObjectArrayHandle.setVolatile(this.mSlots, slot, Thread.currentThread());
            while (!this.isZero(slot)) {
                Parker.park(this);
                Thread.interrupted();
            }
            cObjectArrayHandle.setVolatile(this.mSlots, slot, null);
        }

        final boolean tryAcquireShared(int slot, Clutch clutch) {
            int stripe = this.add(slot, 1);
            if (cObjectArrayHandle.getVolatile(this.mSlots, slot) == clutch) {
                return true;
            }
            this.releaseShared(slot, stripe);
            return false;
        }

        final void releaseShared(int slot) {
            this.releaseShared(slot, this.threadStripe());
        }

        private void releaseShared(int slot, int stripe) {
            this.add(slot, -1, stripe);
            Object entry = cObjectArrayHandle.getVolatile(this.mSlots, slot);
            if (entry instanceof Thread) {
                Thread t = (Thread)entry;
                if (this.isZero(slot)) {
                    Parker.unpark(t);
                }
            }
        }

        private int add(int slot, int delta) {
            int cv;
            int[] counters = this.mCounters;
            int stripe = this.threadStripe();
            if (!cIntArrayHandle.compareAndSet(counters, slot + stripe, cv = cIntArrayHandle.getVolatile(counters, slot + stripe), cv + delta)) {
                stripe = ThreadLocalRandom.current().nextInt(this.mCores) * this.mSlots.length;
                int id = Pack.xorshift((int)Parker.threadId(Thread.currentThread()));
                this.mThreadStripes[id & this.mThreadStripes.length - 1] = stripe;
                this.add(slot, delta, stripe);
            }
            return stripe;
        }

        private void add(int slot, int delta, int stripe) {
            cIntArrayHandle.getAndAdd(this.mCounters, slot + stripe, delta);
        }

        private int threadStripe() {
            int id = Pack.xorshift((int)Parker.threadId(Thread.currentThread()));
            return this.mThreadStripes[id & this.mThreadStripes.length - 1];
        }

        private static int xorshift(int v) {
            v ^= v << 13;
            v ^= v >>> 17;
            v ^= v << 5;
            return v;
        }

        private boolean isZero(int slot) {
            int[] counters = this.mCounters;
            int stride = this.mSlots.length;
            long sum = 0L;
            int i = 0;
            while (i < this.mCores) {
                sum += (long)cIntArrayHandle.getVolatile(counters, slot);
                ++i;
                slot += stride;
            }
            return sum == 0L;
        }
    }
}

