/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.util.LatchCondition;
import org.cojen.tupl.util.Parker;

public class Latch {
    public static final int UNLATCHED = 0;
    public static final int EXCLUSIVE = Integer.MIN_VALUE;
    public static final int SHARED = 1;
    static final int SPIN_LIMIT = Runtime.getRuntime().availableProcessors() > 1 ? 1024 : 1;
    static final VarHandle cStateHandle;
    static final VarHandle cFirstHandle;
    static final VarHandle cLastHandle;
    static final VarHandle cWaiterHandle;
    static final VarHandle cWaitStateHandle;
    static final VarHandle cPrevHandle;
    static final VarHandle cNextHandle;
    volatile int mLatchState;
    private volatile WaitNode mLatchFirst;
    private volatile WaitNode mLatchLast;

    public Latch() {
    }

    public Latch(int initialState) {
        cStateHandle.set(this, initialState);
    }

    public boolean tryAcquireExclusive() {
        return this.doTryAcquireExclusive();
    }

    private boolean doTryAcquireExclusive() {
        return this.mLatchState == 0 && cStateHandle.compareAndSet(this, 0, Integer.MIN_VALUE);
    }

    private void doAcquireExclusiveSpin() {
        while (!this.doTryAcquireExclusive()) {
            Thread.onSpinWait();
        }
    }

    public boolean tryAcquireExclusiveNanos(long nanosTimeout) throws InterruptedException {
        return this.doTryAcquireExclusiveNanos(nanosTimeout);
    }

    private boolean doTryAcquireExclusiveNanos(long nanosTimeout) throws InterruptedException {
        boolean result;
        if (this.doTryAcquireExclusive()) {
            return true;
        }
        if (nanosTimeout == 0L) {
            return false;
        }
        try {
            result = this.acquire(new Timed(nanosTimeout));
        }
        catch (Throwable e) {
            if (nanosTimeout < 0L) {
                this.doAcquireExclusiveSpin();
                return true;
            }
            return false;
        }
        return Latch.checkTimedResult(result, nanosTimeout);
    }

    public void acquireExclusive() {
        if (!this.doTryAcquireExclusive()) {
            this.doAcquireExclusive();
        }
    }

    private void doAcquireExclusive() {
        try {
            this.acquire(new WaitNode());
        }
        catch (Throwable e) {
            this.doAcquireExclusiveSpin();
        }
    }

    public void acquireExclusiveInterruptibly() throws InterruptedException {
        this.doTryAcquireExclusiveNanos(-1L);
    }

    public void uponExclusive(Runnable cont) {
        block10: {
            if (!this.doTryAcquireExclusive()) {
                WaitNode node;
                try {
                    node = new WaitNode(cont, 1);
                }
                catch (Throwable e) {
                    this.doAcquireExclusiveSpin();
                    break block10;
                }
                WaitNode prev = this.enqueue(node);
                boolean acquired = this.doTryAcquireExclusive();
                if (node.mWaiter == null) {
                    if (acquired) {
                        this.releaseExclusive();
                    }
                    return;
                }
                if (!acquired) {
                    return;
                }
                node.mWaiter = null;
                if (this.mLatchFirst != node) {
                    this.remove(node, prev);
                } else {
                    this.removeFirst(node);
                }
            }
        }
        try {
            cont.run();
        }
        catch (Throwable e) {
            Utils.uncaught(e);
        }
        this.releaseExclusive();
    }

    public final void downgrade() {
        this.mLatchState = 1;
        WaitNode first;
        block0: while ((first = this.first()) != null) {
            WaitNode node = first;
            while (true) {
                WaitNode next;
                Object waiter;
                if ((waiter = node.mWaiter) != null) {
                    if (node instanceof Shared) {
                        cStateHandle.getAndAdd(this, 1);
                        if (cWaiterHandle.compareAndSet(node, waiter, null)) {
                            Parker.unpark((Thread)waiter);
                        } else {
                            cStateHandle.getAndAdd(this, -1);
                        }
                    } else {
                        if (node != first) {
                            this.mLatchFirst = node;
                        }
                        return;
                    }
                }
                if ((next = node.mNext) == null) {
                    if (!cLastHandle.compareAndSet(this, node, null)) continue block0;
                    cFirstHandle.compareAndSet(this, first, null);
                    return;
                }
                node = next;
            }
            break;
        }
        return;
    }

    public final void releaseExclusive() {
        int trials = 0;
        while (true) {
            block16: {
                Object waiter;
                WaitNode first;
                block18: {
                    WaitNode last;
                    block17: {
                        WaitNode next;
                        if ((last = this.mLatchLast) == null) {
                            this.mLatchState = 0;
                            last = this.mLatchLast;
                            if (last == null || !cStateHandle.compareAndSet(this, 0, Integer.MIN_VALUE)) {
                                return;
                            }
                        }
                        if ((first = this.mLatchFirst) == null) break block16;
                        waiter = first.mWaiter;
                        if (waiter != null) {
                            if (first instanceof Shared) {
                                this.downgrade();
                                if (this.doReleaseShared()) {
                                    return;
                                }
                                trials = 0;
                                continue;
                            }
                            if (first.mWaitState != 1) {
                                this.mLatchState = 0;
                                Parker.unpark((Thread)waiter);
                                return;
                            }
                        }
                        if ((next = first.mNext) == null) break block17;
                        this.mLatchFirst = next;
                        break block18;
                    }
                    if (last != first || !cLastHandle.compareAndSet(this, last, null)) break block16;
                    cFirstHandle.compareAndSet(this, last, null);
                }
                if (waiter != null && cWaiterHandle.compareAndSet(first, waiter, null)) {
                    if (waiter instanceof Thread) {
                        Thread t = (Thread)waiter;
                        Parker.unpark(t);
                        return;
                    }
                    try {
                        ((Runnable)waiter).run();
                    }
                    catch (Throwable e) {
                        Utils.uncaught(e);
                    }
                    if (this.mLatchState != Integer.MIN_VALUE) {
                        if (this.mLatchState <= 0) {
                            throw new IllegalStateException("Illegal latch state: " + this.mLatchState + ", caused by " + waiter);
                        }
                        if (this.doReleaseShared()) {
                            return;
                        }
                    }
                    trials = 0;
                    continue;
                }
            }
            trials = Latch.spin(trials);
        }
    }

    public final void release(boolean exclusive) {
        if (exclusive) {
            this.releaseExclusive();
        } else {
            this.releaseShared();
        }
    }

    public final void releaseEither() {
        if (cStateHandle.get(this) == Integer.MIN_VALUE) {
            this.releaseExclusive();
        } else {
            this.releaseShared();
        }
    }

    public boolean tryAcquireShared() {
        return this.doTryAcquireShared();
    }

    private boolean doTryAcquireShared() {
        WaitNode first = this.mLatchFirst;
        if (first != null && !(first instanceof Shared)) {
            return false;
        }
        int state = this.mLatchState;
        return state >= 0 && cStateHandle.compareAndSet(this, state, state + 1);
    }

    private void doAcquireSharedSpin() {
        while (!this.doTryAcquireShared()) {
            Thread.onSpinWait();
        }
    }

    public boolean tryAcquireSharedNanos(long nanosTimeout) throws InterruptedException {
        return this.doTryAcquireSharedNanos(nanosTimeout);
    }

    private boolean doTryAcquireSharedNanos(long nanosTimeout) throws InterruptedException {
        boolean result;
        WaitNode first = this.mLatchFirst;
        if (first == null || first instanceof Shared) {
            int state;
            int trials = 0;
            while ((state = this.mLatchState) >= 0) {
                if (cStateHandle.compareAndSet(this, state, state + 1)) {
                    return true;
                }
                trials = Latch.spin(trials);
            }
        }
        if (nanosTimeout == 0L) {
            return false;
        }
        try {
            result = this.acquire(new TimedShared(nanosTimeout));
        }
        catch (Throwable e) {
            if (nanosTimeout < 0L) {
                this.doAcquireSharedSpin();
                return true;
            }
            return false;
        }
        return Latch.checkTimedResult(result, nanosTimeout);
    }

    private static boolean checkTimedResult(boolean result, long nanosTimeout) throws InterruptedException {
        if (!result && (Thread.interrupted() || nanosTimeout < 0L)) {
            InterruptedException e;
            try {
                e = new InterruptedException();
            }
            catch (Throwable e2) {
                if (nanosTimeout < 0L) {
                    throw e2;
                }
                return false;
            }
            throw e;
        }
        return result;
    }

    public boolean acquireSharedUncontended() {
        int state;
        WaitNode first = this.mLatchFirst;
        if ((first == null || first instanceof Shared) && (state = this.mLatchState) >= 0) {
            return cStateHandle.compareAndSet(this, state, state + 1);
        }
        try {
            this.acquire(new Shared());
        }
        catch (Throwable e) {
            this.doAcquireSharedSpin();
        }
        return true;
    }

    public int acquireSharedUncontendedNanos(long nanosTimeout) throws InterruptedException {
        boolean result;
        int state;
        WaitNode first = this.mLatchFirst;
        if ((first == null || first instanceof Shared) && (state = this.mLatchState) >= 0) {
            return cStateHandle.compareAndSet(this, state, state + 1) ? 1 : -1;
        }
        try {
            result = this.acquire(new TimedShared(nanosTimeout));
        }
        catch (Throwable e) {
            if (nanosTimeout < 0L) {
                this.doAcquireSharedSpin();
                return 1;
            }
            return 0;
        }
        return Latch.checkTimedResult(result, nanosTimeout) ? 1 : 0;
    }

    public void acquireShared() {
        if (!this.tryAcquireSharedSpin()) {
            try {
                this.acquire(new Shared());
            }
            catch (Throwable e) {
                this.doAcquireSharedSpin();
            }
        }
    }

    private boolean tryAcquireSharedSpin() {
        WaitNode first = this.mLatchFirst;
        if (first == null || first instanceof Shared) {
            int state;
            int trials = 0;
            while ((state = this.mLatchState) >= 0) {
                if (cStateHandle.compareAndSet(this, state, state + 1)) {
                    return true;
                }
                trials = Latch.spin(trials);
            }
        }
        return false;
    }

    public void acquireSharedInterruptibly() throws InterruptedException {
        this.doTryAcquireSharedNanos(-1L);
    }

    public boolean tryUpgrade() {
        return this.doTryUpgrade();
    }

    private boolean doTryUpgrade() {
        while (this.mLatchState == 1) {
            if (cStateHandle.compareAndSet(this, 1, Integer.MIN_VALUE)) {
                return true;
            }
            Thread.onSpinWait();
        }
        return false;
    }

    public void releaseShared() {
        int trials = 0;
        while (true) {
            int state = this.mLatchState;
            WaitNode last = this.mLatchLast;
            if (last == null) {
                if (cStateHandle.compareAndSet(this, state--, state)) {
                    if (state == 0 && (last = this.mLatchLast) != null && cStateHandle.compareAndSet(this, 0, Integer.MIN_VALUE)) {
                        this.releaseExclusive();
                    }
                    return;
                }
            } else if (state == 1) {
                if (cStateHandle.compareAndSet(this, 1, Integer.MIN_VALUE) || this.doTryUpgrade()) {
                    this.releaseExclusive();
                    return;
                }
            } else if (cStateHandle.compareAndSet(this, state--, state)) {
                return;
            }
            trials = Latch.spin(trials);
        }
    }

    private boolean doReleaseShared() {
        int trials = 0;
        while (true) {
            int state = this.mLatchState;
            WaitNode last = this.mLatchLast;
            if (last == null) {
                if (cStateHandle.compareAndSet(this, state--, state)) {
                    return state != 0 || (last = this.mLatchLast) == null || !cStateHandle.compareAndSet(this, 0, Integer.MIN_VALUE);
                }
            } else if (state == 1) {
                if (cStateHandle.compareAndSet(this, 1, Integer.MIN_VALUE) || this.doTryUpgrade()) {
                    return false;
                }
            } else if (cStateHandle.compareAndSet(this, state--, state)) {
                return true;
            }
            trials = Latch.spin(trials);
        }
    }

    private boolean acquire(WaitNode node) {
        node.mWaiter = Thread.currentThread();
        WaitNode prev = this.enqueue(node);
        int acquireResult = node.tryAcquire(this);
        if (acquireResult < 0) {
            int denied = 0;
            while (true) {
                boolean parkAbort = node.park(this);
                acquireResult = node.tryAcquire(this);
                if (acquireResult >= 0) break;
                if (parkAbort) {
                    if (!cWaiterHandle.compareAndSet(node, Thread.currentThread(), null)) {
                        return true;
                    }
                    int state = this.mLatchState;
                    if (state >= 0) {
                        WaitNode wnode = node;
                        while ((wnode = wnode.mNext) != null) {
                            Object waiter = wnode.mWaiter;
                            if (!(waiter instanceof Thread)) continue;
                            Thread t = (Thread)waiter;
                            if (wnode instanceof Shared) {
                                Parker.unpark(t);
                                continue;
                            }
                            if (state != 0) break;
                            Parker.unpark(t);
                            break;
                        }
                    }
                    if (prev != null) {
                        this.remove(node, prev);
                    }
                    return false;
                }
                if (denied++ != 0) continue;
                node.mWaitState = 1;
            }
        }
        if (acquireResult == 0) {
            if (this.mLatchFirst != node) {
                this.remove(node, prev);
            } else {
                this.removeFirst(node);
            }
        }
        return true;
    }

    private void removeFirst(WaitNode node) {
        WaitNode last;
        do {
            WaitNode next;
            if ((next = node.mNext) == null) continue;
            this.mLatchFirst = next;
            return;
        } while ((last = this.mLatchLast) != node || !cLastHandle.compareAndSet(this, last, null));
        cFirstHandle.compareAndSet(this, last, null);
    }

    private WaitNode enqueue(WaitNode node) {
        WaitNode prev = cLastHandle.getAndSet(this, node);
        if (prev == null) {
            this.mLatchFirst = node;
        } else {
            prev.mNext = node;
            WaitNode pp = prev.mPrev;
            if (pp != null) {
                cNextHandle.setRelease(pp, node);
                prev = pp;
            }
        }
        return prev;
    }

    private void remove(WaitNode node, WaitNode prev) {
        WaitNode nextNext;
        WaitNode next = node.mNext;
        if (next == null) {
            node.mPrev = prev;
            next = node.mNext;
            if (next == null) {
                return;
            }
        }
        while (next.mWaiter == null && (nextNext = next.mNext) != null) {
            next = nextNext;
        }
        cNextHandle.setRelease(prev, next);
    }

    private WaitNode first() {
        int trials = 0;
        WaitNode last;
        while ((last = this.mLatchLast) != null) {
            WaitNode first = this.mLatchFirst;
            if (first != null) {
                return first;
            }
            trials = Latch.spin(trials);
        }
        return null;
    }

    private WaitNode firstWaiter() {
        WaitNode next;
        WaitNode first = this.mLatchFirst;
        if (first == null || first.mWaiter != null || (next = first.mNext) == null) {
            return first;
        }
        if (next.mWaiter != null) {
            return next;
        }
        this.remove(next, first);
        return null;
    }

    public final boolean hasQueuedThreads() {
        return this.mLatchLast != null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        Latch.appendMiniString(b, this);
        b.append('{').append("state=");
        int state = this.mLatchState;
        if (state == 0) {
            b.append("unlatched");
        } else if (state == Integer.MIN_VALUE) {
            b.append("exclusive");
        } else if (state >= 0) {
            b.append("shared:").append(state);
        } else {
            b.append("illegal:").append(state);
        }
        WaitNode last = this.mLatchLast;
        if (last != null) {
            b.append(", ");
            WaitNode first = this.mLatchFirst;
            if (first == last) {
                b.append("firstQueued=").append(last);
            } else if (first == null) {
                b.append("lastQueued=").append(last);
            } else {
                b.append("firstQueued=").append(first).append(", lastQueued=").append(last);
            }
        }
        return b.append('}').toString();
    }

    static void appendMiniString(StringBuilder b, Object obj) {
        if (obj == null) {
            b.append("null");
            return;
        }
        b.append(obj.getClass().getName()).append('@').append(Integer.toHexString(obj.hashCode()));
    }

    static int spin(int trials) {
        if (++trials >= SPIN_LIMIT) {
            Thread.yield();
            trials = 0;
        } else {
            Thread.onSpinWait();
        }
        return trials;
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            cStateHandle = lookup.findVarHandle(Latch.class, "mLatchState", Integer.TYPE);
            cFirstHandle = lookup.findVarHandle(Latch.class, "mLatchFirst", WaitNode.class);
            cLastHandle = lookup.findVarHandle(Latch.class, "mLatchLast", WaitNode.class);
            cWaiterHandle = lookup.findVarHandle(WaitNode.class, "mWaiter", Object.class);
            cWaitStateHandle = lookup.findVarHandle(WaitNode.class, "mWaitState", Integer.TYPE);
            cPrevHandle = lookup.findVarHandle(WaitNode.class, "mPrev", WaitNode.class);
            cNextHandle = lookup.findVarHandle(WaitNode.class, "mNext", WaitNode.class);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    static class Timed
    extends WaitNode {
        private long mNanosTimeout;
        private long mEndNanos;

        Timed(long nanosTimeout) {
            this.mNanosTimeout = nanosTimeout;
            if (nanosTimeout >= 0L) {
                this.mEndNanos = System.nanoTime() + nanosTimeout;
            }
        }

        @Override
        final boolean park(Latch latch) {
            if (this.mNanosTimeout < 0L) {
                Parker.park(latch);
                return Thread.currentThread().isInterrupted();
            }
            Parker.parkNanos(latch, this.mNanosTimeout);
            if (Thread.currentThread().isInterrupted()) {
                return true;
            }
            this.mNanosTimeout = this.mEndNanos - System.nanoTime();
            return this.mNanosTimeout <= 0L;
        }
    }

    static class WaitNode {
        volatile Object mWaiter;
        static final int SIGNALED = 1;
        static final int COND_WAIT = 2;
        static final int COND_WAIT_TAGGED = 3;
        volatile int mWaitState;
        volatile WaitNode mPrev;
        volatile WaitNode mNext;

        WaitNode() {
        }

        WaitNode(Object waiter, int waitState) {
            cWaiterHandle.set(this, waiter);
            cWaitStateHandle.set(this, waitState);
        }

        boolean park(Latch latch) {
            Parker.park(latch);
            Thread.interrupted();
            return false;
        }

        int tryAcquire(Latch latch) {
            for (int i = 0; i < SPIN_LIMIT; ++i) {
                boolean acquired = latch.doTryAcquireExclusive();
                Object waiter = this.mWaiter;
                if (waiter == null) {
                    return 1;
                }
                if (acquired) {
                    if (cWaitStateHandle.get(this) != 1) {
                        this.mWaiter = null;
                    } else if (!cWaiterHandle.compareAndSet(this, waiter, null)) {
                        return 1;
                    }
                    return 0;
                }
                Thread.onSpinWait();
            }
            return -1;
        }

        final void condSignal(Latch latch, LatchCondition queue) {
            this.condRemove(queue);
            cWaitStateHandle.set(this, 1);
            latch.enqueue(this);
        }

        final int condAwait(Latch latch, LatchCondition queue, long nanosTimeout, long nanosEnd) {
            int result;
            block13: {
                block14: {
                    boolean acquired;
                    block12: {
                        latch.releaseExclusive();
                        while (true) {
                            if (nanosTimeout < 0L) {
                                Parker.park(queue);
                            } else {
                                Parker.parkNanos(queue, nanosTimeout);
                            }
                            int i = SPIN_LIMIT;
                            while (true) {
                                acquired = latch.doTryAcquireExclusive();
                                if (this.mWaiter == null) {
                                    return 1;
                                }
                                if (acquired) {
                                    if (cWaitStateHandle.get(this) != 1) break;
                                    this.mWaiter = null;
                                    return 1;
                                }
                                if (--i <= 0) break;
                                Thread.onSpinWait();
                            }
                            if (Thread.interrupted()) {
                                result = -1;
                                break block12;
                            }
                            if (nanosTimeout >= 0L && (nanosTimeout == 0L || (nanosTimeout = nanosEnd - System.nanoTime()) <= 0L)) break;
                            if (!acquired) continue;
                            latch.releaseExclusive();
                        }
                        result = 0;
                    }
                    if (acquired) break block13;
                    Object waiter = this.mWaiter;
                    if (waiter == null || !cWaiterHandle.compareAndSet(this, waiter, null)) break block14;
                    latch.acquireExclusive();
                    if (cWaitStateHandle.get(this) != 1) break block13;
                }
                if (result < 0) {
                    Thread.currentThread().interrupt();
                }
                return 1;
            }
            this.condRemove(queue);
            return result;
        }

        private void condRemove(LatchCondition queue) {
            WaitNode prev = cPrevHandle.get(this);
            WaitNode next = cNextHandle.get(this);
            if (prev == null) {
                queue.mHead = next;
                if (queue.mHead == null) {
                    queue.mTail = null;
                } else {
                    cPrevHandle.set(next, null);
                }
            } else {
                cNextHandle.set(prev, next);
                if (next == null) {
                    queue.mTail = prev;
                } else {
                    cPrevHandle.set(next, prev);
                }
                cPrevHandle.set(this, null);
            }
            cNextHandle.set(this, null);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            Latch.appendMiniString(b, this);
            b.append('{').append("waiter=").append(this.mWaiter);
            b.append(", state=").append(this.mWaitState);
            b.append(", next=");
            Latch.appendMiniString(b, this.mNext);
            b.append(", prev=");
            Latch.appendMiniString(b, this.mPrev);
            return b.append('}').toString();
        }
    }

    static class Shared
    extends WaitNode {
        Shared() {
        }

        @Override
        final int tryAcquire(Latch latch) {
            WaitNode first = latch.firstWaiter();
            if (first != null && !(first instanceof Shared)) {
                return this.mWaiter == null ? 1 : -1;
            }
            int trials = 0;
            while (this.mWaiter != null) {
                int state = latch.mLatchState;
                if (state < 0) {
                    return state;
                }
                if (cStateHandle.compareAndSet(latch, state, state + 1)) {
                    Object waiter = this.mWaiter;
                    if (waiter == null || !cWaiterHandle.compareAndSet(this, waiter, null)) {
                        if (!cStateHandle.compareAndSet(latch, state + 1, state)) {
                            cStateHandle.getAndAdd(latch, -1);
                        }
                        return 1;
                    }
                    return state;
                }
                trials = Latch.spin(trials);
            }
            return 1;
        }
    }

    static class TimedShared
    extends Shared {
        private long mNanosTimeout;
        private long mEndNanos;

        TimedShared(long nanosTimeout) {
            this.mNanosTimeout = nanosTimeout;
            if (nanosTimeout >= 0L) {
                this.mEndNanos = System.nanoTime() + nanosTimeout;
            }
        }

        @Override
        final boolean park(Latch latch) {
            if (this.mNanosTimeout < 0L) {
                Parker.park(latch);
                return Thread.currentThread().isInterrupted();
            }
            Parker.parkNanos(latch, this.mNanosTimeout);
            if (Thread.currentThread().isInterrupted()) {
                return true;
            }
            this.mNanosTimeout = this.mEndNanos - System.nanoTime();
            return this.mNanosTimeout <= 0L;
        }
    }
}

