/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.util;

import java.util.concurrent.TimeUnit;
import org.cojen.tupl.util.Latch;

public class LatchCondition {
    Latch.WaitNode mHead;
    Latch.WaitNode mTail;

    public final boolean isEmpty() {
        return this.mHead == null;
    }

    public final int await(Latch latch) {
        return this.await(latch, -1L, 0L);
    }

    public final int await(Latch latch, long timeout, TimeUnit unit) {
        long nanosEnd;
        long nanosTimeout;
        if (timeout <= 0L) {
            nanosTimeout = timeout;
            nanosEnd = 0L;
        } else {
            nanosTimeout = unit.toNanos(timeout);
            nanosEnd = System.nanoTime() + nanosTimeout;
        }
        return this.await(latch, nanosTimeout, nanosEnd);
    }

    public final int await(Latch latch, long nanosTimeout) {
        long nanosEnd = nanosTimeout <= 0L ? 0L : System.nanoTime() + nanosTimeout;
        return this.await(latch, nanosTimeout, nanosEnd);
    }

    public final int await(Latch latch, long nanosTimeout, long nanosEnd) {
        return this.await(latch, 2, nanosTimeout, nanosEnd);
    }

    public final int awaitTagged(Latch latch, long nanosTimeout) {
        long nanosEnd = nanosTimeout <= 0L ? 0L : System.nanoTime() + nanosTimeout;
        return this.awaitTagged(latch, nanosTimeout, nanosEnd);
    }

    public final int awaitTagged(Latch latch, long nanosTimeout, long nanosEnd) {
        return this.await(latch, 3, nanosTimeout, nanosEnd);
    }

    private int await(Latch latch, int waitState, long nanosTimeout, long nanosEnd) {
        Latch.WaitNode node;
        try {
            node = new Latch.WaitNode(Thread.currentThread(), waitState);
        }
        catch (Throwable e) {
            return -1;
        }
        Latch.WaitNode tail = this.mTail;
        if (tail == null) {
            this.mHead = node;
        } else {
            Latch.cNextHandle.set(tail, node);
            Latch.cPrevHandle.set(node, tail);
        }
        this.mTail = node;
        return node.condAwait(latch, this, nanosTimeout, nanosEnd);
    }

    public final int priorityAwait(Latch latch, long nanosTimeout, long nanosEnd) {
        return this.priorityAwait(latch, 2, nanosTimeout, nanosEnd);
    }

    private int priorityAwait(Latch latch, int waitState, long nanosTimeout, long nanosEnd) {
        Latch.WaitNode node;
        try {
            node = new Latch.WaitNode(Thread.currentThread(), waitState);
        }
        catch (Throwable e) {
            return -1;
        }
        Latch.WaitNode head = this.mHead;
        if (head == null) {
            this.mTail = node;
        } else {
            Latch.cPrevHandle.set(head, node);
            Latch.cNextHandle.set(node, head);
        }
        this.mHead = node;
        return node.condAwait(latch, this, nanosTimeout, nanosEnd);
    }

    public final void uponSignal(Runnable cont) {
        this.upon(cont, 2);
    }

    public final void uponSignalTagged(Runnable cont) {
        this.upon(cont, 3);
    }

    private void upon(Runnable cont, int waitState) {
        Latch.WaitNode node = new Latch.WaitNode(cont, waitState);
        Latch.WaitNode tail = this.mTail;
        if (tail == null) {
            this.mHead = node;
        } else {
            Latch.cNextHandle.set(tail, node);
            Latch.cPrevHandle.set(node, tail);
        }
        this.mTail = node;
    }

    public final void signal(Latch latch) {
        Latch.WaitNode head = this.mHead;
        if (head != null) {
            head.condSignal(latch, this);
        }
    }

    public final void signalAll(Latch latch) {
        Latch.WaitNode head;
        while ((head = this.mHead) != null) {
            head.condSignal(latch, this);
        }
        return;
    }

    public final void signalTagged(Latch latch) {
        Latch.WaitNode head = this.mHead;
        if (head != null && Latch.cWaitStateHandle.get(head) == 3) {
            head.condSignal(latch, this);
        }
    }

    public final void clear() {
        Latch.WaitNode node = this.mHead;
        while (node != null) {
            Object waiter = Latch.cWaiterHandle.get(node);
            if (waiter instanceof Thread) {
                Thread t = (Thread)waiter;
                t.interrupt();
            }
            Latch.cPrevHandle.set(node, null);
            Latch.WaitNode next = Latch.cNextHandle.get(node);
            Latch.cNextHandle.set(node, null);
            node = next;
        }
        this.mHead = null;
        this.mTail = null;
    }
}

