/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.util.Latch;

public final class LocalPool<B> {
    private static final VarHandle cNumEntriesHandle;
    private final Latch mFullLatch;
    private final ThreadLocal<TheEntry<B>> mLocalEntry;
    private final Supplier<B> mSupplier;
    private final TheEntry<B>[] mAllEntries;
    private int mNumEntries;

    public LocalPool(Supplier<B> supplier) {
        this(supplier, -1);
    }

    public LocalPool(Supplier<B> supplier, int maxSize) {
        if (maxSize <= 0) {
            if (maxSize == 0) {
                throw new IllegalArgumentException();
            }
            maxSize = -(maxSize * Runtime.getRuntime().availableProcessors());
        }
        this.mFullLatch = new Latch();
        this.mLocalEntry = new ThreadLocal();
        this.mSupplier = supplier;
        this.mAllEntries = new TheEntry[maxSize];
    }

    public Entry<B> access() {
        TheEntry<B> entry = this.mLocalEntry.get();
        if (entry != null && entry.tryAcquireExclusive()) {
            return entry;
        }
        return this.accessSlow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Entry<B> accessSlow() {
        block8: {
            block9: {
                rnd = ThreadLocalRandom.current();
                allEntries = this.mAllEntries;
                numEntries = LocalPool.cNumEntriesHandle.getAcquire(this);
                if (numEntries > 0 && (entry /* !! */  = allEntries[rnd.nextInt(numEntries)]) != null && entry /* !! */ .tryAcquireExclusive()) break block8;
                this.mFullLatch.acquireShared();
                numEntries = this.mNumEntries;
                if (numEntries >= allEntries.length) break block9;
                if (this.mFullLatch.tryUpgrade()) ** GOTO lbl-1000
                this.mFullLatch.releaseShared();
                this.mFullLatch.acquireExclusive();
                numEntries = this.mNumEntries;
                if (numEntries >= allEntries.length) {
                    this.mFullLatch.downgrade();
                } else lbl-1000:
                // 2 sources

                {
                    try {
                        entry /* !! */  = new TheEntry<Object>((this.mSupplier == null ? null : (B)this.mSupplier.get()));
                        VarHandle.storeStoreFence();
                        allEntries[numEntries] = entry /* !! */ ;
                        this.mNumEntries = numEntries + 1;
                    }
                    finally {
                        this.mFullLatch.releaseExclusive();
                    }
                }
            }
            try {
                entry /* !! */  = allEntries[rnd.nextInt(numEntries)];
                entry /* !! */ .acquireExclusive();
            }
            finally {
                this.mFullLatch.releaseShared();
            }
        }
        this.mLocalEntry.set(entry /* !! */ );
        return entry /* !! */ ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(Consumer<B> consumer) {
        TheEntry<B>[] removed;
        this.mFullLatch.acquireExclusive();
        try {
            int num = this.mNumEntries;
            if (num <= 0) {
                return;
            }
            removed = Arrays.copyOfRange(this.mAllEntries, 0, num);
            Arrays.fill(this.mAllEntries, null);
            this.mNumEntries = 0;
        }
        finally {
            this.mFullLatch.releaseExclusive();
        }
        for (TheEntry<B> e : removed) {
            e.acquireExclusive();
            if (consumer == null) continue;
            consumer.accept(e.get());
        }
    }

    static {
        try {
            cNumEntriesHandle = MethodHandles.lookup().findVarHandle(LocalPool.class, "mNumEntries", Integer.TYPE);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    private static class TheEntry<B>
    extends Latch
    implements Entry<B> {
        private B mInstance;

        private TheEntry(B instance) {
            super(Integer.MIN_VALUE);
            this.mInstance = instance;
        }

        @Override
        public B get() {
            return this.mInstance;
        }

        @Override
        public void replace(B instance) {
            this.mInstance = instance;
        }

        @Override
        public void release() {
            this.releaseExclusive();
        }
    }

    public static interface Entry<B> {
        public B get();

        public void replace(B var1);

        public void release();
    }
}

