/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.ref.WeakReference;
import java.util.concurrent.locks.LockSupport;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.util.Latch;

public abstract class Parker {
    private static final Parker PARKER;
    private static final MethodHandle THREAD_ID;

    public static void unpark(Thread thread) {
        if (thread != null) {
            PARKER.doUnpark(thread);
        }
    }

    public static void park(Object blocker) {
        PARKER.doPark(blocker);
    }

    public static void parkNow(Object blocker) {
        PARKER.doParkNow(blocker);
    }

    public static void parkNanos(Object blocker, long nanos) {
        PARKER.doParkNanos(blocker, nanos);
    }

    public static void parkNanosNow(Object blocker, long nanos) {
        PARKER.doParkNanosNow(blocker, nanos);
    }

    public static long threadId(Thread thread) {
        try {
            return THREAD_ID.invokeExact(thread);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    Parker() {
    }

    abstract void doUnpark(Thread var1);

    abstract void doPark(Object var1);

    abstract void doParkNow(Object var1);

    abstract void doParkNanos(Object var1, long var2);

    abstract void doParkNanosNow(Object var1, long var2);

    static {
        Class<LockSupport> clazz = LockSupport.class;
        String type = System.getProperty(Parker.class.getName());
        if (type == null) {
            PARKER = new Checked();
        } else {
            try {
                PARKER = (Parker)Class.forName(Parker.class.getName() + "$" + type).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                throw Utils.rethrow(Utils.rootCause(e));
            }
        }
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType mt = MethodType.methodType(Long.TYPE);
        try {
            MethodHandle threadId;
            try {
                threadId = lookup.findVirtual(Thread.class, "threadId", mt);
            }
            catch (NoSuchMethodException e) {
                threadId = lookup.findVirtual(Thread.class, "getId", mt);
            }
            THREAD_ID = threadId;
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    private static final class Checked
    extends Parker {
        private static final VarHandle STATE_HANDLE;
        private static final MethodHandle IS_VIRTUAL_THREAD;
        private static final long MAX_CHECK_NANOS = 1000000L;
        private static final int NONE = 0;
        private static final int PARKED = 1;
        private static final int UNPARKED = 2;
        private Entry[] mEntries = new Entry[16];
        private int mSize;

        Checked() {
        }

        @Override
        void doUnpark(Thread thread) {
            if (!Checked.isVirtual(thread)) {
                try {
                    if (STATE_HANDLE.getAndSet(this.entryFor(thread), 2) != 1) {
                        return;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            LockSupport.unpark(thread);
        }

        @Override
        void doPark(Object blocker) {
            Thread thread = Thread.currentThread();
            if (Checked.isVirtual(thread)) {
                LockSupport.park(blocker);
            } else {
                Entry e = this.check(thread);
                if (e != null) {
                    LockSupport.park(blocker);
                    e.mState = 0;
                }
            }
        }

        @Override
        void doParkNow(Object blocker) {
            Thread thread = Thread.currentThread();
            if (Checked.isVirtual(thread)) {
                LockSupport.park(blocker);
            } else {
                Entry e = this.checkNow(thread);
                if (e != null) {
                    LockSupport.park(blocker);
                    e.mState = 0;
                }
            }
        }

        @Override
        void doParkNanos(Object blocker, long nanos) {
            Thread thread = Thread.currentThread();
            if (Checked.isVirtual(thread)) {
                LockSupport.parkNanos(blocker, nanos);
            } else {
                Entry e = this.check(thread);
                if (e != null) {
                    if ((nanos -= 1000000L) > 0L) {
                        LockSupport.parkNanos(blocker, nanos);
                    }
                    e.mState = 0;
                }
            }
        }

        @Override
        void doParkNanosNow(Object blocker, long nanos) {
            Thread thread = Thread.currentThread();
            if (Checked.isVirtual(thread)) {
                LockSupport.parkNanos(blocker, nanos);
            } else {
                Entry e = this.checkNow(thread);
                if (e != null) {
                    if ((nanos -= 1000000L) > 0L) {
                        LockSupport.parkNanos(blocker, nanos);
                    }
                    e.mState = 0;
                }
            }
        }

        private static boolean isVirtual(Thread thread) {
            try {
                return IS_VIRTUAL_THREAD.invokeExact(thread);
            }
            catch (Throwable e) {
                throw Utils.rethrow(e);
            }
        }

        private Entry check(Thread thread) {
            Entry e;
            long start = System.nanoTime();
            try {
                e = this.entryFor(thread);
            }
            catch (Throwable ex) {
                return null;
            }
            int i = Latch.SPIN_LIMIT;
            while (e.mState != 2) {
                if (thread.isInterrupted()) {
                    return null;
                }
                if (--i <= 0) {
                    Thread.yield();
                    i = Latch.SPIN_LIMIT;
                } else {
                    Thread.onSpinWait();
                }
                if (System.nanoTime() - start <= 1000000L) continue;
                if (!STATE_HANDLE.compareAndSet(e, 0, 1)) break;
                return e;
            }
            e.mState = 0;
            return null;
        }

        private Entry checkNow(Thread thread) {
            Entry e;
            try {
                e = this.entryFor(thread);
            }
            catch (Throwable ex) {
                return null;
            }
            if (e.mState != 2) {
                if (thread.isInterrupted()) {
                    return null;
                }
                if (STATE_HANDLE.compareAndSet(e, 0, 1)) {
                    return e;
                }
            }
            e.mState = 0;
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Entry entryFor(Thread thread) {
            int hash = this.hash(thread);
            Entry e = this.findEntry(thread, hash);
            if (e == null) {
                Checked checked = this;
                synchronized (checked) {
                    e = this.findEntry(thread, hash);
                    if (e == null) {
                        if ((double)this.mSize >= (double)this.mEntries.length * 0.75 && !this.cleanup()) {
                            this.rehash();
                        }
                        e = new Entry(thread);
                        int ix = hash & this.mEntries.length - 1;
                        e.mNext = this.mEntries[ix];
                        this.mEntries[ix] = e;
                        ++this.mSize;
                    }
                }
            }
            return e;
        }

        private int hash(Thread thread) {
            int hash = Long.hashCode(Checked.threadId(thread));
            hash ^= hash >>> 20 ^ hash >>> 12;
            hash ^= hash >>> 7 ^ hash >>> 4;
            return hash;
        }

        private Entry findEntry(Thread thread, int hash) {
            Entry[] entries = this.mEntries;
            Entry e = entries[hash & entries.length - 1];
            while (e != null) {
                if (e.get() == thread) {
                    return e;
                }
                e = e.mNext;
            }
            return null;
        }

        private boolean cleanup() {
            int originalSize = this.mSize;
            Entry[] entries = this.mEntries;
            for (int i = 0; i < entries.length; ++i) {
                Entry e = entries[i];
                Entry prev = null;
                while (e != null) {
                    Entry next = e.mNext;
                    Thread t = (Thread)e.get();
                    if (t == null || t.getState() == Thread.State.TERMINATED) {
                        if (prev == null) {
                            entries[i] = next;
                        } else {
                            prev.mNext = next;
                        }
                        --this.mSize;
                    } else {
                        prev = e;
                    }
                    e = next;
                }
            }
            return this.mSize != originalSize;
        }

        private void rehash() {
            Entry[] entries = this.mEntries;
            Entry[] newEntries = new Entry[entries.length << 1];
            for (int i = 0; i < entries.length; ++i) {
                Entry e = entries[i];
                while (e != null) {
                    Entry next = e.mNext;
                    Thread t = (Thread)e.get();
                    if (t == null || t.getState() == Thread.State.TERMINATED) {
                        --this.mSize;
                    } else {
                        int ix = this.hash(t) & newEntries.length - 1;
                        e.mNext = newEntries[ix];
                        newEntries[ix] = e;
                    }
                    e = next;
                }
            }
            this.mEntries = newEntries;
        }

        static {
            try {
                MethodHandle isVirtual;
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                STATE_HANDLE = lookup.findVarHandle(Entry.class, "mState", Integer.TYPE);
                try {
                    isVirtual = lookup.findVirtual(Thread.class, "isVirtual", MethodType.methodType(Boolean.TYPE));
                }
                catch (NoSuchMethodException e) {
                    isVirtual = MethodHandles.empty(MethodType.methodType(Boolean.TYPE, Thread.class));
                }
                IS_VIRTUAL_THREAD = isVirtual;
            }
            catch (Throwable e) {
                throw Utils.rethrow(e);
            }
        }

        private static class Entry
        extends WeakReference<Thread> {
            Entry mNext;
            volatile int mState;

            Entry(Thread thread) {
                super(thread);
            }
        }
    }

    private static final class Yield
    extends Parker {
        private Yield() {
        }

        @Override
        void doUnpark(Thread thread) {
        }

        @Override
        void doPark(Object blocker) {
            Thread.yield();
        }

        @Override
        void doParkNow(Object blocker) {
            Thread.yield();
        }

        @Override
        void doParkNanos(Object blocker, long nanos) {
            Thread.yield();
        }

        @Override
        void doParkNanosNow(Object blocker, long nanos) {
            Thread.yield();
        }
    }

    private static final class Spin
    extends Parker {
        private Spin() {
        }

        @Override
        void doUnpark(Thread thread) {
        }

        @Override
        void doPark(Object blocker) {
            Thread.onSpinWait();
        }

        @Override
        void doParkNow(Object blocker) {
            Thread.onSpinWait();
        }

        @Override
        void doParkNanos(Object blocker, long nanos) {
            Thread.onSpinWait();
        }

        @Override
        void doParkNanosNow(Object blocker, long nanos) {
            Thread.onSpinWait();
        }
    }

    private static final class Never
    extends Parker {
        private Never() {
        }

        @Override
        void doUnpark(Thread thread) {
        }

        @Override
        void doPark(Object blocker) {
        }

        @Override
        void doParkNow(Object blocker) {
        }

        @Override
        void doParkNanos(Object blocker, long nanos) {
        }

        @Override
        void doParkNanosNow(Object blocker, long nanos) {
        }
    }

    private static final class Now
    extends Parker {
        private Now() {
        }

        @Override
        void doUnpark(Thread thread) {
            LockSupport.unpark(thread);
        }

        @Override
        void doPark(Object blocker) {
            LockSupport.park(blocker);
        }

        @Override
        void doParkNow(Object blocker) {
            LockSupport.park(blocker);
        }

        @Override
        void doParkNanos(Object blocker, long nanos) {
            LockSupport.parkNanos(blocker, nanos);
        }

        @Override
        void doParkNanosNow(Object blocker, long nanos) {
            LockSupport.parkNanos(blocker, nanos);
        }
    }
}

