/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.util;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.cojen.tupl.util.Parker;

public final class Runner
extends AbstractExecutorService {
    private static final ThreadGroup cMainGroup = Thread.currentThread().getThreadGroup();
    private static final Runner cMainRunner = new Runner(cMainGroup);
    private static volatile ConcurrentHashMap<ThreadGroup, Runner> cRunners;
    private final ThreadGroup mGroup;
    private Loop mReady;

    public static void start(Runnable command) {
        Runner.start(null, command);
    }

    public static void start(String namePrefix, Runnable command) {
        Objects.requireNonNull(command);
        Runnable actual = command;
        if (namePrefix != null) {
            actual = () -> {
                Runner.setThreadName(Thread.currentThread(), namePrefix);
                command.run();
            };
        }
        Runner.current().execute(actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Runner current() {
        Runner runner;
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        if (group == cMainGroup) {
            return cMainRunner;
        }
        ConcurrentHashMap<ThreadGroup, Runner> runners = cRunners;
        if (runners == null) {
            Class<Runner> clazz = Runner.class;
            // MONITORENTER : org.cojen.tupl.util.Runner.class
            runners = cRunners;
            if (runners == null) {
                cRunners = runners = new ConcurrentHashMap();
            }
            // MONITOREXIT : clazz
        }
        if ((runner = runners.get(group)) != null) return runner;
        Class<Runner> clazz = Runner.class;
        // MONITORENTER : org.cojen.tupl.util.Runner.class
        runner = runners.get(group);
        if (runner == null) {
            runner = new Runner(group);
            cRunners.put(group, runner);
        }
        // MONITOREXIT : clazz
        return runner;
    }

    private static void setThreadName(Thread t, String namePrefix) {
        t.setName(namePrefix + "-" + Long.toUnsignedString(Parker.threadId(t)));
    }

    private Runner(ThreadGroup group) {
        this.mGroup = group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable task) {
        Loop ready;
        Runner runner = this;
        synchronized (runner) {
            ready = this.mReady;
            if (ready == null) {
                new Loop(task).start();
            } else {
                Loop prev = ready.mPrev;
                if (prev != null) {
                    prev.mNext = null;
                    ready.mPrev = null;
                }
                this.mReady = prev;
                ready.mTask = task;
            }
        }
        Parker.unpark(ready);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    private synchronized void enqueue(Loop ready) {
        Loop prev = this.mReady;
        if (prev != null) {
            prev.mNext = ready;
            ready.mPrev = prev;
        }
        this.mReady = ready;
    }

    private synchronized Runnable tryRemove(Loop exiting) {
        Runnable task = exiting.mTask;
        if (task != null) {
            return task;
        }
        Loop prev = exiting.mPrev;
        Loop next = exiting.mNext;
        if (next != null) {
            next.mPrev = prev;
        } else {
            this.mReady = prev;
        }
        if (prev != null) {
            prev.mNext = next;
        }
        return null;
    }

    private class Loop
    extends Thread {
        private static final long TIMEOUT = 50000000000L;
        private static final long JITTER = 10000000000L;
        private Loop mPrev;
        private Loop mNext;
        private volatile Runnable mTask;

        Loop(Runnable task) {
            super(Runner.this.mGroup, (Runnable)null);
            this.setDaemon(true);
            Runner.setThreadName(this, "Runner-" + Runner.this.mGroup.getName());
            this.mTask = task;
        }

        @Override
        public void run() {
            String name = this.getName();
            Runnable task = this.mTask;
            block4: while (true) {
                this.mTask = null;
                if (this.isInterrupted()) {
                    Thread.interrupted();
                }
                try {
                    task.run();
                }
                catch (Throwable e) {
                    try {
                        this.getUncaughtExceptionHandler().uncaughtException(this, e);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (this.getPriority() != 5) {
                    this.setPriority(5);
                }
                if (!name.equals(this.getName())) {
                    this.setName(name);
                }
                task = null;
                Runner.this.enqueue(this);
                long timeout = 50000000000L + ThreadLocalRandom.current().nextLong(10000000000L);
                long end = System.nanoTime() + timeout;
                do {
                    Parker.parkNanos(this, timeout);
                    task = this.mTask;
                    if (task != null) continue block4;
                } while ((timeout = end - System.nanoTime()) > 0L);
                task = Runner.this.tryRemove(this);
                if (task == null) break;
            }
        }
    }
}

